/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch.raycast;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api_krunch.ConstraintEncoder;
import org.valkyrienskies.physics_api_krunch.raycast.RayCastResultImpl;
import org.valkyrienskies.physics_api_krunch.raycast.RayCastResultWithVelocityImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultEncoder;", "", "", "rayCastResultBytes", "Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultImpl;", "decodeRayCastResultImpl", "([B)Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultImpl;", "rayCastResultWithVelocityBytes", "Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultWithVelocityImpl;", "decodeRayCastResultWithVelocityImpl", "([B)Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultWithVelocityImpl;", "rayCastResult", "encodeRayCastResultImpl", "(Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultImpl;)[B", "encodeRayCastResultWithVelocityImpl", "(Lorg/valkyrienskies/physics_api_krunch/raycast/RayCastResultWithVelocityImpl;)[B", "", "RAY_CAST_RESULT_SIZE", "I", "RAY_CAST_RESULT_WITH_VELOCITY_SIZE", "<init>", "()V", "physics_api_krunch"})
public final class RayCastResultEncoder {
    @NotNull
    public static final RayCastResultEncoder INSTANCE = new RayCastResultEncoder();
    private static final int RAY_CAST_RESULT_SIZE = 36;
    private static final int RAY_CAST_RESULT_WITH_VELOCITY_SIZE = 84;

    private RayCastResultEncoder() {
    }

    @NotNull
    public final byte[] encodeRayCastResultImpl(@NotNull RayCastResultImpl rayCastResult) {
        Intrinsics.checkNotNullParameter((Object)rayCastResult, (String)"rayCastResult");
        byte[] result = new byte[36];
        ByteBuffer byteBuffer = ByteBuffer.wrap(result).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(rayCastResult.getHitBodyId());
        byteBuffer.putDouble(rayCastResult.getDistance());
        ConstraintEncoder.writeVector3dc(rayCastResult.getHitNormal(), byteBuffer);
        return result;
    }

    @NotNull
    public final RayCastResultImpl decodeRayCastResultImpl(@NotNull byte[] rayCastResultBytes) {
        Intrinsics.checkNotNullParameter((Object)rayCastResultBytes, (String)"rayCastResultBytes");
        if (rayCastResultBytes.length != 36) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"rayCastResultBytes has the wrong size ", (Object)rayCastResultBytes.length));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(rayCastResultBytes).order(ByteOrder.LITTLE_ENDIAN);
        int bodyId = byteBuffer.getInt();
        double distance = byteBuffer.getDouble();
        Vector3dc vector3dc = ConstraintEncoder.readVector3dc(byteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)vector3dc, (String)"readVector3dc(byteBuffer)");
        Vector3dc normal = vector3dc;
        return new RayCastResultImpl(bodyId, distance, normal);
    }

    @NotNull
    public final byte[] encodeRayCastResultWithVelocityImpl(@NotNull RayCastResultWithVelocityImpl rayCastResult) {
        Intrinsics.checkNotNullParameter((Object)rayCastResult, (String)"rayCastResult");
        byte[] result = new byte[84];
        ByteBuffer byteBuffer = ByteBuffer.wrap(result).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(rayCastResult.getHitBodyId());
        byteBuffer.putDouble(rayCastResult.getDistance());
        ConstraintEncoder.writeVector3dc(rayCastResult.getHitNormal(), byteBuffer);
        ConstraintEncoder.writeVector3dc(rayCastResult.getVelocity(), byteBuffer);
        ConstraintEncoder.writeVector3dc(rayCastResult.getAngularVelocity(), byteBuffer);
        return result;
    }

    @NotNull
    public final RayCastResultWithVelocityImpl decodeRayCastResultWithVelocityImpl(@NotNull byte[] rayCastResultWithVelocityBytes) {
        Intrinsics.checkNotNullParameter((Object)rayCastResultWithVelocityBytes, (String)"rayCastResultWithVelocityBytes");
        if (rayCastResultWithVelocityBytes.length != 84) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"rayCastResultWithVelocityBytes has the wrong size ", (Object)rayCastResultWithVelocityBytes.length));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(rayCastResultWithVelocityBytes).order(ByteOrder.LITTLE_ENDIAN);
        int bodyId = byteBuffer.getInt();
        double distance = byteBuffer.getDouble();
        Vector3dc vector3dc = ConstraintEncoder.readVector3dc(byteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)vector3dc, (String)"readVector3dc(byteBuffer)");
        Vector3dc normal = vector3dc;
        Vector3dc vector3dc2 = ConstraintEncoder.readVector3dc(byteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)vector3dc2, (String)"readVector3dc(byteBuffer)");
        Vector3dc velocity = vector3dc2;
        Vector3dc vector3dc3 = ConstraintEncoder.readVector3dc(byteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)vector3dc3, (String)"readVector3dc(byteBuffer)");
        Vector3dc angularVelocity = vector3dc3;
        return new RayCastResultWithVelocityImpl(bodyId, distance, normal, velocity, angularVelocity);
    }
}

