/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.simevents.CollisionEventInfo;
import org.valkyrienskies.physics_api.simevents.CollisionEventType;
import org.valkyrienskies.physics_api_krunch.simevents.CollisionEventImpl;

public class CollisionEventEncoder {
    public static void encodeCollisionEvent(@NotNull CollisionEventImpl constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(constraint.getBodyIdA());
        writeBuffer.putInt(constraint.getBodyIdB());
        List<CollisionEventInfo> infos = constraint.getContacts();
        writeBuffer.putInt(infos.size());
        for (CollisionEventInfo info : infos) {
            writeBuffer.put((byte)info.getType().ordinal());
            Vector3dc point = info.getPoint();
            writeBuffer.putDouble(point.x()).putDouble(point.y()).putDouble(point.z());
            Vector3dc normal = info.getNormal();
            writeBuffer.putDouble(normal.x()).putDouble(normal.y()).putDouble(normal.z());
            writeBuffer.putFloat(info.getSeparation());
            Vector3dc relativeVelocity = info.getRelativeVelocity();
            writeBuffer.putDouble(relativeVelocity.x()).putDouble(relativeVelocity.y()).putDouble(relativeVelocity.z());
        }
    }

    @NotNull
    public static CollisionEventImpl decodeCollisionEvent(@NotNull ByteBuffer readBuffer) {
        int body0Id = readBuffer.getInt();
        int body1Id = readBuffer.getInt();
        int size = readBuffer.getInt();
        ArrayList<CollisionEventInfo> infos = new ArrayList<CollisionEventInfo>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            CollisionEventType type = CollisionEventType.values()[readBuffer.get()];
            CollisionEventInfo info = CollisionEventEncoder.getCollisionEventInfo(readBuffer, type);
            infos.add(info);
        }
        return new CollisionEventImpl(body0Id, body1Id, infos);
    }

    @NotNull
    private static CollisionEventInfo getCollisionEventInfo(@NotNull ByteBuffer readBuffer, CollisionEventType type) {
        Vector3d point = new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
        Vector3d normal = new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
        float separation = readBuffer.getFloat();
        Vector3d relativeVelocity = new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
        return new CollisionEventInfo(type, (Vector3dc)point, (Vector3dc)normal, separation, (Vector3dc)relativeVelocity);
    }
}

