/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.internal.world.VsiClientShipWorld;
import org.valkyrienskies.core.internal.world.chunks.VsiTerrainUpdate;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\nJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR)\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\f0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/valkyrienskies/mod/util/ClientConnectivityUpdateQueue;", "", "Lnet/minecraft/world/level/ChunkPos;", "pos", "", "forceUpdate", "", "queueChunkForInitialization", "(Lnet/minecraft/world/level/ChunkPos;Z)V", "onRegistriesCompleted", "()V", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "toInitialize", "Lkotlin/collections/ArrayDeque;", "getToInitialize", "()Lkotlin/collections/ArrayDeque;", "<init>", "valkyrienskies-120"})
public final class ClientConnectivityUpdateQueue {
    @NotNull
    public static final ClientConnectivityUpdateQueue INSTANCE = new ClientConnectivityUpdateQueue();
    @NotNull
    private static final ArrayDeque<Pair<ChunkPos, Boolean>> toInitialize = new ArrayDeque();

    private ClientConnectivityUpdateQueue() {
    }

    @NotNull
    public final ArrayDeque<Pair<ChunkPos, Boolean>> getToInitialize() {
        return toInitialize;
    }

    @JvmStatic
    public static final void queueChunkForInitialization(@NotNull ChunkPos pos, boolean forceUpdate) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        toInitialize.addLast((Object)new Pair((Object)pos, (Object)forceUpdate));
    }

    public final void onRegistriesCompleted() {
        while ((Pair)toInitialize.removeFirstOrNull() != null) {
            VsiClientShipWorld clientShipWorld;
            ClientLevel level;
            Pair pair;
            ChunkPos pos = (ChunkPos)pair.component1();
            boolean shouldForce = (Boolean)pair.component2();
            if (Minecraft.m_91087_().f_91073_ != null && level.m_6325_(pos.f_45578_, pos.f_45579_) != null && (clientShipWorld = VSGameUtilsKt.getShipObjectWorld(level)) != null && VSGameConfig.CLIENT.getConnectivity().getEnableClientConnectivity()) {
                LevelChunk worldChunk;
                ArrayList<VsiTerrainUpdate> voxelShapeUpdates = new ArrayList<VsiTerrainUpdate>();
                LevelChunkSection[] chunkSections = worldChunk.m_7103_();
                int n2 = chunkSections.length;
                for (int sectionY = 0; sectionY < n2; ++sectionY) {
                    boolean bl2;
                    LevelChunkSection chunkSection;
                    Intrinsics.checkNotNullExpressionValue((Object)chunkSections[sectionY], (String)"get(...)");
                    Vector3ic chunkPos = (Vector3ic)new Vector3i(pos.f_45578_, worldChunk.m_151568_(sectionY), pos.f_45579_);
                    if (!chunkSection.m_188008_()) {
                        VsiTerrainUpdate voxelShapeUpdate = VSGameUtilsKt.toDenseVoxelUpdate(chunkSection, chunkPos);
                        bl2 = voxelShapeUpdates.add(voxelShapeUpdate);
                        continue;
                    }
                    VsiTerrainUpdate emptyVoxelShapeUpdate = VSGameUtilsKt.getVsCore().newEmptyVoxelShapeUpdate(chunkPos.x(), chunkPos.y(), chunkPos.z(), true);
                    bl2 = voxelShapeUpdates.add(emptyVoxelShapeUpdate);
                }
                if (!shouldForce) {
                    clientShipWorld.addTerrainUpdates(ValkyrienSkies.api().getDimensionId((Level)level), (List<? extends VsiTerrainUpdate>)voxelShapeUpdates);
                } else {
                    Iterator iterator;
                    Intrinsics.checkNotNullExpressionValue(voxelShapeUpdates.iterator(), (String)"iterator(...)");
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                        VsiTerrainUpdate update = (VsiTerrainUpdate)e2;
                        clientShipWorld.forceUpdateConnectivityChunk(ValkyrienSkies.api().getDimensionId((Level)level), update.getChunkX(), update.getChunkY(), update.getChunkZ(), update);
                    }
                }
            }
            if (!((Collection)toInitialize).isEmpty()) continue;
        }
    }
}

