/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.entity;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.simibubi.create.content.logistics.box.PackageEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.EntityShipCollisionUtils;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={PackageEntity.class})
public abstract class MixinPackageEntity
extends LivingEntity {
    protected MixinPackageEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @WrapMethod(method={"fromItemStack"})
    private static PackageEntity wrapFromItemStack(Level world, Vec3 position, ItemStack itemstack, Operation<PackageEntity> original) {
        Ship ship = VSGameUtilsKt.getShipManagingPos(world, position.f_82479_, position.f_82480_, position.f_82481_);
        if (ship != null) {
            Vector3d worldPos = ship.getTransform().getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(position));
            PackageEntity result = (PackageEntity)original.call(new Object[]{world, VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos), itemstack});
            ((IEntityDraggingInformationProvider)result).getDraggingInformation().setLastShipStoodOn(ship.getId());
            return result;
        }
        return (PackageEntity)original.call(new Object[]{world, position, itemstack});
    }

    @WrapMethod(method={"fromDroppedItem"})
    private static PackageEntity wrapFromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack, Operation<PackageEntity> original) {
        Ship ship = VSGameUtilsKt.getShipManaging(originalEntity);
        if (ship != null) {
            Vector3d worldPos = ship.getTransform().getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(originalEntity.m_20182_()));
            originalEntity.m_146884_(VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos));
            PackageEntity result = (PackageEntity)original.call(new Object[]{world, originalEntity, itemstack});
            ((IEntityDraggingInformationProvider)result).getDraggingInformation().setLastShipStoodOn(ship.getId());
            return result;
        }
        return (PackageEntity)original.call(new Object[]{world, originalEntity, itemstack});
    }

    @WrapMethod(method={"centerPackage"})
    private static boolean wrapCenterPackageToShip(Entity entity, Vec3 target, Operation<Boolean> original) {
        Ship ship = VSGameUtilsKt.getShipManagingPos(entity.m_9236_(), target.f_82479_, target.f_82480_, target.f_82481_);
        if (ship != null) {
            Vector3d worldPos = ship.getTransform().getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(target));
            ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(ship.getId());
            return (Boolean)original.call(new Object[]{entity, VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos)});
        }
        return (Boolean)original.call(new Object[]{entity, target});
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/box/PackageEntity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 redirectToShipCollision(Entity entity, Vec3 motion, AABB aabb, Level level, List<VoxelShape> list, Operation<Vec3> collideOriginal) {
        EntityDraggingInformation entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
        Long shipId = entityDraggingInformation.getLastShipStoodOn();
        Vec3 worldMotion = (Vec3)collideOriginal.call(new Object[]{entity, motion, aabb, level, list});
        Vec3 adjustedMotion = EntityShipCollisionUtils.INSTANCE.adjustEntityMovementForShipCollisions(entity, worldMotion, aabb, level);
        entityDraggingInformation.setLastShipStoodOn(shipId);
        return adjustedMotion;
    }
}

