/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.save_mob_location_on_ship;

import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.entity.ShipyardPosSavable;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={ChunkMap.class})
public class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Inject(method={"removeEntity"}, at={@At(value="HEAD")})
    protected void unloadEntityMixin(Entity entity, CallbackInfo info) {
        Mob mob;
        Vector3d shipyardPos;
        if (entity instanceof Mob && (shipyardPos = this.valkyrienskies$getShipyardPos((Entity)(mob = (Mob)entity))) != null && VSGameUtilsKt.getShipManagingPos(this.f_140133_, (Vector3dc)shipyardPos) != null && ((ShipyardPosSavable)mob).valkyrienskies$getUnloadedShipyardPos() == null) {
            ((ShipyardPosSavable)mob).valkyrienskies$setUnloadedShipyardPos(shipyardPos);
        }
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    protected void loadEntityMixin(Entity entity, CallbackInfo info) {
        Mob mob;
        Vector3d shipyardPos;
        if (entity instanceof Mob && (shipyardPos = ((ShipyardPosSavable)(mob = (Mob)entity)).valkyrienskies$getUnloadedShipyardPos()) != null) {
            if (VSGameConfig.SERVER.getSaveMobsPositionOnShip()) {
                mob.m_6021_(shipyardPos.x, shipyardPos.y, shipyardPos.z);
            }
            ((ShipyardPosSavable)mob).valkyrienskies$setUnloadedShipyardPos(null);
        }
    }

    @Unique
    private Vector3d valkyrienskies$getShipyardPos(Entity entity) {
        Ship ship;
        EntityDraggingInformation dragInfo = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
        if (dragInfo.getLastShipStoodOn() != null && (ship = VSGameUtilsKt.getAllShips((Level)this.f_140133_).getById(dragInfo.getLastShipStoodOn())) != null && ship.getWorldAABB().containsPoint((Vector3dc)VectorConversionsMCKt.toJOML(entity.m_20182_()))) {
            return ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(entity.m_20182_()));
        }
        return null;
    }
}

