/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.block_tint;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel {
    @ModifyVariable(method={"calculateBlockTint(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/ColorResolver;)I"}, ordinal=0, at=@At(value="HEAD"), argsOnly=true)
    private BlockPos fixBlockPos(BlockPos old) {
        if (!VSGameConfig.CLIENT.getBlockTinting().getFixBlockTinting()) {
            return old;
        }
        Vector3d newPos = VSGameUtilsKt.toWorldCoordinates((Level)ClientLevel.class.cast(this), new Vector3d((double)old.m_123341_(), (double)old.m_123342_(), (double)old.m_123343_()));
        return BlockPos.m_274561_((double)newPos.x, (double)newPos.y, (double)newPos.z);
    }

    @Inject(method={"getBlockTint(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/ColorResolver;)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockTint(BlockPos blockPos, ColorResolver colorResolver, CallbackInfoReturnable<Integer> cir) {
        if (VSGameConfig.CLIENT.getBlockTinting().getFixBlockTinting() && VSGameUtilsKt.isBlockInShipyard((Level)ClientLevel.class.cast(this), blockPos)) {
            cir.setReturnValue((Object)((ClientLevel)ClientLevel.class.cast(this)).m_104762_(blockPos, colorResolver));
        }
    }
}

