/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.compat.flywheel;

import dev.engine_room.flywheel.api.visualization.VisualEmbedding;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntitySection;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.impl.hooks.VSEvents;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ShipEmbeddingManager {
    public static final ShipEmbeddingManager INSTANCE = new ShipEmbeddingManager();
    protected static ConcurrentHashMap<ClientShip, Vec3i> vs$shipAnchor = new ConcurrentHashMap();
    protected static ConcurrentHashMap<ClientShip, Vec3i> vs$EmbeddingOrigin = new ConcurrentHashMap();
    protected static ConcurrentHashMap<ClientShip, VisualEmbedding> vs$shipEmbedding = new ConcurrentHashMap();
    protected static ConcurrentHashMap<BlockEntity, ClientShip> vs$shipBEs = new ConcurrentHashMap();

    private ShipEmbeddingManager() {
        VSEvents.ShipUnloadEventClient.Companion.on(event -> this.unloadShip(event.getShip()));
        VSGameEvents.INSTANCE.getShipsStartRendering().on(event -> this.updateAllShips());
        VSGameEvents.INSTANCE.getShipsStartRenderingSodium().on(event -> this.updateAllShips());
        VSGameEvents.INSTANCE.getEntitySectionSetShip().on(event -> this.updateEntitySection(event.getSection()));
    }

    private void updateEntitySection(EntitySection<?> section) {
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)Minecraft.m_91087_().f_91073_);
        if (manager == null) {
            return;
        }
        section.m_156845_().forEach(entity -> {
            manager.entities().queueRemove((Object)((Entity)entity));
            manager.entities().queueAdd((Object)((Entity)entity));
        });
    }

    public synchronized VisualEmbedding getOrCreateEmbedding(ClientShip ship, VisualizationContext ctx) {
        VisualEmbedding prevEmbedding = vs$shipEmbedding.get(ship);
        if (prevEmbedding != null && ctx.renderOrigin().equals((Object)vs$EmbeddingOrigin.get(ship))) {
            return prevEmbedding;
        }
        vs$shipBEs.entrySet().removeIf(entry -> {
            VisualizationManager manager = VisualizationManager.get((LevelAccessor)((BlockEntity)entry.getKey()).m_58904_());
            if (entry.getValue() == ship && manager != null) {
                manager.blockEntities().queueRemove((Object)((BlockEntity)entry.getKey()));
                manager.blockEntities().queueAdd((Object)((BlockEntity)entry.getKey()));
                return true;
            }
            return false;
        });
        if (prevEmbedding != null) {
            prevEmbedding.delete();
        }
        BlockPos anchor = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft(ship.getRenderTransform().getPositionInShip()));
        Vec3i origin = ctx.renderOrigin();
        VisualEmbedding result = ctx.createEmbedding((Vec3i)anchor);
        ShipEmbeddingManager.setEmbeddingTransform(result, ship, (Vec3i)anchor, origin);
        vs$shipAnchor.put(ship, (Vec3i)anchor);
        vs$EmbeddingOrigin.put(ship, origin);
        vs$shipEmbedding.put(ship, result);
        return result;
    }

    public synchronized void updateAllShips() {
        for (ClientShip ship : vs$shipEmbedding.keySet()) {
            Vec3i anchor = vs$shipAnchor.get(ship);
            VisualEmbedding embedding = vs$shipEmbedding.get(ship);
            Vec3i origin = vs$EmbeddingOrigin.get(ship);
            ShipEmbeddingManager.setEmbeddingTransform(embedding, ship, anchor, origin);
        }
    }

    public synchronized void unloadShip(ClientShip ship) {
        VisualEmbedding embedding = vs$shipEmbedding.remove(ship);
        if (embedding != null) {
            embedding.delete();
        }
        vs$shipBEs.entrySet().removeIf(entry -> {
            if (entry.getValue() == ship) {
                VisualizationManager.get((LevelAccessor)((BlockEntity)entry.getKey()).m_58904_()).blockEntities().queueRemove((Object)((BlockEntity)entry.getKey()));
                return true;
            }
            return false;
        });
        vs$shipAnchor.remove(ship);
        vs$EmbeddingOrigin.remove(ship);
    }

    public synchronized void unloadAllShip() {
        vs$shipBEs.clear();
        vs$shipEmbedding.clear();
        vs$shipAnchor.clear();
        vs$EmbeddingOrigin.clear();
    }

    protected static void setEmbeddingTransform(VisualEmbedding embedding, ClientShip ship, Vec3i anchor, Vec3i origin) {
        Matrix4f poseMatrix = new Matrix4f();
        Matrix3f normalMatrix = new Matrix3f();
        poseMatrix.translate((Vector3fc)new Vector3f((float)(-origin.m_123341_()), (float)(-origin.m_123342_()), (float)(-origin.m_123343_())));
        poseMatrix.translate((Vector3fc)ship.getRenderTransform().getShipToWorld().transformPosition((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_(), new Vector3d()).get(new Vector3f()));
        poseMatrix.rotate((Quaternionfc)ship.getRenderTransform().getShipToWorldRotation().get(new Quaternionf()));
        poseMatrix.scale((Vector3fc)ship.getRenderTransform().getShipToWorldScaling().get(new Vector3f()));
        normalMatrix.set((Matrix4fc)poseMatrix);
        embedding.transforms((Matrix4fc)poseMatrix, (Matrix3fc)normalMatrix);
    }

    public void register(BlockEntity blockEntity, ClientShip ship) {
        vs$shipBEs.put(blockEntity, ship);
    }
}

