/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.compat;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.DragController;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.GameToPhysicsAdapter;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/mod/compat/Weather2Compat;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "<init>", "()V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nWeather2Compat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Weather2Compat.kt\norg/valkyrienskies/mod/compat/Weather2Compat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1863#2:91\n1863#2,2:92\n1864#2:94\n*S KotlinDebug\n*F\n+ 1 Weather2Compat.kt\norg/valkyrienskies/mod/compat/Weather2Compat\n*L\n27#1:91\n72#1:92,2\n27#1:94\n*E\n"})
public final class Weather2Compat {
    @NotNull
    public static final Weather2Compat INSTANCE = new Weather2Compat();

    private Weather2Compat() {
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!VSGameConfig.SERVER.getWeather2().getEnableWeatherCompat()) {
            return;
        }
        WeatherManagerServer mgr = ServerTickHandler.getWeatherManagerFor((ResourceKey)level.m_46472_());
        float windMult = VSGameConfig.SERVER.getWeather2().getWindMultiplier() / (float)1000;
        float windMax = VSGameConfig.SERVER.getWeather2().getWindMaxVel();
        float stormDampen = 1.0f - VSGameConfig.SERVER.getWeather2().getStormDampening();
        double stormRange = VSGameConfig.SERVER.getWeather2().getStormRange();
        Iterable $this$forEach$iv = (Iterable)((Object)VSGameUtilsKt.getShipObjectWorld(level).getLoadedShips());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedServerShip ship = (LoadedServerShip)element$iv;
            boolean bl2 = false;
            Vector3d vec = new Vector3d();
            GameToPhysicsAdapter forces = ValkyrienSkiesMod.getOrCreateGTPA(ship.getChunkClaimDimension());
            Vector3dc com = ship.getInertiaData().getCenterOfMassInShip();
            Vec3 pos = VectorConversionsMCKt.toMinecraft((Vector3dc)vec);
            ship.getShipToWorld().transformPosition(com, vec);
            DragController dragController = ship.getDragController();
            if (dragController != null) {
                Vector3d vector3d = new Vector3d(0.0, 0.0, -1.0).rotateY(Math.toRadians(mgr.getWindManager().getWindAngle(pos)));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"rotateY(...)");
                dragController.setWindDirection((Vector3dc)vector3d, "WEATHER2");
            }
            DragController dragController2 = ship.getDragController();
            if (dragController2 != null) {
                dragController2.setWindSpeed((double)mgr.getWindManager().getWindSpeed(BlockPos.m_274446_((Position)((Position)pos))), "WEATHER2");
            }
            Vec3 motion = VectorConversionsMCKt.toMinecraft(ship.getVelocity());
            double mass = ship.getInertiaData().getMass();
            Ref.ObjectRef forcePlusMotion = new Ref.ObjectRef();
            forcePlusMotion.element = mgr.getWindManager().applyWindForceImpl(pos, motion, (float)mass, windMult, windMax, true);
            List list = mgr.getStormsAround(pos, stormRange);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStormsAround(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WeatherObject it2 = (WeatherObject)element$iv2;
                boolean bl3 = false;
                if (!(it2 instanceof StormObject) || ((StormObject)it2).getTornadoFunnelSimple() == null) continue;
                forcePlusMotion.element = ((StormObject)it2).spinObject(pos, (Vec3)forcePlusMotion.element, false, stormDampen, stormDampen, true, 0.0f);
                Weather2Compat.tick$lambda$1$applyForcePlusMotion(vec, (Ref.ObjectRef<Vec3>)forcePlusMotion, ship, mass, forces);
            }
        }
    }

    private static final void tick$lambda$1$applyForcePlusMotion(Vector3d vec, Ref.ObjectRef<Vec3> forcePlusMotion, LoadedServerShip $ship, double mass, GameToPhysicsAdapter forces) {
        vec.x = ((Vec3)forcePlusMotion.element).f_82479_;
        vec.y = ((Vec3)forcePlusMotion.element).f_82480_;
        vec.z = ((Vec3)forcePlusMotion.element).f_82481_;
        vec.sub($ship.getVelocity());
        vec.mul(mass);
        forces.applyWorldForce($ship.getId(), (Vector3dc)vec, null);
    }
}

