/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.config.VSGameConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "buoyancyData", "Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "getBuoyancyData", "()Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "<init>", "()V", "BuoyancyData", "valkyrienskies-120"})
public final class BuoyancyHandlerAttachment
implements ShipPhysicsListener {
    @NotNull
    private final BuoyancyData buoyancyData = new BuoyancyData(0.0, null, 3, null);

    @NotNull
    public final BuoyancyData getBuoyancyData() {
        return this.buoyancyData;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (!VSGameConfig.SERVER.getEnablePocketBuoyancy()) {
            return;
        }
        if (this.buoyancyData.getPocketCenterAverage().lengthSquared() == 0.0) {
            return;
        }
        physShip.setBuoyantFactor(1.0 + this.buoyancyData.getPocketVolumeTotal() * VSGameConfig.SERVER.getBuoyancyFactorPerPocketVolume());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\"\u0010\b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0004\"\u0004\b\u0018\u0010\u0019R\"\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007\"\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "", "", "component1", "()D", "Lorg/joml/Vector3dc;", "component2", "()Lorg/joml/Vector3dc;", "pocketVolumeTotal", "pocketCenterAverage", "copy", "(DLorg/joml/Vector3dc;)Lorg/valkyrienskies/mod/common/util/BuoyancyHandlerAttachment$BuoyancyData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getPocketVolumeTotal", "setPocketVolumeTotal", "(D)V", "Lorg/joml/Vector3dc;", "getPocketCenterAverage", "setPocketCenterAverage", "(Lorg/joml/Vector3dc;)V", "<init>", "(DLorg/joml/Vector3dc;)V", "valkyrienskies-120"})
    public static final class BuoyancyData {
        private volatile double pocketVolumeTotal;
        @JsonIgnore
        @NotNull
        private volatile Vector3dc pocketCenterAverage;

        public BuoyancyData(double pocketVolumeTotal, @NotNull Vector3dc pocketCenterAverage) {
            Intrinsics.checkNotNullParameter((Object)pocketCenterAverage, (String)"pocketCenterAverage");
            this.pocketVolumeTotal = pocketVolumeTotal;
            this.pocketCenterAverage = pocketCenterAverage;
        }

        public /* synthetic */ BuoyancyData(double d2, Vector3dc vector3dc, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                d2 = 0.0;
            }
            if ((n2 & 2) != 0) {
                vector3dc = (Vector3dc)new Vector3d();
            }
            this(d2, vector3dc);
        }

        public final double getPocketVolumeTotal() {
            return this.pocketVolumeTotal;
        }

        public final void setPocketVolumeTotal(double d2) {
            this.pocketVolumeTotal = d2;
        }

        @NotNull
        public final Vector3dc getPocketCenterAverage() {
            return this.pocketCenterAverage;
        }

        public final void setPocketCenterAverage(@NotNull Vector3dc vector3dc) {
            Intrinsics.checkNotNullParameter((Object)vector3dc, (String)"<set-?>");
            this.pocketCenterAverage = vector3dc;
        }

        public final double component1() {
            return this.pocketVolumeTotal;
        }

        @NotNull
        public final Vector3dc component2() {
            return this.pocketCenterAverage;
        }

        @NotNull
        public final BuoyancyData copy(double pocketVolumeTotal, @NotNull Vector3dc pocketCenterAverage) {
            Intrinsics.checkNotNullParameter((Object)pocketCenterAverage, (String)"pocketCenterAverage");
            return new BuoyancyData(pocketVolumeTotal, pocketCenterAverage);
        }

        public static /* synthetic */ BuoyancyData copy$default(BuoyancyData buoyancyData, double d2, Vector3dc vector3dc, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d2 = buoyancyData.pocketVolumeTotal;
            }
            if ((n2 & 2) != 0) {
                vector3dc = buoyancyData.pocketCenterAverage;
            }
            return buoyancyData.copy(d2, vector3dc);
        }

        @NotNull
        public String toString() {
            return "BuoyancyData(pocketVolumeTotal=" + this.pocketVolumeTotal + ", pocketCenterAverage=" + this.pocketCenterAverage + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.pocketVolumeTotal);
            result = result * 31 + this.pocketCenterAverage.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BuoyancyData)) {
                return false;
            }
            BuoyancyData buoyancyData = (BuoyancyData)other;
            if (Double.compare(this.pocketVolumeTotal, buoyancyData.pocketVolumeTotal) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pocketCenterAverage, (Object)buoyancyData.pocketCenterAverage);
        }

        public BuoyancyData() {
            this(0.0, null, 3, null);
        }
    }
}

