/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.item;

import java.util.function.DoubleSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.bodies.properties.BodyTransform;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.core.internal.VsiCore;
import org.valkyrienskies.core.internal.ships.VsiServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/mod/common/item/ShipCreatorItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "isFoil", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/item/context/UseOnContext;", "ctx", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Ljava/util/function/DoubleSupplier;", "scale", "Ljava/util/function/DoubleSupplier;", "minScaling", "Lnet/minecraft/world/item/Item$Properties;", "properties", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Ljava/util/function/DoubleSupplier;Ljava/util/function/DoubleSupplier;)V", "valkyrienskies-120"})
public final class ShipCreatorItem
extends Item {
    @NotNull
    private final DoubleSupplier scale;
    @NotNull
    private final DoubleSupplier minScaling;

    public ShipCreatorItem(@NotNull Item.Properties properties, @NotNull DoubleSupplier scale, @NotNull DoubleSupplier minScaling) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)minScaling, (String)"minScaling");
        super(properties);
        this.scale = scale;
        this.minScaling = minScaling;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Level level = ctx.m_43725_();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            InteractionResult interactionResult = super.m_6225_(ctx);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
            return interactionResult;
        }
        ServerLevel level2 = serverLevel;
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = level2.m_8055_(blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState blockState2 = blockState;
        if (!level2.f_46443_) {
            Level level3 = ctx.m_43725_();
            Intrinsics.checkNotNull((Object)blockPos);
            Ship parentShip = VSGameUtilsKt.getShipManagingPos(level3, blockPos);
            if (!blockState2.m_60795_()) {
                String dimensionId = VSGameUtilsKt.getDimensionId((Level)level2);
                double scale = this.scale.getAsDouble();
                double minScaling = this.minScaling.getAsDouble();
                ServerShip serverShip = VSGameUtilsKt.getShipObjectWorld(level2).createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)blockPos), false, scale, dimensionId);
                BlockPos centerPos = VectorConversionsMCKt.toBlockPos((Vector3ic)ChunkClaim.getCenterBlockCoordinates$default((ChunkClaim)serverShip.getChunkClaim(), (LevelYRange)VSGameUtilsKt.getYRange((Level)level2), null, (int)2, null));
                RelocationUtilKt.relocateBlock((Level)level2, blockPos, centerPos, true, serverShip, Rotation.NONE);
                Player player = ctx.m_43723_();
                if (player != null) {
                    Object[] objectArray = new Object[]{serverShip.getSlug()};
                    player.m_213846_((Component)Component.m_237110_((String)"command.valkyrienskies.shipify.success_one", (Object[])objectArray));
                }
                if (parentShip != null) {
                    Vector3d newShipPosInWorld = parentShip.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOMLD((Vec3i)blockPos).add(0.5, 0.5, 0.5));
                    Vector3d newShipPosInShipyard = VectorConversionsMCKt.toJOMLD((Vec3i)blockPos).add(0.5, 0.5, 0.5);
                    Quaterniondc newShipRotation = parentShip.getTransform().getShipToWorldRotation();
                    Vector3d newShipScaling = parentShip.getTransform().getShipToWorldScaling().mul(scale, new Vector3d());
                    if (newShipScaling.x() < minScaling) {
                        newShipScaling = new Vector3d(minScaling, minScaling, minScaling);
                    }
                    VsiCore vsiCore = VSGameUtilsKt.getVsCore();
                    Intrinsics.checkNotNull((Object)newShipPosInWorld);
                    Vector3dc vector3dc = (Vector3dc)newShipPosInWorld;
                    Vector3d vector3d = newShipScaling;
                    Intrinsics.checkNotNull((Object)vector3d);
                    Vector3dc vector3dc2 = (Vector3dc)vector3d;
                    Intrinsics.checkNotNull((Object)newShipPosInShipyard);
                    BodyTransform newTransform = vsiCore.newBodyTransform(vector3dc, newShipRotation, vector3dc2, (Vector3dc)newShipPosInShipyard);
                    Intrinsics.checkNotNull((Object)serverShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.ships.VsiServerShip");
                    ((VsiServerShip)serverShip).unsafeSetTransform(newTransform);
                }
            }
        }
        InteractionResult interactionResult = super.m_6225_(ctx);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

