/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity.handling;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4dc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.entity.handling.VSEntityHandler;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bJw\u0010\u001b\u001a\u00020\u0006\"\b\b\u0000\u0010\n*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ7\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J7\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010\bJ5\u0010(\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e\u00a2\u0006\u0004\b(\u0010,\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/mod/common/entity/handling/AbstractShipyardEntityHandler;", "Lorg/valkyrienskies/mod/common/entity/handling/VSEntityHandler;", "Lnet/minecraft/world/entity/Entity;", "entity", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "", "freshEntityInShipyard", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;)V", "entityRemovedFromShipyard", "T", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "entityRenderer", "", "x", "y", "z", "", "rotationYaw", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrixStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "packedLight", "applyRenderTransform", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/client/renderer/entity/EntityRenderer;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "self", "vehicle", "positionSetFromVehicle", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;DDD)V", "Lorg/joml/Vector3d;", "pos", "getTeleportPos", "(Lnet/minecraft/world/entity/Entity;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "passenger", "applyRenderOnMountedEntity", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;FLcom/mojang/blaze3d/vertex/PoseStack;)V", "moveEntityFromWorldToShipyard", "entityX", "entityY", "entityZ", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;DDD)V", "<init>", "()V", "valkyrienskies-120"})
public abstract class AbstractShipyardEntityHandler
implements VSEntityHandler {
    @Override
    public void freshEntityInShipyard(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
    }

    @Override
    public void entityRemovedFromShipyard(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
    }

    @Override
    public <T extends Entity> void applyRenderTransform(@NotNull ClientShip ship, @NotNull T entity, @NotNull EntityRenderer<T> entityRenderer, double x2, double y2, double z2, float rotationYaw, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(entityRenderer, (String)"entityRenderer");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ShipTransform transform = ship.getRenderTransform();
        Vec3 entityPosition = entity.m_20318_(partialTicks);
        Matrix4dc matrix4dc = transform.getShipToWorld();
        Intrinsics.checkNotNull((Object)entityPosition);
        Vector3d transformed = matrix4dc.transformPosition(VectorConversionsMCKt.toJOML(entityPosition));
        double camX = x2 - entityPosition.f_82479_;
        double camY = y2 - entityPosition.f_82480_;
        double camZ = z2 - entityPosition.f_82481_;
        Vec3 offset = entityRenderer.m_7860_(entity, partialTicks);
        Vector3dc scale = transform.getShipToWorldScaling();
        matrixStack.m_85837_(transformed.x + camX, transformed.y + camY, transformed.z + camZ);
        matrixStack.m_252781_(new Quaternionf(transform.getShipToWorldRotation()));
        matrixStack.m_85841_((float)scale.x(), (float)scale.y(), (float)scale.z());
        matrixStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    @Override
    public void positionSetFromVehicle(@NotNull Entity self, @NotNull Entity vehicle, double x2, double y2, double z2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        self.m_6034_(x2, y2, z2);
    }

    @Override
    @NotNull
    public Vector3d getTeleportPos(@NotNull Entity self, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos;
    }

    @Override
    public void applyRenderOnMountedEntity(@NotNull ClientShip ship, @NotNull Entity self, @NotNull Entity passenger, float partialTicks, @NotNull PoseStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        matrixStack.m_252781_(new Quaternionf(ship.getRenderTransform().getShipToWorldRotation()));
    }

    public final void moveEntityFromWorldToShipyard(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        this.moveEntityFromWorldToShipyard(entity, ship, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public final void moveEntityFromWorldToShipyard(@NotNull Entity entity, @NotNull Ship ship, double entityX, double entityY, double entityZ) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Vector3d shipyardPos = ship.getWorldToShip().transformPosition(entityX, entityY, entityZ, new Vector3d());
        Vec3 vec3 = entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOML(vec3).sub(ship.getTransform().getPositionInWorld());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        Vector3d relativePos = vector3d;
        Vector3d shipPosVelocity = new Vector3d(ship.getVelocity()).add((Vector3dc)new Vector3d(ship.getOmega()).cross((Vector3dc)relativePos)).mul(0.05);
        Vec3 vec32 = entity.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getDeltaMovement(...)");
        Vector3d vector3d2 = VectorConversionsMCKt.toJOML(vec32).sub((Vector3dc)shipPosVelocity);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
        Vector3d relativeDeltaOnShip = vector3d2;
        ship.getWorldToShip().transformDirection(relativeDeltaOnShip);
        entity.m_6034_(shipyardPos.x, shipyardPos.y, shipyardPos.z);
        entity.m_20256_(VectorConversionsMCKt.toMinecraft((Vector3dc)relativeDeltaOnShip));
        entity.f_19854_ = shipyardPos.x;
        entity.f_19855_ = shipyardPos.y;
        entity.f_19856_ = shipyardPos.z;
        Vector3d direction = null;
        double yaw = 0.0;
        double pitch = 0.0;
        if (entity instanceof AbstractArrow) {
            Vec3 vec33 = ((AbstractArrow)entity).m_20184_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getDeltaMovement(...)");
            direction = VectorConversionsMCKt.toJOML(vec33);
            yaw = Math.atan2(direction.x, direction.z);
            pitch = Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
        } else {
            Matrix4dc matrix4dc = ship.getWorldToShip();
            Vec3 vec34 = entity.m_20154_();
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"getLookAngle(...)");
            direction = matrix4dc.transformDirection(VectorConversionsMCKt.toJOML(vec34));
            yaw = Math.atan2(-direction.x, direction.z);
            pitch = Math.atan2(-direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
        }
        entity.m_146922_((float)(yaw * 57.29577951308232));
        entity.m_146926_((float)(pitch * 57.29577951308232));
        LogUtils.getLogger().info("Yaw {}, Pitch {}", (Object)Float.valueOf(entity.m_146908_()), (Object)Float.valueOf(entity.m_146909_()));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
        if (entity instanceof AbstractHurtingProjectile) {
            Vector3d power = new Vector3d(((AbstractHurtingProjectile)entity).f_36813_, ((AbstractHurtingProjectile)entity).f_36814_, ((AbstractHurtingProjectile)entity).f_36815_);
            ship.getWorldToShip().transformDirection(power);
            ((AbstractHurtingProjectile)entity).f_36813_ = power.x;
            ((AbstractHurtingProjectile)entity).f_36814_ = power.y;
            ((AbstractHurtingProjectile)entity).f_36815_ = power.z;
            ProjectileUtil.m_37284_((Entity)entity, (float)1.0f);
        }
    }
}

