/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.eldritch;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.Dimensional_Rift_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.eldritch.AbstractEldritchSpell;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class VoidDevourerSpell
extends AbstractEldritchSpell {
    private static final ResourceLocation SPELL_ID = new ResourceLocation("traveloptics", "void_devourer");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(3).setCooldownSeconds(60.0).build();

    public VoidDevourerSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
        this.baseManaCost = 250;
    }

    public ResourceLocation getSpellResource() {
        return SPELL_ID;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.BLACK_HOLE_OPENING.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
        Vec3 lookDirection = caster.m_20154_();
        Vec3 spawnPosition = caster.m_20182_().m_82549_(lookDirection.m_82490_(20.0));
        float spellPower = this.getSpellPower(spellLevel, (Entity)caster);
        int baseLifespan = 200;
        int adjustedLifespan = (int)((float)baseLifespan + spellPower * 50.0f);
        Dimensional_Rift_Entity riftEntity = new Dimensional_Rift_Entity(level, spawnPosition.f_82479_, spawnPosition.f_82480_ + 3.0, spawnPosition.f_82481_, caster);
        riftEntity.setLifespan(adjustedLifespan);
        riftEntity.setStage(spellLevel + 1);
        riftEntity.setOwner(caster);
        level.m_7967_((Entity)riftEntity);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int baseLifespan = 200;
        float spellPower = this.getSpellPower(spellLevel, (Entity)caster);
        int adjustedLifespan = (int)((float)baseLifespan + spellPower * 50.0f);
        float lifespanInSeconds = (float)adjustedLifespan / 20.0f;
        return List.of(Component.m_237110_((String)"ui.traveloptics.stage", (Object[])new Object[]{spellLevel + 1}), Component.m_237110_((String)"ui.traveloptics.lifespan", (Object[])new Object[]{String.format("%.1f", Float.valueOf(lifespanInSeconds))}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

