/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.blood;

import com.gametechbc.traveloptics.api.particle.CylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.entity.mobs.EnragedDeadKingBoss;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@AutoSpellConfig
public class CallForthTheDeadKingSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "call_forth_the_dead_king");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(3600.0).build();

    public CallForthTheDeadKingSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 0;
        this.spellPowerPerLevel = 0;
        this.castTime = 300;
        this.baseManaCost = 25000;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.DEAD_KING_MUSIC_INTRO.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_12089_);
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.traveloptics.call_forth_the_dead_king_guide"), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public CastResult canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player) {
        if (castSource != CastSource.SCROLL) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"spell.traveloptics.dead_king_cast.warning", (Object[])new Object[]{this.getDisplayName(player)}).m_130940_(ChatFormatting.RED));
        }
        return super.canBeCastedBy(spellLevel, castSource, playerMagicData, player);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 6, ParticleHelper.BLOOD, ParticleDirection.UPWARD, 3.0, 2.0, 2.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        EnragedDeadKingBoss enragedDeadKing;
        if (!level.f_46443_ && (enragedDeadKing = (EnragedDeadKingBoss)((EntityType)TravelopticsEntities.ENRAGED_DEAD_KING.get()).m_20615_(level)) != null) {
            double angle = Math.toRadians(-entity.m_146908_());
            double xOffset = 2.0 * Math.cos(angle - 1.5707963267948966);
            double zOffset = 2.0 * Math.sin(angle - 1.5707963267948966);
            double spawnX = entity.m_20185_() + xOffset;
            double spawnY = entity.m_20186_();
            double spawnZ = entity.m_20189_() + zOffset;
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            if (lightning != null) {
                lightning.m_6027_(spawnX, spawnY, spawnZ);
                lightning.m_20874_(true);
                lightning.setDamage(0.0f);
                level.m_7967_((Entity)lightning);
            }
            enragedDeadKing.m_7678_(spawnX, spawnY, spawnZ, entity.m_146908_(), entity.m_146909_());
            enragedDeadKing.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(enragedDeadKing.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
            level.m_7967_((Entity)enragedDeadKing);
        }
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(entity.m_9236_(), 35, entity.m_20182_(), 18.0f));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_LONG_CAST;
    }

    public boolean stopSoundOnCancel() {
        return true;
    }
}

