/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.armor;

import com.gametechbc.traveloptics.api.utils.TOArmorUtils;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.data_manager.CooldownsManager;
import com.gametechbc.traveloptics.data_manager.StormlineManager;
import com.gametechbc.traveloptics.entity.armor.riptide_sovereign.RiptideSovereignArmorModel;
import com.gametechbc.traveloptics.entity.armor.riptide_sovereign.RiptideSovereignArmorRenderer;
import com.gametechbc.traveloptics.item.TravelopticsArmorMaterials;
import com.gametechbc.traveloptics.item.UnbreakableImbueableArmor;
import com.github.L_Ender.cataclysm.entity.effect.Lightning_Storm_Entity;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiptideSovereignArmorItem
extends UnbreakableImbueableArmor {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String COOLDOWN_RANK_DECREASE = "stormline_rank_decrease";
    public static final String COOLDOWN_STORMLINE_GAIN = "stormline_progression_gain";
    private static final int RANK_DECREASE_COOLDOWN_TICKS = 15;
    private static final int STORMLINE_GAIN_COOLDOWN_TICKS = 10;
    private static final int LIGHTNING_RING_COUNT = 4;
    private static final int LIGHTNING_ENTITIES_PER_RING = 8;
    private static final float LIGHTNING_RING_DISTANCE_START = 1.2f;
    private static final float LIGHTNING_RING_DISTANCE_INCREMENT = 1.0f;
    private static final int LIGHTNING_SPAWN_DELAY_PER_RING = 5;
    private static final float LIGHTNING_BASE_DAMAGE = 8.0f;

    public RiptideSovereignArmorItem(ArmorItem.Type slot, Item.Properties settings) {
        super(TravelopticsArmorMaterials.RIPTIDE_SOVEREIGN, slot, settings);
    }

    @Override
    protected Set<ArmorItem.Type> getImbuableArmorTypes() {
        return Set.of(ArmorItem.Type.CHESTPLATE);
    }

    @Override
    protected Map<ArmorItem.Type, Integer> getMaxSpellSlots() {
        return Map.of(ArmorItem.Type.CHESTPLATE, 1);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!RiptideSovereignArmorItem.isWearingFullSet(player)) {
            return;
        }
        ItemStack chestplate = player.m_6844_(ArmorItem.Type.CHESTPLATE.m_266308_());
        if (stack != chestplate || chestplate.m_41720_() != this) {
            return;
        }
        if (!level.f_46443_) {
            CooldownsManager.tickCooldown(chestplate);
        }
    }

    public static void onPlayerTakeDamage(Player player, ItemStack chestplate, Entity attacker) {
        if (!RiptideSovereignArmorItem.isWearingFullSet(player)) {
            return;
        }
        if (CooldownsManager.getCooldown(chestplate, COOLDOWN_RANK_DECREASE) > 0) {
            return;
        }
        boolean wasDecreased = StormlineManager.decreaseRank(chestplate, player);
        if (wasDecreased && attacker != null) {
            RiptideSovereignArmorItem.triggerLightningDischarge(player, attacker);
            CooldownsManager.setCooldown(chestplate, COOLDOWN_RANK_DECREASE, 15, 15);
        }
    }

    public static void onPlayerDealAquaDamage(Player player, ItemStack chestplate) {
        if (!RiptideSovereignArmorItem.isWearingFullSet(player)) {
            return;
        }
        if (CooldownsManager.getCooldown(chestplate, COOLDOWN_STORMLINE_GAIN) > 0) {
            return;
        }
        StormlineManager.addFromAquaDamage(chestplate, player);
        CooldownsManager.setCooldown(chestplate, COOLDOWN_STORMLINE_GAIN, 10, 10);
    }

    public static void onPlayerDealLightningDamage(Player player, ItemStack chestplate) {
        if (!RiptideSovereignArmorItem.isWearingFullSet(player)) {
            return;
        }
        if (CooldownsManager.getCooldown(chestplate, COOLDOWN_STORMLINE_GAIN) > 0) {
            return;
        }
        StormlineManager.addFromLightningDamage(chestplate, player);
        CooldownsManager.setCooldown(chestplate, COOLDOWN_STORMLINE_GAIN, 10, 10);
    }

    private static void triggerLightningDischarge(Player caster, Entity targetEntity) {
        Level level = caster.m_9236_();
        if (level.f_46443_) {
            return;
        }
        float damage = RiptideSovereignArmorItem.calculateLightningDischargeDamage(caster);
        double centerX = targetEntity.m_20185_();
        double centerY = targetEntity.m_20186_();
        double centerZ = targetEntity.m_20189_();
        for (int ring = 0; ring < 4; ++ring) {
            float currentRingDistance = 1.2f + (float)ring * 1.0f;
            int spawnDelay = ring * 5;
            double ringOffset = ring % 2 == 0 ? 0.0 : 0.19634954084936207;
            for (int i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 * (double)i / 8.0 + ringOffset;
                double offsetX = (double)currentRingDistance * Math.cos(angle);
                double offsetZ = (double)currentRingDistance * Math.sin(angle);
                double x = centerX + offsetX;
                double y = centerY;
                double z = centerZ + offsetZ;
                RiptideSovereignArmorItem.spawnLightningStormEntity(level, caster, x, y, z, (float)angle, damage, spawnDelay);
            }
        }
    }

    private static void spawnLightningStormEntity(Level level, Player caster, double x, double y, double z, float rotation, float damage, int spawnDelay) {
        Lightning_Storm_Entity lightning = new Lightning_Storm_Entity(level, x, y, z, rotation, spawnDelay, damage, 0.0f, (LivingEntity)caster, 1.5f);
        level.m_7967_((Entity)lightning);
    }

    private static float calculateLightningDischargeDamage(Player player) {
        float spellPowerMultiplier = TOGeneralUtils.getSpellPowerScaling((LivingEntity)player, (Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), (Attribute)AttributeRegistry.SPELL_POWER.get());
        return 8.0f * spellPowerMultiplier;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.riptide_sovereign_armor.tooltip").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.riptide_sovereign_armor.tooltip1"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.riptide_sovereign_armor.tooltip2"));
        if (this.f_265916_ == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.m_237113_((String)""));
            int rank = StormlineManager.getCurrentRank(stack);
            String rankName = StormlineManager.getRankName(stack);
            int[] progress = StormlineManager.getRankProgress(stack);
            int currentProgress = progress[0];
            int requiredForNext = progress[1];
            if (rank == 5) {
                currentProgress = 160;
                requiredForNext = 160;
            }
            tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.riptide_sovereign_armor.tooltip.stormline", (Object[])new Object[]{rank, rankName}).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(" [" + currentProgress + "/" + requiredForNext + "]")).m_130940_(ChatFormatting.YELLOW)));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
    }

    public static boolean isWearingFullSet(Player player) {
        return TOArmorUtils.isWearingFullSet(player, RiptideSovereignArmorItem.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new RiptideSovereignArmorRenderer(new RiptideSovereignArmorModel());
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState armorAnimations(AnimationState<RiptideSovereignArmorItem> animationState) {
        Entity entity = (Entity)animationState.getData(DataTickets.ENTITY);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_6069_()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("swimming", Animation.LoopType.LOOP));
            } else if (player.m_150110_().f_35935_ || player.m_21255_()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("fall_flying", Animation.LoopType.LOOP));
            } else if (player.m_20096_()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        } else {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "riptide_sovereign_armor", 10, this::armorAnimations)});
    }
}

