/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.events;

import com.gametechbc.traveloptics.ClientProxy;
import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.entity.misc.TOFollowingScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.util.AquaticRarityColorHelper;
import com.gametechbc.traveloptics.util.MagnetRarityColorHelper;
import com.gametechbc.traveloptics.util.TravelopticsKeybindManager;
import com.github.L_Ender.cataclysm.client.event.EventPosePlayerHand;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="traveloptics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    private static final float[] VIOLET_SKY_COLOR = new float[]{0.25f, 0.0f, 0.45f};
    private static final ResourceLocation NIGHTWARDEN_BOSS_BAR = new ResourceLocation("traveloptics", "textures/gui/boss_bar/nightwarden_boss_bar.png");
    private static final ResourceLocation ZAEVORATH_NATURE_BOSS_BAR = new ResourceLocation("traveloptics", "textures/gui/boss_bar/zaevorath_boss_bar_nature.png");
    private static final ResourceLocation ZAEVORATH_FIRE_BOSS_BAR = new ResourceLocation("traveloptics", "textures/gui/boss_bar/zaevorath_boss_bar_fire.png");
    private static final ResourceLocation ZAEVORATH_AQUA_BOSS_BAR = new ResourceLocation("traveloptics", "textures/gui/boss_bar/zaevorath_boss_bar_aqua.png");

    @SubscribeEvent
    public static void onSkyRender(ViewportEvent.ComputeFogColor event) {
        MobEffectInstance effect;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (effect = mc.f_91074_.m_21124_((MobEffect)TravelopticsEffects.ASTRAL_SENSE_TREASURE.get())) != null) {
            event.setRed(VIOLET_SKY_COLOR[0]);
            event.setGreen(VIOLET_SKY_COLOR[1]);
            event.setBlue(VIOLET_SKY_COLOR[2]);
        }
        if (mc.f_91074_ != null && (effect = mc.f_91074_.m_21124_((MobEffect)TravelopticsEffects.ASTRAL_SENSE.get())) != null) {
            event.setRed(VIOLET_SKY_COLOR[0]);
            event.setGreen(VIOLET_SKY_COLOR[1]);
            event.setBlue(VIOLET_SKY_COLOR[2]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderBossOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (ClientProxy.bossBarRenderTypes.containsKey(event.getBossEvent().m_18860_())) {
            int shieldProgressWidth;
            int shieldBarY;
            int shieldBarX;
            PoseStack poseStack;
            int j1;
            int i1;
            int l;
            int progressWidth;
            int renderTypeFor = ClientProxy.bossBarRenderTypes.get(event.getBossEvent().m_18860_());
            int i = event.getGuiGraphics().m_280182_();
            int j = event.getY();
            Component component = event.getBossEvent().m_18861_();
            if (renderTypeFor == 0) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280163_(NIGHTWARDEN_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 30.0f, 188, 27, 241, 115);
                progressWidth = (int)(event.getBossEvent().m_142717_() * 188.0f);
                event.getGuiGraphics().m_280163_(NIGHTWARDEN_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 1.0f, progressWidth, 27, 241, 115);
                l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                i1 = i / 2 - l / 2;
                j1 = j - 9;
                poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 9978623, 2557773, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
            if (renderTypeFor == 1) {
                event.setCanceled(true);
                int adaptationBarX = event.getX() + 69;
                int adaptationBarY = event.getY() + 1;
                event.getGuiGraphics().m_280163_(NIGHTWARDEN_BOSS_BAR, adaptationBarX, adaptationBarY, 95.0f, 87.0f, 50, 13, 241, 115);
                float adaptationProgress = event.getBossEvent().m_142717_();
                int adaptationProgressWidth = (int)(adaptationProgress * 50.0f);
                event.getGuiGraphics().m_280163_(NIGHTWARDEN_BOSS_BAR, adaptationBarX, adaptationBarY, 95.0f, 64.0f, adaptationProgressWidth, 13, 241, 115);
                event.setIncrement(event.getIncrement() + 5);
            }
            if (renderTypeFor == 2) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280163_(ZAEVORATH_NATURE_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 0.0f, 188, 23, 241, 115);
                progressWidth = (int)(event.getBossEvent().m_142717_() * 188.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_NATURE_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 30.0f, progressWidth, 23, 241, 115);
                l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                i1 = i / 2 - l / 2;
                j1 = j - 9;
                poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 9978623, 2557773, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
            if (renderTypeFor == 3) {
                event.setCanceled(true);
                shieldBarX = event.getX() + 4;
                shieldBarY = event.getY() - 2;
                event.getGuiGraphics().m_280163_(ZAEVORATH_NATURE_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 65.0f, 181, 4, 241, 115);
                shieldProgressWidth = (int)(event.getBossEvent().m_142717_() * 181.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_NATURE_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 85.0f, shieldProgressWidth, 4, 241, 115);
                event.setIncrement(event.getIncrement() + 3);
            }
            if (renderTypeFor == 4) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280163_(ZAEVORATH_FIRE_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 0.0f, 188, 23, 241, 115);
                progressWidth = (int)(event.getBossEvent().m_142717_() * 188.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_FIRE_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 30.0f, progressWidth, 23, 241, 115);
                l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                i1 = i / 2 - l / 2;
                j1 = j - 9;
                poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 9978623, 2557773, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
            if (renderTypeFor == 5) {
                event.setCanceled(true);
                shieldBarX = event.getX() + 4;
                shieldBarY = event.getY() - 2;
                event.getGuiGraphics().m_280163_(ZAEVORATH_FIRE_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 65.0f, 181, 4, 241, 115);
                shieldProgressWidth = (int)(event.getBossEvent().m_142717_() * 181.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_FIRE_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 85.0f, shieldProgressWidth, 4, 241, 115);
                event.setIncrement(event.getIncrement() + 3);
            }
            if (renderTypeFor == 6) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280163_(ZAEVORATH_AQUA_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 0.0f, 188, 23, 241, 115);
                progressWidth = (int)(event.getBossEvent().m_142717_() * 188.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_AQUA_BOSS_BAR, event.getX(), event.getY() + 1, 26.0f, 30.0f, progressWidth, 23, 241, 115);
                l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                i1 = i / 2 - l / 2;
                j1 = j - 9;
                poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 9978623, 2557773, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
            if (renderTypeFor == 7) {
                event.setCanceled(true);
                shieldBarX = event.getX() + 4;
                shieldBarY = event.getY() - 2;
                event.getGuiGraphics().m_280163_(ZAEVORATH_AQUA_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 65.0f, 181, 4, 241, 115);
                shieldProgressWidth = (int)(event.getBossEvent().m_142717_() * 181.0f);
                event.getGuiGraphics().m_280163_(ZAEVORATH_AQUA_BOSS_BAR, shieldBarX, shieldBarY, 30.0f, 85.0f, shieldProgressWidth, 4, 241, 115);
                event.setIncrement(event.getIncrement() + 3);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_() && ((Boolean)ClientConfig.activateScreenShake.get()).booleanValue()) {
            float delta = Minecraft.m_91087_().m_91296_();
            float ticksExistedDelta = (float)player.f_19797_ + delta;
            float shakeAmplitude = 0.0f;
            for (Entity screenShake : player.m_9236_().m_45976_(TOScreenShakeEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
                if (!(screenShake.m_20270_((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            for (Entity screenShake : player.m_9236_().m_45976_(TOFollowingScreenShakeEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
                if (!(screenShake.m_20270_((Entity)player) <= screenShake.getRadius())) continue;
                shakeAmplitude += screenShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            if (shakeAmplitude > 0.0f) {
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TravelopticsKeybindManager.updateKeyStates();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Component originalName;
        ItemStack stack = event.getItemStack();
        if (stack.m_41791_() == TravelopticsItems.RARITY_MAGNETIC && !event.getToolTip().isEmpty()) {
            originalName = (Component)event.getToolTip().get(0);
            MutableComponent gradientName = MagnetRarityColorHelper.createWaveGradient(originalName.getString());
            event.getToolTip().set(0, gradientName);
        }
        if (stack.m_41791_() == TravelopticsItems.RARITY_AQUATIC && !event.getToolTip().isEmpty()) {
            originalName = (Component)event.getToolTip().get(0);
            MutableComponent seaWaveName = AquaticRarityColorHelper.createSeaWaveGradient(originalName.getString());
            event.getToolTip().set(0, seaWaveName);
        }
    }

    @SubscribeEvent
    public static void onPoseHand(EventPosePlayerHand event) {
        boolean isObliterator;
        LivingEntity player = (LivingEntity)event.getEntityIn();
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        boolean bl = isObliterator = !(!mainHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR.get()) && !mainHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_ONE.get()) && !mainHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_TWO.get()) && !mainHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_THREE.get()) || !offHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR.get()) && !offHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_ONE.get()) && !offHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_TWO.get()) && !offHand.m_150930_((Item)TravelopticsItems.THE_OBLITERATOR_LEVEL_THREE.get()));
        if (isObliterator && player.m_6117_()) {
            if (player.m_5737_() == HumanoidArm.LEFT) {
                event.getModel().f_102811_.f_104203_ = event.getModel().f_102811_.f_104203_ * 0.5f - (float)Math.PI;
                event.getModel().f_102811_.f_104204_ = 0.0f;
            } else {
                event.getModel().f_102812_.f_104203_ = event.getModel().f_102812_.f_104203_ * 0.5f - (float)Math.PI;
                event.getModel().f_102812_.f_104204_ = 0.0f;
            }
        }
    }
}

