/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.projectiles.lightning_sandstorm_projectile;

import com.gametechbc.traveloptics.entity.projectiles.lightning_sandstorm_projectile.BaseLightningSandstormProjectile;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.Lightning_Zap_Particle;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LightningSandstormPierceProjectileEntity
extends BaseLightningSandstormProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(LightningSandstormPierceProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_MAX_LIFE = SynchedEntityData.m_135353_(LightningSandstormPierceProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_HOMING_ENABLED = SynchedEntityData.m_135353_(LightningSandstormPierceProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private DamageSource damageSource;
    public double xPower;
    public double yPower;
    public double zPower;
    private LivingEntity cachedOwner;
    private UUID ownerUUID;
    private int lifeTicks = 0;
    private boolean hasPlayedSummon = false;
    private List<Entity> victims = new ArrayList<Entity>();
    private int discardTimer = -1;
    private static final int DISCARD_DELAY = 10;
    @Nullable
    private LivingEntity homingTarget;
    @Nullable
    private UUID homingTargetId;
    private int homingDelayTimer = 0;
    private boolean homingActive = false;
    private static final RawAnimation IDLE_TRAVEL = RawAnimation.begin().thenLoop("idle_travel");
    private static final RawAnimation STORM_SUMMON = RawAnimation.begin().thenPlay("storm_summon");
    private static final RawAnimation DISCARD_ANIM = RawAnimation.begin().thenPlay("discard");
    private final AnimationController<LightningSandstormPierceProjectileEntity> idleController = new AnimationController((GeoAnimatable)this, "idle_controller", 0, this::idleAnimationPredicate);
    private final AnimationController<LightningSandstormPierceProjectileEntity> summonController = new AnimationController((GeoAnimatable)this, "summon_controller", 0, this::summonAnimationPredicate);
    private final AnimationController<LightningSandstormPierceProjectileEntity> discardController = new AnimationController((GeoAnimatable)this, "discard_controller", 0, state -> PlayState.STOP).triggerableAnim("discard_trigger", DISCARD_ANIM);

    public LightningSandstormPierceProjectileEntity(EntityType<? extends LightningSandstormPierceProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.m_20242_(false);
    }

    public LightningSandstormPierceProjectileEntity(Level level, LivingEntity owner, double dirX, double dirY, double dirZ, float damage) {
        this((EntityType<? extends LightningSandstormPierceProjectileEntity>)((EntityType)TravelopticsEntities.LIGHTNING_SANDSTORM_PIERCE_PROJECTILE.get()), level);
        this.setOwner(owner);
        this.m_7678_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_(), this.m_146908_(), this.m_146909_());
        this.m_20090_();
        this.setDamage(damage);
        this.m_19915_(owner.m_146908_(), owner.m_146909_());
        double d0 = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (d0 != 0.0) {
            this.xPower = dirX / d0 * 0.1;
            this.yPower = dirY / d0 * 0.1;
            this.zPower = dirZ / d0 * 0.1;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(DATA_MAX_LIFE, (Object)200);
        this.f_19804_.m_135372_(DATA_HOMING_ENABLED, (Object)false);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("MaxLife", this.getMaxLife());
        tag.m_128405_("LifeTicks", this.lifeTicks);
        tag.m_128379_("HasPlayedSummon", this.hasPlayedSummon);
        tag.m_128347_("xPower", this.xPower);
        tag.m_128347_("yPower", this.yPower);
        tag.m_128347_("zPower", this.zPower);
        tag.m_128405_("DiscardTimer", this.discardTimer);
        tag.m_128379_("HomingEnabled", this.isHomingEnabled());
        tag.m_128405_("HomingDelayTimer", this.homingDelayTimer);
        tag.m_128379_("HomingActive", this.homingActive);
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (this.homingTarget != null) {
            tag.m_128362_("HomingTargetUUID", this.homingTarget.m_20148_());
        }
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Damage")) {
            this.setDamage(tag.m_128457_("Damage"));
        }
        if (tag.m_128441_("MaxLife")) {
            this.setMaxLife(tag.m_128451_("MaxLife"));
        }
        if (tag.m_128441_("LifeTicks")) {
            this.lifeTicks = tag.m_128451_("LifeTicks");
        }
        if (tag.m_128441_("HasPlayedSummon")) {
            this.hasPlayedSummon = tag.m_128471_("HasPlayedSummon");
        }
        if (tag.m_128441_("xPower")) {
            this.xPower = tag.m_128459_("xPower");
        }
        if (tag.m_128441_("yPower")) {
            this.yPower = tag.m_128459_("yPower");
        }
        if (tag.m_128441_("zPower")) {
            this.zPower = tag.m_128459_("zPower");
        }
        if (tag.m_128441_("DiscardTimer")) {
            this.discardTimer = tag.m_128451_("DiscardTimer");
        }
        if (tag.m_128441_("HomingEnabled")) {
            this.setHomingEnabled(tag.m_128471_("HomingEnabled"));
        }
        if (tag.m_128441_("HomingDelayTimer")) {
            this.homingDelayTimer = tag.m_128451_("HomingDelayTimer");
        }
        if (tag.m_128441_("HomingActive")) {
            this.homingActive = tag.m_128471_("HomingActive");
        }
        if (tag.m_128403_("OwnerUUID")) {
            this.ownerUUID = tag.m_128342_("OwnerUUID");
        }
        if (tag.m_128403_("HomingTargetUUID")) {
            this.homingTargetId = tag.m_128342_("HomingTargetUUID");
        }
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getMaxLife() {
        return (Integer)this.f_19804_.m_135370_(DATA_MAX_LIFE);
    }

    public void setMaxLife(int ticks) {
        this.f_19804_.m_135381_(DATA_MAX_LIFE, (Object)ticks);
    }

    public boolean isHomingEnabled() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOMING_ENABLED);
    }

    public void setHomingEnabled(boolean enabled) {
        this.f_19804_.m_135381_(DATA_HOMING_ENABLED, (Object)enabled);
    }

    @Nullable
    public LivingEntity getOwnerAsLiving() {
        Entity entity;
        if (this.cachedOwner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.cachedOwner = (LivingEntity)entity;
        }
        return this.cachedOwner;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.cachedOwner = owner;
            this.ownerUUID = owner.m_20148_();
            super.m_5602_((Entity)owner);
        }
    }

    public void setHomingTarget(@Nullable LivingEntity target) {
        this.homingTarget = target;
        if (target != null) {
            this.homingTargetId = target.m_20148_();
        }
    }

    public void setHomingDelay(int delay) {
        this.homingActive = false;
        this.homingDelayTimer = delay;
    }

    @Nullable
    private LivingEntity getHomingTarget() {
        if (this.homingTarget == null && this.homingTargetId != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.homingTargetId);
            if (entity instanceof LivingEntity) {
                this.homingTarget = (LivingEntity)entity;
            }
            if (this.homingTarget == null) {
                this.homingTargetId = null;
            }
        }
        return this.homingTarget;
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            HitResult hitresult;
            super.m_8119_();
            ++this.lifeTicks;
            if (this.discardTimer >= 0) {
                ++this.discardTimer;
                if (this.discardTimer >= 10) {
                    this.m_146870_();
                    return;
                }
            }
            if ((hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() == HitResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_8060_((BlockHitResult)hitresult);
                return;
            }
            if (this.lifeTicks >= this.getMaxLife() && this.discardTimer < 0) {
                this.m_146870_();
                return;
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            this.spawnLightningTrailParticles();
            List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(0.5));
            for (Entity target : nearbyEntities) {
                if (!this.m_5603_(target) || this.victims.contains(target)) continue;
                this.m_5790_(new EntityHitResult(target));
            }
            if (!this.m_9236_().f_46443_ && this.isHomingEnabled() && this.discardTimer < 0) {
                Vec3 projectilePos;
                Vec3 targetPos;
                Vec3 directionToTarget;
                double distance;
                LivingEntity target;
                if (this.homingDelayTimer > 0) {
                    --this.homingDelayTimer;
                    if (this.homingDelayTimer <= 0) {
                        this.homingActive = true;
                    }
                }
                if (this.homingActive && (target = this.getHomingTarget()) != null && target.m_6084_() && (!(target instanceof Player) || !target.m_5833_()) && (distance = (directionToTarget = (targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.65, 0.0)).m_82546_(projectilePos = this.m_20182_())).m_82553_()) > 0.1) {
                    directionToTarget = directionToTarget.m_82541_();
                    double homingStrength = 0.08;
                    this.xPower += directionToTarget.f_82479_ * homingStrength;
                    this.yPower += directionToTarget.f_82480_ * homingStrength;
                    this.zPower += directionToTarget.f_82481_ * homingStrength;
                    this.xPower = Mth.m_14008_((double)this.xPower, (double)-0.15, (double)0.15);
                    this.yPower = Mth.m_14008_((double)this.yPower, (double)-0.15, (double)0.15);
                    this.zPower = Mth.m_14008_((double)this.zPower, (double)-0.15, (double)0.15);
                }
            }
            float inertia = this.getInertia();
            this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)inertia));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
    }

    protected float getInertia() {
        return 0.9f;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            this.spawnImpactParticles(result.m_82450_());
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity target = result.m_82443_();
            if (this.victims.contains(target)) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                LivingEntity owner = this.getOwnerAsLiving();
                if (livingTarget == owner) {
                    return;
                }
                if (owner != null && !owner.m_7307_((Entity)livingTarget)) {
                    if (this.damageSource == null) {
                        this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)livingTarget, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), (Entity)this, (Entity)owner);
                    }
                    DamageSources.ignoreNextKnockback((LivingEntity)livingTarget);
                    boolean damaged = livingTarget.m_6469_(this.damageSource, this.getDamage());
                    if (damaged) {
                        this.victims.add(target);
                        if (this.discardTimer < 0) {
                            this.discardTimer = 0;
                            this.triggerAnim("discard_controller", "discard_trigger");
                        }
                    }
                    this.spawnImpactParticles(livingTarget.m_20191_().m_82399_());
                }
            }
        }
    }

    protected boolean m_5603_(Entity target) {
        if (!target.m_271807_()) {
            return false;
        }
        Entity owner = this.m_19749_();
        return owner == null || !owner.equals((Object)target) && !owner.m_7307_(target);
    }

    private void spawnLightningTrailParticles() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Vec3 movement = this.m_20184_();
        double movementLength = movement.m_82553_();
        if (movementLength < 0.01) {
            return;
        }
        Vec3 backDirection = movement.m_82541_().m_82490_(-1.0);
        AABB boundingBox = this.m_20191_();
        int particleCount = 3 + this.f_19796_.m_188503_(2);
        for (int i = 0; i < particleCount; ++i) {
            double startX = boundingBox.f_82288_ + this.f_19796_.m_188500_() * (boundingBox.f_82291_ - boundingBox.f_82288_);
            double startY = boundingBox.f_82289_ + this.f_19796_.m_188500_() * (boundingBox.f_82292_ - boundingBox.f_82289_);
            double startZ = boundingBox.f_82290_ + this.f_19796_.m_188500_() * (boundingBox.f_82293_ - boundingBox.f_82290_);
            double trailDistance = 0.8 + movementLength * 0.5;
            double endX = startX + backDirection.f_82479_ * trailDistance;
            double endY = startY + backDirection.f_82480_ * trailDistance;
            double endZ = startZ + backDirection.f_82481_ * trailDistance;
            this.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(130, 157, 239), startX, startY, startZ, endX, endY, endZ);
        }
    }

    private void spawnImpactParticles(Vec3 hitPos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (double)hitPos.f_82479_, (double)hitPos.f_82480_, (double)hitPos.f_82481_, (int)10, (double)0.08, (double)0.08, (double)0.08, (double)0.3, (boolean)false);
        for (int j = 0; j < 5 + this.f_19796_.m_188503_(3); ++j) {
            float angle = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float distance = this.f_19796_.m_188501_() * 1.5f;
            double zapX = hitPos.f_82479_ + Math.cos(angle) * (double)distance;
            double zapY = hitPos.f_82480_;
            double zapZ = hitPos.f_82481_ + Math.sin(angle) * (double)distance;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new Lightning_Zap_Particle.ZapData(130, 157, 239, 0.0f), (double)zapX, (double)zapY, (double)zapZ, (int)1, (double)0.0, (double)(this.f_19796_.m_188583_() * 0.08), (double)0.0, (double)0.0, (boolean)true);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private PlayState idleAnimationPredicate(AnimationState<LightningSandstormPierceProjectileEntity> state) {
        if (this.discardTimer < 0) {
            state.getController().setAnimation(IDLE_TRAVEL);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState summonAnimationPredicate(AnimationState<LightningSandstormPierceProjectileEntity> state) {
        if (!this.hasPlayedSummon && this.lifeTicks <= 10) {
            state.getController().setAnimation(STORM_SUMMON);
            if (this.lifeTicks == 10) {
                this.hasPlayedSummon = true;
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.idleController});
        controllers.add(new AnimationController[]{this.summonController});
        controllers.add(new AnimationController[]{this.discardController});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

