/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpiritPointsManager {
    private static final int MAX_SPIRIT_POINTS = 200;

    public static int getSpiritPoints(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("SpiritPoints")) {
            return stack.m_41783_().m_128451_("SpiritPoints");
        }
        return 0;
    }

    public static void setSpiritPoints(ItemStack stack, int points) {
        int cappedPoints = Math.min(points, 200);
        stack.m_41784_().m_128405_("SpiritPoints", cappedPoints);
    }

    public static void addSpiritPoints(ItemStack stack, Player player, int amount) {
        int currentPoints = SpiritPointsManager.getSpiritPoints(stack);
        int newPoints = Math.min(currentPoints + amount, 200);
        SpiritPointsManager.setSpiritPoints(stack, newPoints);
        SpiritPointsManager.displayActionBar(player, newPoints);
        SpiritPointsManager.playSoundOnThreshold(player, currentPoints, newPoints);
        SpiritPointsManager.spawnParticlesOnThreshold(player, currentPoints, newPoints);
    }

    public static void removeSpiritPoints(ItemStack stack, Player player, int amount) {
        int currentPoints = SpiritPointsManager.getSpiritPoints(stack);
        int newPoints = Math.max(currentPoints - amount, 0);
        SpiritPointsManager.setSpiritPoints(stack, newPoints);
        SpiritPointsManager.displayActionBar(player, newPoints);
    }

    private static void displayActionBar(Player player, int points) {
        if (player instanceof ServerPlayer) {
            MutableComponent message = points >= 200 ? Component.m_237113_((String)("\u2620 Soul Fragments: " + points)).m_130938_(style -> style.m_178520_(16770714)).m_130940_(ChatFormatting.BOLD) : Component.m_237113_((String)("\u2620 Soul Fragments: " + points)).m_130938_(style -> style.m_178520_(7733218));
            player.m_5661_((Component)message, true);
        }
    }

    private static void playSoundOnThreshold(Player player, int oldPoints, int newPoints) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (newPoints >= 200 && oldPoints < 200) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)TravelopticsSounds.SPIRIT_POINTS_MAX.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 100 && oldPoints < 100) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)TravelopticsSounds.SPIRIT_POINTS_THRESHOLD_TWO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 50 && oldPoints < 50) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)TravelopticsSounds.SPIRIT_POINTS_THRESHOLD_ONE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnParticlesOnThreshold(Player player, int oldPoints, int newPoints) {
        if (newPoints >= 200 && oldPoints < 200) {
            Vec3 playerPosition = player.m_20182_();
            MagicManager.spawnParticles((Level)player.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)playerPosition.f_82479_, (double)playerPosition.f_82480_, (double)playerPosition.f_82481_, (int)20, (double)0.0, (double)1.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }
}

