/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SoulApexManager {
    private static final String SOUL_APEX_TAG = "SoulApexCount";
    private static final int MAX_SOUL_APEX = 5;

    public static int getSoulApexCount(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(SOUL_APEX_TAG);
    }

    public static void setSoulApexCount(ItemStack stack, int count) {
        CompoundTag tag = stack.m_41784_();
        int clampedCount = Math.max(0, Math.min(count, 5));
        tag.m_128405_(SOUL_APEX_TAG, clampedCount);
    }

    public static void addSoulApex(ItemStack stack, Player player, int amount) {
        int currentCount = SoulApexManager.getSoulApexCount(stack);
        int newCount = Math.min(currentCount + amount, 5);
        SoulApexManager.setSoulApexCount(stack, newCount);
        player.m_5661_((Component)Component.m_237113_((String)("\u25c8 Soul Apex: " + newCount + "/5")).m_130940_(ChatFormatting.LIGHT_PURPLE), true);
    }

    public static void removeSoulApex(ItemStack stack, Player player, int amount) {
        int currentCount = SoulApexManager.getSoulApexCount(stack);
        int newCount = Math.max(currentCount - amount, 0);
        SoulApexManager.setSoulApexCount(stack, newCount);
        player.m_5661_((Component)Component.m_237113_((String)("\u25c8 Soul Apex: " + newCount + "/5")).m_130940_(ChatFormatting.LIGHT_PURPLE), true);
    }

    public static boolean hasMaxSoulApex(ItemStack stack) {
        return SoulApexManager.getSoulApexCount(stack) >= 5;
    }

    public static boolean hasSoulApex(ItemStack stack, int required) {
        return SoulApexManager.getSoulApexCount(stack) >= required;
    }

    public static int getMaxSoulApex() {
        return 5;
    }
}

