/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.util;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class DragonMathUtil {
    public static float approachSmooth(float current, float previous, float desired, float desiredSpeed, float deltaSpeed) {
        float prevSpeed = current - previous;
        desiredSpeed = Math.abs(desiredSpeed);
        desiredSpeed = current < desired ? desiredSpeed : -desiredSpeed;
        float speed = Mth.m_14121_((float)prevSpeed, (float)desiredSpeed, (float)deltaSpeed);
        float speedApproachReduction = (float)(1.0 - Math.pow(Mth.m_14036_((float)(-Math.abs(current - desired) / Math.abs(2.0f * desiredSpeed / deltaSpeed) + 1.0f), (float)0.0f, (float)1.0f), 4.0));
        return current < desired ? Mth.m_14036_((float)(current + speed), (float)current, (float)desired) : Mth.m_14036_((float)(current + (speed *= speedApproachReduction)), (float)desired, (float)current);
    }

    public static float approachDegreesSmooth(float current, float previous, float desired, float desiredSpeed, float deltaSpeed) {
        float desiredDifference = Mth.m_14118_((float)current, (float)desired);
        float previousDifference = Mth.m_14118_((float)current, (float)previous);
        return DragonMathUtil.approachSmooth(current, current + previousDifference, current + desiredDifference, desiredSpeed, deltaSpeed);
    }

    public static double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.m_20189_() - first.m_20189_(), second.m_20185_() - first.m_20185_()) * 57.29577951308232 + 90.0;
    }

    public static double getDotProductBodyFacingEntity(Entity entity, Entity target) {
        Vec3 vecBetween = target.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
        return vecBetween.m_82526_(Vec3.m_82498_((float)0.0f, (float)entity.m_146908_()).m_82541_());
    }

    public static Vec3 circleEntityPosition(Entity target, float radius, float speed, boolean clockwise, int frame, float offset) {
        int direction = clockwise ? 1 : -1;
        double t = (double)(direction * frame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
    }

    public static <T extends Entity> List<T> getEntitiesNearby(Entity entity, Class<T> entityClass, double radius) {
        return entity.m_9236_().m_6443_(entityClass, entity.m_20191_().m_82377_(radius, radius, radius), e -> e != entity && (double)entity.m_20270_(e) <= radius + (double)(e.m_20205_() / 2.0f));
    }

    public static List<LivingEntity> getAttackableEntitiesNearby(Entity entity, double radius) {
        List nearbyEntities = entity.m_9236_().m_45933_(entity, entity.m_20191_().m_82377_(radius, radius, radius));
        return nearbyEntities.stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).filter(LivingEntity::m_5789_).filter(e -> (double)entity.m_20270_((Entity)e) <= radius + (double)(e.m_20205_() / 2.0f)).collect(Collectors.toList());
    }

    public static Vec3 calculateFlightVector(Entity entity, Vec3 target, double speed, double acceleration) {
        Vec3 direction = target.m_82546_(entity.m_20182_()).m_82541_();
        Vec3 currentVel = entity.m_20184_();
        Vec3 targetVel = direction.m_82490_(speed);
        return currentVel.m_82549_(targetVel.m_82546_(currentVel).m_82490_(acceleration));
    }

    public static void smoothLookAt(LivingEntity entity, Entity target, float maxYawChange, float maxPitchChange) {
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20188_() - entity.m_20188_();
        double dz = target.m_20189_() - entity.m_20189_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Math.atan2(dy, horizontalDist) * 57.29577951308232));
        float currentYaw = entity.m_146908_();
        float prevYaw = entity.f_19859_;
        float newYaw = DragonMathUtil.approachDegreesSmooth(currentYaw, prevYaw, targetYaw, maxYawChange, Math.max(1.0f, maxYawChange * 0.5f));
        entity.m_146922_(newYaw);
        float currentPitch = entity.m_146909_();
        float prevPitch = entity.f_19860_;
        float newPitch = DragonMathUtil.approachDegreesSmooth(currentPitch, prevPitch, targetPitch, maxPitchChange, Math.max(1.0f, maxPitchChange * 0.5f));
        entity.m_146926_(newPitch);
        entity.f_20883_ = entity.m_146908_();
    }

    public static boolean hasLineOfSight(LivingEntity entity, Entity target) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_21574_().m_148306_(target);
        }
        return (double)entity.m_20270_(target) < Objects.requireNonNull(entity.m_21051_(Attributes.f_22277_)).m_22135_();
    }

    public static Vec3 calculateDodgeDirection(Entity entity, Entity projectile) {
        Vec3 projectileVel = new Vec3(projectile.m_20185_() - projectile.f_19854_, projectile.m_20186_() - projectile.f_19855_, projectile.m_20189_() - projectile.f_19856_);
        if (projectileVel.m_82556_() < 0.001) {
            return Vec3.f_82478_;
        }
        Vec3 lateral = projectileVel.m_82541_().m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (lateral.m_82556_() < 1.0E-6) {
            return Vec3.f_82478_;
        }
        lateral = lateral.m_82541_();
        Vec3 entityPos = entity.m_20182_();
        Vec3 predictedImpact = projectile.m_20182_().m_82549_(projectileVel.m_82490_(20.0));
        Vec3 leftPos = entityPos.m_82549_(lateral);
        Vec3 rightPos = entityPos.m_82549_(lateral.m_82490_(-1.0));
        if (rightPos.m_82546_(predictedImpact).m_82556_() > leftPos.m_82546_(predictedImpact).m_82556_()) {
            lateral = lateral.m_82490_(-1.0);
        }
        return lateral;
    }

    public static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    public static float easeOutSine(float t) {
        return (float)Math.sin((double)t * Math.PI / 2.0);
    }

    public static float lerpSmooth(float start, float end, float progress, EasingFunction easing) {
        float easedProgress = switch (easing.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> progress;
            case 1 -> DragonMathUtil.easeInOutCubic(progress);
            case 2 -> DragonMathUtil.easeOutSine(progress);
        };
        return Mth.m_14179_((float)easedProgress, (float)start, (float)end);
    }

    public static Vec3 clampVectorLength(Vec3 vector, double maxLength) {
        double lengthSq = vector.m_82556_();
        if (lengthSq > maxLength * maxLength) {
            return vector.m_82541_().m_82490_(maxLength);
        }
        return vector;
    }

    public static Vec3 addHorizontalMovement(Vec3 currentVel, Vec3 addedVel) {
        return new Vec3(currentVel.f_82479_ + addedVel.f_82479_, currentVel.f_82480_, currentVel.f_82481_ + addedVel.f_82481_);
    }

    public static Vec3 calculateRepulsionForce(Entity center, Entity target, double radius, double strength) {
        Vec3 direction = target.m_20182_().m_82546_(center.m_20182_());
        double distance = direction.m_82553_();
        if (distance >= radius || distance == 0.0) {
            return Vec3.f_82478_;
        }
        double force = strength * (1.0 - distance / radius) * (1.0 - distance / radius);
        return direction.m_82541_().m_82490_(force);
    }

    public static Quaternionf quatFromRotationXYZ(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x = (float)Math.toRadians(x);
            y = (float)Math.toRadians(y);
            z = (float)Math.toRadians(z);
        }
        return new Quaternionf().rotationXYZ(x, y, z);
    }

    public static double clampAltitude(double currentY, double groundY, double minAbove, double maxAbove) {
        return Mth.m_14008_((double)currentY, (double)(groundY + minAbove), (double)(groundY + maxAbove));
    }

    public static float yawErrorToTarget(Entity self, Entity target) {
        float wantedYaw = (float)(Math.atan2(target.m_20189_() - self.m_20189_(), target.m_20185_() - self.m_20185_()) * 180.0 / Math.PI) - 90.0f;
        return Math.abs(Mth.m_14118_((float)self.m_146908_(), (float)wantedYaw));
    }

    public static enum EasingFunction {
        LINEAR,
        EASE_IN_OUT_CUBIC,
        EASE_OUT_SINE;

    }
}

