/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;

public class DragonSoundHandler {
    private final DragonEntity dragon;
    private final DragonSoundProfile profile;
    private static final int MIN_OVERLAP_GUARD_TICKS = 5;
    private static final Set<String> DEFAULT_NON_OVERLAPPING_KEYS = Set.of("hurt", "stegonaut_hurt", "cindervane_hurt", "primitive_drake_hurt", "die", "raevyx_hurt", "raevyx_die", "baby_raevyx_hurt", "baby_raevyx_die", "nulljaw_hurt", "nulljaw_die");
    private static final Map<String, Integer> GENERIC_VOCAL_WINDOWS = Map.of("hurt", 20, "die", 62);
    private final Map<String, Integer> vocalCooldowns = new HashMap<String, Integer>();
    private long lastStepTick = -100L;

    public DragonSoundHandler(DragonEntity dragon) {
        this.dragon = dragon;
        DragonSoundProfile providedProfile = dragon.getSoundProfile();
        this.profile = providedProfile != null ? providedProfile : DragonSoundProfile.EMPTY;
    }

    public void tick() {
    }

    public void handleAnimationSound(DragonEntity entity, Object keyframeData, AnimationController<?> controller) {
        String raw;
        if (this.dragon.isDying()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (keyframeData == null) {
            return;
        }
        String controllerName = null;
        try {
            if (controller != null && controller.getName() != null) {
                controllerName = controller.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean sittingMuted = this.dragon.isStayOrSitMuted();
        boolean sleeping = this.dragon.m_5803_();
        boolean sleepTransitioning = this.dragon.isSleepTransitioning();
        if (sleeping) {
            return;
        }
        if (sleepTransitioning && !"action".equals(controllerName)) {
            return;
        }
        String locator = null;
        try {
            raw = (String)keyframeData.getClass().getMethod("getSound", new Class[0]).invoke(keyframeData, new Object[0]);
            try {
                locator = (String)keyframeData.getClass().getMethod("getLocator", new Class[0]).invoke(keyframeData, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            return;
        }
        if (raw == null || raw.isEmpty()) {
            return;
        }
        String sound = raw.toLowerCase(Locale.ROOT);
        if (sound.contains(":")) {
            this.handleAutoSoundSpec(sound);
            return;
        }
        String normalizedForFlap = null;
        if (sound.contains("flap")) {
            normalizedForFlap = sound.substring(sound.indexOf("flap"));
        }
        String normalizedForStep = null;
        if (sound.contains("step")) {
            normalizedForStep = sound.substring(sound.indexOf("step"));
        }
        if (this.profile.handleAnimationSound(this, this.dragon, sound, locator)) {
            return;
        }
        if (sittingMuted) {
            return;
        }
        if (normalizedForFlap != null && normalizedForFlap.startsWith("flap")) {
            this.handleWingFlapSound(normalizedForFlap);
            return;
        }
        if (normalizedForStep != null && (normalizedForStep.startsWith("step") || normalizedForStep.startsWith("run_step"))) {
            this.handleStepSound(normalizedForStep);
            return;
        }
        this.playFallbackSound(sound, locator);
    }

    private void handleAutoSoundSpec(String spec) {
        try {
            String[] parts = spec.split("\\|");
            String soundId = parts[0];
            float volume = parts.length > 1 ? Float.parseFloat(parts[1]) : 1.0f;
            float pitch = parts.length > 2 ? Float.parseFloat(parts[2]) : 1.0f;
            ResourceLocation rl = ResourceLocation.m_135820_((String)soundId);
            if (rl != null) {
                this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(rl), SoundSource.NEUTRAL, volume, pitch, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleWingFlapSound(String key) {
        if (this.profile.handleWingFlapSound(this, this.dragon, key)) {
            return;
        }
        float volume = this.dragon.m_6162_() ? 0.6f : 1.0f;
        float pitch = 1.0f;
        if (key.contains("left")) {
            pitch += 0.05f;
        } else if (key.contains("right")) {
            pitch -= 0.05f;
        }
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), ModSounds.RAEVYX_FLAP.get(), SoundSource.NEUTRAL, volume, pitch, false);
    }

    private void handleStepSound(String key) {
        Vec3 pos = this.dragon.m_20182_();
        if (this.profile.handleStepSound(this, this.dragon, key, null, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0f, 1.0f)) {
            return;
        }
        this.playFootstepSound(this.dragon.m_9236_(), pos, this.dragon);
    }

    private void playFallbackSound(String key, String locator) {
        DragonSoundProfile profile = this.dragon.getSoundProfile();
        if (profile != null && profile.handleAnimationSound(this, this.dragon, key, locator)) {
            return;
        }
        if (DEFAULT_NON_OVERLAPPING_KEYS.contains(key)) {
            if (this.isInCooldown(key)) {
                return;
            }
            this.startCooldown(key);
        }
        this.playClientSound(this.dragon, this.resolveLocator(locator), ModSounds.RAEVYX_CHUFF.get(), 1.0f, 1.0f);
    }

    private boolean isInCooldown(String key) {
        Integer cooldown = this.vocalCooldowns.get(key);
        return cooldown != null && cooldown > this.dragon.f_19797_;
    }

    private void startCooldown(String key) {
        int window = GENERIC_VOCAL_WINDOWS.getOrDefault(key, 20);
        this.vocalCooldowns.put(key, this.dragon.f_19797_ + Math.max(window, 5));
    }

    private Vec3 resolveLocator(String locator) {
        if (locator == null || locator.isEmpty()) {
            return this.dragon.m_20182_();
        }
        return this.profile.resolveLocator(this, this.dragon, locator);
    }

    public void playVocal(String vocalKey) {
        if (this.dragon.m_213877_() || this.dragon.m_21224_()) {
            return;
        }
        if (this.isInCooldown(vocalKey)) {
            return;
        }
        this.startCooldown(vocalKey);
        DragonSoundProfile profile = this.dragon.getSoundProfile();
        if (profile != null && profile.handleVocal(this, this.dragon, vocalKey)) {
            return;
        }
        DragonEntity.VocalEntry entry = this.resolveVocalEntry(profile, vocalKey);
        if (entry == null || entry.soundSupplier() == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (this.dragon.m_5803_() || this.dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && this.dragon.isStayOrSitMuted()) {
            return;
        }
        if (entry.animationId() != null && !entry.animationId().isEmpty()) {
            String controllerId = entry.controllerId() != null && !entry.controllerId().isEmpty() ? entry.controllerId() : "action";
            this.dragon.triggerAnim(controllerId, vocalKey);
        }
    }

    public void playClientSound(DragonEntity dragon, Vec3 position, SoundEvent sound, float volume, float pitch) {
        double x = position != null ? position.f_82479_ : dragon.m_20185_();
        double y = position != null ? position.f_82480_ : dragon.m_20186_();
        double z = position != null ? position.f_82481_ : dragon.m_20189_();
        Level level = dragon.m_9236_();
        if (level.f_46443_) {
            level.m_7785_(x, y, z, sound, SoundSource.NEUTRAL, volume, pitch, false);
        } else {
            level.m_6263_(null, x, y, z, sound, SoundSource.NEUTRAL, volume, pitch);
        }
    }

    public void playFootstepSound(Level level, Vec3 pos, DragonEntity dragon) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11908_, SoundSource.NEUTRAL, dragon.m_6162_() ? 0.5f : 0.9f, dragon.m_217043_().m_188501_() * 0.2f + 0.9f);
    }

    private DragonEntity.VocalEntry resolveVocalEntry(DragonSoundProfile profile, String key) {
        DragonEntity.VocalEntry entry = this.dragon.getVocalEntries().get(key);
        if (entry != null) {
            return entry;
        }
        if (profile != null && (entry = profile.getFallbackVocalEntry(key)) != null) {
            return entry;
        }
        int underscore = key.indexOf(95);
        while (underscore > 0) {
            String suffix = key.substring(underscore + 1);
            entry = this.dragon.getVocalEntries().get(suffix);
            if (entry != null) {
                return entry;
            }
            if (profile != null && (entry = profile.getFallbackVocalEntry(suffix)) != null) {
                return entry;
            }
            underscore = key.indexOf(95, underscore + 1);
        }
        return null;
    }

    public DragonSoundProfile getProfile() {
        return this.profile;
    }

    public DragonEntity getDragon() {
        return this.dragon;
    }

    public boolean allowOverlap(String locator) {
        return this.profile.allowOverlap(locator);
    }

    public boolean shouldPreventOverlap(String key) {
        return DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
    }

    public Vec3 resolveLocatorWorldPos(String locator) {
        return this.resolveLocator(locator);
    }

    public long getLastStepTick() {
        return this.lastStepTick;
    }

    public void setLastStepTick(long tick) {
        this.lastStepTick = tick;
    }
}

