/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.effect.raevyx;

import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningChainData;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RaevyxLightningChainEntity
extends Entity {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHAIN = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CASTER_FEMALE = SynchedEntityData.m_135353_(RaevyxLightningChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private Vec3 startPos;
    private Vec3 endPos;
    private int chainCount = 0;
    private int maxChains = 3;

    public RaevyxLightningChainEntity(EntityType<? extends RaevyxLightningChainEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RaevyxLightningChainEntity(Level level, double x, double y, double z, float damage, float size, LivingEntity caster, boolean isChain) {
        this(ModEntities.RAEVYX_LIGHTNING_CHAIN.get(), level);
        this.m_6034_(x, y, z);
        this.setDamage(damage);
        this.setSize(size);
        this.setCaster(caster);
        this.setIsChain(isChain);
        this.setDelay(0);
        this.setLifespan(0);
    }

    public RaevyxLightningChainEntity(Level level, Vec3 startPos, Vec3 endPos, float damage, float size, LivingEntity caster, boolean isChain) {
        this(level, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, damage, size, caster, isChain);
        this.startPos = startPos;
        this.endPos = endPos;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LIFESPAN, (Object)0);
        this.f_19804_.m_135372_(DELAY, (Object)0);
        this.f_19804_.m_135372_(IS_CHAIN, (Object)false);
        this.f_19804_.m_135372_(CASTER_FEMALE, (Object)false);
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int lifespan) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)lifespan);
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(int delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float size) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(Mth.m_14036_((float)size, (float)0.5f, (float)3.0f)));
        }
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean getIsChain() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHAIN);
    }

    public void setIsChain(boolean isChain) {
        this.f_19804_.m_135381_(IS_CHAIN, (Object)isChain);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.owner = caster;
        UUID uUID = this.ownerUUID = caster == null ? null : caster.m_20148_();
        if (caster instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)caster;
            this.f_19804_.m_135381_(CASTER_FEMALE, (Object)dragon.isFemale());
        }
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    private boolean isCasterFemale() {
        return (Boolean)this.f_19804_.m_135370_(CASTER_FEMALE);
    }

    public boolean m_6783_(double distance) {
        double d0 = 64.0 * RaevyxLightningChainEntity.m_20150_();
        return distance < d0 * d0;
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    @NotNull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getSize() * 0.5f), (float)this.getSize());
    }

    public void m_8119_() {
        super.m_8119_();
        this.setLifespan(this.getLifespan() + 1);
        int adjustedLifespan = this.getLifespan() - this.getDelay();
        if (this.m_9236_().f_46443_) {
            if (adjustedLifespan == 1) {
                this.spawnLightningParticles();
            }
        } else {
            if (adjustedLifespan == 5) {
                this.dealDamage();
                if (this.getIsChain() && this.chainCount < this.maxChains) {
                    this.attemptChainLightning();
                }
            }
            if (adjustedLifespan > 20) {
                this.m_146870_();
            }
        }
    }

    private void spawnLightningParticles() {
        boolean female = this.isCasterFemale();
        if (this.startPos != null && this.endPos != null) {
            if (this.getIsChain()) {
                this.m_9236_().m_7107_((ParticleOptions)new RaevyxLightningChainData(this.getSize(), this.startPos, this.endPos, female), this.startPos.f_82479_, this.startPos.f_82480_, this.startPos.f_82481_, 0.0, 0.0, 0.0);
            } else {
                Vec3 delta = this.endPos.m_82546_(this.startPos);
                int segments = Math.max(3, (int)(delta.m_82553_() * 4.0));
                Vec3 step = delta.m_82490_(1.0 / (double)segments);
                for (int i = 0; i <= segments; ++i) {
                    Vec3 pos = this.startPos.m_82549_(step.m_82490_((double)i));
                    Vec3 dir = step.m_82541_();
                    this.m_9236_().m_7107_((ParticleOptions)new RaevyxLightningStormData(this.getSize(), female), pos.f_82479_, pos.f_82480_, pos.f_82481_, dir.f_82479_, dir.f_82480_, dir.f_82481_);
                }
            }
        } else if (this.getIsChain()) {
            this.m_9236_().m_7107_((ParticleOptions)new RaevyxLightningStormData(this.getSize(), female), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        } else {
            this.m_9236_().m_7107_((ParticleOptions)new RaevyxLightningStormData(this.getSize(), female), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void dealDamage() {
        AABB damageBox = this.m_20191_().m_82400_((double)this.getSize() * 2.0);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, damageBox)) {
            LivingEntity caster;
            if (!entity.m_6084_() || entity.m_20147_() || entity == this.getCaster() || this.isProtectedFromCaster(caster = this.getCaster(), entity)) continue;
            DamageSource damageSource = caster != null ? this.m_269291_().m_269333_(caster) : this.m_269291_().m_269425_();
            entity.m_6469_(damageSource, this.getDamage());
            this.spawnImpactEffects(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        }
    }

    private void spawnImpactEffects(Vec3 impactPos) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        boolean female = this.isCasterFemale();
        float size = this.getSize() * 0.8f;
        server.m_8767_((ParticleOptions)new RaevyxLightningStormData(size, female), impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnChainImpactEffects(Vec3 chainPos) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        boolean female = this.isCasterFemale();
        float size = this.getSize() * 0.6f;
        server.m_8767_((ParticleOptions)new RaevyxLightningStormData(size, female), chainPos.f_82479_, chainPos.f_82480_, chainPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void attemptChainLightning() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB searchBox = this.m_20191_().m_82400_((double)this.getSize() * 4.0);
        LivingEntity nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        for (LivingEntity entity : serverLevel.m_45976_(LivingEntity.class, searchBox)) {
            double distance;
            LivingEntity caster;
            if (!entity.m_6084_() || entity.m_20147_() || entity == this.getCaster() || this.isProtectedFromCaster(caster = this.getCaster(), entity) || !((distance = (double)this.m_20270_((Entity)entity)) < nearestDistance)) continue;
            nearestTarget = entity;
            nearestDistance = distance;
        }
        if (nearestTarget != null) {
            Vec3 chainStart = this.m_20182_();
            Vec3 chainEnd = nearestTarget.m_20182_().m_82520_(0.0, (double)(nearestTarget.m_20206_() / 2.0f), 0.0);
            this.spawnChainImpactEffects(chainStart);
            RaevyxLightningChainEntity chainEntity = new RaevyxLightningChainEntity((Level)serverLevel, chainStart, chainEnd, this.getDamage() * 0.8f, this.getSize() * 0.9f, this.getCaster(), true);
            chainEntity.chainCount = this.chainCount + 1;
            chainEntity.maxChains = this.maxChains;
            serverLevel.m_7967_((Entity)chainEntity);
        }
    }

    private boolean isProtectedFromCaster(@Nullable LivingEntity caster, LivingEntity target) {
        DragonEntity dragon;
        if (caster == null) {
            return false;
        }
        if (caster instanceof DragonEntity && (dragon = (DragonEntity)caster).isAlly((Entity)target)) {
            return true;
        }
        return caster.m_7307_((Entity)target);
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        compound.m_128405_("lifespan", this.getLifespan());
        compound.m_128405_("delay", this.getDelay());
        compound.m_128350_("damage", this.getDamage());
        compound.m_128350_("size", this.getSize());
        compound.m_128379_("isChain", this.getIsChain());
        compound.m_128379_("casterFemale", ((Boolean)this.f_19804_.m_135370_(CASTER_FEMALE)).booleanValue());
        compound.m_128405_("chainCount", this.chainCount);
        compound.m_128405_("maxChains", this.maxChains);
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        if (this.startPos != null) {
            compound.m_128347_("startX", this.startPos.f_82479_);
            compound.m_128347_("startY", this.startPos.f_82480_);
            compound.m_128347_("startZ", this.startPos.f_82481_);
        }
        if (this.endPos != null) {
            compound.m_128347_("endX", this.endPos.f_82479_);
            compound.m_128347_("endY", this.endPos.f_82480_);
            compound.m_128347_("endZ", this.endPos.f_82481_);
        }
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        this.setLifespan(compound.m_128451_("lifespan"));
        this.setDelay(compound.m_128451_("delay"));
        this.setDamage(compound.m_128457_("damage"));
        this.setSize(compound.m_128457_("size"));
        this.setIsChain(compound.m_128471_("isChain"));
        if (compound.m_128441_("casterFemale")) {
            this.f_19804_.m_135381_(CASTER_FEMALE, (Object)compound.m_128471_("casterFemale"));
        }
        this.chainCount = compound.m_128451_("chainCount");
        this.maxChains = compound.m_128451_("maxChains");
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
        if (compound.m_128441_("startX")) {
            this.startPos = new Vec3(compound.m_128459_("startX"), compound.m_128459_("startY"), compound.m_128459_("startZ"));
        }
        if (compound.m_128441_("endX")) {
            this.endPos = new Vec3(compound.m_128459_("endX"), compound.m_128459_("endY"), compound.m_128459_("endZ"));
        }
    }
}

