/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.effect.ignivorus;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IgnivorusMagmaPillarEntity
extends Entity
implements GeoEntity {
    private static final RawAnimation EMERGE_ANIMATION = RawAnimation.begin().thenPlay("animation.ignivorus_magma_pillar.emerge");
    private static final RawAnimation SUBSIDE_ANIMATION = RawAnimation.begin().thenPlay("animation.ignivorus_magma_pillar.subside");
    private static final int SUBSIDE_DURATION_TICKS = 9;
    private static final EntityDimensions BASE_DIMENSIONS = EntityDimensions.m_20395_((float)5.5f, (float)5.5f);
    private static final EntityDataAccessor<Integer> DATA_STAGE = SynchedEntityData.m_135353_(IgnivorusMagmaPillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(IgnivorusMagmaPillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_SUBSIDING = SynchedEntityData.m_135353_(IgnivorusMagmaPillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Ignivorus owner;
    private UUID ownerUUID;
    private float impactDamage = 16.0f;
    private double knockbackStrength = 1.0;
    private int warmupTicks = 6;
    private int lifetimeTicks = 36;
    private int livedTicks;
    private int subsideTicks;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private boolean rotationLocked = false;
    private float lockedHeadYaw = 0.0f;

    public IgnivorusMagmaPillarEntity(EntityType<? extends IgnivorusMagmaPillarEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public IgnivorusMagmaPillarEntity(Level level, Vec3 pos, Ignivorus owner, int stageIndex, float impactDamage, double knockbackStrength, int warmupTicks, int lifetimeTicks) {
        this(ModEntities.IGNIVORUS_MAGMA_PILLAR.get(), level);
        this.m_146884_(pos);
        this.owner = owner;
        this.ownerUUID = owner != null ? owner.m_20148_() : null;
        this.impactDamage = impactDamage;
        this.knockbackStrength = knockbackStrength;
        this.warmupTicks = warmupTicks;
        this.lifetimeTicks = lifetimeTicks;
        this.setStage(stageIndex);
        this.setVisualScale(1.0f + (float)stageIndex * 0.2f);
        float ownerYaw = owner != null ? owner.m_146908_() : 0.0f;
        float yaw = (float)Math.round(ownerYaw / 90.0f) * 90.0f;
        this.initializeRotation(yaw);
        this.rotationLocked = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_STAGE, (Object)0);
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_SUBSIDING, (Object)false);
    }

    public void setStage(int stage) {
        this.f_19804_.m_135381_(DATA_STAGE, (Object)Math.max(0, stage));
        this.m_6210_();
    }

    public int getStage() {
        return (Integer)this.f_19804_.m_135370_(DATA_STAGE);
    }

    public void setVisualScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(Math.max(0.5f, scale)));
        this.m_6210_();
    }

    public float getVisualScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public void setImpactDamage(float impactDamage) {
        this.impactDamage = impactDamage;
    }

    public void setKnockbackStrength(double knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public void setWarmupTicks(int warmupTicks) {
        this.warmupTicks = warmupTicks;
    }

    public void setLifetimeTicks(int lifetimeTicks) {
        this.lifetimeTicks = lifetimeTicks;
    }

    public boolean isSubsiding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SUBSIDING);
    }

    private void beginSubside() {
        if (this.isSubsiding()) {
            return;
        }
        this.subsideTicks = 0;
        this.f_19804_.m_135381_(DATA_SUBSIDING, (Object)true);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.livedTicks;
        this.m_20256_(Vec3.f_82478_);
        if (this.m_9236_().f_46443_) {
            this.spawnClientEffects();
        }
        if (this.isSubsiding()) {
            ++this.subsideTicks;
            if (!this.m_9236_().f_46443_ && this.subsideTicks >= 9) {
                this.m_146870_();
            }
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.resolveOwner();
            if (this.livedTicks >= this.warmupTicks) {
                this.applyImpact();
            }
            if (this.livedTicks >= this.lifetimeTicks) {
                this.beginSubside();
            }
        }
    }

    public void m_146922_(float yaw) {
        if (!this.rotationLocked) {
            super.m_146922_(yaw);
        }
    }

    public void m_146926_(float pitch) {
        if (!this.rotationLocked) {
            super.m_146926_(0.0f);
        }
    }

    public void m_5618_(float yaw) {
        if (!this.rotationLocked) {
            super.m_5618_(yaw);
        }
    }

    public void m_5616_(float yaw) {
        if (!this.rotationLocked) {
            super.m_5616_(yaw);
        }
    }

    public float m_6080_() {
        return this.rotationLocked ? this.lockedHeadYaw : super.m_6080_();
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int steps, boolean teleport) {
        if (this.rotationLocked) {
            super.m_6453_(x, y, z, this.lockedHeadYaw, 0.0f, steps, teleport);
        } else {
            super.m_6453_(x, y, z, yRot, xRot, steps, teleport);
        }
    }

    private void resolveOwner() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (this.owner == null && this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.ownerUUID)) instanceof Ignivorus) {
            Ignivorus ignivorus;
            this.owner = ignivorus = (Ignivorus)entity;
        }
    }

    private void applyImpact() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double radius = 1.6 * (double)this.getVisualScale();
        double height = 4.0 + (double)this.getVisualScale() * 2.0;
        AABB area = new AABB(this.m_20185_() - radius, this.m_20186_(), this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + height, this.m_20189_() + radius);
        List hits = server.m_6443_(LivingEntity.class, area, target -> {
            if (!target.m_6084_() || !target.m_5789_()) {
                return false;
            }
            if (target == this.owner) {
                return false;
            }
            if (this.hitEntities.contains(target.m_20148_())) {
                return false;
            }
            return this.owner == null || !this.owner.isAlly((Entity)target);
        });
        DamageSource source = this.owner != null ? this.m_269291_().m_269333_((LivingEntity)this.owner) : this.m_269291_().m_269047_();
        boolean firstHit = this.hitEntities.isEmpty() && !hits.isEmpty();
        for (LivingEntity target2 : hits) {
            this.hitEntities.add(target2.m_20148_());
            target2.m_6469_(source, this.impactDamage);
            target2.m_20254_(4);
            Vec3 knockDir = target2.m_20182_().m_82546_(this.m_20182_());
            knockDir = new Vec3(knockDir.f_82479_, 0.0, knockDir.f_82481_);
            if (knockDir.m_82556_() < 1.0E-4) {
                knockDir = new Vec3(0.0, 0.0, 1.0);
            }
            knockDir = knockDir.m_82541_().m_82490_(this.knockbackStrength);
            double verticalBoost = 0.35 + (double)this.getStage() * 0.05;
            target2.m_5997_(knockDir.f_82479_, verticalBoost, knockDir.f_82481_);
            target2.f_19812_ = true;
            target2.f_19864_ = true;
            if (!(target2 instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target2;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target2));
        }
        if (firstHit) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 20, 0.6, 1.2, 0.6, 0.05);
            server.m_5594_(null, this.m_20183_(), ModSounds.IGNIVORUS_MAGMA_PILLAR.get(), SoundSource.HOSTILE, 1.4f, 0.8f + server.f_46441_.m_188501_() * 0.2f);
        }
    }

    private void spawnClientEffects() {
        if (this.m_9236_().f_46441_.m_188501_() < 0.6f) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, this.m_20185_(), this.m_20186_() + this.m_9236_().f_46441_.m_188500_() * 3.0, this.m_20189_(), 0.0, 0.01, 0.0);
        }
        if (this.m_9236_().f_46441_.m_188501_() < 0.4f) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123801_, this.m_20185_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.6, this.m_20186_() + 0.1, this.m_20189_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.6, 0.0, -0.04, 0.0);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        this.livedTicks = tag.m_128451_("Lived");
        this.lifetimeTicks = tag.m_128451_("Lifetime");
        this.warmupTicks = tag.m_128451_("Warmup");
        this.impactDamage = tag.m_128457_("ImpactDamage");
        this.knockbackStrength = tag.m_128459_("Knockback");
        this.setStage(tag.m_128451_("Stage"));
        this.setVisualScale(tag.m_128457_("Scale"));
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.hitEntities.clear();
        if (tag.m_128441_("HitEntities")) {
            long[] uuidArray = tag.m_128467_("HitEntities");
            for (int i = 0; i < uuidArray.length; i += 2) {
                this.hitEntities.add(new UUID(uuidArray[i], uuidArray[i + 1]));
            }
        }
        if (tag.m_128441_("LockedYaw")) {
            this.initializeRotation(tag.m_128457_("LockedYaw"));
        }
        this.rotationLocked = tag.m_128471_("RotationLocked");
        this.subsideTicks = Math.max(0, tag.m_128451_("SubsideTicks"));
        if (tag.m_128441_("Subsiding")) {
            this.f_19804_.m_135381_(DATA_SUBSIDING, (Object)tag.m_128471_("Subsiding"));
        }
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128405_("Lived", this.livedTicks);
        tag.m_128405_("Lifetime", this.lifetimeTicks);
        tag.m_128405_("Warmup", this.warmupTicks);
        tag.m_128350_("ImpactDamage", this.impactDamage);
        tag.m_128347_("Knockback", this.knockbackStrength);
        tag.m_128405_("Stage", this.getStage());
        tag.m_128350_("Scale", this.getVisualScale());
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128379_("RotationLocked", this.rotationLocked);
        tag.m_128350_("LockedYaw", this.lockedHeadYaw);
        tag.m_128379_("Subsiding", this.isSubsiding());
        tag.m_128405_("SubsideTicks", this.subsideTicks);
        long[] uuidArray = new long[this.hitEntities.size() * 2];
        int i = 0;
        for (UUID uuid : this.hitEntities) {
            uuidArray[i++] = uuid.getMostSignificantBits();
            uuidArray[i++] = uuid.getLeastSignificantBits();
        }
        tag.m_128388_("HitEntities", uuidArray);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        float yaw = packet.m_237567_();
        this.initializeRotation(yaw);
        this.rotationLocked = true;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return BASE_DIMENSIONS.m_20388_(this.getVisualScale());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    private <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> state) {
        if (this.isSubsiding()) {
            state.getController().setAnimation(SUBSIDE_ANIMATION);
        } else {
            state.getController().setAnimation(EMERGE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    private void initializeRotation(float yaw) {
        super.m_146922_(yaw);
        super.m_5618_(yaw);
        super.m_5616_(yaw);
        this.lockedHeadYaw = yaw;
        this.f_19859_ = yaw;
        this.f_19860_ = 0.0f;
    }
}

