/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.effect.cindervane;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CindervaneMagmaBlockEntity
extends Entity {
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE = SynchedEntityData.m_135353_(CindervaneMagmaBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private Cindervane owner;
    private double impactRadius;
    private float impactDamage;
    private int lifetimeTicks;
    private int livedTicks;

    public CindervaneMagmaBlockEntity(EntityType<? extends CindervaneMagmaBlockEntity> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
        this.m_6210_();
    }

    public CindervaneMagmaBlockEntity(Level level, Vec3 pos, Cindervane owner, double impactRadius, float impactDamage, int lifetimeTicks) {
        this(ModEntities.CINDERVANE_MAGMA_BLOCK.get(), level);
        this.m_146884_(pos);
        this.owner = owner;
        this.impactRadius = impactRadius;
        this.impactDamage = impactDamage;
        this.lifetimeTicks = lifetimeTicks;
        this.m_20256_(Vec3.f_82478_);
        this.setBlockState(Blocks.f_50450_.m_49966_());
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_BLOCK_STATE, (Object)Blocks.f_50450_.m_49966_());
    }

    public void setFiringProperties(Cindervane owner, double impactRadius, float impactDamage, int lifetimeTicks) {
        this.owner = owner;
        this.impactRadius = impactRadius;
        this.impactDamage = impactDamage;
        this.lifetimeTicks = lifetimeTicks;
    }

    public void setBlockState(BlockState state) {
        this.f_19804_.m_135381_(DATA_BLOCK_STATE, (Object)state);
    }

    public BlockState getBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_BLOCK_STATE);
    }

    public void m_8119_() {
        if (this.getBlockState().m_60795_()) {
            this.m_146870_();
            return;
        }
        ++this.livedTicks;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            if (this.livedTicks > this.lifetimeTicks) {
                this.explode();
                return;
            }
            if (this.m_20096_()) {
                Vec3 motion = this.m_20184_();
                this.m_20334_(motion.f_82479_ * 0.7, -motion.f_82480_ * 0.5, motion.f_82481_ * 0.7);
                this.explode();
                return;
            }
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            this.spawnTrailParticles();
        }
    }

    private void spawnTrailParticles() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.011, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.003, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123801_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, -0.035, 0.0);
    }

    private void explode() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.m_146870_();
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 impact = this.m_20182_();
        server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, impact.f_82479_, impact.f_82480_ + 0.5, impact.f_82481_, 18, 0.5, 0.3, 0.5, 0.04);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, impact.f_82479_, impact.f_82480_ + 0.5, impact.f_82481_, 30, 0.6, 0.4, 0.6, 0.08);
        server.m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, this.m_5720_(), 0.7f, 1.1f);
        AABB area = new AABB(impact.f_82479_ - this.impactRadius, impact.f_82480_ - this.impactRadius, impact.f_82481_ - this.impactRadius, impact.f_82479_ + this.impactRadius, impact.f_82480_ + this.impactRadius, impact.f_82481_ + this.impactRadius);
        List hits = server.m_6443_(LivingEntity.class, area, target -> target.m_6084_() && target != this.owner && (this.owner == null || !this.owner.isAlly((Entity)target)));
        for (LivingEntity target2 : hits) {
            target2.m_6469_(server.m_269111_().m_269036_((Entity)this, (Entity)(this.owner != null ? this.owner : this)), this.impactDamage);
            target2.m_20254_(4);
        }
        this.igniteArea(server, BlockPos.m_274446_((Position)impact));
        this.m_146870_();
    }

    private void igniteArea(ServerLevel server, BlockPos base) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos below;
                BlockState belowState;
                BlockPos pos = base.m_7918_(dx, 0, dz);
                BlockState state = server.m_8055_(pos);
                if (!state.m_60795_() || (belowState = server.m_8055_(below = pos.m_7495_())).m_60795_() || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)server, pos)) continue;
                server.m_7731_(pos, Blocks.f_50083_.m_49966_(), 11);
            }
        }
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        Level level;
        this.livedTicks = tag.m_128451_("Lived");
        this.lifetimeTicks = tag.m_128451_("Lifetime");
        this.impactRadius = tag.m_128459_("ImpactRadius");
        this.impactDamage = tag.m_128457_("ImpactDamage");
        if (tag.m_128425_("BlockState", 10) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockState state = NbtUtils.m_247651_((HolderGetter)server.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
            this.setBlockState(state.m_60795_() ? Blocks.f_50450_.m_49966_() : state);
        }
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128405_("Lived", this.livedTicks);
        tag.m_128405_("Lifetime", this.lifetimeTicks);
        tag.m_128347_("ImpactRadius", this.impactRadius);
        tag.m_128350_("ImpactDamage", this.impactDamage);
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.getBlockState()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_20334_(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    protected boolean m_7310_(Entity passenger) {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public double m_6048_() {
        return -0.2;
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_269533_(DamageTypeTags.f_268738_);
    }

    public float m_20236_(@NotNull Pose pose) {
        return 0.5f;
    }

    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return EntityDimensions.m_20398_((float)0.98f, (float)0.98f);
    }

    @Nullable
    public Cindervane getOwner() {
        return this.owner;
    }
}

