/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.util;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class DragonDestructionManager {
    private static final Map<BlockPos, Integer> blockMeltProgress = new HashMap<BlockPos, Integer>();
    private static final Map<BlockPos, Long> lastExposureTick = new HashMap<BlockPos, Long>();

    private DragonDestructionManager() {
    }

    public static void applyFireBreathImpact(ServerLevel level, DragonEntity dragon, Vec3 impactPoint, double radius, float damage, int fireSeconds, int meltTicksRequired, boolean canMeltBlocks) {
        if (level == null || dragon == null || impactPoint == null) {
            return;
        }
        DragonDestructionManager.damageEntities(level, dragon, impactPoint, radius, damage, fireSeconds);
        DragonDestructionManager.igniteBlocks(level, impactPoint, radius);
        if (canMeltBlocks && meltTicksRequired > 0) {
            double destructionRadius = radius * 0.4;
            DragonDestructionManager.meltBlocks(level, impactPoint, destructionRadius, meltTicksRequired);
        }
    }

    private static void damageEntities(ServerLevel level, DragonEntity dragon, Vec3 impactPoint, double radius, float damage, int fireSeconds) {
        AABB area = new AABB(impactPoint, impactPoint).m_82400_(radius);
        HashSet<LivingEntity> hit = new HashSet<LivingEntity>();
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, area, e -> e.m_6084_() && e != dragon && !dragon.isAlly((Entity)e))) {
            if (!hit.add(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269254_(), damage);
            entity.m_20254_(fireSeconds);
        }
    }

    private static void igniteBlocks(ServerLevel level, Vec3 impactPoint, double radius) {
        BlockPos center = BlockPos.m_274446_((Position)impactPoint);
        int r = (int)Math.ceil(radius);
        RandomSource random = level.f_46441_;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-r, -r, -r), (BlockPos)center.m_7918_(r, r, r))) {
            BlockPos above;
            double dz;
            double dy;
            double dx;
            double distSq;
            if (random.m_188501_() > 0.35f || (distSq = (dx = (double)pos.m_123341_() + 0.5 - impactPoint.f_82479_) * dx + (dy = (double)pos.m_123342_() + 0.5 - impactPoint.f_82480_) * dy + (dz = (double)pos.m_123343_() + 0.5 - impactPoint.f_82481_) * dz) > radius * radius || !level.m_46749_(pos)) continue;
            if (level.m_46859_(pos)) {
                BlockState fire = Blocks.f_50083_.m_49966_();
                if (!fire.m_60710_((LevelReader)level, pos)) continue;
                level.m_7731_(pos, fire, 11);
                continue;
            }
            if (!(random.m_188501_() < 0.15f) || !level.m_46859_(above = pos.m_7494_()) || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)level, above)) continue;
            level.m_7731_(above, Blocks.f_50083_.m_49966_(), 11);
        }
    }

    private static void meltBlocks(ServerLevel level, Vec3 impactPoint, double radius, int requiredTicks) {
        BlockPos center = BlockPos.m_274446_((Position)impactPoint);
        int r = (int)Math.ceil(radius);
        long currentTick = level.m_46467_();
        HashSet<BlockPos> exposedThisTick = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-r, -r, -r), (BlockPos)center.m_7918_(r, r, r))) {
            BlockState state;
            double dz;
            double dy;
            double dx = (double)pos.m_123341_() + 0.5 - impactPoint.f_82479_;
            double distSq = dx * dx + (dy = (double)pos.m_123342_() + 0.5 - impactPoint.f_82480_) * dy + (dz = (double)pos.m_123343_() + 0.5 - impactPoint.f_82481_) * dz;
            if (distSq > radius * radius || !level.m_46749_(pos) || (state = level.m_8055_(pos)).m_60795_() || !DragonDestructionManager.canMeltBlock(state)) continue;
            BlockPos immutablePos = pos.m_7949_();
            exposedThisTick.add(immutablePos);
            int progress = blockMeltProgress.getOrDefault(immutablePos, 0);
            blockMeltProgress.put(immutablePos, ++progress);
            lastExposureTick.put(immutablePos, currentTick);
            if (progress < requiredTicks) continue;
            level.m_46961_(immutablePos, true);
            blockMeltProgress.remove(immutablePos);
            lastExposureTick.remove(immutablePos);
        }
        DragonDestructionManager.cleanupStaleProgress(currentTick);
    }

    private static void cleanupStaleProgress(long currentTick) {
        lastExposureTick.entrySet().removeIf(entry -> {
            boolean isStale;
            long lastTick = (Long)entry.getValue();
            boolean bl = isStale = currentTick - lastTick > 20L;
            if (isStale) {
                blockMeltProgress.remove(entry.getKey());
            }
            return isStale;
        });
    }

    private static boolean canMeltBlock(BlockState state) {
        if (state.m_60800_(null, null) < 0.0f) {
            return false;
        }
        return state.m_60734_() != Blocks.f_50752_ && state.m_60734_() != Blocks.f_50375_ && state.m_60734_() != Blocks.f_50272_ && state.m_60734_() != Blocks.f_50448_ && state.m_60734_() != Blocks.f_50447_ && state.m_60734_() != Blocks.f_50677_ && state.m_60734_() != Blocks.f_50678_ && state.m_60734_() != Blocks.f_50257_ && state.m_60734_() != Blocks.f_50258_ && state.m_60734_() != Blocks.f_50446_;
    }
}

