/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class StegonautAnimationHandler {
    private final Stegonaut drake;
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.idle");
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.walk");
    private static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.swim");
    private static final RawAnimation SLEEP_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.sleep");
    private static final RawAnimation SIT_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.sit");
    private static final RawAnimation SIT_DOWN = RawAnimation.begin().thenPlay("animation.stegonaut.down");
    private static final RawAnimation SIT_UP = RawAnimation.begin().thenPlay("animation.stegonaut.up");
    private static final RawAnimation FALL_ASLEEP = RawAnimation.begin().thenPlay("animation.stegonaut.fall_asleep");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("animation.stegonaut.wake_up");

    public StegonautAnimationHandler(Stegonaut drake) {
        this.drake = drake;
    }

    public void triggerSitDownAnimation() {
        this.drake.triggerAnim("action", "sit_down");
    }

    public void triggerSitUpAnimation() {
        this.drake.triggerAnim("action", "sit_up");
    }

    public void triggerFallAsleepAnimation() {
        this.drake.triggerAnim("action", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.drake.triggerAnim("action", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.drake.triggerAnim("action", "wake_up");
    }

    public PlayState handleMovementAnimation(AnimationState<Stegonaut> state) {
        state.getController().transitionLength(8);
        if (this.drake.m_9236_().f_46443_ && !this.drake.isClientAnimationReady()) {
            state.setAndContinue(IDLE_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.drake.m_20072_()) {
            state.getController().transitionLength(6);
            state.setAndContinue(SWIM_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.drake.m_5803_() && !this.drake.isSleepingEntering() && !this.drake.isSleepingExiting()) {
            state.getController().transitionLength(6);
            state.setAndContinue(SLEEP_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.drake.isSleepingEntering() || this.drake.isSleepingExiting()) {
            return PlayState.STOP;
        }
        if (this.drake.getSitProgress() > 0.5f) {
            state.getController().transitionLength(4);
            state.setAndContinue(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        int groundState = this.drake.getEffectiveGroundState();
        if (groundState >= 1 || this.drake.isWalking()) {
            state.setAndContinue(WALK_ANIM);
        } else {
            state.setAndContinue(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void initializeAnimation() {
    }

    public void resetAnimationState() {
    }

    public void setupActionController(AnimationController<Stegonaut> actionController) {
        actionController.triggerableAnim("grumble1", RawAnimation.begin().thenPlay("animation.stegonaut.grumble1"));
        actionController.triggerableAnim("grumble2", RawAnimation.begin().thenPlay("animation.stegonaut.grumble2"));
        actionController.triggerableAnim("grumble3", RawAnimation.begin().thenPlay("animation.stegonaut.grumble3"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.stegonaut.eat"));
        actionController.triggerableAnim("hurt", RawAnimation.begin().thenPlay("animation.stegonaut.hurt"));
        actionController.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.stegonaut.die"));
        actionController.triggerableAnim("sit_down", SIT_DOWN);
        actionController.triggerableAnim("sit_up", SIT_UP);
        actionController.triggerableAnim("fall_asleep", FALL_ASLEEP);
        actionController.triggerableAnim("sleep", SLEEP_ANIM);
        actionController.triggerableAnim("wake_up", WAKE_UP);
    }

    public PlayState actionPredicate(AnimationState<Stegonaut> state) {
        state.getController().transitionLength(5);
        return PlayState.STOP;
    }
}

