/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RaevyxTamingHandler {
    private final Raevyx wyvern;
    private int failureCounter = 0;
    private float recoveryTargetHealth = -1.0f;
    private int stunGraceTicks = 0;
    private boolean aiLocked = false;
    private boolean awaitingFeed = false;
    private int stunTimeoutTicks = 0;
    private static final int STUN_TIMEOUT = 600;

    public RaevyxTamingHandler(Raevyx wyvern) {
        this.wyvern = wyvern;
    }

    public void tickServer() {
        this.tickRecovery();
    }

    public boolean isAwaitingFeed() {
        return this.awaitingFeed;
    }

    public void enterStun() {
        this.awaitingFeed = false;
        this.stunGraceTicks = Math.max(this.stunGraceTicks, 20);
        this.recoveryTargetHealth = -1.0f;
        this.stunTimeoutTicks = 0;
        this.ensureStunState();
    }

    public void enterHoldState() {
        this.awaitingFeed = true;
        this.stunGraceTicks = 0;
        this.recoveryTargetHealth = -1.0f;
        this.stunTimeoutTicks = 600;
        this.ensureStunState();
        if (!this.wyvern.m_9236_().f_46443_) {
            this.wyvern.m_5496_(SoundEvents.f_11686_, 1.5f, 0.8f);
        }
    }

    public void setRecoveryTarget(float targetHealth) {
        this.awaitingFeed = false;
        this.recoveryTargetHealth = Math.max(0.0f, Math.min(targetHealth, this.wyvern.m_21233_()));
        this.stunGraceTicks = Math.max(this.stunGraceTicks, 40);
        this.stunTimeoutTicks = 0;
        this.ensureStunState();
    }

    public void clearRecovery() {
        this.recoveryTargetHealth = -1.0f;
        this.stunGraceTicks = 0;
        this.awaitingFeed = false;
        this.stunTimeoutTicks = 0;
        boolean wasStunned = this.wyvern.isTamingStunned();
        if (this.wyvern.isTamingStunned()) {
            this.wyvern.m_20088_().m_135381_(Raevyx.DATA_TAMING_STUNNED, (Object)false);
        }
        if (this.aiLocked && !this.wyvern.m_9236_().f_46443_) {
            this.aiLocked = false;
            this.wyvern.m_21557_(false);
        }
    }

    public void incrementFailures() {
        ++this.failureCounter;
    }

    public void resetFailures() {
        this.failureCounter = 0;
    }

    public int getFailureCounter() {
        return this.failureCounter;
    }

    public void save(CompoundTag tag) {
        tag.m_128405_("TamingFailures", Math.max(0, this.failureCounter));
        tag.m_128350_("TamingTargetHealth", this.recoveryTargetHealth);
        tag.m_128405_("TamingStunGraceTicks", Math.max(0, this.stunGraceTicks));
        tag.m_128379_("TamingAiLocked", this.aiLocked);
        tag.m_128379_("TamingAwaitingFeed", this.awaitingFeed);
        tag.m_128379_("TamingStunned", this.wyvern.isTamingStunned());
        tag.m_128405_("TamingStunTimeout", Math.max(0, this.stunTimeoutTicks));
    }

    public void load(CompoundTag tag) {
        this.failureCounter = Math.max(0, tag.m_128451_("TamingFailures"));
        this.recoveryTargetHealth = tag.m_128441_("TamingTargetHealth") ? tag.m_128457_("TamingTargetHealth") : -1.0f;
        this.stunGraceTicks = Math.max(0, tag.m_128451_("TamingStunGraceTicks"));
        this.aiLocked = tag.m_128471_("TamingAiLocked");
        this.awaitingFeed = tag.m_128471_("TamingAwaitingFeed");
        this.stunTimeoutTicks = Math.max(0, tag.m_128451_("TamingStunTimeout"));
        if (tag.m_128471_("TamingStunned")) {
            this.wyvern.m_20088_().m_135381_(Raevyx.DATA_TAMING_STUNNED, (Object)true);
            if (this.aiLocked && !this.wyvern.m_9236_().f_46443_) {
                this.wyvern.m_21557_(true);
            }
        } else {
            this.clearRecovery();
        }
    }

    private void tickRecovery() {
        Level level = this.wyvern.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!this.wyvern.m_21824_() && !this.wyvern.isTamingStunned() && this.wyvern.isBelowTamingThreshold()) {
            this.enterHoldState();
        }
        if (!this.wyvern.isTamingStunned()) {
            return;
        }
        this.ensureStunState();
        if (this.awaitingFeed) {
            if (this.stunTimeoutTicks > 0) {
                --this.stunTimeoutTicks;
                if (this.stunTimeoutTicks <= 0) {
                    this.wyvern.m_21153_(this.wyvern.m_21233_());
                    List nearbyPlayers = level.m_6443_(Player.class, this.wyvern.m_20191_().m_82400_(32.0), p -> p instanceof ServerPlayer);
                    for (Player player : nearbyPlayers) {
                        if (!(player instanceof ServerPlayer)) continue;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.raevyx.taming_timeout", (Object[])new Object[]{this.wyvern.m_7755_()}), true);
                    }
                    this.clearRecovery();
                }
            }
            return;
        }
        if (this.stunGraceTicks > 0) {
            --this.stunGraceTicks;
        }
        if (this.recoveryTargetHealth > 0.0f && this.wyvern.m_21223_() + 0.5f < this.recoveryTargetHealth) {
            float missing = this.recoveryTargetHealth - this.wyvern.m_21223_();
            float healPerTick = Math.max(2.0f, this.wyvern.m_21233_() * 0.02f);
            this.wyvern.m_5634_(Math.min(healPerTick, missing));
        } else if (this.stunGraceTicks <= 0) {
            this.clearRecovery();
        }
    }

    private void ensureStunState() {
        boolean wasStunned = this.wyvern.isTamingStunned();
        if (!this.wyvern.m_9236_().f_46443_ && !this.aiLocked) {
            this.wyvern.m_21557_(true);
            this.aiLocked = true;
        }
        this.wyvern.m_6710_(null);
        this.wyvern.m_21561_(false);
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.m_20256_(Vec3.f_82478_);
        if (this.wyvern.m_20160_()) {
            this.wyvern.m_20153_();
        }
        this.wyvern.m_20088_().m_135381_(Raevyx.DATA_TAMING_STUNNED, (Object)true);
    }
}

