/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public record RaevyxAnimationHandler(Raevyx wyvern) {
    private static final RawAnimation GROUND_IDLE = RawAnimation.begin().thenLoop("animation.raevyx.idle");
    private static final RawAnimation GROUND_WALK = RawAnimation.begin().thenLoop("animation.raevyx.walk");
    private static final RawAnimation GROUND_RUN = RawAnimation.begin().thenLoop("animation.raevyx.run");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.raevyx.sit");
    private static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("animation.raevyx.takeoff");
    private static final RawAnimation FLY_GLIDE = RawAnimation.begin().thenLoop("animation.raevyx.fly_glide");
    private static final RawAnimation GLIDE_DOWN = RawAnimation.begin().thenLoop("animation.raevyx.glide_down");
    private static final RawAnimation FLAP = RawAnimation.begin().thenLoop("animation.raevyx.flap");
    private static final RawAnimation FLY_IDLE = RawAnimation.begin().thenLoop("animation.raevyx.fly_idle");
    private static final RawAnimation SPRINT_FLAP = RawAnimation.begin().thenLoop("animation.raevyx.sprint_flap");
    private static final RawAnimation LANDING = RawAnimation.begin().thenPlay("animation.raevyx.landing");
    private static final RawAnimation LANDED = RawAnimation.begin().thenPlay("animation.raevyx.landed");
    private static final RawAnimation DODGE = RawAnimation.begin().thenPlay("animation.raevyx.dodge");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.raevyx.swim");
    private static final RawAnimation STUNNED = RawAnimation.begin().thenLoop("animation.raevyx.stunned");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.raevyx.sleep");
    private static RawAnimation currentFlightAnimation = FLY_GLIDE;

    public void triggerSitDownAnimation() {
        this.wyvern.triggerAnim("action", "sit_down");
    }

    public void triggerSitUpAnimation() {
        this.wyvern.triggerAnim("action", "sit_up");
    }

    public void triggerFallAsleepAnimation() {
        this.wyvern.triggerAnim("action", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.wyvern.triggerAnim("action", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.wyvern.triggerAnim("action", "wake_up");
    }

    public void triggerDodgeLeftAnimation() {
        this.wyvern.triggerAnim("action", "dodge_left");
    }

    public void triggerDodgeRightAnimation() {
        this.wyvern.triggerAnim("action", "dodge_right");
    }

    public PlayState handleMovementAnimation(AnimationState<Raevyx> state) {
        boolean inWater;
        state.getController().transitionLength(6);
        if (this.wyvern.areRiderControlsLocked()) {
            return PlayState.STOP;
        }
        if (this.wyvern.m_9236_().f_46443_ && !this.wyvern.isClientAnimationReady()) {
            state.setAndContinue(GROUND_IDLE);
            return PlayState.CONTINUE;
        }
        boolean bl = inWater = this.wyvern.m_20069_() || this.wyvern.m_20072_();
        if (inWater) {
            state.getController().transitionLength(4);
            state.setAndContinue(SWIM);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isDying()) {
            return PlayState.STOP;
        }
        if (this.wyvern.isTamingStunned()) {
            state.getController().transitionLength(4);
            state.setAndContinue(STUNNED);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.m_5803_() && !this.wyvern.isSleepingEntering() && !this.wyvern.isSleepingExiting()) {
            state.getController().transitionLength(6);
            state.setAndContinue(SLEEP);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isSleepingEntering() || this.wyvern.isSleepingExiting()) {
            return PlayState.STOP;
        }
        float maxSit = this.wyvern.maxSitTicks();
        float sitProgress = this.wyvern.getSitProgress();
        if (sitProgress >= maxSit) {
            state.setAndContinue(SIT);
            return PlayState.CONTINUE;
        }
        if (sitProgress > 0.0f) {
            return PlayState.STOP;
        }
        if (this.wyvern.m_6162_()) {
            if (this.wyvern.isActuallyRunning()) {
                state.getController().transitionLength(3);
                state.setAndContinue(GROUND_RUN);
            } else if (this.wyvern.isWalking()) {
                state.getController().transitionLength(3);
                state.setAndContinue(GROUND_WALK);
            } else {
                state.getController().transitionLength(4);
                state.setAndContinue(GROUND_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isDodging()) {
            state.setAndContinue(DODGE);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isLanding()) {
            state.setAndContinue(LANDING);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.m_29443_()) {
            int syncedMode = this.wyvern.getSyncedFlightMode();
            Vec3 vNow = this.wyvern.m_20184_();
            if (syncedMode == 3) {
                state.getController().transitionLength(4);
                state.setAndContinue(TAKEOFF);
                return PlayState.CONTINUE;
            }
            if (this.wyvern.isRiderLandingBlendActive()) {
                state.getController().transitionLength(4);
                currentFlightAnimation = LANDING;
                state.setAndContinue(LANDING);
                return PlayState.CONTINUE;
            }
            if (this.wyvern.m_20160_() && this.wyvern.isGoingDown() && !this.wyvern.isRiderLandingBlendActive()) {
                RawAnimation descend = GLIDE_DOWN;
                if (currentFlightAnimation != descend) {
                    state.getController().transitionLength(6);
                    currentFlightAnimation = descend;
                }
                state.setAndContinue(descend);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 5) {
                RawAnimation hover = FLY_IDLE;
                if (currentFlightAnimation != hover) {
                    state.getController().transitionLength(6);
                    currentFlightAnimation = hover;
                }
                state.setAndContinue(hover);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 4) {
                RawAnimation sprint = SPRINT_FLAP;
                if (currentFlightAnimation != sprint) {
                    state.getController().transitionLength(3);
                    currentFlightAnimation = sprint;
                }
                state.setAndContinue(sprint);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 2) {
                state.getController().transitionLength(6);
                state.setAndContinue(FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 1) {
                state.getController().transitionLength(4);
                state.setAndContinue(FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 0) {
                state.getController().transitionLength(12);
                state.setAndContinue(FLY_GLIDE);
                return PlayState.CONTINUE;
            }
            state.getController().transitionLength(12);
            state.setAndContinue(FLY_GLIDE);
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isActuallyRunning()) {
            state.getController().transitionLength(3);
            state.setAndContinue(GROUND_RUN);
        } else if (this.wyvern.isWalking()) {
            state.getController().transitionLength(3);
            state.setAndContinue(GROUND_WALK);
        } else {
            state.getController().transitionLength(4);
            state.setAndContinue(GROUND_IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void setupActionController(AnimationController<Raevyx> actionController) {
        this.registerVocalTriggers(actionController);
        actionController.triggerableAnim("lightning_bite", RawAnimation.begin().thenPlay("animation.raevyx.lightning_bite"));
        actionController.triggerableAnim("horn_gore", RawAnimation.begin().thenPlay("animation.raevyx.horn_gore"));
        actionController.triggerableAnim("dodge_left", RawAnimation.begin().thenPlay("animation.raevyx.dodge_left"));
        actionController.triggerableAnim("dodge_right", RawAnimation.begin().thenPlay("animation.raevyx.dodge_right"));
        actionController.triggerableAnim("lightning_beam_start", RawAnimation.begin().thenPlay("animation.raevyx.lightning_beam_start"));
        actionController.triggerableAnim("lightning_beaming", RawAnimation.begin().thenLoop("animation.raevyx.lightning_beaming"));
        actionController.triggerableAnim("lightning_beam_stop", RawAnimation.begin().thenPlay("animation.raevyx.lightning_beam_stop"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.raevyx.eat"));
        actionController.triggerableAnim("summon_storm_ground_start", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_ground_start"));
        actionController.triggerableAnim("summon_storm_ground", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_ground"));
        actionController.triggerableAnim("summon_storm_ground_end", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_ground_end"));
        actionController.triggerableAnim("summon_storm_air_start", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_air_start"));
        actionController.triggerableAnim("summon_storm_air", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_air"));
        actionController.triggerableAnim("summon_storm_air_end", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_air_end"));
        actionController.triggerableAnim("sit_down", RawAnimation.begin().thenPlay("animation.raevyx.down"));
        actionController.triggerableAnim("sit_up", RawAnimation.begin().thenPlay("animation.raevyx.up"));
        actionController.triggerableAnim("fall_asleep", RawAnimation.begin().thenPlay("animation.raevyx.fall_asleep"));
        actionController.triggerableAnim("sleep", RawAnimation.begin().thenLoop("animation.raevyx.sleep"));
        actionController.triggerableAnim("wake_up", RawAnimation.begin().thenPlay("animation.raevyx.wake_up"));
        actionController.triggerableAnim("landed", LANDED);
        actionController.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.raevyx.die"));
    }

    private void registerVocalTriggers(AnimationController<Raevyx> action) {
        this.wyvern.getVocalEntries().forEach((key, entry) -> {
            if (entry.animationId() != null && !entry.animationId().isEmpty()) {
                action.triggerableAnim(key, RawAnimation.begin().thenPlay(entry.animationId()));
            }
        });
    }

    public PlayState bankingPredicate(AnimationState<Raevyx> state) {
        boolean inWater;
        if (this.wyvern.m_9236_().f_46443_ && !this.wyvern.isClientAnimationReady()) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.banking_off"));
            return PlayState.CONTINUE;
        }
        if (this.wyvern.m_5803_() || this.wyvern.isSleepingEntering() || this.wyvern.isSleepingExiting() || this.wyvern.isTamingStunned() || this.wyvern.areRiderControlsLocked()) {
            return PlayState.STOP;
        }
        boolean bl = inWater = this.wyvern.m_20069_() || this.wyvern.m_20072_();
        if (inWater) {
            return PlayState.STOP;
        }
        state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.banking_off"));
        return PlayState.CONTINUE;
    }

    public PlayState pitchingPredicate(AnimationState<Raevyx> state) {
        boolean inWater;
        if (this.wyvern.m_9236_().f_46443_ && !this.wyvern.isClientAnimationReady()) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_off"));
            return PlayState.CONTINUE;
        }
        if (this.wyvern.m_5803_() || this.wyvern.isSleepingEntering() || this.wyvern.isSleepingExiting() || this.wyvern.isTamingStunned() || this.wyvern.areRiderControlsLocked()) {
            return PlayState.STOP;
        }
        boolean bl = inWater = this.wyvern.m_20069_() || this.wyvern.m_20072_();
        if (inWater) {
            return PlayState.STOP;
        }
        double pitchDir = this.wyvern.getPitchDirection();
        if (pitchDir > 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_down"));
        } else if (pitchDir < 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_up"));
        } else {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_off"));
        }
        return PlayState.CONTINUE;
    }
}

