/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfig;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModItems;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonFloatGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonWaterEscapeGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxAirCombatGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxBreedGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFlightGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxGroundCombatGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxProtectBabiesGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxTemptGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.baby.RaevyxFollowParentGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.behavior.DragonSleepBehavior;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityProfile;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxRiderController;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxSoundProfile;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxTamingHandler;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ElectricalConductivityCapable;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Raevyx
extends RideableDragonBase
implements FlyingAnimal,
DragonFlightCapable,
ShakesScreen,
SoundHandledDragon,
ElectricalConductivityCapable {
    private static final float TAMING_HEALTH_RATIO = 0.33333334f;
    public static final int MIN_AMBIENT_DELAY = 200;
    public static final int MAX_AMBIENT_DELAY = 600;
    public static final float MODEL_SCALE = 1.0f;
    public static final int AGGRO_TTL_TICKS = 200;
    public static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_TAKEOFF = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_HOVERING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_LANDING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_LANDED = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_GROUND_MOVE_STATE = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_FLIGHT_MODE = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_RIDER_FORWARD = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_RIDER_STRAFE = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_SCREEN_SHAKE_AMOUNT = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DATA_BEAMING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_BEAM_GLOW = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_RIDER_LANDING_BLEND = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_BEAM_END_SET = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_BEAM_END_X = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_BEAM_END_Y = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_BEAM_END_Z = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DATA_BEAM_START_SET = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_BEAM_START_X = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_BEAM_START_Y = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_BEAM_START_Z = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DATA_GOING_UP = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_GOING_DOWN = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_ACCELERATING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_SLEEPING_ENTERING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_SLEEPING_EXITING = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_FEEDING_COOLDOWN = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_TAMING_STUNNED = SynchedEntityData.m_135353_(Raevyx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimatableInstanceCache dragonCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final float MAX_BEAM_YAW_DEG = 40.0f;
    public static final float MAX_BEAM_PITCH_DEG = 50.0f;
    private double cachedOwnerDistance = Double.MAX_VALUE;
    private int ownerDistanceCacheTime = -1;
    private List<Projectile> cachedNearbyProjectiles = new ArrayList<Projectile>();
    private int nearbyProjectilesCacheTime = -1;
    private int projectileCacheIntervalTicks = 3;
    private int emptyProjectileScans = 0;
    private double cachedHorizontalSpeed = 0.0;
    private int horizontalSpeedCacheTime = -1;
    private static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    private static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    private static final double RIDER_LOW_ALTITUDE_GLIDE_THRESHOLD = 6.0;
    private static final double RIDER_WATER_SURFACE_LEVEL = 62.0;
    private static final double RIDER_WATER_SURFACE_TOLERANCE = 2.0;
    private static final int RIDER_WATER_SCAN_RADIUS = 2;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.5;
    private static final int RIDER_LANDING_BLEND_DURATION = 5;
    private boolean inHighAltitudeGlide = false;
    private double lastCheckedX = 0.0;
    private double lastCheckedY = 0.0;
    private double lastCheckedZ = 0.0;
    private int ticksSinceLastMovement = 0;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.raevyx.grumble1", ModSounds.RAEVYX_GRUMBLE_1, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble2", "action", "animation.raevyx.grumble2", ModSounds.RAEVYX_GRUMBLE_2, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble3", "action", "animation.raevyx.grumble3", ModSounds.RAEVYX_GRUMBLE_3, 0.8f, 0.95f, 0.1f, false, false, false).add("purr", "action", "animation.raevyx.purr", ModSounds.RAEVYX_PURR, 0.8f, 1.05f, 0.05f, true, false, true).add("snort", "action", "animation.raevyx.snort", ModSounds.RAEVYX_SNORT, 0.9f, 0.9f, 0.2f, false, false, false).add("chuff", "action", "animation.raevyx.chuff", ModSounds.RAEVYX_CHUFF, 0.9f, 0.9f, 0.2f, false, false, false).add("content", "action", "animation.raevyx.content", ModSounds.RAEVYX_CONTENT, 0.8f, 1.0f, 0.1f, true, false, true).add("excited", "action", "", ModSounds.RAEVYX_EXCITED, 1.0f, 1.0f, 0.3f, false, false, false).add("growl_warning", "action", "", ModSounds.RAEVYX_GROWL_WARNING, 1.2f, 0.8f, 0.4f, false, false, false).add("roar", "action", "animation.raevyx.roar", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_ground", "action", "animation.raevyx.roar_ground", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_air", "action", "animation.raevyx.roar_air", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("raevyx_hurt", "hurt", "animation.raevyx.hurt", ModSounds.RAEVYX_HURT, 1.2f, 0.95f, 0.1f, true, true, true).add("raevyx_die", "action", "animation.raevyx.die", ModSounds.RAEVYX_DIE, 1.5f, 0.95f, 0.1f, false, true, true).add("baby_raevyx_hurt", "hurt", "animation.raevyx.hurt", ModSounds.BABY_RAEVYX_HURT, 1.4f, 1.05f, 0.15f, true, true, true).add("baby_raevyx_die", "action", "animation.raevyx.die", ModSounds.BABY_RAEVYX_DIE, 1.3f, 1.0f, 0.1f, false, true, true).build();
    private boolean manualSitCommand = false;
    private boolean commandChangeManual = false;
    private int riderLandingBlendTicks = 0;
    private static final int DISMOUNT_RECALL_WINDOW = 60;
    private int dismountRecallTicks = 0;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    public int timeFlying = 0;
    public boolean landingFlag = false;
    public boolean landedFlag = false;
    public int landingTimer = 0;
    public int landedTimer = 0;
    int runningTicks = 0;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    private static final double DODGE_HORIZONTAL_DRAG = 0.92;
    private static final double DODGE_VERTICAL_DRAG = 0.95;
    boolean dodging = false;
    int dodgeTicksLeft = 0;
    Vec3 dodgeVec = Vec3.f_82478_;
    int dodgeCooldownTicks = 0;
    int dodgeIFramesTicks = 0;
    private float preDodgeStepHeight = 1.0f;
    private int clientAnimInitTicks = 0;
    private static final int ANIM_INIT_GRACE_PERIOD = 5;
    private boolean allowGroundBeamDuringStorm = false;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepFallAsleepTriggered = false;
    private boolean sleepSitUpTriggered = false;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private int followFailsafeCooldown = 0;
    private int postStandUnlockTicks = 0;
    private final RaevyxTamingHandler tamingController = new RaevyxTamingHandler(this);
    private int tamingAbortCalmTicks = 0;
    private int riderTakeoffTicks = 0;
    private long lastLandingGameTime = Long.MIN_VALUE;
    public final GroundPathNavigation groundNav;
    public final FlyingPathNavigation airNav;
    public boolean usingAirNav = false;
    public static final double RIDER_WALK_SPEED = 0.18;
    public static final double RIDER_RUN_SPEED = 0.4;
    private final RaevyxInteractionHandler lightningInteractionHandler;
    private final RaevyxAnimationHandler animationHandler;
    private final RaevyxRiderController riderController;
    private final DragonSoundHandler soundHandler;
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();
    private int hurtSoundCooldown = 0;
    private Vec3 prevClientBeamEnd = null;
    private Vec3 clientBeamEnd = null;
    private Vec3 beamLookLerp = null;
    private Vec3 beamAimDir = null;
    private float beamYawOffsetRad = 0.0f;
    private float beamPitchOffsetRad = 0.0f;
    private int beamTime = 0;
    private Vec3 beamServerTarget = null;
    private static final double WATER_EFFECT_MAX_HEIGHT = 8.0;
    private static final double WATER_EFFECT_INTENSITY = 0.6;
    private boolean wasVehicleLastTick = false;
    private boolean shouldSpawnBabies = false;
    private int babiesToSpawn = 0;
    private int superchargeTicks = 0;
    private int tempInvulnTicks = 0;
    private int superchargeVfxCooldown = 0;
    private int takeoffLockTicks = 0;
    private final Map<Integer, Long> recentAggroIds = new ConcurrentHashMap<Integer, Long>();
    private int aggroGrowlCooldown = 0;
    private static final ElectricalConductivityProfile CONDUCTIVITY_PROFILE = new ElectricalConductivityProfile(1.0f, 0.5f, 0.0f, 1.0, 0.3, 0.0);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.dragonCache;
    }

    @Override
    public void setCommand(int command) {
        int previous = super.getCommand();
        super.setCommand(command);
        this.manualSitCommand = command == 1 ? this.commandChangeManual || this.manualSitCommand : false;
        this.commandChangeManual = false;
    }

    public void setCommandManual(int command) {
        this.commandChangeManual = true;
        this.setCommand(command);
    }

    public void setCommandAuto(int command) {
        this.commandChangeManual = false;
        this.setCommand(command);
    }

    public boolean shouldForceOwnerFollow() {
        return this.dismountRecallTicks > 0;
    }

    public void clearForcedOwnerFollow() {
        this.dismountRecallTicks = 0;
    }

    private boolean getBooleanData(EntityDataAccessor<Boolean> accessor) {
        return (Boolean)this.f_19804_.m_135370_(accessor);
    }

    private void setBooleanData(EntityDataAccessor<Boolean> accessor, boolean value) {
        this.f_19804_.m_135381_(accessor, (Object)value);
    }

    private int getIntegerData(EntityDataAccessor<Integer> accessor) {
        return (Integer)this.f_19804_.m_135370_(accessor);
    }

    private float getFloatData(EntityDataAccessor<Float> accessor) {
        return ((Float)this.f_19804_.m_135370_(accessor)).floatValue();
    }

    public boolean canFeed() {
        int cooldownTicks = (Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN);
        return cooldownTicks > 0;
    }

    public void setFeedingCooldown(int ticks) {
        this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)ticks);
    }

    public boolean isTamingStunned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAMING_STUNNED);
    }

    public void enterTamingStun() {
        this.tamingController.enterStun();
    }

    public void setTamingRecoveryTarget(float targetHealth) {
        this.tamingController.setRecoveryTarget(targetHealth);
    }

    public void clearTamingRecovery() {
        this.tamingController.clearRecovery();
    }

    public void incrementTamingFailures() {
        this.tamingController.incrementFailures();
    }

    public void resetTamingFailures() {
        this.tamingController.resetFailures();
    }

    public boolean isAwaitingTamingFeed() {
        return this.tamingController.isAwaitingFeed();
    }

    public void abortTamingAttempt() {
        this.abortTamingAttempt(true);
    }

    public void abortTamingAttempt(boolean restoreHealth) {
        this.clearTamingRecovery();
        this.resetTamingFailures();
        this.m_6710_(null);
        this.m_21561_(false);
        this.m_6703_(null);
        this.m_6598_(null);
        this.combatManager.clearAllStates();
        this.f_19864_ = false;
        if (restoreHealth && this.m_6084_()) {
            this.m_21153_(this.m_21233_());
        }
        this.tamingAbortCalmTicks = Math.max(this.tamingAbortCalmTicks, 100);
    }

    public boolean isBelowTamingThreshold() {
        return this.m_21223_() <= this.getTamingThreshold();
    }

    public float getTamingThreshold() {
        return this.m_21233_() * 0.33333334f;
    }

    public long getLastLandingGameTime() {
        return this.lastLandingGameTime;
    }

    @Override
    public void markLandedNow() {
        this.setFlying(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.riderTakeoffTicks = 0;
        this.timeFlying = 0;
        if (!this.m_9236_().f_46443_) {
            this.lastLandingGameTime = this.m_9236_().m_46467_();
        }
    }

    public boolean m_21825_() {
        return super.m_21825_() && !this.m_20160_() && !this.m_20159_() && !this.m_29443_();
    }

    public Raevyx(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.m_274367_(1.25f);
        this.groundNav = new DragonPathNavigateGround((Mob)this, level);
        this.airNav = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(@Nonnull BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        this.airNav.m_26440_(false);
        this.airNav.m_7008_(false);
        this.airNav.m_26443_(false);
        this.f_21344_ = this.groundNav;
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.lightningInteractionHandler = new RaevyxInteractionHandler(this);
        this.animationHandler = new RaevyxAnimationHandler(this);
        this.riderController = new RaevyxRiderController(this);
        this.soundHandler = new DragonSoundHandler(this);
        RandomSource rng = this.m_217043_();
        this.ambientSoundTimer = rng.m_188503_(80);
        this.nextAmbientSoundDelay = 200 + rng.m_188503_(400);
        if (!level.f_46443_) {
            this.applyConfiguredAttributes();
        }
    }

    @Override
    protected float getBodyTurnSpeed() {
        return 0.6f;
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public boolean isStayOrSitMuted() {
        return this.m_21827_() || this.m_21825_();
    }

    @Override
    protected void m_7355_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.RAEVYX_ID);
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, config.maxHealth()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22280_, config.flyingSpeed()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, config.armor());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAMING, (Object)false);
        this.f_19804_.m_135372_(DATA_BEAM_GLOW, (Object)false);
        this.f_19804_.m_135372_(DATA_RIDER_LANDING_BLEND, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_EXITING, (Object)false);
        this.f_19804_.m_135372_(DATA_BEAM_END_SET, (Object)false);
        this.f_19804_.m_135372_(DATA_BEAM_END_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAM_END_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAM_END_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAM_START_SET, (Object)false);
        this.f_19804_.m_135372_(DATA_BEAM_START_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAM_START_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BEAM_START_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_FEEDING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DATA_TAMING_STUNNED, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.f_19804_.m_135372_(DATA_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_TAKEOFF, (Object)false);
        this.f_19804_.m_135372_(DATA_HOVERING, (Object)false);
        this.f_19804_.m_135372_(DATA_LANDING, (Object)false);
        this.f_19804_.m_135372_(DATA_LANDED, (Object)false);
        this.f_19804_.m_135372_(DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135372_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_GOING_UP, (Object)false);
        this.f_19804_.m_135372_(DATA_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(DATA_ACCELERATING, (Object)false);
    }

    @Override
    protected EntityDataAccessor<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected EntityDataAccessor<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected EntityDataAccessor<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected EntityDataAccessor<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected EntityDataAccessor<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    @Override
    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
        this.setFlying(flying);
        this.setTakeoff(takeoff);
        this.setHovering(hovering);
        this.setLanding(landing);
    }

    @Override
    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.combatManager.getActiveAbility();
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    @Override
    public boolean canUseAbility() {
        return !this.m_6162_() && this.combatManager.canUseAbility();
    }

    public void useRidingAbility(String abilityName) {
        Player p;
        if (this.m_6162_()) {
            return;
        }
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        LivingEntity cp = this.m_6688_();
        if (!(cp instanceof LivingEntity)) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_21824_() && cp instanceof Player && !this.m_21830_((LivingEntity)(p = (Player)cp))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        }
    }

    @Override
    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (this.m_6162_()) {
            return;
        }
        super.tryActivateAbility(abilityType);
    }

    @Override
    protected boolean isRiderInputLocked(Player player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected void applyRiderVerticalInput(Player player, boolean goingUp, boolean goingDown, boolean locked) {
        boolean inWater;
        boolean bl = inWater = this.m_20069_() || this.m_20072_();
        if (inWater) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
            return;
        }
        if (locked) {
            this.setGoingUp(false);
            this.setGoingDown(false);
            return;
        }
        if (this.m_29443_()) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
        } else {
            this.setGoingUp(false);
            this.setGoingDown(false);
        }
    }

    @Override
    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = this.applyInputDeadzone(forward);
        float str = this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.m_29443_()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                int n = moveState = this.isAccelerating() ? 2 : 1;
            }
            if ((Integer)this.m_20088_().m_135370_(DATA_GROUND_MOVE_STATE) != moveState) {
                this.m_20088_().m_135381_(DATA_GROUND_MOVE_STATE, (Object)moveState);
                this.syncAnimState(moveState, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                DragonAbility active;
                if (abilityName == null || abilityName.isEmpty() || (active = this.getActiveAbility()) == null) break;
                this.forceEndActiveAbility();
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.toggleMeleeMode();
                break;
            }
            case DOUBLE_TAP_A: {
                if (locked) break;
                this.onRiderDodge((Player)player, true);
                break;
            }
            case DOUBLE_TAP_D: {
                if (locked) break;
                this.onRiderDodge((Player)player, false);
                break;
            }
        }
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public Vec3 getMouthPosition() {
        Vec3 mouthLoc = this.getClientLocatorPosition("mouth_origin");
        if (mouthLoc != null) {
            return mouthLoc;
        }
        return this.computeHeadMouthOrigin(1.0f);
    }

    public Vec3 computeHeadMouthOrigin(float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)this.f_19854_, (double)this.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)this.f_19855_, (double)this.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)this.f_19856_, (double)this.m_20189_());
        float yawDeg = Mth.m_14179_((float)partialTicks, (float)this.f_20886_, (float)this.f_20885_);
        float pitchDeg = Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double R = -0.03125;
        double U = 0.4125;
        double F = 0.915625;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double up = U * cp - F * sp;
        double fwd = U * sp + F * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = R * cy - fwd * sy;
        double offZ = R * sy + fwd * cy;
        return new Vec3(x + offX, y + up, z + offZ);
    }

    public Vec3 getBeamStartAnchor(float partialTicks) {
        Vec3 clientBone = this.getClientLocatorPosition("beamBoneOrigin");
        if (clientBone != null) {
            return clientBone;
        }
        return this.computeHeadMouthOrigin(partialTicks);
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
    }

    public boolean isBeaming() {
        return this.getBooleanData(DATA_BEAMING);
    }

    public void setBeaming(boolean beaming) {
        boolean wasBeaming = this.getBooleanData(DATA_BEAMING);
        this.setBooleanData(DATA_BEAMING, beaming);
        if (!beaming) {
            this.clearBeamPath();
            this.beamTime = 0;
            this.beamServerTarget = null;
        }
        if (!beaming || !wasBeaming) {
            this.resetBeamAim();
        }
        if (beaming && !wasBeaming) {
            this.beamTime = 0;
            this.beamServerTarget = this.createInitialBeamTarget();
        }
    }

    public boolean isBeamGlowActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_BEAM_GLOW);
    }

    public void setBeamGlowActive(boolean active) {
        this.f_19804_.m_135381_(DATA_BEAM_GLOW, (Object)active);
    }

    public void setBeamEndPosition(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(DATA_BEAM_END_SET, (Object)false);
        } else {
            this.f_19804_.m_135381_(DATA_BEAM_END_SET, (Object)true);
            this.f_19804_.m_135381_(DATA_BEAM_END_X, (Object)Float.valueOf((float)pos.f_82479_));
            this.f_19804_.m_135381_(DATA_BEAM_END_Y, (Object)Float.valueOf((float)pos.f_82480_));
            this.f_19804_.m_135381_(DATA_BEAM_END_Z, (Object)Float.valueOf((float)pos.f_82481_));
        }
    }

    public Vec3 getBeamEndPosition() {
        if (!this.getBooleanData(DATA_BEAM_END_SET)) {
            return null;
        }
        return new Vec3((double)this.getFloatData(DATA_BEAM_END_X), (double)this.getFloatData(DATA_BEAM_END_Y), (double)this.getFloatData(DATA_BEAM_END_Z));
    }

    public Vec3 getClientBeamEndPosition(float partialTicks) {
        if (this.clientBeamEnd != null && this.prevClientBeamEnd != null) {
            Vec3 d = this.clientBeamEnd.m_82546_(this.prevClientBeamEnd);
            return this.prevClientBeamEnd.m_82549_(d.m_82490_((double)partialTicks));
        }
        Vec3 serverPos = this.getBeamEndPosition();
        return this.clientBeamEnd != null ? this.clientBeamEnd : (serverPos != null ? serverPos : Vec3.f_82478_);
    }

    public void setBeamStartPosition(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(DATA_BEAM_START_SET, (Object)false);
        } else {
            this.f_19804_.m_135381_(DATA_BEAM_START_SET, (Object)true);
            this.f_19804_.m_135381_(DATA_BEAM_START_X, (Object)Float.valueOf((float)pos.f_82479_));
            this.f_19804_.m_135381_(DATA_BEAM_START_Y, (Object)Float.valueOf((float)pos.f_82480_));
            this.f_19804_.m_135381_(DATA_BEAM_START_Z, (Object)Float.valueOf((float)pos.f_82481_));
        }
    }

    public Vec3 getBeamStartPosition() {
        if (!this.getBooleanData(DATA_BEAM_START_SET)) {
            return null;
        }
        return new Vec3((double)this.getFloatData(DATA_BEAM_START_X), (double)this.getFloatData(DATA_BEAM_START_Y), (double)this.getFloatData(DATA_BEAM_START_Z));
    }

    public void syncBeamPath(@Nullable Vec3 start, @Nullable Vec3 end) {
        this.setBeamStartPosition(start);
        this.setBeamEndPosition(end);
    }

    public void clearBeamPath() {
        this.setBeamStartPosition(null);
        this.setBeamEndPosition(null);
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.f_21344_ = this.airNav;
            this.f_21342_ = new DragonFlightMoveHelper(this);
            this.usingAirNav = true;
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.f_21344_ = this.groundNav;
            this.f_21342_ = new MoveControl((Mob)this);
            this.usingAirNav = false;
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        return new DragonPathNavigateGround((Mob)this, level);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        if (!flying && this.m_20160_() && !this.m_21827_() && !this.m_20096_()) {
            return;
        }
        boolean wasFlying = this.m_29443_();
        this.f_19804_.m_135381_(DATA_FLYING, (Object)flying);
        if (wasFlying != flying) {
            this.setAccelerating(false);
        }
        if (wasFlying != flying) {
            if (flying) {
                this.switchToAirNavigation();
                this.setRunning(false);
            } else {
                this.switchToGroundNavigation();
            }
        }
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        if (takeoff && this.m_6162_()) {
            takeoff = false;
        }
        boolean wasTakeoff = this.isTakeoff();
        this.f_19804_.m_135381_(DATA_TAKEOFF, (Object)takeoff);
        if (takeoff && !wasTakeoff && !this.m_9236_().f_46443_) {
            float pitch = 0.94f + this.m_217043_().m_188501_() * 0.12f;
            this.m_5496_(ModSounds.RAEVYX_TAKEOFF.get(), 1.2f, pitch);
        }
    }

    @Override
    public void setHovering(boolean hovering) {
        if (hovering && this.m_6162_()) {
            hovering = false;
        }
        this.f_19804_.m_135381_(DATA_HOVERING, (Object)hovering);
    }

    @Override
    public boolean isWalking() {
        int s;
        if (this.m_29443_()) {
            return false;
        }
        int n = s = this.m_9236_().f_46443_ ? this.getEffectiveGroundState() : ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 1) {
            return true;
        }
        if (s == 2) {
            return false;
        }
        if (this.m_9236_().f_46443_ && super.getEffectiveGroundState() < 0) {
            double speed = this.m_20184_().m_165925_();
            return speed > 0.004 && speed <= 0.1;
        }
        return false;
    }

    @Override
    public boolean isActuallyRunning() {
        int s;
        if (this.m_29443_()) {
            return false;
        }
        int n = s = this.m_9236_().f_46443_ ? this.getEffectiveGroundState() : ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 2) {
            return true;
        }
        if (s == 1) {
            return false;
        }
        return this.getBooleanData(DATA_RUNNING);
    }

    @Override
    public void setLanding(boolean landing) {
        if (landing && this.m_20160_()) {
            return;
        }
        this.f_19804_.m_135381_(DATA_LANDING, (Object)landing);
        if (landing) {
            this.landingTimer = 0;
            this.m_21573_().m_26573_();
            this.setTakeoff(false);
            this.landingFlag = true;
        } else {
            this.landingFlag = false;
        }
    }

    public void setLanded(boolean landed) {
        this.f_19804_.m_135381_(DATA_LANDED, (Object)landed);
        if (landed) {
            this.landedTimer = 0;
            this.landedFlag = true;
        } else {
            this.landedFlag = false;
        }
    }

    @Override
    public int getSyncedFlightMode() {
        return this.getIntegerData(DATA_FLIGHT_MODE);
    }

    public void setFlightMode(int mode) {
        this.f_19804_.m_135381_(DATA_FLIGHT_MODE, (Object)mode);
    }

    @Override
    public int getGroundMoveState() {
        return this.getIntegerData(DATA_GROUND_MOVE_STATE);
    }

    @Override
    protected int getFlightMode() {
        if (!this.m_29443_()) {
            this.inHighAltitudeGlide = false;
            return -1;
        }
        if (this.isTakeoff() || this.timeFlying < 35) {
            return 3;
        }
        if (this.isHovering()) {
            return 2;
        }
        if (this.isLanding()) {
            return 2;
        }
        if (this.m_21824_() && this.m_20160_()) {
            Player player;
            LivingEntity rider = this.m_6688_();
            if (rider instanceof Player && this.m_21830_((LivingEntity)(player = (Player)rider))) {
                double deltaX = this.m_20185_() - this.lastCheckedX;
                double deltaY = this.m_20186_() - this.lastCheckedY;
                double deltaZ = this.m_20189_() - this.lastCheckedZ;
                double positionChangeSqr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                boolean goingUp = this.isGoingUp();
                boolean goingDown = this.isGoingDown();
                boolean accelerating = this.isAccelerating();
                if (positionChangeSqr > 1.0E-4 || goingUp || goingDown || accelerating) {
                    this.ticksSinceLastMovement = 0;
                    this.lastCheckedX = this.m_20185_();
                    this.lastCheckedY = this.m_20186_();
                    this.lastCheckedZ = this.m_20189_();
                } else {
                    ++this.ticksSinceLastMovement;
                }
                if (this.ticksSinceLastMovement > 3) {
                    return 5;
                }
                if (accelerating) {
                    return 4;
                }
                int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20189_()));
                double altitudeAboveTerrain = this.m_20186_() - (double)groundY;
                if (this.shouldGlideNearWaterSurface() || altitudeAboveTerrain <= 6.0) {
                    this.inHighAltitudeGlide = false;
                    return 0;
                }
                if (this.inHighAltitudeGlide) {
                    if (altitudeAboveTerrain > 30.0) {
                        return 0;
                    }
                    this.inHighAltitudeGlide = false;
                    return 1;
                }
                if (altitudeAboveTerrain > 40.0) {
                    this.inHighAltitudeGlide = true;
                    return 0;
                }
                return 1;
            }
        } else {
            this.inHighAltitudeGlide = false;
        }
        double horizontalSpeedSqr = this.m_20184_().m_165925_();
        double yDelta = this.m_20186_() - this.f_19855_;
        if (Math.abs(yDelta) < 0.06 && horizontalSpeedSqr > 0.01) {
            return 0;
        }
        return 1;
    }

    private int computeFlightModeForSync() {
        return this.getFlightMode();
    }

    @Override
    protected boolean isDragonFlying() {
        return this.getBooleanData(DATA_FLYING);
    }

    @Override
    public boolean isTakeoff() {
        return this.getBooleanData(DATA_TAKEOFF);
    }

    @Override
    public boolean isLanding() {
        return this.getBooleanData(DATA_LANDING);
    }

    public boolean isLanded() {
        return this.getBooleanData(DATA_LANDED);
    }

    @Override
    public boolean isHovering() {
        return this.getBooleanData(DATA_HOVERING);
    }

    @Override
    public boolean isRunning() {
        return this.getBooleanData(DATA_RUNNING);
    }

    @Override
    public void setRunning(boolean running) {
        this.setBooleanData(DATA_RUNNING, running);
        if (running) {
            this.runningTicks = 0;
        }
    }

    @Override
    public void tickAnimationStates() {
    }

    @Override
    public int getEffectiveGroundState() {
        return super.getEffectiveGroundState();
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.m_9236_().f_46443_) {
            int s = Math.max(0, Math.min(2, state));
            if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != s) {
                this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return ownerPlayer.m_6047_();
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_LIGHTNING_BEAM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_ROAR.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_SUMMON_STORM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        if (this.getMeleeMode() == 0) {
            return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_BITE.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_HORN_GORE.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    public double m_6048_() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void m_19956_(@Nonnull Entity passenger, @Nonnull Entity.MoveFunction moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @NotNull
    public Vec3 m_7688_(@Nonnull LivingEntity passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    public boolean isDodging() {
        return this.dodging;
    }

    public void beginDodge(Vec3 vec, int ticks) {
        this.dodging = true;
        this.dodgeVec = vec;
        this.dodgeTicksLeft = Math.max(1, ticks);
        this.m_20256_(vec);
        this.m_21573_().m_26573_();
        this.f_19812_ = true;
    }

    @Override
    protected void onRiderDodge(Player player, boolean isLeft) {
        if (this.m_29443_()) {
            return;
        }
        if (this.dodgeCooldownTicks > 0) {
            return;
        }
        int DODGE_DURATION = 12;
        int DODGE_COOLDOWN = 30;
        int DODGE_IFRAMES = 8;
        int DODGE_CONTROL_LOCK = 12;
        double DODGE_DISTANCE = 20.0;
        float yawRad = (float)Math.toRadians(this.m_146908_());
        double forwardX = -Math.sin(yawRad);
        double forwardZ = Math.cos(yawRad);
        double rightX = Math.cos(yawRad);
        double rightZ = Math.sin(yawRad);
        double dragScale = 1.0 - Math.pow(0.92, 12.0);
        double perTickSpeed = 1.5999999999999992 / dragScale;
        double dodgeDirX = rightX * (double)(isLeft ? 1 : -1);
        double dodgeDirZ = rightZ * (double)(isLeft ? 1 : -1);
        Vec3 dodgeVector = new Vec3(dodgeDirX * perTickSpeed, 0.0, dodgeDirZ * perTickSpeed);
        this.beginDodge(dodgeVector, 12);
        this.lockRiderControls(12);
        this.dodgeCooldownTicks = 30;
        this.dodgeIFramesTicks = 8;
        if (isLeft) {
            this.animationHandler.triggerDodgeLeftAnimation();
        } else {
            this.animationHandler.triggerDodgeRightAnimation();
        }
    }

    public boolean isClientAnimationReady() {
        return this.clientAnimInitTicks >= 5;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickControllers();
        this.tickBankingLogic();
        this.tickPitchingLogic();
        this.tickRunningTime();
        this.tickScreenShake();
        if (this.m_9236_().f_46443_) {
            if (this.clientAnimInitTicks < 5) {
                ++this.clientAnimInitTicks;
            }
            this.tickSound();
            return;
        }
        this.tickSittingState();
        this.tickRiderTakeoff();
        this.tickHurtSoundCooldown();
        this.tickDismountRecall();
        this.spawnBabiesIfNeeded();
        this.timeFlying = this.m_29443_() ? ++this.timeFlying : 0;
        if (!this.m_9236_().f_46443_ && this.m_29443_()) {
            int newFlightMode = this.computeFlightModeForSync();
            this.setFlightMode(newFlightMode);
        }
        if (this.m_29443_() && this.m_6688_() != null && !this.isLanding() && !this.isBeaming() && !this.isTakeoff() && this.isHovering()) {
            this.setHovering(false);
        }
        if (this.postStandUnlockTicks > 0) {
            --this.postStandUnlockTicks;
        }
        this.tickRiderControlLock();
        if (this.f_19797_ % 2 == 0) {
            this.tickRiderControlLockMovement();
            this.tickWaterDisturbance();
        }
        this.tickFeedingCooldown();
        if (this.tamingAbortCalmTicks > 0) {
            --this.tamingAbortCalmTicks;
        }
        if (this.dodgeCooldownTicks > 0) {
            --this.dodgeCooldownTicks;
        }
        if (this.dodgeIFramesTicks > 0) {
            --this.dodgeIFramesTicks;
        }
        this.tamingController.tickServer();
        this.tickSleepTransition();
        this.tickSleepCooldowns();
        this.handleAmbientSounds();
        this.tickFlightPhysics();
        if (this.f_19797_ % 5 == 0) {
            this.tickSuperchargeTimer();
            this.tickTempInvulnTimer();
            this.tickSuperchargeVfx();
            this.tickMountingState();
            this.tickFollowFailsafe();
        }
        if (this.f_19797_ % 100 == 0) {
            this.tickRecentAggroCleanup();
        }
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            if (this.m_20160_()) {
                this.wakeUpImmediately();
                this.clearAllStatesWhenMounted();
            } else if (this.m_5448_() != null || this.m_5912_()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            } else if (this.m_20072_() || this.m_20077_()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            }
            super.tickAnimationStates();
        }
        if (!(this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting())) {
            super.tickAnimationStates();
        }
        if (this.isDodging()) {
            this.handleDodgeMovement();
            return;
        }
        this.tickBeamLook();
        if (!this.m_9236_().f_46443_ && this.m_6162_()) {
            if (this.m_5448_() != null) {
                super.m_6710_(null);
            }
            if (this.getActiveAbility() != null) {
                this.combatManager.forceEndActiveAbility();
            }
            this.m_21561_(false);
        }
        this.tickClientSideUpdates();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            boolean onGroundNow;
            if (!this.m_21827_() && ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue() != 0.0f) {
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
            boolean bl = onGroundNow = this.m_20096_() && !this.m_20069_();
            if (this.m_29443_()) {
                this.f_19789_ = 0.0f;
                if (this.isTakeoff() && !onGroundNow && this.timeFlying > 35) {
                    this.setTakeoff(false);
                }
                if (onGroundNow && !this.isTakeoff()) {
                    if (!this.isLanding()) {
                        this.setLanding(true);
                    }
                    this.setFlying(false);
                } else if (this.isLanding() && !onGroundNow) {
                    this.setLanding(false);
                }
            }
            if (this.isLanding()) {
                if (onGroundNow) {
                    ++this.landingTimer;
                    if (this.landingTimer >= 5) {
                        this.markLandedNow();
                    }
                } else {
                    this.landingTimer = 0;
                }
            } else {
                this.landingTimer = 0;
            }
            this.tickAnimationStates();
        }
        this.m_20242_(this.m_29443_() || this.isHovering());
        if (!this.m_29443_() && this.usingAirNav) {
            this.switchToGroundNavigation();
        }
    }

    private void tickScreenShake() {
        if (this.m_9236_().f_46443_) {
            this.prevScreenShakeAmount = this.screenShakeAmount;
            this.screenShakeAmount = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
            return;
        }
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
        } else if (((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue() != 0.0f) {
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        }
    }

    private void tickFlightPhysics() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isTakeoff() && this.m_29443_() && this.timeFlying < 35) {
            Vec3 motion = this.m_20184_();
            double upwardForce = 0.11;
            this.m_20256_(motion.m_82520_(0.0, upwardForce, 0.0));
        }
        if (this.m_29443_() && this.m_20184_().f_82480_ < 0.0 && this.m_6084_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    private void tickWaterDisturbance() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.m_29443_()) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB box = this.m_20191_();
        int checkDown = 0;
        while ((double)checkDown < 8.0) {
            BlockPos checkPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_) - checkDown, (int)Math.floor(pos.f_82481_));
            BlockState state = this.m_9236_().m_8055_(checkPos);
            if (!state.m_60819_().m_76178_()) {
                double waterY = (double)checkPos.m_123342_() + 1.0;
                double boxWidth = box.m_82362_();
                double boxLength = box.m_82385_();
                int particleCount = (int)Math.ceil((boxWidth + boxLength) / 2.0 * 0.6 * 8.0);
                particleCount = Math.min(particleCount, 50);
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * boxWidth;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * boxLength;
                    double particleX = pos.f_82479_ + offsetX;
                    double particleZ = pos.f_82481_ + offsetZ;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, particleX, waterY, particleZ, 1, offsetX * 0.2, 0.1, offsetZ * 0.2, 0.1);
                    if (!(this.f_19796_.m_188501_() < 0.25f)) continue;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123772_, particleX, waterY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            ++checkDown;
        }
    }

    private boolean shouldGlideNearWaterSurface() {
        if (!this.m_29443_()) {
            return false;
        }
        if (this.m_20186_() > 64.0) {
            return false;
        }
        int baseX = Mth.m_14107_((double)this.m_20185_());
        int baseY = Mth.m_14107_((double)this.m_20186_());
        int baseZ = Mth.m_14107_((double)this.m_20189_());
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                int dy = 0;
                while ((double)dy < 8.0) {
                    BlockState state;
                    checkPos.m_122178_(baseX + dx, baseY - dy, baseZ + dz);
                    if (this.m_9236_().m_46805_((BlockPos)checkPos) && !(state = this.m_9236_().m_8055_((BlockPos)checkPos)).m_60819_().m_76178_()) {
                        double surfaceY = (double)checkPos.m_123342_() + 1.0;
                        if (Math.abs(this.m_20186_() - surfaceY) <= 2.0) {
                            return true;
                        }
                    }
                    ++dy;
                }
            }
        }
        return false;
    }

    private void tickHurtSoundCooldown() {
        if (this.hurtSoundCooldown > 0) {
            --this.hurtSoundCooldown;
        }
    }

    private void tickSound() {
        this.getSoundHandler().tick();
    }

    private void tickSittingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && this.m_21827_()) {
            this.m_21839_(false);
        }
    }

    private void tickMountingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && !this.wasVehicleLastTick) {
            this.clearAllStatesWhenMounted();
        }
        this.wasVehicleLastTick = this.m_20160_();
    }

    private void tickDismountRecall() {
        if (this.m_20160_()) {
            this.clearForcedOwnerFollow();
            return;
        }
        if (this.dismountRecallTicks > 0) {
            --this.dismountRecallTicks;
        }
    }

    private void triggerForcedOwnerFollow() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_21839_(false);
        this.setCommandAuto(0);
        this.setHovering(false);
        this.setLanding(false);
        this.m_21573_().m_26573_();
        this.dismountRecallTicks = 60;
    }

    private void clearAllStatesWhenMounted() {
        if (!this.m_9236_().f_46443_ && this.m_20160_()) {
            this.wakeUpImmediately();
            if (this.m_21827_()) {
                this.m_21839_(false);
                if (this.getCommand() == 1) {
                    this.setCommandAuto(0);
                }
            }
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            this.suppressSleep(300);
            this.clearForcedOwnerFollow();
        }
    }

    private void tickRunningTime() {
        this.runningTicks = this.isRunning() ? ++this.runningTicks : Math.max(0, this.runningTicks - 2);
    }

    private void tickBeamLook() {
        if (!this.isBeaming()) {
            this.resetBeamAim();
            return;
        }
        Vec3 start = this.getBeamStartAnchor(1.0f);
        if (start == null) {
            this.resetBeamAim();
            return;
        }
        boolean riderControlled = this.m_6688_() != null;
        Vec3 aimDir = this.refreshBeamAimDirection(start, riderControlled);
        if (aimDir == null) {
            aimDir = this.beamAimDir = Vec3.m_82498_((float)this.m_146909_(), (float)this.f_20885_).m_82541_();
            this.updateBeamOffsets(aimDir);
        }
        this.applyBeamLook(aimDir);
    }

    public Vec3 getBeamAimDirection() {
        return this.beamAimDir;
    }

    public float getBeamYawOffsetRad() {
        return this.beamYawOffsetRad;
    }

    public float getBeamPitchOffsetRad() {
        return this.beamPitchOffsetRad;
    }

    public Vec3 refreshBeamAimDirection(Vec3 start, boolean smooth) {
        Vec3 desiredDir = this.computeRawBeamAimDirection(start);
        if (desiredDir == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        Vec3 clamped = this.clampBeamDirection(desiredDir);
        if (clamped == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        if (this.beamAimDir == null) {
            this.beamAimDir = clamped;
        } else if (smooth) {
            double blend = 0.35;
            this.beamAimDir = this.beamAimDir.m_82549_(clamped.m_82546_(this.beamAimDir).m_82490_(blend));
            double len = this.beamAimDir.m_82553_();
            this.beamAimDir = len > 1.0E-6 ? this.beamAimDir.m_82490_(1.0 / len) : clamped;
        } else {
            this.beamAimDir = clamped;
        }
        this.updateBeamOffsets(this.beamAimDir);
        return this.beamAimDir;
    }

    private Vec3 computeRawBeamAimDirection(Vec3 start) {
        Vec3 towardTarget;
        LivingEntity rider;
        Vec3 riderLook;
        LivingEntity cp = this.m_6688_();
        if (cp instanceof LivingEntity && (riderLook = (rider = cp).m_20154_()).m_82556_() > 1.0E-6) {
            return riderLook.m_82541_();
        }
        if (!this.m_9236_().f_46443_) {
            this.tickBeamTargeting(start);
        }
        if (this.beamServerTarget != null && (towardTarget = this.beamServerTarget.m_82546_(start)).m_82556_() > 1.0E-6) {
            return towardTarget.m_82541_();
        }
        Vec3 fallbackDir = Vec3.m_82498_((float)this.m_146909_(), (float)this.f_20885_);
        return fallbackDir.m_82556_() > 1.0E-6 ? fallbackDir.m_82541_() : Vec3.f_82478_;
    }

    private Vec3 clampBeamDirection(Vec3 desiredDir) {
        float finalYaw;
        if (desiredDir == null || desiredDir.m_82556_() < 1.0E-6) {
            this.updateBeamOffsets(null);
            return null;
        }
        Vec3 dir = desiredDir.m_82541_();
        float desiredYawDeg = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        float desiredPitchDeg = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.29577951308232);
        float headYaw = this.f_20885_;
        float headPitch = this.m_146909_();
        float yawErrDeg = Mth.m_14118_((float)headYaw, (float)desiredYawDeg);
        float pitchErrDeg = desiredPitchDeg - headPitch;
        float clampedYawErr = Mth.m_14036_((float)yawErrDeg, (float)-40.0f, (float)40.0f);
        float clampedPitchErr = Mth.m_14036_((float)pitchErrDeg, (float)-50.0f, (float)50.0f);
        float finalPitch = headPitch + clampedPitchErr;
        Vec3 finalDir = Vec3.m_82498_((float)finalPitch, (float)(finalYaw = headYaw + clampedYawErr));
        return finalDir.m_82556_() > 1.0E-6 ? finalDir.m_82541_() : null;
    }

    private Vec3 createInitialBeamTarget() {
        LivingEntity target = this.m_5448_();
        Vec3 shootFrom = this.getBeamStartAnchor(1.0f);
        if (shootFrom == null) {
            shootFrom = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
        }
        if (target != null && target.m_6084_()) {
            Vec3 randomOffset = new Vec3((double)(-50.0f + this.f_19796_.m_188501_() * 100.0f), (double)(-20.0f + this.f_19796_.m_188501_() * 40.0f), (double)(-50.0f + this.f_19796_.m_188501_() * 100.0f));
            return target.m_20182_().m_82549_(randomOffset);
        }
        Vec3 forward = new Vec3(0.0, this.f_19796_.m_188499_() ? 50.0 : 10.0, 30.0).m_82524_((float)Math.toRadians(-this.f_20883_));
        return shootFrom.m_82549_(forward);
    }

    private void tickBeamTargeting(Vec3 shootFrom) {
        Vec3 currentTarget;
        ++this.beamTime;
        LivingEntity target = this.m_5448_();
        Vec3 vec3 = currentTarget = this.beamServerTarget != null ? this.beamServerTarget : shootFrom;
        if (target != null && target.m_6084_()) {
            float maxBeamTime = 60.0f;
            float time = (float)this.beamTime / maxBeamTime;
            float accuracy = 1.0f - Math.min(0.75f, time) / 0.75f;
            Vec3 wobbleOffset = new Vec3(Math.sin((float)this.f_19797_ * 0.2f) * 4.0, Math.sin((float)this.f_19797_ * 0.15f) * 2.0, Math.cos((float)this.f_19797_ * 0.2f) * -4.0).m_82524_((float)Math.toRadians(-this.f_20883_)).m_82490_((double)accuracy);
            Vec3 targetPoint = target.m_146892_().m_82520_(0.0, -0.25, 0.0).m_82549_(wobbleOffset);
            this.beamServerTarget = targetPoint.m_82546_(currentTarget).m_82490_((double)0.1f).m_82549_(currentTarget);
        } else {
            Vec3 sweepOffset = new Vec3(Math.sin((float)this.f_19797_ * 0.1f) * 10.0, 0.0, 6.0).m_82524_((float)Math.toRadians(-this.f_20883_));
            Vec3 sweepTarget = shootFrom.m_82549_(sweepOffset);
            this.beamServerTarget = sweepTarget.m_82546_(currentTarget).m_82490_((double)0.1f).m_82549_(currentTarget);
        }
    }

    private void applyBeamLook(@Nullable Vec3 aimDir) {
        if (aimDir == null) {
            return;
        }
        float desiredYaw = (float)(Math.atan2(-aimDir.f_82479_, aimDir.f_82481_) * 57.29577951308232);
        float desiredPitch = (float)(-Math.atan2(aimDir.f_82480_, Math.sqrt(aimDir.f_82479_ * aimDir.f_82479_ + aimDir.f_82481_ * aimDir.f_82481_)) * 57.29577951308232);
        float headYawSpeed = 15.0f;
        float headPitchSpeed = 12.0f;
        this.f_20885_ = Mth.m_14148_((float)this.f_20885_, (float)desiredYaw, (float)headYawSpeed);
        float currentPitch = this.m_146909_();
        float pitchDelta = desiredPitch - currentPitch;
        float pitchChange = Mth.m_14036_((float)pitchDelta, (float)(-headPitchSpeed), (float)headPitchSpeed);
        this.m_146926_(currentPitch + pitchChange);
        float yawDiff = Mth.m_14145_((float)desiredYaw, (float)Mth.m_14177_((float)this.f_20883_));
        if (yawDiff > 24.0f) {
            float bodyRotSpeed = 8.0f;
            this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)desiredYaw, (float)bodyRotSpeed));
            this.f_20883_ = Mth.m_14148_((float)this.f_20883_, (float)desiredYaw, (float)bodyRotSpeed);
        }
    }

    private void resetBeamAim() {
        this.beamLookLerp = null;
        this.beamAimDir = null;
        this.beamYawOffsetRad = 0.0f;
        this.beamPitchOffsetRad = 0.0f;
    }

    private void updateBeamOffsets(@Nullable Vec3 direction) {
        if (direction == null || direction.m_82556_() < 1.0E-6) {
            this.beamYawOffsetRad = 0.0f;
            this.beamPitchOffsetRad = 0.0f;
            return;
        }
        Vec3 dir = direction.m_82541_();
        float finalYawDeg = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        float finalPitchDeg = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.29577951308232);
        float headYaw = this.f_20885_;
        float headPitch = this.m_146909_();
        float yawOffsetDeg = Mth.m_14118_((float)headYaw, (float)finalYawDeg);
        float pitchOffsetDeg = finalPitchDeg - headPitch;
        this.beamYawOffsetRad = yawOffsetDeg * ((float)Math.PI / 180);
        this.beamPitchOffsetRad = pitchOffsetDeg * ((float)Math.PI / 180);
    }

    private void tickClientSideUpdates() {
        if (this.m_9236_().f_46443_) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
            this.prevClientBeamEnd = this.clientBeamEnd;
            this.clientBeamEnd = this.getBeamEndPosition();
        }
    }

    private void tickRiderTakeoff() {
        if (!this.m_9236_().f_46443_ && this.riderTakeoffTicks > 0 && !this.isDying()) {
            double boost;
            --this.riderTakeoffTicks;
            Vec3 velocity = this.m_20184_();
            double d = boost = this.m_29443_() ? 0.08 : 0.12;
            if (velocity.f_82480_ < boost) {
                this.m_20334_(velocity.f_82479_, boost, velocity.f_82481_);
            }
            this.f_19812_ = true;
        }
    }

    private void tickControllers() {
        this.updateSittingProgress();
    }

    private void updateSittingProgress() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.m_21827_()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = this.getSitDownAnimationTicks();
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else {
            if (!this.m_9236_().f_46443_ && super.m_21825_()) {
                this.m_21837_(false);
            }
            if (this.m_20160_()) {
                if (this.sitProgress != 0.0f) {
                    this.sitProgress = 0.0f;
                    this.prevSitProgress = 0.0f;
                    this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
                    this.isSittingDown = false;
                    this.isStandingUp = false;
                    this.sitTransitionTicks = 0;
                }
            } else if (this.sitProgress > 0.0f) {
                if ((this.sitProgress == this.maxSitTicks() || this.isSittingDown) && !this.isStandingUp) {
                    this.animationHandler.triggerSitUpAnimation();
                    this.isStandingUp = true;
                    this.isSittingDown = false;
                    this.sitTransitionTicks = this.getSitUpAnimationTicks();
                }
                float decrementRate = this.maxSitTicks() / (float)this.getSitUpAnimationTicks();
                this.sitProgress -= decrementRate;
                if (this.sitProgress < 0.0f) {
                    this.sitProgress = 0.0f;
                }
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
    }

    private void tickRiderControlLockMovement() {
        if (!this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_6688_() == null) {
            this.clearRiderControlLock();
            return;
        }
        this.m_21573_().m_26573_();
        this.m_6710_(null);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    private void tickFollowFailsafe() {
        double speed;
        LivingEntity owner;
        if (this.followFailsafeCooldown > 0) {
            this.followFailsafeCooldown -= 5;
            return;
        }
        this.followFailsafeCooldown = 20;
        if (this.isSleepLocked() || this.m_21827_() || this.m_20159_() || this.m_20160_() || this.isDying()) {
            return;
        }
        if (this.getCommand() == 1 && !this.m_21827_()) {
            this.setCommandAuto(0);
        }
        if ((owner = this.m_269323_()) == null || !owner.m_6084_()) {
            return;
        }
        if (owner.m_9236_() != this.m_9236_()) {
            return;
        }
        if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
            return;
        }
        if (this.m_29443_()) {
            return;
        }
        double distSq = this.m_20280_((Entity)owner);
        if (distSq < 324.0) {
            if (!this.m_21573_().m_26572_() && this.getCommand() == 0 && !this.m_21827_()) {
                this.m_21573_().m_5624_((Entity)owner, 0.8);
            }
            return;
        }
        boolean moveGoalActive = this.f_21345_.m_25386_().anyMatch(wrapped -> {
            Goal goal = wrapped.m_26015_();
            return goal instanceof RaevyxFollowOwnerGoal || goal instanceof RaevyxGroundCombatGoal || goal instanceof RaevyxAirCombatGoal;
        });
        if (moveGoalActive) {
            return;
        }
        this.switchToGroundNavigation();
        boolean shouldRun = distSq > 625.0;
        this.setRunning(shouldRun);
        this.setGroundMoveStateFromAI(shouldRun ? 2 : 1);
        double d = speed = shouldRun ? 1.35 : 0.9;
        if (!this.m_21573_().m_5624_((Entity)owner, speed)) {
            this.m_21573_().m_26573_();
            this.attemptOwnerTeleport(owner);
        }
    }

    private void attemptOwnerTeleport(LivingEntity owner) {
        BlockPos ownerPos = owner.m_20183_();
        for (int i = 0; i < 8; ++i) {
            int dz;
            int dx = this.f_19796_.m_188503_(7) - 3;
            BlockPos candidate = ownerPos.m_7918_(dx, 0, dz = this.f_19796_.m_188503_(7) - 3);
            if (!this.isTeleportFriendlyBlock(candidate)) continue;
            this.m_6021_((double)candidate.m_123341_() + 0.5, candidate.m_123342_(), (double)candidate.m_123343_() + 0.5);
            this.m_21573_().m_26573_();
            return;
        }
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState floor = this.m_9236_().m_8055_(below);
        BlockState body = this.m_9236_().m_8055_(pos);
        BlockState above = this.m_9236_().m_8055_(pos.m_7494_());
        return floor.m_60804_((BlockGetter)this.m_9236_(), below) && body.m_60795_() && above.m_60795_();
    }

    private void tickSuperchargeTimer() {
        if (this.superchargeTicks > 0) {
            this.superchargeTicks -= 5;
            if (this.superchargeTicks <= 0) {
                this.superchargeTicks = 0;
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(180.0);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
                this.allowGroundBeamDuringStorm = false;
            }
        }
    }

    private void tickTempInvulnTimer() {
        if (this.tempInvulnTicks > 0) {
            this.tempInvulnTicks -= 5;
            if (this.tempInvulnTicks <= 0) {
                this.tempInvulnTicks = 0;
                if (!this.isDying()) {
                    this.m_20331_(false);
                }
            }
        }
    }

    private void tickSuperchargeVfx() {
        if (this.isSupercharged() && this.m_9236_().m_46470_() && this.superchargeVfxCooldown-- <= 0) {
            this.spawnSuperchargeVfx();
            this.superchargeVfxCooldown = 6 + this.f_19796_.m_188503_(6);
        }
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.m_9236_().f_46443_ && !this.sleepFallAsleepTriggered) {
            if (this.getSitProgress() >= this.maxSitTicks()) {
                this.sleepFallAsleepTriggered = true;
                this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
                this.animationHandler.triggerFallAsleepAnimation();
            } else {
                this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
                return;
            }
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                    this.animationHandler.triggerSleepAnimation();
                } else if (this.isSleepingExiting()) {
                    if (!this.sleepSitUpTriggered) {
                        if (this.shouldStaySeatedCommand()) {
                            this.setSleeping(false);
                            this.sleepSitUpTriggered = false;
                            this.setSleepingExiting(false);
                            this.sleepTransitionTicks = 0;
                            this.sleepAmbientCooldownTicks = 10;
                            this.m_21839_(true);
                            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.maxSitTicks()));
                            if (!this.m_9236_().f_46443_) {
                                this.releaseSleepLock();
                            }
                            return;
                        }
                        this.sleepSitUpTriggered = true;
                        this.sleepTransitionTicks = this.getSleepSitUpDuration();
                        this.animationHandler.triggerSitUpAnimation();
                        this.m_21839_(false);
                    } else {
                        this.setSleeping(false);
                        this.sleepSitUpTriggered = false;
                        this.setSleepingExiting(false);
                        this.sleepAmbientCooldownTicks = 10;
                        if (!this.m_9236_().f_46443_) {
                            this.releaseSleepLock();
                        }
                    }
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    private void tickFeedingCooldown() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        int cooldownTicks = (Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN);
        if (cooldownTicks > 0) {
            this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)(--cooldownTicks));
        }
    }

    private void tickBankingLogic() {
        boolean inWater;
        this.prevBankAngle = this.bankAngle;
        boolean bl = inWater = this.m_20069_() || this.m_20072_();
        if (inWater || this.areRiderControlsLocked() || !this.m_29443_() || this.m_21827_()) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.65f + yawChange * 0.35f;
        float targetAngle = Mth.m_14036_((float)(this.bankSmoothedYaw * 6.5f), (float)-90.0f, (float)90.0f);
        this.bankAngle = Mth.m_14179_((float)0.4f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 10.0f;
        float exit = 4.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.m_20160_() || !this.m_29443_() || this.m_20096_()) {
            boolean wasLanding = this.riderLandingBlendTicks > 0 && this.isRiderLandingBlendActive();
            this.riderLandingBlendTicks = 0;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
                if (wasLanding && this.m_20096_() && this.m_20160_()) {
                    this.setFlying(false);
                    this.setTakeoff(false);
                    this.timeFlying = 0;
                    this.triggerAnim("action", "landed");
                    this.lockRiderControls(30);
                }
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 5;
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_46805_(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int surfaceY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        int dragonY = (int)Math.floor(this.m_20186_());
        int scanTopY = dragonY + 3;
        int scanBottomY = Math.min(groundY - 1, dragonY - 15);
        for (int y = scanTopY; y >= scanBottomY; --y) {
            BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            BlockState checkState = this.m_9236_().m_8055_(checkPos);
            if (checkState.m_60819_().m_76178_()) continue;
            return Double.POSITIVE_INFINITY;
        }
        return this.m_20186_() - (double)groundY;
    }

    private void tickPitchingLogic() {
        boolean inWater;
        this.tickRiderLandingBlendTimer();
        boolean bl = inWater = this.m_20069_() || this.m_20072_();
        if (inWater || this.areRiderControlsLocked() || !this.m_29443_() || this.m_21827_()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) >= -0.25 && altitude <= 8.5) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.m_146909_() - this.f_19860_;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.85f + pitchChange * 0.15f;
            float enter = 3.0f;
            float exit = 3.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 20);
        }
    }

    protected void m_6677_(@Nonnull DamageSource source) {
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return this.m_6162_() ? RaevyxAbilities.BABY_HURT : RaevyxAbilities.HURT;
    }

    @Override
    protected DragonAbilityType<?, ?> getDeathAbilityType() {
        return this.m_6162_() ? RaevyxAbilities.BABY_DIE : RaevyxAbilities.DIE;
    }

    @Override
    protected void onSuccessfulDamage(DamageSource source, float amount) {
        if (this.isDying()) {
            return;
        }
        if (this.hurtSoundCooldown > 0) {
            return;
        }
        super.onSuccessfulDamage(source, amount);
        this.hurtSoundCooldown = this.m_20160_() ? 15 : 8;
    }

    private void playCustomAmbientSound() {
        if (this.m_6162_()) {
            return;
        }
        RandomSource random = this.m_217043_();
        if (this.isDying() || this.m_5912_() || this.isBeaming() || this.getActiveAbility() != null) {
            return;
        }
        String vocalKey = null;
        if (this.m_21827_()) {
            vocalKey = random.m_188501_() < 0.6f ? "content" : "purr";
        } else if (this.m_29443_()) {
            if (random.m_188501_() < 0.3f) {
                vocalKey = "chuff";
            }
        } else {
            float grumbleChance;
            vocalKey = !(this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering() || !this.isWalking() && !this.isRunning()) ? (this.isRunning() ? "snort" : "chuff") : ((grumbleChance = random.m_188501_()) < 0.4f ? "grumble1" : (grumbleChance < 0.7f ? "grumble2" : (grumbleChance < 0.9f ? "grumble3" : "purr")));
        }
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.m_6162_() || this.isDying() || this.m_5803_() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0 || this.areRiderControlsLocked()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void resetAmbientSoundTimer() {
        RandomSource random = this.m_217043_();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.m_188503_(400);
    }

    public void playExcitedSound() {
        this.getSoundHandler().playVocal("excited");
    }

    public void playAnnoyedSound() {
        this.getSoundHandler().playVocal("annoyed");
    }

    private void handleDodgeMovement() {
        this.m_20256_(this.dodgeVec);
        this.f_19812_ = true;
        this.dodgeVec = this.dodgeVec.m_82542_(0.92, 0.95, 0.92);
        if (--this.dodgeTicksLeft <= 0) {
            this.dodging = false;
            this.dodgeVec = Vec3.f_82478_;
        }
    }

    @Override
    public void m_7023_(@NotNull Vec3 motion) {
        LivingEntity livingEntity;
        boolean inWater;
        boolean sittingLocked;
        if (this.isDodging()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        boolean bl = sittingLocked = (this.m_21827_() || this.m_21825_()) && this.postStandUnlockTicks <= 0;
        if (sittingLocked || this.isDying() || this.m_5803_() || this.isSleepTransitioning()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            motion = Vec3.f_82478_;
            super.m_7023_(motion);
            return;
        }
        boolean bl2 = inWater = this.m_20069_() || this.m_20072_();
        if (inWater && !this.m_9236_().f_46443_ && this.m_29443_()) {
            this.setFlying(false);
            this.setTakeoff(false);
            this.setHovering(false);
            this.setLanding(false);
            this.switchToGroundNavigation();
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            if (inWater) {
                this.handleWaterSwimming(motion);
            } else if (this.m_29443_()) {
                this.riderController.handleRiderMovement(player, motion);
            } else {
                this.m_7910_(this.riderController.getRiddenSpeed(player));
                super.m_7023_(motion);
            }
        } else {
            super.m_7023_(motion);
        }
    }

    private void handleWaterSwimming(Vec3 input) {
        Vec3 velocity = this.m_20184_();
        double swimSpeed = 0.4;
        if (this.isAccelerating()) {
            swimSpeed *= 1.3;
        }
        Vec3 desired = this.getSwimVec3(input, swimSpeed, velocity);
        Vec3 blended = velocity.m_82549_(desired.m_82546_(velocity).m_82490_(0.15));
        double dragFactor = 0.88;
        blended = blended.m_82542_(dragFactor, 0.92, dragFactor);
        double dy = blended.f_82480_;
        dy = this.isGoingUp() ? Math.min(swimSpeed * 0.6, dy + 0.08) : (this.isGoingDown() ? Math.max(-swimSpeed * 0.8, dy - 0.12) : (dy -= 0.03));
        blended = new Vec3(blended.f_82479_, dy, blended.f_82481_);
        this.m_20256_(blended);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        boolean atSurface = !this.m_5842_();
        boolean tryingToAscend = this.isGoingUp();
        double currentVelY = this.m_20184_().f_82480_;
        if (atSurface && tryingToAscend && currentVelY > 0.0 && !this.m_29443_() && !this.m_9236_().f_46443_) {
            this.setFlying(true);
            this.setTakeoff(true);
            this.setHovering(false);
            this.setLanding(false);
            this.switchToAirNavigation();
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.4, 0.0));
            this.riderTakeoffTicks = 35;
        }
    }

    private Vec3 getSwimVec3(Vec3 wishDir, double swimSpeed, Vec3 velocity) {
        double strafe = wishDir.f_82479_;
        double forward = wishDir.f_82481_;
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double sin = Math.sin(yawRad);
        double cos = Math.cos(yawRad);
        double worldX = strafe * cos - forward * sin;
        double worldZ = forward * cos + strafe * sin;
        double dx = worldX * 0.6 * swimSpeed;
        double dz = worldZ * 0.6 * swimSpeed;
        return new Vec3(dx, 0.0, dz);
    }

    public boolean isFlightControllerStuck() {
        MoveControl moveControl = this.f_21342_;
        if (moveControl instanceof DragonFlightMoveHelper) {
            DragonFlightMoveHelper flightHelper = (DragonFlightMoveHelper)moveControl;
            return flightHelper.hasGivenUp();
        }
        return false;
    }

    public static boolean canSpawnHere(EntityType<Raevyx> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos below = pos.m_7495_();
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (!level.m_6425_(below).m_76178_()) {
            return false;
        }
        boolean solidGround = level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
        boolean feetFree = level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
        boolean headFree = level.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)level, pos.m_7494_()).m_83281_();
        return solidGround && feetFree && headFree;
    }

    @Override
    @NotNull
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, spawnReason, (SpawnGroupData)spawnData, dataTag);
        if (spawnReason == MobSpawnType.CHUNK_GENERATION && !(spawnData instanceof RaevyxFamilyData) && this.f_19796_.m_188501_() < 0.6f) {
            spawnData = new RaevyxFamilyData(false);
            this.shouldSpawnBabies = true;
            this.babiesToSpawn = 2 + this.f_19796_.m_188503_(2);
        }
        this.applyConfiguredAttributes();
        return spawnData;
    }

    private void applyConfiguredAttributes() {
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.RAEVYX_ID);
        this.setAttributeBase(Attributes.f_22276_, config.maxHealth());
        this.setAttributeBase(Attributes.f_22280_, config.flyingSpeed());
        this.setAttributeBase(Attributes.f_22284_, config.armor());
        double maxHealth = config.maxHealth();
        if ((double)this.m_21223_() > maxHealth) {
            this.m_21153_((float)maxHealth);
        }
    }

    private void setAttributeBase(Attribute attribute, double value) {
        AttributeInstance instance = this.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    private void spawnBabiesIfNeeded() {
        if (!this.shouldSpawnBabies || this.babiesToSpawn <= 0) {
            return;
        }
        this.shouldSpawnBabies = false;
        for (int i = 0; i < this.babiesToSpawn; ++i) {
            Raevyx baby = (Raevyx)ModEntities.RAEVYX.get().m_20615_(this.m_9236_());
            if (baby == null) continue;
            baby.setGender(this.f_19796_.m_188499_() ? DragonGender.FEMALE : DragonGender.MALE);
            baby.skipRespawnTicks = 5;
            baby.m_6863_(true);
            baby.m_146762_(-24000);
            double angle = Math.PI * 2 * (double)i / (double)this.babiesToSpawn;
            double distance = 1.0 + this.f_19796_.m_188500_() * 0.5;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            baby.m_7678_(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)baby);
        }
        this.babiesToSpawn = 0;
    }

    public int m_8132_() {
        return this.isBeaming() ? 50 : 180;
    }

    public int m_8085_() {
        return this.isBeaming() ? 40 : 180;
    }

    public int m_21529_() {
        return this.isBeaming() ? 90 : 180;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DragonFloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DragonWaterEscapeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RaevyxAirCombatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RaevyxGroundCombatGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new RaevyxFollowParentGoal(this, 1.15));
        this.f_21345_.m_25352_(7, (Goal)new RaevyxBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RaevyxFollowOwnerGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new RaevyxGroundWanderGoal(this, 1.0, 60));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxTemptGoal(this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42527_, Items.f_42526_, Items.f_42529_}), false));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxFlightGoal(this));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !Raevyx.this.m_20160_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return !Raevyx.this.m_20160_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new DragonOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new RaevyxProtectBabiesGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        if (this.isDying()) {
            return false;
        }
        if (this.dodgeIFramesTicks > 0) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.isTamingStunned() && !this.m_21824_()) {
            return super.m_6469_(damageSource, amount);
        }
        boolean wasFlying = this.m_29443_();
        boolean wasRidden = this.m_20160_();
        boolean result = super.m_6469_(damageSource, amount);
        if (result && wasRidden && wasFlying && this.m_20160_()) {
            this.setFlying(true);
            this.setLanding(false);
            this.switchToAirNavigation();
        }
        return result;
    }

    public int m_6062_() {
        return 3600;
    }

    public int m_7305_(int currentAir) {
        int refillPerTick = 50;
        return Math.min(this.m_6062_(), currentAir + refillPerTick);
    }

    public void m_8038_(@Nonnull ServerLevel level, @Nonnull LightningBolt lightning) {
        if (this.m_6060_()) {
            this.m_20095_();
        }
    }

    public float getBankAngleDegrees(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public int getPitchDirection() {
        return this.pitchDir;
    }

    public void startSupercharge(int ticks) {
        boolean wasNotSupercharged = !this.isSupercharged();
        this.superchargeTicks = Math.max(this.superchargeTicks, Math.max(0, ticks));
        if (wasNotSupercharged && this.isSupercharged()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(360.0);
            this.m_21153_(this.m_21233_());
            this.allowGroundBeamDuringStorm = true;
        }
    }

    public boolean isSupercharged() {
        return this.superchargeTicks > 0;
    }

    public float getDamageMultiplier() {
        return this.isSupercharged() ? 2.0f : 1.0f;
    }

    public void startTemporaryInvuln(int ticks) {
        this.tempInvulnTicks = Math.max(this.tempInvulnTicks, Math.max(0, ticks));
        this.m_20331_(true);
    }

    private void spawnSuperchargeVfx() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.6, 0.0);
        double radius = Math.max(this.m_20191_().m_82362_(), this.m_20191_().m_82385_()) * 0.55;
        int bursts = 2 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < bursts; ++i) {
            Vec3 dir = Raevyx.randomUnit(this.f_19796_);
            double length = 0.4 + this.f_19796_.m_188500_() * 0.7;
            Vec3 offset = Raevyx.randomUnit(this.f_19796_).m_82490_(radius * 0.35);
            Vec3 from = center.m_82549_(offset);
            Vec3 to = from.m_82549_(dir.m_82490_(length));
            float size = 0.5f + this.f_19796_.m_188501_() * 0.25f;
            this.emitMicroArc(server, from, to, size);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, center.f_82479_, center.f_82480_, center.f_82481_, 3, radius * 0.15, radius * 0.15, radius * 0.15, 0.0);
    }

    private void emitMicroArc(ServerLevel server, Vec3 from, Vec3 to, float size) {
        Vec3 delta = to.m_82546_(from);
        int steps = 2 + this.f_19796_.m_188503_(3);
        Vec3 step = delta.m_82490_(1.0 / (double)steps);
        Vec3 pos = from;
        Vec3 dir = step.m_82556_() > 1.0E-6 ? step.m_82541_() : Raevyx.randomUnit(this.f_19796_);
        boolean female = this.isFemale();
        for (int i = 0; i <= steps; ++i) {
            if (this.f_19796_.m_188501_() < 0.7f) {
                server.m_8767_((ParticleOptions)new RaevyxLightningStormData(size, female), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, dir.f_82479_, dir.f_82480_, dir.f_82481_, 0.0);
            }
            pos = pos.m_82549_(step);
        }
    }

    private static Vec3 randomUnit(RandomSource rnd) {
        double u = rnd.m_188500_();
        double v = rnd.m_188500_();
        double theta = Math.PI * 2 * u;
        double z = 2.0 * v - 1.0;
        double r = Math.sqrt(1.0 - z * z);
        return new Vec3(r * Math.cos(theta), z, r * Math.sin(theta));
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    private int getSitDownAnimationTicks() {
        return 30;
    }

    private int getSitUpAnimationTicks() {
        return 20;
    }

    private int getFallAsleepAnimationTicks() {
        return 50;
    }

    private int getWakeUpAnimationTicks() {
        return 53;
    }

    public int getSleepSitUpDuration() {
        return this.getSitUpAnimationTicks();
    }

    @Override
    public float maxSitTicks() {
        return 30.0f;
    }

    @Override
    public DragonSleepBehavior.DragonSleepPreferences getSleepPreferences() {
        return DragonSleepBehavior.DragonSleepPreferences.DIURNAL();
    }

    @Override
    public boolean m_5803_() {
        return this.getBooleanData(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.setBooleanData(DATA_SLEEPING, sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return this.getBooleanData(DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.setBooleanData(DATA_SLEEPING_ENTERING, entering);
    }

    public boolean isSleepingExiting() {
        return this.getBooleanData(DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.setBooleanData(DATA_SLEEPING_EXITING, exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        int snapshot = this.getCommand();
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = snapshot;
        }
        if (snapshot == 1) {
            this.setCommandManual(1);
        } else {
            this.setCommandAuto(1);
        }
        this.m_21839_(true);
        this.m_21573_().m_26573_();
        this.m_6710_(null);
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
        this.m_20256_(Vec3.f_82478_);
        this.setFlying(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setHovering(false);
    }

    private void releaseSleepLock() {
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired == 1) {
                this.setCommandManual(1);
                this.m_21839_(true);
            } else {
                this.setCommandAuto(desired);
                this.m_21839_(false);
            }
        }
        this.m_21573_().m_26573_();
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
    }

    @Override
    public void startSleepEnter() {
        boolean alreadySitting;
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepFallAsleepTriggered = false;
        this.sleepSitUpTriggered = false;
        boolean bl = alreadySitting = this.m_21827_() || this.getSitProgress() >= this.maxSitTicks() || this.shouldStaySeatedCommand();
        if (alreadySitting) {
            this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
            this.sleepFallAsleepTriggered = true;
            this.animationHandler.triggerFallAsleepAnimation();
            this.m_21839_(true);
            if (!this.m_9236_().f_46443_) {
                this.enterSleepLock();
            }
        } else {
            this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
            this.animationHandler.triggerSitDownAnimation();
            if (!this.m_9236_().f_46443_) {
                this.enterSleepLock();
            }
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.m_5803_() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepFallAsleepTriggered = false;
        this.sleepSitUpTriggered = false;
        this.sleepTransitionTicks = this.getWakeUpAnimationTicks();
        this.animationHandler.triggerWakeUpAnimation();
        this.m_21839_(true);
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
        }
    }

    @Override
    public void wakeUpImmediately() {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepFallAsleepTriggered = false;
        this.sleepSitUpTriggered = false;
        this.sleepCancelTicks = 2;
        this.m_21839_(false);
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0 || this.isTamingStunned();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult result = this.lightningInteractionHandler.handleInteraction(player, hand);
        if (result == InteractionResult.PASS) {
            return super.m_6071_(player, hand);
        }
        return result;
    }

    public void m_21839_(boolean sitting) {
        boolean wasSitting = this.m_21827_();
        super.m_21839_(sitting);
        if (sitting) {
            if (this.m_29443_()) {
                this.setLanding(true);
            }
            this.setRunning(false);
            this.m_21573_().m_26573_();
        } else if (wasSitting) {
            if (!this.m_9236_().f_46443_) {
                this.switchToGroundNavigation();
                if (this.m_29443_()) {
                    this.setFlying(false);
                }
                this.setTakeoff(false);
                this.setLanding(false);
                this.setHovering(false);
                this.usingAirNav = false;
                this.postStandUnlockTicks = Math.max(this.postStandUnlockTicks, 20);
            }
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
            if (!this.m_9236_().f_46443_) {
                this.followFailsafeCooldown = 0;
                this.m_21573_().m_26573_();
                this.tickFollowFailsafe();
            }
        }
    }

    public void m_7822_(byte eventId) {
        if (eventId == 6) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(eventId);
        }
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42526_) || stack.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.saveRideableData(tag);
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128379_("UsingAirNav", this.usingAirNav);
        tag.m_128405_("RiderTakeoffTicks", this.riderTakeoffTicks);
        tag.m_128356_("LastLandingGameTime", this.lastLandingGameTime);
        tag.m_128379_("LandingFlag", this.landingFlag);
        tag.m_128405_("LandingTimer", this.landingTimer);
        tag.m_128379_("LandedFlag", this.landedFlag);
        tag.m_128405_("LandedTimer", this.landedTimer);
        this.combatManager.saveToNBT(tag);
        tag.m_128405_("SuperchargeTicks", Math.max(0, this.superchargeTicks));
        tag.m_128405_("TempInvulnTicks", Math.max(0, this.tempInvulnTicks));
        tag.m_128379_("AllowGroundBeamStorm", this.allowGroundBeamDuringStorm);
        tag.m_128379_("ManualSitCommand", this.manualSitCommand);
        tag.m_128405_("FeedingCooldownTicks", Math.max(0, (Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN)));
        this.tamingController.save(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.loadRideableData(tag);
        boolean savedFlying = tag.m_128471_("Flying");
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.usingAirNav = tag.m_128471_("UsingAirNav");
        this.riderTakeoffTicks = tag.m_128441_("RiderTakeoffTicks") ? tag.m_128451_("RiderTakeoffTicks") : 0;
        this.lastLandingGameTime = tag.m_128441_("LastLandingGameTime") ? tag.m_128454_("LastLandingGameTime") : Long.MIN_VALUE;
        this.landingFlag = tag.m_128441_("LandingFlag") && tag.m_128471_("LandingFlag");
        this.landingTimer = tag.m_128441_("LandingTimer") ? tag.m_128451_("LandingTimer") : 0;
        this.landedFlag = tag.m_128441_("LandedFlag") && tag.m_128471_("LandedFlag");
        int n = this.landedTimer = tag.m_128441_("LandedTimer") ? tag.m_128451_("LandedTimer") : 0;
        if (!savedFlying) {
            this.landingTimer = 0;
        }
        this.clearRiderControlLock();
        this.takeoffLockTicks = 0;
        this.combatManager.loadFromNBT(tag);
        if (tag.m_128441_("SuperchargeTicks")) {
            this.superchargeTicks = Math.max(0, tag.m_128451_("SuperchargeTicks"));
        }
        if (tag.m_128441_("TempInvulnTicks")) {
            this.tempInvulnTicks = Math.max(0, tag.m_128451_("TempInvulnTicks"));
            if (this.tempInvulnTicks > 0) {
                this.m_20331_(true);
            }
        }
        if (tag.m_128441_("AllowGroundBeamStorm")) {
            this.allowGroundBeamDuringStorm = tag.m_128471_("AllowGroundBeamStorm");
        }
        if (tag.m_128441_("FeedingCooldownTicks")) {
            this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)Math.max(0, tag.m_128451_("FeedingCooldownTicks")));
        }
        this.tamingController.load(tag);
        boolean bl = this.manualSitCommand = tag.m_128441_("ManualSitCommand") && tag.m_128471_("ManualSitCommand");
        if (this.usingAirNav) {
            this.switchToAirNavigation();
        } else {
            this.switchToGroundNavigation();
        }
        if (this.getCommand() != 1 && this.m_21827_()) {
            this.m_21839_(false);
        }
        if (this.sleepLocked || this.isSleepingEntering() || this.isSleepingExiting() || ((Boolean)this.f_19804_.m_135370_(DATA_SLEEPING)).booleanValue()) {
            this.releaseSleepLock();
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.sleepCommandSnapshot = -1;
        this.followFailsafeCooldown = 0;
        boolean shouldHaveNoGravity = this.m_29443_() || this.isHovering();
        this.m_20242_(shouldHaveNoGravity);
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            this.m_21561_(false);
        }
        if (this.getCommand() == 1 && !this.manualSitCommand) {
            this.setCommandAuto(0);
            this.m_21839_(false);
        }
        if (!this.m_21824_()) {
            this.setCommandAuto(0);
            this.m_21839_(false);
            this.m_21837_(false);
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.isSittingDown = false;
            this.isStandingUp = false;
            this.sitTransitionTicks = 0;
            this.sleepReentryCooldownTicks = 0;
            this.sleepAmbientCooldownTicks = 0;
        }
        this.applyConfiguredAttributes();
    }

    protected boolean m_6093_() {
        return !this.m_29443_() && !this.isHovering();
    }

    public int getRiderTakeoffTicks() {
        return this.riderTakeoffTicks;
    }

    public void setRiderTakeoffTicks(int ticks) {
        this.riderTakeoffTicks = Math.max(0, ticks);
    }

    public void clearAllStatesForMounting() {
        this.m_6710_(null);
        this.setBeaming(false);
        this.setRunning(false);
        this.m_21573_().m_26573_();
        this.setTakeoff(false);
        this.setLanding(false);
        this.setHovering(false);
        if (this.m_21827_()) {
            this.m_21839_(false);
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
        }
        this.riderTakeoffTicks = 0;
        this.combatManager.clearAllStates();
        this.sleepReentryCooldownTicks = 0;
        this.sleepAmbientCooldownTicks = 0;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::handleMovementAnimation);
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 2, state -> {
            if (this.isTamingStunned()) {
                return PlayState.STOP;
            }
            return PlayState.STOP;
        });
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Raevyx>)actionController);
        AnimationController HurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        HurtController.triggerableAnim("raevyx_hurt", RawAnimation.begin().thenPlay("animation.raevyx.hurt"));
        HurtController.triggerableAnim("baby_raevyx_hurt", RawAnimation.begin().thenPlay("animation.raevyx.hurt"));
        HurtController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{HurtController});
        if (!this.m_6162_()) {
            AnimationController bankingController = new AnimationController((GeoAnimatable)this, "banking", 8, this.animationHandler::bankingPredicate);
            AnimationController pitchingController = new AnimationController((GeoAnimatable)this, "pitching", 6, this.animationHandler::pitchingPredicate);
            controllers.add(new AnimationController[]{bankingController});
            controllers.add(new AnimationController[]{pitchingController});
        }
        controllers.add(new AnimationController[]{movementController});
        controllers.add(new AnimationController[]{actionController});
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return RaevyxSoundProfile.INSTANCE;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return this.getMeleeMode() == 0 ? RaevyxAbilities.RAEVYX_BITE : RaevyxAbilities.RAEVYX_HORN_GORE;
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return RaevyxAbilities.RAEVYX_ROAR;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return RaevyxAbilities.RAEVYX_SUMMON_STORM;
    }

    public void onAnimationSound(SoundKeyframeEvent<Raevyx> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    public double getCachedDistanceToOwner() {
        int currentTick = this.f_19797_;
        if (currentTick - this.ownerDistanceCacheTime >= 3) {
            LivingEntity owner = this.m_269323_();
            this.cachedOwnerDistance = owner != null ? this.m_20280_((Entity)owner) : Double.MAX_VALUE;
            this.ownerDistanceCacheTime = currentTick;
        }
        return this.cachedOwnerDistance;
    }

    public List<Projectile> getCachedNearbyProjectiles() {
        if (!(this.m_9236_() instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        if (this.f_19797_ - this.nearbyProjectilesCacheTime >= this.projectileCacheIntervalTicks) {
            List<Projectile> found = DragonMathUtil.getEntitiesNearby((Entity)this, Projectile.class, 30.0);
            this.cachedNearbyProjectiles = found;
            this.nearbyProjectilesCacheTime = this.f_19797_;
            if (found.isEmpty()) {
                this.emptyProjectileScans = Math.min(this.emptyProjectileScans + 1, 4);
                this.projectileCacheIntervalTicks = 3 + this.emptyProjectileScans * 2;
            } else {
                this.emptyProjectileScans = 0;
                this.projectileCacheIntervalTicks = 3;
            }
        }
        return this.cachedNearbyProjectiles;
    }

    @Override
    public void lockRiderControls(int ticks) {
        super.lockRiderControls(ticks);
        this.setAccelerating(false);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.m_20256_(Vec3.f_82478_);
        if (!this.m_9236_().f_46443_) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
    }

    public boolean isTakeoffLocked() {
        return this.takeoffLockTicks > 0;
    }

    public void lockTakeoff(int ticks) {
        this.takeoffLockTicks = Math.max(this.takeoffLockTicks, Math.max(0, ticks));
    }

    public void clearTakeoffLock() {
        this.takeoffLockTicks = 0;
    }

    private void tickTakeoffLock() {
        if (this.takeoffLockTicks > 0) {
            --this.takeoffLockTicks;
        }
    }

    public void clearTemporaryInvuln() {
        this.tempInvulnTicks = 0;
        if (!this.isDying()) {
            this.m_20331_(false);
        }
    }

    public void noteAggroFrom(LivingEntity target) {
        if (target == null || target.m_9236_().f_46443_) {
            return;
        }
        this.recentAggroIds.put(target.m_19879_(), this.m_9236_().m_46467_() + 200L);
    }

    public List<LivingEntity> getRecentAggro() {
        ArrayList<LivingEntity> out = new ArrayList<LivingEntity>();
        long now = this.m_9236_().m_46467_();
        Iterator<Map.Entry<Integer, Long>> it = this.recentAggroIds.entrySet().iterator();
        while (it.hasNext()) {
            LivingEntity le;
            Map.Entry<Integer, Long> e = it.next();
            if (e.getValue() < now) {
                it.remove();
                continue;
            }
            Entity ent = this.m_9236_().m_6815_(e.getKey().intValue());
            if (ent instanceof LivingEntity && (le = (LivingEntity)ent).m_6084_()) {
                out.add(le);
                continue;
            }
            it.remove();
        }
        return out;
    }

    private void tickRecentAggroCleanup() {
        if (this.recentAggroIds.isEmpty()) {
            return;
        }
        long now = this.m_9236_().m_46467_();
        this.recentAggroIds.entrySet().removeIf(entry -> (Long)entry.getValue() < now);
    }

    public float m_20236_(@Nonnull Pose pose) {
        EntityDimensions dimensions = this.m_6972_(pose);
        return dimensions.f_20378_ * 0.6f;
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.6f;
    }

    @NotNull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        EntityDimensions baseDimensions = super.m_6972_(pose);
        if (this.m_6162_()) {
            return baseDimensions.m_20388_(0.4f);
        }
        return baseDimensions;
    }

    public void m_30232_() {
        super.m_30232_();
        this.m_6210_();
    }

    @Override
    public double getCachedHorizontalSpeed() {
        if (this.f_19797_ != this.horizontalSpeedCacheTime) {
            Vec3 velocity = this.m_20184_();
            this.cachedHorizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            this.horizontalSpeedCacheTime = this.f_19797_;
        }
        return this.cachedHorizontalSpeed;
    }

    public boolean m_7848_(@Nonnull Animal otherAnimal) {
        if (!this.m_35506_()) {
            return false;
        }
        if (otherAnimal instanceof Raevyx) {
            Raevyx otherDragon = (Raevyx)otherAnimal;
            if (this.isFemale() == otherDragon.isFemale()) {
                return false;
            }
            return otherDragon.m_35506_();
        }
        return false;
    }

    public boolean m_35506_() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob otherParent) {
        Raevyx baby = (Raevyx)ModEntities.RAEVYX.get().m_20615_((Level)level);
        if (baby != null) {
            baby.setGender(this.f_19796_.m_188499_() ? DragonGender.FEMALE : DragonGender.MALE);
            UUID ownerId = this.m_21805_();
            if (ownerId != null) {
                baby.m_21816_(ownerId);
                baby.m_7105_(true);
            }
            baby.skipRespawnTicks = 5;
            baby.m_146762_(-24000);
            BlockPos safePos = this.findSafeBabySpawnPos((LevelAccessor)level, this.m_20183_());
            double spawnY = safePos != null ? (double)safePos.m_123342_() : this.m_20186_();
            baby.m_7678_(this.m_20185_(), spawnY, this.m_20189_(), this.m_146908_(), 0.0f);
        }
        return baby;
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@Nonnull Player player, @Nonnull Vec3 deltaIn) {
        if (this.areRiderControlsLocked()) {
            return Vec3.f_82478_;
        }
        Vec3 input = this.riderController.getRiddenInput(player, deltaIn);
        return super.m_274312_(player, input);
    }

    protected void m_274498_(@Nonnull Player player, @Nonnull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        if (!this.m_9236_().f_46443_) {
            this.tickTakeoffLock();
        }
        if (!this.areRiderControlsLocked()) {
            this.riderController.tickRidden(player, travelVector);
        } else {
            player.f_19789_ = 0.0f;
            this.f_19789_ = 0.0f;
            this.m_6710_(null);
            this.copyRiderLook(player);
            this.setAccelerating(false);
            if (!this.m_29443_()) {
                this.setGoingUp(false);
                this.setGoingDown(false);
            }
        }
        if (this.isBeaming()) {
            Vec3 start = this.getBeamStartAnchor(1.0f);
            if (start == null) {
                this.resetBeamAim();
                this.copyRiderLook(player);
            } else {
                Vec3 aim = this.refreshBeamAimDirection(start, true);
                if (aim != null) {
                    this.applyBeamLook(aim);
                } else {
                    this.copyRiderLook(player);
                }
            }
        }
    }

    protected float m_245547_(@Nonnull Player rider) {
        if (this.areRiderControlsLocked()) {
            return 0.0f;
        }
        return this.riderController.getRiddenSpeed(rider);
    }

    @Override
    public void m_20351_(@Nonnull Entity passenger) {
        boolean shouldRecallOwner = !this.m_9236_().f_46443_ && passenger == this.m_6688_() && passenger == this.m_269323_() && !this.m_20096_();
        super.m_20351_(passenger);
        if (shouldRecallOwner) {
            this.triggerForcedOwnerFollow();
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if ((this.isTamingStunned() || this.tamingAbortCalmTicks > 0) && target != null) {
            return;
        }
        if (this.m_6162_()) {
            super.m_6710_(null);
            return;
        }
        LivingEntity previousTarget = this.m_5448_();
        super.m_6710_(target);
        if (!this.m_9236_().f_46443_) {
            if (this.aggroGrowlCooldown > 0) {
                --this.aggroGrowlCooldown;
            }
            if (target != null && previousTarget == null && this.aggroGrowlCooldown <= 0) {
                if (!this.m_20160_() && !this.isStayOrSitMuted()) {
                    this.getSoundHandler().playVocal("growl_warning");
                }
                this.aggroGrowlCooldown = this.m_20160_() ? 120 : 80;
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.riderController.getControllingPassenger();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @Nonnull DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            this.f_19789_ = 0.0f;
            for (Entity e : this.m_20197_()) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)e;
                le.f_19789_ = 0.0f;
            }
        }
        return false;
    }

    @Override
    public float getFlightSpeed() {
        return 1.0f;
    }

    @Override
    public double getPreferredFlightAltitude() {
        return 15.0;
    }

    @Override
    public boolean canTakeoff() {
        return !this.m_20072_() && !this.m_20077_() && this.m_20096_();
    }

    private boolean shouldStaySeatedCommand() {
        return this.m_21824_() && this.getCommand() == 1;
    }

    @Override
    public ElectricalConductivityProfile getConductivityProfile() {
        return CONDUCTIVITY_PROFILE;
    }

    @Override
    public ElectricalConductivityState getConductivityState() {
        return ElectricalConductivityCapable.super.getConductivityState();
    }

    public Raevyx asConductiveEntity() {
        return this;
    }

    public boolean canBeBound() {
        return !this.m_5803_() && !this.isDying() && !this.isBeaming();
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = this.getFloatData(DATA_SCREEN_SHAKE_AMOUNT);
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 25.0;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        this.screenShakeAmount = Math.max(this.screenShakeAmount, intensity);
        this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    private static class RaevyxFamilyData
    extends AgeableMob.AgeableMobGroupData {
        public RaevyxFamilyData(boolean shouldSpawnBaby) {
            super(shouldSpawnBaby);
        }
    }
}

