/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public final class NulljawSoundProfile
implements DragonSoundProfile {
    public static final NulljawSoundProfile INSTANCE = new NulljawSoundProfile();
    private static final Map<String, Integer> VOCAL_WINDOWS = Map.ofEntries(Map.entry("grumble1", 100), Map.entry("grumble2", 120), Map.entry("grumble3", 80), Map.entry("roar", 140), Map.entry("roar2", 160), Map.entry("phase1", 85), Map.entry("phase2", 180), Map.entry("phase2_start", 60), Map.entry("phase2_end", 70), Map.entry("hurt", 20), Map.entry("die", 90));
    private static final Map<String, String> EFFECT_TO_VOCAL_KEY = Map.ofEntries(Map.entry("nulljaw_grumble1", "grumble1"), Map.entry("nulljaw_grumble2", "grumble2"), Map.entry("nulljaw_grumble3", "grumble3"), Map.entry("nulljaw_roar", "roar"), Map.entry("nulljaw_roar2", "roar2"), Map.entry("nulljaw_phase1", "phase1"), Map.entry("nulljaw_phase1_underwater", "phase1"), Map.entry("nulljaw_phase2", "phase2"), Map.entry("nulljaw_phase2_start", "phase2_start"), Map.entry("nulljaw_phase2_end", "phase2_end"), Map.entry("nulljaw_phase2_underwater", "phase2"), Map.entry("nulljaw_hurt", "hurt"), Map.entry("nulljaw_die", "die"));
    private static final Map<String, DragonEntity.VocalEntry> FALLBACK_VOCALS = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.nulljaw.grumble1", ModSounds.NULLJAW_GRUMBLE_1, 1.5f, 0.95f, 0.1f, false, false, false).add("grumble2", "action", "animation.nulljaw.grumble2", ModSounds.NULLJAW_GRUMBLE_2, 1.5f, 0.95f, 0.1f, false, false, false).add("grumble3", "action", "animation.nulljaw.grumble3", ModSounds.NULLJAW_GRUMBLE_3, 1.5f, 0.95f, 0.1f, false, false, false).add("roar", "action", "animation.nulljaw.roar", ModSounds.NULLJAW_ROAR, 2.5f, 0.9f, 0.1f, false, false, false).add("roar2", "action", "animation.nulljaw.roar2", ModSounds.NULLJAW_ROAR2, 2.5f, 0.8f, 0.1f, false, false, false).add("phase1", "action", "animation.nulljaw.phase1", ModSounds.NULLJAW_PHASE1, 1.4f, 0.9f, 0.2f, false, false, false).add("phase2", "action", "animation.nulljaw.phase2", ModSounds.NULLJAW_PHASE2, 2.5f, 0.9f, 0.2f, false, false, false).add("phase2_start", "action", "animation.nulljaw.phase2_start", ModSounds.NULLJAW_PHASE2_START, 2.0f, 0.9f, 0.1f, false, false, false).add("phase2_end", "action", "animation.nulljaw.phase2_end", ModSounds.NULLJAW_PHASE2_END, 1.8f, 0.95f, 0.15f, false, false, false).add("hurt", "action", "animation.nulljaw.hurt", ModSounds.NULLJAW_HURT, 1.2f, 0.95f, 0.05f, false, true, true).add("die", "action", "animation.nulljaw.die", ModSounds.NULLJAW_DIE, 1.4f, 0.9f, 0.05f, false, true, true).build();

    private NulljawSoundProfile() {
    }

    @Override
    public boolean handleAnimationSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator) {
        String vocalKey = EFFECT_TO_VOCAL_KEY.get(key);
        if (vocalKey != null) {
            this.playVocalEntry(handler, dragon, vocalKey, locator);
            return true;
        }
        return switch (key) {
            case "nulljaw_walk" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_WALK.get(), 0.8f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_run" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_RUN.get(), 0.8f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_walk2" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_WALK2.get(), 0.8f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_run2" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_RUN2.get(), 0.8f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_claw" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_CLAW.get(), 1.2f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_bite" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_BITE.get(), 1.1f, 0.95f, 0.1f);
                yield true;
            }
            case "nulljaw_horngore" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_HORNGORE.get(), 1.2f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_eat" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.NULLJAW_EAT.get(), 2.5f, 0.8f, 0.1f);
                yield true;
            }
            default -> false;
        };
    }

    @Override
    public DragonEntity.VocalEntry getFallbackVocalEntry(String key) {
        return FALLBACK_VOCALS.get(key);
    }

    @Override
    public int getVocalAnimationWindowTicks(String key) {
        return VOCAL_WINDOWS.getOrDefault(key, -1);
    }

    private void playVocalEntry(DragonSoundHandler handler, DragonEntity dragon, String vocalKey, String locator) {
        DragonEntity.VocalEntry entry = dragon.getVocalEntries().get(vocalKey);
        if (entry == null) {
            entry = FALLBACK_VOCALS.get(vocalKey);
        }
        if (entry == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (dragon.m_5803_() || dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && dragon.isStayOrSitMuted()) {
            return;
        }
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = entry.basePitch();
        if (entry.pitchVariance() != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * entry.pitchVariance();
        }
        this.playClientSound(dragon, at, entry.soundSupplier().get(), entry.volume(), pitch);
    }

    private void playSimpleSound(DragonSoundHandler handler, DragonEntity dragon, String locator, SoundEvent sound, float volume, float basePitch, float variance) {
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = basePitch;
        if (variance != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * variance;
        }
        this.playClientSound(dragon, at, sound, volume, pitch);
    }

    private void playClientSound(DragonEntity dragon, Vec3 position, SoundEvent sound, float volume, float pitch) {
        double x = position != null ? position.f_82479_ : dragon.m_20185_();
        double y = position != null ? position.f_82480_ : dragon.m_20186_();
        double z = position != null ? position.f_82481_ : dragon.m_20189_();
        dragon.m_9236_().m_7785_(x, y, z, sound, SoundSource.NEUTRAL, volume, pitch, false);
    }
}

