/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfig;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.registry.ModItems;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record NulljawInteractionHandler(Nulljaw drake) {
    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!this.drake.m_21824_()) {
            return this.handleUntamedInteraction(player, hand, heldItem);
        }
        return this.handleTamedInteraction(player, hand, heldItem);
    }

    private InteractionResult handleUntamedInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.NULLJAW_ID);
        boolean legacyTaming = config.extraBoolean("legacy_taming", false);
        if (this.drake.m_6898_(heldItem)) {
            if (legacyTaming) {
                return this.handleLegacyTaming(player, heldItem);
            }
            if (this.drake.m_21223_() < this.drake.m_21233_()) {
                return this.handleFeeding(player, heldItem, true);
            }
        }
        if (!legacyTaming && hand == InteractionHand.MAIN_HAND && heldItem.m_41619_() && !player.m_6047_()) {
            boolean started = this.drake.beginUntamedRide(player);
            return started ? InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleLegacyTaming(Player player, ItemStack food) {
        if (!this.drake.canFeed()) {
            if (!this.drake.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.nulljaw.still_eating", (Object[])new Object[]{this.drake.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!this.drake.m_9236_().f_46443_) {
            boolean success;
            if (!player.m_150110_().f_35937_) {
                food.m_41774_(1);
            }
            this.drake.triggerAnim("action", "eat");
            this.drake.setFeedingCooldown(40);
            boolean heartyMeal = food.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
            float healAmount = heartyMeal ? 35.0f : 5.0f;
            float newHealth = Math.min(this.drake.m_21223_() + healAmount, this.drake.m_21233_());
            this.drake.m_21153_(newHealth);
            if (heartyMeal) {
                this.drake.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            }
            DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.NULLJAW_ID);
            double tameChance = heartyMeal ? config.extraDoubles().getOrDefault("taming_chance", 6.0) / 2.0 : config.extraDoubles().getOrDefault("taming_chance", 6.0);
            int tameRoll = (int)Math.round(tameChance);
            boolean bl = success = this.drake.m_217043_().m_188503_(Math.max(1, tameRoll)) == 0;
            if (success) {
                this.drake.m_21828_(player);
                this.drake.m_21839_(true);
                this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)7);
                this.drake.awardTamingAdvancement(player);
            } else {
                this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)6);
            }
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleTamedInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        if (!this.drake.m_21830_((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.drake.m_6898_(heldItem) && this.drake.m_21223_() < this.drake.m_21233_()) {
            return this.handleFeeding(player, heldItem, false);
        }
        if (this.drake.canOwnerCommand(player) && heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND) {
            return this.handleCommandCycling(player);
        }
        if (hand == InteractionHand.MAIN_HAND && heldItem.m_41619_() && !player.m_6047_()) {
            return this.handleMounting(player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFeeding(Player player, ItemStack food, boolean untamed) {
        if (!this.drake.canFeed()) {
            if (!this.drake.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.nulljaw.still_eating", (Object[])new Object[]{this.drake.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!this.drake.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                food.m_41774_(1);
            }
            this.drake.triggerAnim("action", "eat");
            this.drake.setFeedingCooldown(50);
            boolean heartyMeal = food.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
            float healAmount = heartyMeal ? 35.0f : (untamed ? 5.0f : 10.0f);
            float newHealth = Math.min(this.drake.m_21223_() + healAmount, this.drake.m_21233_());
            this.drake.m_21153_(newHealth);
            if (heartyMeal) {
                this.drake.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            }
            this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)7);
            if (!this.drake.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean fullyHealed = newHealth >= this.drake.m_21233_();
                serverPlayer.m_5661_((Component)Component.m_237110_((String)(fullyHealed ? "entity.saintsdragons.nulljaw.fed" : "entity.saintsdragons.nulljaw.fed_partial"), (Object[])new Object[]{this.drake.m_7755_()}), true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleMounting(Player player) {
        if (!this.drake.canOwnerMount(player) || this.drake.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.drake.m_9236_().f_46443_) {
            if (this.drake.m_21827_()) {
                this.drake.m_21839_(false);
            }
            this.drake.m_6710_(null);
            this.drake.m_21573_().m_26573_();
            player.m_20329_((Entity)this.drake);
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleCommandCycling(Player player) {
        if (this.drake.isInSitTransition()) {
            if (!this.drake.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String messageKey = this.drake.isSittingDownAnimation() ? "entity.saintsdragons.nulljaw.sitting_down" : (this.drake.isStandingUpAnimation() ? "entity.saintsdragons.nulljaw.standing_up" : "entity.saintsdragons.nulljaw.transitioning");
                serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.drake.m_7755_()}), true);
            }
            return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
        }
        int currentCommand = this.drake.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.drake.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.drake.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.drake.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.drake.m_21839_(false);
                break;
            }
            case 1: {
                this.drake.m_21839_(true);
                break;
            }
            case 2: {
                this.drake.m_21839_(false);
                break;
            }
        }
    }
}

