/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public final class IgnivorusSoundProfile
implements DragonSoundProfile {
    public static final IgnivorusSoundProfile INSTANCE = new IgnivorusSoundProfile();
    private static final Map<String, Integer> VOCAL_WINDOWS = Map.ofEntries(Map.entry("roar", 64), Map.entry("grumble1", 80), Map.entry("grumble2", 85), Map.entry("grumble3", 90));
    private static final Map<String, String> EFFECT_TO_VOCAL_KEY = Map.ofEntries(Map.entry("ignivorus_roar", "roar"), Map.entry("ignivorus_grumble1", "grumble1"), Map.entry("ignivorus_grumble2", "grumble2"), Map.entry("ignivorus_grumble3", "grumble3"));
    private static final Map<String, DragonEntity.VocalEntry> FALLBACK_VOCALS = new DragonEntity.VocalEntryBuilder().add("roar", "action", "animation.ignivorus.roar", ModSounds.IGNIVORUS_ROAR, 1.8f, 0.85f, 0.15f, false, false, false).add("grumble1", "action", "animation.ignivorus.grumble1", ModSounds.IGNIVORUS_GRUMBLE_1, 1.1f, 0.95f, 0.05f, false, false, false).add("grumble2", "action", "animation.ignivorus.grumble2", ModSounds.IGNIVORUS_GRUMBLE_2, 1.15f, 1.0f, 0.05f, false, false, false).add("grumble3", "action", "animation.ignivorus.grumble3", ModSounds.IGNIVORUS_GRUMBLE_3, 1.2f, 0.9f, 0.05f, false, false, false).build();

    private IgnivorusSoundProfile() {
    }

    @Override
    public boolean handleAnimationSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator) {
        String vocalKey = EFFECT_TO_VOCAL_KEY.get(key);
        if (vocalKey != null) {
            if ("roar".equals(vocalKey)) {
                return true;
            }
            this.playVocalEntry(handler, dragon, vocalKey, locator);
            return true;
        }
        return switch (key) {
            case "ignivorus_bite" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_BITE.get(), 1.2f, 0.95f, 0.1f);
                yield true;
            }
            case "ignivorus_eat" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_EAT.get(), 1.2f, 0.95f, 0.1f);
                yield true;
            }
            case "ignivorus_body_slam" -> {
                this.playSimpleSound(handler, dragon, "body_locator", ModSounds.IGNIVORUS_BODY_SLAM.get(), 2.0f, 0.9f, 0.15f);
                yield true;
            }
            case "ignivorus_walk" -> {
                this.playMovementSound(handler, dragon, locator, ModSounds.IGNIVORUS_WALK.get(), 1.0f, 0.85f);
                yield true;
            }
            case "ignivorus_run" -> {
                this.playMovementSound(handler, dragon, locator, ModSounds.IGNIVORUS_RUN.get(), 1.1f, 0.9f);
                yield true;
            }
            case "ignivorus_ultimate_start" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE_START.get(), 2.0f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_ultimate" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE.get(), 2.5f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_ultimate_end" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE_END.get(), 2.0f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_ultimate_start_air" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE_START_AIR.get(), 2.0f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_ultimate_air" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE_AIR.get(), 2.5f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_ultimate_end_air" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_ULTIMATE_END_AIR.get(), 2.0f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_fire_breath_start", "ignivorus_fire_breathing", "ignivorus_fire_breath_end" -> true;
            case "ignivorus_takeoff" -> true;
            case "ignivorus_landed" -> {
                this.playSimpleSound(handler, dragon, "body_locator", ModSounds.IGNIVORUS_LANDED.get(), 1.5f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_bulldozer_enter" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_BULLDOZER_ENTER.get(), 1.5f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_bulldozing" -> {
                this.playSimpleSound(handler, dragon, "body_locator", ModSounds.IGNIVORUS_BULLDOZING.get(), 1.5f, 1.0f, 0.0f);
                yield true;
            }
            case "ignivorus_bulldozer_exit" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.IGNIVORUS_BULLDOZER_EXIT.get(), 1.5f, 1.0f, 0.0f);
                yield true;
            }
            default -> false;
        };
    }

    @Override
    public boolean handleWingFlapSound(DragonSoundHandler handler, DragonEntity dragon, String key) {
        float volume = dragon.m_6162_() ? 0.7f : 1.2f;
        float pitch = 0.95f + (dragon.m_217043_().m_188501_() - 0.5f) * 0.1f;
        dragon.m_9236_().m_7785_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), ModSounds.IGNIVORUS_FLAP.get(), SoundSource.NEUTRAL, volume, pitch, false);
        return true;
    }

    @Override
    public DragonEntity.VocalEntry getFallbackVocalEntry(String key) {
        return FALLBACK_VOCALS.get(key);
    }

    @Override
    public int getVocalAnimationWindowTicks(String key) {
        return VOCAL_WINDOWS.getOrDefault(key, -1);
    }

    @Override
    public Vec3 resolveLocator(DragonSoundHandler handler, DragonEntity dragon, String locator) {
        Ignivorus ignivorus;
        Vec3 cached;
        if (dragon instanceof Ignivorus && (cached = (ignivorus = (Ignivorus)dragon).getClientLocatorPosition(locator)) != null) {
            return cached;
        }
        return DragonSoundProfile.super.resolveLocator(handler, dragon, locator);
    }

    private void playVocalEntry(DragonSoundHandler handler, DragonEntity dragon, String vocalKey, String locator) {
        DragonEntity.VocalEntry entry = dragon.getVocalEntries().get(vocalKey);
        if (entry == null) {
            entry = FALLBACK_VOCALS.get(vocalKey);
        }
        if (entry == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (dragon.m_5803_() || dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && dragon.isStayOrSitMuted()) {
            return;
        }
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = entry.basePitch();
        if (entry.pitchVariance() != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * entry.pitchVariance();
        }
        this.playClientSound(dragon, at, entry.soundSupplier().get(), entry.volume(), pitch);
    }

    private void playSimpleSound(DragonSoundHandler handler, DragonEntity dragon, String locator, SoundEvent sound, float volume, float basePitch, float variance) {
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = basePitch;
        if (variance != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * variance;
        }
        this.playClientSound(dragon, at, sound, volume, pitch);
    }

    private void playMovementSound(DragonSoundHandler handler, DragonEntity dragon, String locator, SoundEvent sound, float volume, float basePitch) {
        if (dragon instanceof Ignivorus) {
            long currentTick = dragon.f_19797_;
            long tickDiff = currentTick - handler.getLastStepTick();
            if (tickDiff < 5L) {
                return;
            }
            handler.setLastStepTick(currentTick);
        }
        Vec3 body = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "body_locator");
        float vol = volume * 1.2f;
        float pitch = basePitch + (dragon.m_217043_().m_188501_() - 0.5f) * 0.05f;
        this.playClientSound(dragon, body, sound, vol, pitch);
    }

    private void playClientSound(DragonEntity dragon, Vec3 position, SoundEvent sound, float volume, float pitch) {
        double x = position != null ? position.f_82479_ : dragon.m_20185_();
        double y = position != null ? position.f_82480_ : dragon.m_20186_();
        double z = position != null ? position.f_82481_ : dragon.m_20189_();
        dragon.m_9236_().m_7785_(x, y, z, sound, SoundSource.NEUTRAL, volume, pitch, false);
    }
}

