/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfig;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.registry.ModItems;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public record IgnivorusInteractionHandler(Ignivorus dragon) {
    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        if (this.dragon.isDying()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.dragon.m_21824_()) {
            return this.handleUntamedInteraction(player, itemstack);
        }
        return this.handleTamedInteraction(player, itemstack, hand);
    }

    private InteractionResult handleUntamedInteraction(Player player, ItemStack itemstack) {
        boolean client = this.dragon.m_9236_().f_46443_;
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID);
        boolean legacyTaming = config.extraBoolean("legacy_taming", false);
        if (!legacyTaming && this.dragon.isTamingStunned() && player.m_6047_() && itemstack.m_41619_()) {
            if (!client) {
                this.dragon.abortTamingAttempt();
                this.sendStatusMessage(player, "entity.saintsdragons.ignivorus.taming_aborted");
            }
            return InteractionResult.m_19078_((boolean)client);
        }
        if (!this.dragon.m_6898_(itemstack)) {
            return InteractionResult.PASS;
        }
        if (!legacyTaming && this.dragon.isTamingStunned() && !this.dragon.isAwaitingTamingFeed()) {
            this.sendStatusMessage(player, "entity.saintsdragons.ignivorus.taming_dazed");
            return InteractionResult.CONSUME;
        }
        if (!this.dragon.canFeed()) {
            if (!client && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.ignivorus.still_eating", (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!legacyTaming) {
            float minRequiredHealth = this.dragon.getTamingThreshold();
            if (this.dragon.m_21223_() > minRequiredHealth + 1.0f) {
                this.sendStatusMessage(player, "entity.saintsdragons.ignivorus.taming_need_weakened");
                return InteractionResult.CONSUME;
            }
        }
        if (!client) {
            boolean success;
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.dragon.triggerAnim("action", "eat");
            this.dragon.setFeedingCooldown(20);
            boolean hearty = itemstack.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
            if (hearty) {
                this.dragon.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            }
            if (legacyTaming) {
                float healAmount = hearty ? 30.0f : 10.0f;
                float newHealth = Math.min(this.dragon.m_21223_() + healAmount, this.dragon.m_21233_());
                this.dragon.m_21153_(newHealth);
            } else {
                this.dragon.enterTamingStun();
            }
            double tameChance = hearty ? config.extraDoubles().getOrDefault("taming_chance_hearty", 4.0) : config.extraDoubles().getOrDefault("taming_chance_base", 7.0);
            int tameRoll = (int)Math.round(tameChance);
            boolean bl = success = this.dragon.m_217043_().m_188503_(Math.max(1, tameRoll)) == 0;
            if (success) {
                this.dragon.m_21828_(player);
                this.dragon.m_21839_(true);
                this.dragon.setCommandManual(1);
                this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
                if (!legacyTaming) {
                    this.dragon.resetTamingFailures();
                    this.dragon.clearTamingRecovery();
                }
                this.triggerTamingAdvancement(player);
            } else {
                if (!legacyTaming) {
                    Float healTarget = this.nextFailureHealTarget();
                    this.dragon.setTamingRecoveryTarget(healTarget.floatValue());
                    this.dragon.incrementTamingFailures();
                }
                this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)6);
                this.sendStatusMessage(player, "entity.saintsdragons.ignivorus.taming_failed");
            }
        }
        return InteractionResult.m_19078_((boolean)client);
    }

    private InteractionResult handleTamedInteraction(Player player, ItemStack itemstack, InteractionHand hand) {
        boolean isOwner = player.equals((Object)this.dragon.m_269323_());
        if (this.dragon.m_6898_(itemstack)) {
            return this.handleFeeding(player, itemstack);
        }
        if (isOwner) {
            if (itemstack.m_150930_(Items.f_151049_)) {
                return this.handleTextureVariantChange(player, itemstack, 1);
            }
            if (itemstack.m_150930_(Items.f_42413_)) {
                return this.handleTextureVariantChange(player, itemstack, 0);
            }
        }
        if (isOwner) {
            if (player.m_6047_() && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                return this.handleCommandCycling(player);
            }
            if (!player.m_6047_() && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                return this.handleMounting(player);
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFeeding(Player player, ItemStack itemstack) {
        if (!this.dragon.canFeed()) {
            if (!this.dragon.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.ignivorus.still_eating", (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.dragon.triggerAnim("action", "eat");
            this.dragon.setFeedingCooldown(23);
            float currentHealth = this.dragon.m_21223_();
            boolean hearty = itemstack.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
            float healAmount = hearty ? 30.0f : 10.0f;
            float newHealth = Math.min(currentHealth + healAmount, this.dragon.m_21233_());
            this.dragon.m_21153_(newHealth);
            if (hearty) {
                this.dragon.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            }
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String messageKey = newHealth >= this.dragon.m_21233_() ? "entity.saintsdragons.ignivorus.fed" : "entity.saintsdragons.ignivorus.fed_partial";
                serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
    }

    private InteractionResult handleTextureVariantChange(Player player, ItemStack itemstack, int targetVariant) {
        if (this.dragon.getTextureVariant() == targetVariant) {
            if (!this.dragon.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String messageKey = targetVariant == 1 ? "entity.saintsdragons.ignivorus.already_variant_two" : "entity.saintsdragons.ignivorus.already_variant_default";
                serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.dragon.setTextureVariant(targetVariant);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String messageKey = targetVariant == 1 ? "entity.saintsdragons.ignivorus.variant_changed_to_two" : "entity.saintsdragons.ignivorus.variant_changed_to_default";
                serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
        }
        return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
    }

    private InteractionResult handleCommandCycling(Player player) {
        int currentCommand = this.dragon.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.dragon.setCommandManual(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.dragon.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.dragon.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.dragon.m_21839_(false);
                break;
            }
            case 1: {
                this.dragon.m_21839_(true);
                break;
            }
            case 2: {
                this.dragon.m_21839_(false);
            }
        }
    }

    private InteractionResult handleMounting(Player player) {
        if (this.dragon.m_20160_()) {
            return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
        }
        if (this.dragon.m_21827_()) {
            this.dragon.m_21839_(false);
        }
        if (player.m_20329_((Entity)this.dragon)) {
            return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
        }
        return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
    }

    private Float nextFailureHealTarget() {
        return Float.valueOf(this.dragon.m_21233_());
    }

    private void sendStatusMessage(Player player, String key) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)Component.m_237110_((String)key, (Object[])new Object[]{this.dragon.m_7755_()}), true);
        }
    }

    private void triggerTamingAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_ignivorus"));
            if (advancement != null) {
                serverPlayer.m_8960_().m_135988_(advancement, "tame_ignivorus");
            }
        }
    }
}

