/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers;

import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public record IgnivorusAnimationHandler(Ignivorus dragon) {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.ignivorus.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.ignivorus.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.ignivorus.run");
    private static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("animation.ignivorus.take_off");
    private static final RawAnimation LANDING = RawAnimation.begin().thenPlay("animation.ignivorus.landing");
    private static final RawAnimation LANDED = RawAnimation.begin().thenPlay("animation.ignivorus.landed");
    private static final RawAnimation GLIDE = RawAnimation.begin().thenLoop("animation.ignivorus.glide");
    private static final RawAnimation GLIDE_DOWN = RawAnimation.begin().thenLoop("animation.ignivorus.glide_down");
    private static final RawAnimation FLAP = RawAnimation.begin().thenLoop("animation.ignivorus.flap");
    private static final RawAnimation SPRINT_FLAP = RawAnimation.begin().thenLoop("animation.ignivorus.sprint_flap");
    private static final RawAnimation FLY_IDLE = RawAnimation.begin().thenLoop("animation.ignivorus.fly_idle");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.ignivorus.sit");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.ignivorus.swim");
    private static final RawAnimation STUNNED = RawAnimation.begin().thenLoop("animation.ignivorus.stunned");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.ignivorus.sleep");
    private static final RawAnimation BULLDOZER_IDLE = RawAnimation.begin().thenLoop("animation.ignivorus.bulldozer_idle");
    private static final RawAnimation BULLDOZING = RawAnimation.begin().thenLoop("animation.ignivorus.bulldozing");

    public PlayState handleMovementAnimation(AnimationState<Ignivorus> state) {
        state.getController().transitionLength(6);
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(IDLE);
            return PlayState.CONTINUE;
        }
        if (this.dragon.areRiderControlsLocked()) {
            return PlayState.STOP;
        }
        if (this.dragon.isDying()) {
            return PlayState.STOP;
        }
        if (this.dragon.isTamingStunned()) {
            state.getController().transitionLength(4);
            state.setAndContinue(STUNNED);
            return PlayState.CONTINUE;
        }
        if (this.dragon.m_5803_() && !this.dragon.isSleepingEntering() && !this.dragon.isSleepingExiting()) {
            state.getController().transitionLength(6);
            state.setAndContinue(SLEEP);
            return PlayState.CONTINUE;
        }
        if (this.dragon.isSleepingEntering() || this.dragon.isSleepingExiting()) {
            return PlayState.STOP;
        }
        if (!this.dragon.m_29443_() && ((Boolean)this.dragon.m_20088_().m_135370_(Ignivorus.DATA_BULLDOZING)).booleanValue()) {
            boolean isMoving;
            boolean bl = isMoving = Math.abs(this.dragon.m_20184_().f_82479_) > 0.01 || Math.abs(this.dragon.m_20184_().f_82481_) > 0.01;
            if (isMoving) {
                state.setAndContinue(BULLDOZING);
            } else {
                state.setAndContinue(BULLDOZER_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (!this.dragon.m_29443_() && (this.dragon.m_21827_() || this.dragon.getSitProgress() > 0.5f)) {
            state.setAndContinue(SIT);
            return PlayState.CONTINUE;
        }
        if (!this.dragon.m_29443_() && this.dragon.m_20072_()) {
            state.setAndContinue(SWIM);
            return PlayState.CONTINUE;
        }
        if (this.dragon.m_29443_()) {
            int syncedMode = this.dragon.getSyncedFlightMode();
            Vec3 vel = this.dragon.m_20184_();
            boolean sprinting = this.dragon.isAccelerating();
            if (syncedMode == 3 || this.dragon.isTakeoff() || this.dragon.timeFlying < 30) {
                state.getController().transitionLength(4);
                state.setAndContinue(TAKEOFF);
                return PlayState.CONTINUE;
            }
            if (this.dragon.isRiderLandingBlendActive() || this.dragon.isLanding()) {
                state.getController().transitionLength(4);
                state.setAndContinue(LANDING);
                return PlayState.CONTINUE;
            }
            if (this.dragon.m_20160_() && this.dragon.isGoingDown() && !this.dragon.isRiderLandingBlendActive()) {
                state.getController().transitionLength(6);
                state.setAndContinue(GLIDE_DOWN);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 5) {
                state.getController().transitionLength(6);
                state.setAndContinue(FLY_IDLE);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 4) {
                state.getController().transitionLength(3);
                state.setAndContinue(SPRINT_FLAP);
                return PlayState.CONTINUE;
            }
            if (this.dragon.isGoingUp() || vel.f_82480_ > 0.02) {
                state.getController().transitionLength(4);
                state.setAndContinue(FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 2 || this.dragon.isHovering()) {
                state.getController().transitionLength(6);
                state.setAndContinue(sprinting ? SPRINT_FLAP : FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 1) {
                state.getController().transitionLength(4);
                state.setAndContinue(sprinting ? SPRINT_FLAP : FLAP);
            } else {
                state.getController().transitionLength(12);
                state.setAndContinue(GLIDE);
            }
        } else {
            int groundState = (Integer)this.dragon.m_20088_().m_135370_(Ignivorus.DATA_GROUND_MOVE_STATE);
            switch (groundState) {
                case 2: {
                    state.setAndContinue(RUN);
                    break;
                }
                case 1: {
                    state.setAndContinue(WALK);
                    break;
                }
                default: {
                    state.setAndContinue(IDLE);
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public PlayState bankingPredicate(AnimationState<Ignivorus> state) {
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.banking_off"));
            return PlayState.CONTINUE;
        }
        if (this.dragon.isDying() || this.dragon.m_5803_() || this.dragon.isSleepingEntering() || this.dragon.isSleepingExiting()) {
            return PlayState.STOP;
        }
        if (this.dragon.isTamingStunned() || this.dragon.areRiderControlsLocked() || this.dragon.isRiderLandingBlendActive()) {
            return PlayState.STOP;
        }
        state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.banking_off"));
        return PlayState.CONTINUE;
    }

    public PlayState pitchingPredicate(AnimationState<Ignivorus> state) {
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.pitching_off"));
            return PlayState.CONTINUE;
        }
        if (this.dragon.isDying() || this.dragon.m_5803_() || this.dragon.isSleepingEntering() || this.dragon.isSleepingExiting()) {
            return PlayState.STOP;
        }
        if (this.dragon.isTamingStunned() || this.dragon.areRiderControlsLocked() || this.dragon.isRiderLandingBlendActive()) {
            return PlayState.STOP;
        }
        double pitchDir = this.dragon.getPitchDirection();
        if (pitchDir > 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.pitching_down"));
        } else if (pitchDir < 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.pitching_up"));
        } else {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.ignivorus.pitching_off"));
        }
        return PlayState.CONTINUE;
    }

    public void triggerSitDownAnimation() {
        this.dragon.triggerAnim("action", "sit_down");
    }

    public void triggerSitUpAnimation() {
        this.dragon.triggerAnim("action", "sit_up");
    }

    public void triggerFallAsleepAnimation() {
        this.dragon.triggerAnim("action", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.dragon.triggerAnim("action", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.dragon.triggerAnim("action", "wake_up");
    }

    public void triggerBulldozeEnterAnimation() {
        this.dragon.triggerAnim("action", "bulldozer_enter");
    }

    public void triggerBulldozeExitAnimation() {
        this.dragon.triggerAnim("action", "bulldozer_exit");
    }

    public void setupActionController(AnimationController<Ignivorus> actionController) {
        actionController.triggerableAnim("sit_down", RawAnimation.begin().thenPlay("animation.ignivorus.down"));
        actionController.triggerableAnim("sit_up", RawAnimation.begin().thenPlay("animation.ignivorus.up"));
        actionController.triggerableAnim("fall_asleep", RawAnimation.begin().thenPlay("animation.ignivorus.fall_asleep"));
        actionController.triggerableAnim("wake_up", RawAnimation.begin().thenPlay("animation.ignivorus.wake_up"));
        actionController.triggerableAnim("sleep", RawAnimation.begin().thenLoop("animation.ignivorus.sleep"));
        actionController.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation.ignivorus.bite"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.ignivorus.eat"));
        actionController.triggerableAnim("body_slam", RawAnimation.begin().thenPlay("animation.ignivorus.body_slam"));
        actionController.triggerableAnim("fire_breath_start", RawAnimation.begin().thenPlay("animation.ignivorus.fire_breath_start"));
        actionController.triggerableAnim("fire_breathing", RawAnimation.begin().thenLoop("animation.ignivorus.fire_breathing"));
        actionController.triggerableAnim("fire_breath_stop", RawAnimation.begin().thenPlay("animation.ignivorus.fire_breath_end"));
        actionController.triggerableAnim("roar", RawAnimation.begin().thenPlay("animation.ignivorus.roar"));
        actionController.triggerableAnim("ultimate_start", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate_start"));
        actionController.triggerableAnim("ultimate", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate"));
        actionController.triggerableAnim("ultimate_end", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate_end"));
        actionController.triggerableAnim("ultimate_start_air", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate_start_air"));
        actionController.triggerableAnim("ultimate_air", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate_air"));
        actionController.triggerableAnim("ultimate_end_air", RawAnimation.begin().thenPlay("animation.ignivorus.ultimate_end_air"));
        actionController.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.ignivorus.die"));
        actionController.triggerableAnim("landed", LANDED);
        actionController.triggerableAnim("bulldozer_enter", RawAnimation.begin().thenPlay("animation.ignivorus.bulldozer_enter"));
        actionController.triggerableAnim("bulldozer_exit", RawAnimation.begin().thenPlay("animation.ignivorus.bulldozer_exit"));
        actionController.triggerableAnim("ignivorus_grumble1", RawAnimation.begin().thenPlay("animation.ignivorus.grumble1"));
        actionController.triggerableAnim("ignivorus_grumble2", RawAnimation.begin().thenPlay("animation.ignivorus.grumble2"));
        actionController.triggerableAnim("ignivorus_grumble3", RawAnimation.begin().thenPlay("animation.ignivorus.grumble3"));
    }
}

