/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.ignivorus;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfig;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonMeleeMode;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModItems;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.ignivorus.IgnivorusAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonFloatGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonWaterEscapeGoal;
import com.leon.saintsdragons.server.ai.goals.ignivorus.IgnivorusAirCombatGoal;
import com.leon.saintsdragons.server.ai.goals.ignivorus.IgnivorusFlightGoal;
import com.leon.saintsdragons.server.ai.goals.ignivorus.IgnivorusFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.ignivorus.IgnivorusGroundCombatGoal;
import com.leon.saintsdragons.server.ai.goals.ignivorus.IgnivorusGroundWanderGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.behavior.DragonSleepBehavior;
import com.leon.saintsdragons.server.entity.controller.ignivorus.IgnivorusRiderController;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers.IgnivorusAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers.IgnivorusInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers.IgnivorusSoundProfile;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.handlers.IgnivorusTamingHandler;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ignivorus
extends RideableDragonBase
implements DragonFlightCapable,
SoundHandledDragon,
ShakesScreen {
    public static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_TAKEOFF = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_HOVERING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_LANDING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_RIDER_LANDING_BLEND = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_FLIGHT_MODE = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_RIDER_FORWARD = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_RIDER_STRAFE = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> DATA_GROUND_MOVE_STATE = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_GOING_UP = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_GOING_DOWN = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_ACCELERATING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_BULLDOZING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_FEEDING_COOLDOWN = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_TAMING_STUNNED = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_TEXTURE_VARIANT = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FIRE_BREATHING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_FIRE_BREATH_PROGRESS = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FIRE_START_SET = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_FIRE_START_X = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FIRE_START_Y = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FIRE_START_Z = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_FIRE_END_SET = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_FIRE_END_X = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FIRE_END_Y = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FIRE_END_Z = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SCREEN_SHAKE_AMOUNT = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_CINEMATIC_ZOOM_ACTIVE = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING_ENTERING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING_EXITING = SynchedEntityData.m_135353_(Ignivorus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double MODEL_SCALE = 1.0;
    public static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    public static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    public static final double RIDER_LOW_ALTITUDE_GLIDE_THRESHOLD = 6.0;
    public static final double RIDER_WATER_SURFACE_LEVEL = 62.0;
    public static final double RIDER_WATER_SURFACE_TOLERANCE = 2.0;
    public static final int RIDER_WATER_SCAN_RADIUS = 2;
    public static final int RIDER_WATER_SCAN_DEPTH = 8;
    private static final double WATER_EFFECT_MAX_HEIGHT = 8.0;
    private static final double WATER_EFFECT_INTENSITY = 0.6;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.0;
    private static final int RIDER_LANDING_BLEND_DURATION = 5;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("ignivorus_roar", "action", "animation.ignivorus.roar", ModSounds.IGNIVORUS_ROAR, 1.8f, 0.85f, 0.15f, false, false, false).add("ignivorus_grumble1", "action", "animation.ignivorus.grumble1", ModSounds.IGNIVORUS_GRUMBLE_1, 1.1f, 0.95f, 0.08f, true, false, true).add("ignivorus_grumble2", "action", "animation.ignivorus.grumble2", ModSounds.IGNIVORUS_GRUMBLE_2, 1.15f, 1.0f, 0.08f, true, false, true).add("ignivorus_grumble3", "action", "animation.ignivorus.grumble3", ModSounds.IGNIVORUS_GRUMBLE_3, 1.2f, 0.9f, 0.08f, true, false, true).add("ignivorus_hurt", "hurt", "animation.ignivorus.hurt", ModSounds.IGNIVORUS_HURT, 1.6f, 0.95f, 0.1f, true, true, true).add("ignivorus_die", "action", "animation.ignivorus.die", ModSounds.IGNIVORUS_DIE, 1.8f, 0.9f, 0.05f, false, true, true).build();
    public AnimatableInstanceCache dragonCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final IgnivorusAnimationHandler animationHandler = new IgnivorusAnimationHandler(this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private boolean riderHighAltitudeGlide = false;
    private final IgnivorusRiderController riderController;
    private final IgnivorusInteractionHandler interactionHandler = new IgnivorusInteractionHandler(this);
    private final IgnivorusTamingHandler tamingController = new IgnivorusTamingHandler(this);
    private final DragonPathNavigateGround groundNav;
    private final FlyingPathNavigation airNav;
    private boolean usingAirNav;
    public int timeFlying = 0;
    private int airTicks;
    public int groundTicks;
    private int riderLandingBlendTicks = 0;
    public static final double RIDER_WALK_SPEED = 0.225;
    public static final double RIDER_RUN_SPEED = 0.6;
    private static final float MAX_FIRE_YAW_DEG = 70.0f;
    private static final float MAX_FIRE_PITCH_DEG = 45.0f;
    private Vec3 fireAimDir;
    private boolean sleeping = false;
    private boolean sleepingEntering = false;
    private boolean sleepingExiting = false;
    private boolean sleepTransitioning = false;
    private int sleepTransitionTicks = 0;
    private boolean sleepFallAsleepTriggered = false;
    private boolean sleepSitUpTriggered = false;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private int sleepSuppressionTicks = 0;
    private int fireTime = 0;
    private Vec3 fireServerTarget = null;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private boolean bulldozing = false;
    private int bulldozeCooldownTicks = 0;
    private final Map<Integer, Integer> bulldozeHitCooldowns = new HashMap<Integer, Integer>();
    private static final float SHAKE_DECAY_PER_TICK = 0.025f;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    private float cinematicZoomProgress = 0.0f;
    private float prevCinematicZoomProgress = 0.0f;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final int MIN_AMBIENT_DELAY = 180;
    private static final int MAX_AMBIENT_DELAY = 520;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    private int clientAnimInitTicks = 0;
    private static final int ANIM_INIT_GRACE_PERIOD = 5;
    public double lastCheckedX = 0.0;
    public double lastCheckedY = 0.0;
    public double lastCheckedZ = 0.0;
    public int ticksSinceLastMovement = 0;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();
    private static final float TAMING_HEALTH_RATIO = 0.33333334f;
    private int tamingAbortCalmTicks = 0;

    public Ignivorus(EntityType<? extends Ignivorus> type, Level level) {
        super(type, level);
        this.m_274367_(1.1f);
        this.groundNav = new DragonPathNavigateGround((Mob)this, level);
        this.airNav = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(@NotNull BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        this.f_21344_ = this.groundNav;
        this.f_21342_ = new MoveControl((Mob)this);
        this.usingAirNav = false;
        this.riderController = new IgnivorusRiderController(this);
        this.resetAmbientSoundTimer();
        if (!level.f_46443_) {
            this.applyConfiguredAttributes();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_TAKEOFF, (Object)false);
        this.f_19804_.m_135372_(DATA_HOVERING, (Object)false);
        this.f_19804_.m_135372_(DATA_LANDING, (Object)false);
        this.f_19804_.m_135372_(DATA_RIDER_LANDING_BLEND, (Object)false);
        this.f_19804_.m_135372_(DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135372_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_GOING_UP, (Object)false);
        this.f_19804_.m_135372_(DATA_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(DATA_ACCELERATING, (Object)false);
        this.f_19804_.m_135372_(DATA_BULLDOZING, (Object)false);
        this.f_19804_.m_135372_(DATA_FIRE_BREATHING, (Object)false);
        this.f_19804_.m_135372_(DATA_FIRE_BREATH_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(DATA_FIRE_START_SET, (Object)false);
        this.f_19804_.m_135372_(DATA_FIRE_START_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIRE_START_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIRE_START_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIRE_END_SET, (Object)false);
        this.f_19804_.m_135372_(DATA_FIRE_END_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIRE_END_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIRE_END_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_CINEMATIC_ZOOM_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_FEEDING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DATA_TAMING_STUNNED, (Object)false);
        this.f_19804_.m_135372_(DATA_TEXTURE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_EXITING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID);
        double attackDamage = config.abilityDamage("bite", 15.0);
        return Ignivorus.m_21552_().m_22268_(Attributes.f_22276_, config.maxHealth()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, config.flyingSpeed()).m_22268_(Attributes.f_22281_, attackDamage).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22284_, config.armor()).m_22268_(Attributes.f_22278_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DragonFloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DragonWaterEscapeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new IgnivorusFlightGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new IgnivorusAirCombatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new IgnivorusGroundCombatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new IgnivorusFollowOwnerGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new IgnivorusGroundWanderGoal(this, 1.0, 120));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DragonOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, spawnType, spawnData, dataTag);
        this.applyConfiguredAttributes();
        return data;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.soundHandler.tick();
        this.tickRiderControlLock();
        this.tickBulldozeState();
        this.tickScreenShake();
        this.tickCinematicZoom();
        if (this.m_9236_().f_46443_) {
            if (this.clientAnimInitTicks < 5) {
                ++this.clientAnimInitTicks;
            }
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
        }
        if (this.m_29443_()) {
            ++this.airTicks;
            this.groundTicks = 0;
            ++this.timeFlying;
            if (this.isTakeoff() && this.timeFlying > 30) {
                this.setTakeoff(false);
            }
        } else {
            ++this.groundTicks;
            this.airTicks = 0;
            this.timeFlying = 0;
        }
        if (!this.m_9236_().f_46443_ && this.m_29443_()) {
            int newFlightMode = this.computeFlightModeForSync();
            this.setFlightMode(newFlightMode);
        }
        if (!this.m_9236_().f_46443_ && this.isLanding() && this.m_20096_()) {
            this.markLandedNow();
        }
        if (!this.m_9236_().f_46443_ && !this.m_29443_() && this.isHovering() && this.m_20096_()) {
            this.setHovering(false);
        }
        this.m_20242_(this.m_29443_() || this.isHovering());
        this.tickBankingLogic();
        this.tickPitchingLogic();
        if (!this.m_9236_().f_46443_) {
            int cooldown;
            if (this.tamingAbortCalmTicks > 0) {
                --this.tamingAbortCalmTicks;
            }
            this.tamingController.tickServer();
            this.tickTerrainClearing();
            this.handleAmbientSounds();
            if (this.f_19797_ % 2 == 0) {
                this.tickWaterDisturbance();
            }
            if ((cooldown = ((Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN)).intValue()) > 0) {
                this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)(cooldown - 1));
            }
        }
        this.updateSittingProgress();
        if (!this.m_9236_().f_46443_) {
            if (this.sleepSuppressionTicks > 0) {
                --this.sleepSuppressionTicks;
            }
            this.tickSleepTransitions();
        }
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        if (this.isDying()) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        return super.m_6469_(damageSource, amount);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return this.groundNav;
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@NotNull Player player, @NotNull Vec3 deltaIn) {
        Vec3 input = this.riderController.getRiddenInput(player, deltaIn);
        return super.m_274312_(player, input);
    }

    private void handleAmbientSounds() {
        if (this.m_6162_() || this.isDying() || this.m_5803_() || this.isSleepTransitioning() || this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_5448_() != null || this.getActiveAbility() != null || this.isBreathingFire()) {
            return;
        }
        if (this.m_21827_() || this.isStayOrSitMuted()) {
            return;
        }
        if (this.bulldozing) {
            return;
        }
        if (this.ambientSoundTimer < this.nextAmbientSoundDelay) {
            ++this.ambientSoundTimer;
            return;
        }
        this.playAmbientGrumble();
        this.resetAmbientSoundTimer();
    }

    private void playAmbientGrumble() {
        float roll = this.m_217043_().m_188501_();
        String vocalKey = roll < 0.34f ? "ignivorus_grumble1" : (roll < 0.67f ? "ignivorus_grumble2" : "ignivorus_grumble3");
        this.getSoundHandler().playVocal(vocalKey);
    }

    private void resetAmbientSoundTimer() {
        RandomSource random = this.m_217043_();
        this.ambientSoundTimer = 0;
        int range = Math.max(1, 340);
        this.nextAmbientSoundDelay = 180 + random.m_188503_(range);
    }

    public boolean canFeed() {
        return (Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN) <= 0;
    }

    public void setFeedingCooldown(int ticks) {
        this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)Math.max(0, ticks));
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_TEXTURE_VARIANT);
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(DATA_TEXTURE_VARIANT, (Object)variant);
    }

    public boolean isTamingStunned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAMING_STUNNED);
    }

    public void enterTamingStun() {
        this.tamingController.enterStun();
    }

    public void enterTamingHoldState() {
        this.tamingController.enterHoldState();
    }

    public void setTamingRecoveryTarget(float targetHealth) {
        this.tamingController.setRecoveryTarget(targetHealth);
    }

    public void clearTamingRecovery() {
        this.tamingController.clearRecovery();
    }

    public void incrementTamingFailures() {
        this.tamingController.incrementFailures();
    }

    public void resetTamingFailures() {
        this.tamingController.resetFailures();
    }

    public int getTamingFailureCounter() {
        return this.tamingController.getFailureCounter();
    }

    public boolean isAwaitingTamingFeed() {
        return this.tamingController.isAwaitingFeed();
    }

    public void abortTamingAttempt() {
        this.clearTamingRecovery();
        this.tamingAbortCalmTicks = Math.max(this.tamingAbortCalmTicks, 100);
    }

    public boolean isBelowTamingThreshold() {
        return this.m_21223_() <= this.getTamingThreshold();
    }

    public float getTamingThreshold() {
        return this.m_21233_() * 0.33333334f;
    }

    @Override
    public void lockRiderControls(int ticks) {
        super.lockRiderControls(ticks);
        this.setAccelerating(false);
        this.setLastRiderForward(0.0f);
        this.setLastRiderStrafe(0.0f);
        this.setGroundMoveStateFromRider(0);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.m_20256_(Vec3.f_82478_);
        if (!this.m_9236_().f_46443_) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
    }

    private void tickCinematicZoom() {
        this.prevCinematicZoomProgress = this.cinematicZoomProgress;
        boolean active = (Boolean)this.f_19804_.m_135370_(DATA_CINEMATIC_ZOOM_ACTIVE);
        float target = active ? 1.0f : 0.0f;
        this.cinematicZoomProgress = Mth.m_14179_((float)0.12f, (float)this.cinematicZoomProgress, (float)target);
        if (Math.abs(this.cinematicZoomProgress - target) < 0.01f) {
            this.cinematicZoomProgress = target;
        }
    }

    private void tickBulldozeState() {
        if (!this.m_9236_().f_46443_) {
            if (this.bulldozeCooldownTicks > 0) {
                --this.bulldozeCooldownTicks;
            }
            this.bulldozeHitCooldowns.entrySet().removeIf(entry -> {
                entry.setValue((Integer)entry.getValue() - 1);
                return (Integer)entry.getValue() <= 0;
            });
            if (this.bulldozing && this.m_20160_() && !this.isAccelerating()) {
                this.setAccelerating(true);
            }
            if (this.bulldozing && !this.m_20160_()) {
                this.bulldozing = false;
                this.f_19804_.m_135381_(DATA_BULLDOZING, (Object)false);
                this.setAccelerating(false);
                this.bulldozeCooldownTicks = 40;
                this.clearRiderControlLock();
                this.bulldozeHitCooldowns.clear();
            }
            if (this.bulldozing && this.m_20160_()) {
                Vec3 mouthPos = this.getMouthPosition();
                AABB dragonBox = this.m_20191_().m_82400_(1.5);
                AABB mouthBox = new AABB(mouthPos, mouthPos).m_82400_(2.5);
                AABB combinedBox = dragonBox.m_82367_(mouthBox);
                List entities = this.m_9236_().m_6443_(LivingEntity.class, combinedBox, entity -> entity != this && entity != this.m_6688_() && !this.m_7307_((Entity)entity));
                for (LivingEntity target : entities) {
                    int entityId = target.m_19879_();
                    if (this.bulldozeHitCooldowns.containsKey(entityId)) continue;
                    target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
                    double knockbackStrength = 2.0;
                    double dx = target.m_20185_() - mouthPos.f_82479_;
                    double dz = target.m_20189_() - mouthPos.f_82481_;
                    double dist = Math.sqrt(dx * dx + dz * dz);
                    if (dist > 0.0) {
                        target.m_147240_(knockbackStrength, -dx / dist, -dz / dist);
                    }
                    this.bulldozeHitCooldowns.put(entityId, 5);
                }
            }
        }
    }

    public void setUltimateCameraZoomActive(boolean active) {
        this.f_19804_.m_135381_(DATA_CINEMATIC_ZOOM_ACTIVE, (Object)active);
    }

    public float getUltimateCameraZoom(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevCinematicZoomProgress, (float)this.cinematicZoomProgress);
    }

    @Override
    protected boolean isRiderInputLocked(Player player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected float getRiderLockPitchMin() {
        return -70.0f;
    }

    @Override
    protected float getRiderLockPitchMax() {
        return 45.0f;
    }

    protected void m_274498_(@NotNull Player player, @NotNull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        this.riderController.tickRidden(player, travelVector);
        if (this.isBreathingFire()) {
            Vec3 aim;
            Vec3 start = this.getFireBreathStartAnchor(1.0f);
            if (start == null) {
                start = this.m_146892_();
            }
            if ((aim = this.refreshFireAimDirection(start, true)) != null) {
                this.applyFireLook(aim);
            } else {
                this.copyRiderLook(player);
            }
        } else {
            this.resetFireAimDirection();
        }
    }

    @Override
    public void m_20351_(@NotNull Entity passenger) {
        super.m_20351_(passenger);
    }

    @Override
    public void m_7023_(@NotNull Vec3 travelVec) {
        boolean inWater;
        if (this.areRiderControlsLocked()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        boolean bl = inWater = this.m_20069_() || this.m_20072_();
        if (this.m_20160_() && this.riderController.getRidingPlayer() != null) {
            Player rider = this.riderController.getRidingPlayer();
            if (inWater) {
                this.handleWaterSwimming(travelVec);
            } else if (this.m_29443_()) {
                this.riderController.handleRiderMovement(rider, travelVec);
            } else {
                this.m_7910_(this.riderController.getRiddenSpeed(rider));
                super.m_7023_(travelVec);
            }
            return;
        }
        if (inWater) {
            this.handleWaterSwimming(travelVec);
            return;
        }
        super.m_7023_(travelVec);
    }

    public float m_245547_(@NotNull Player rider) {
        return this.riderController.getRiddenSpeed(rider);
    }

    private void handleWaterSwimming(Vec3 input) {
        Vec3 velocity = this.m_20184_();
        double swimSpeed = 0.4;
        if (this.isAccelerating()) {
            swimSpeed *= 1.3;
        }
        Vec3 desired = this.getSwimVec3(input, swimSpeed);
        Vec3 blended = velocity.m_82549_(desired.m_82546_(velocity).m_82490_(0.15));
        double dragFactor = 0.88;
        blended = blended.m_82542_(dragFactor, 0.92, dragFactor);
        double dy = blended.f_82480_;
        dy = this.isGoingUp() ? Math.min(swimSpeed * 0.6, dy + 0.08) : (this.isGoingDown() ? Math.max(-swimSpeed * 0.8, dy - 0.12) : (dy -= 0.03));
        blended = new Vec3(blended.f_82479_, dy, blended.f_82481_);
        this.m_20256_(blended);
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private Vec3 getSwimVec3(Vec3 wishDir, double swimSpeed) {
        double strafe = wishDir.f_82479_;
        double forward = wishDir.f_82481_;
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double sin = Math.sin(yawRad);
        double cos = Math.cos(yawRad);
        double worldX = strafe * cos - forward * sin;
        double worldZ = forward * cos + strafe * sin;
        double dx = worldX * 0.6 * swimSpeed;
        double dz = worldZ * 0.6 * swimSpeed;
        return new Vec3(dx, 0.0, dz);
    }

    @Override
    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = locked ? 0.0f : this.applyInputDeadzone(forward);
        float str = locked ? 0.0f : this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.m_29443_()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                int n = moveState = this.isAccelerating() ? 2 : 1;
            }
            if ((Integer)this.m_20088_().m_135370_(DATA_GROUND_MOVE_STATE) != moveState) {
                this.m_20088_().m_135381_(DATA_GROUND_MOVE_STATE, (Object)moveState);
            }
        }
    }

    @Override
    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        if (action == DragonRiderAction.DOUBLE_TAP_W) {
            if (!locked) {
                this.onRiderBulldoze((Player)player);
            }
            return;
        }
        if (this.bulldozing) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.onRiderToggleMelee((Player)player);
                break;
            }
            case ABILITY_USE: {
                if (locked || abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.forceEndActiveAbility();
                break;
            }
        }
    }

    public boolean isClientAnimationReady() {
        return this.clientAnimInitTicks >= 5;
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.m_9236_().f_46443_) {
            int s = Mth.m_14045_((int)state, (int)0, (int)2);
            if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != s) {
                this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)s);
            }
        }
    }

    public void setGroundMoveStateFromRider(int state) {
        int s = Mth.m_14045_((int)state, (int)0, (int)2);
        if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != s) {
            this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)s);
        }
    }

    @Override
    public boolean m_5803_() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING) : this.sleeping;
    }

    @Override
    public boolean isSleepTransitioning() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_ENTERING) != false || (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_EXITING) != false;
        }
        return this.sleepTransitioning || this.sleepingEntering || this.sleepingExiting;
    }

    public boolean isSleepingEntering() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_ENTERING) : this.sleepingEntering;
    }

    public boolean isSleepingExiting() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_EXITING) : this.sleepingExiting;
    }

    public boolean isSleepLocked() {
        return this.sleeping || this.sleepingEntering || this.sleepingExiting || this.sleepTransitioning || this.sleepLocked;
    }

    @Override
    public void startSleepEnter() {
        boolean alreadySeated;
        if (this.sleeping || this.sleepingEntering || this.sleepingExiting || this.sleepTransitioning) {
            return;
        }
        this.sleepTransitioning = true;
        this.sleepingEntering = true;
        this.sleepingExiting = false;
        this.sleeping = false;
        this.sleepFallAsleepTriggered = false;
        this.sleepSitUpTriggered = false;
        this.sleepLocked = true;
        this.sleepCommandSnapshot = this.getCommand();
        this.f_19804_.m_135381_(DATA_SLEEPING_ENTERING, (Object)true);
        this.f_19804_.m_135381_(DATA_SLEEPING_EXITING, (Object)false);
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.setGroundMoveStateFromAI(0);
        this.setFlying(false);
        this.setHovering(false);
        this.setTakeoff(false);
        this.setLanding(false);
        boolean bl = alreadySeated = this.getSitProgress() >= this.maxSitTicks();
        if (!alreadySeated) {
            this.m_21839_(false);
        }
        if (this.m_21827_() || this.getSitProgress() >= this.maxSitTicks()) {
            this.sleepTransitionTicks = 1;
        } else {
            this.sleepTransitionTicks = this.getSleepSitDownDuration();
            this.animationHandler.triggerSitDownAnimation();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.sleeping && !this.sleepingEntering || this.sleepingExiting) {
            return;
        }
        this.sleeping = false;
        this.sleepingEntering = false;
        this.sleepingExiting = true;
        this.sleepTransitioning = true;
        this.sleepSitUpTriggered = false;
        this.sleepTransitionTicks = this.getSleepWakeUpDuration();
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135381_(DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135381_(DATA_SLEEPING_EXITING, (Object)true);
        this.setGroundMoveStateFromAI(0);
        this.m_21839_(true);
        this.animationHandler.triggerWakeUpAnimation();
        this.suppressSleep(40);
    }

    @Override
    public void wakeUpImmediately() {
        this.suppressSleep(40);
        this.sleepTransitionTicks = 0;
        this.sleepTransitioning = false;
        this.sleepFallAsleepTriggered = false;
        this.sleepSitUpTriggered = false;
        this.sleeping = false;
        this.sleepingEntering = false;
        this.sleepingExiting = false;
        this.sleepLocked = false;
        this.sleepCommandSnapshot = -1;
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135381_(DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135381_(DATA_SLEEPING_EXITING, (Object)false);
        this.m_21839_(false);
        this.setGroundMoveStateFromAI(0);
    }

    public void suppressSleep(int ticks) {
        this.sleepSuppressionTicks = Math.max(this.sleepSuppressionTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepSuppressionTicks > 0 || this.m_5448_() != null || this.m_29443_() || this.m_20072_() || this.m_20160_() || this.isTamingStunned();
    }

    @Override
    public DragonSleepBehavior.DragonSleepPreferences getSleepPreferences() {
        return DragonSleepBehavior.DragonSleepPreferences.NOCTURNAL();
    }

    @Override
    public boolean canSleepNow() {
        boolean ownerSleeping = false;
        if (this.m_21824_()) {
            Player player;
            LivingEntity owner = this.m_269323_();
            ownerSleeping = owner instanceof Player && (player = (Player)owner).m_5803_();
        }
        return !this.m_9236_().m_46461_() || ownerSleeping;
    }

    public int getSleepSitDownDuration() {
        return 38;
    }

    public int getSleepSitUpDuration() {
        return 38;
    }

    public int getSleepFallAsleepDuration() {
        return 38;
    }

    public int getSleepWakeUpDuration() {
        return 38;
    }

    private void tickSleepTransitions() {
        if (!(this.sleeping || this.sleepingEntering || this.sleepingExiting || this.sleepTransitioning)) {
            return;
        }
        this.freezeDuringSleepChain();
        if (this.sleepingEntering) {
            if (!this.sleepFallAsleepTriggered) {
                boolean seatedEnough;
                if (this.sleepTransitionTicks > 0) {
                    --this.sleepTransitionTicks;
                    if (this.sleepTransitionTicks > 0) {
                        return;
                    }
                }
                boolean bl = seatedEnough = this.m_21827_() || this.getSitProgress() >= this.maxSitTicks();
                if (seatedEnough) {
                    this.sleepFallAsleepTriggered = true;
                    this.sleepTransitionTicks = this.getSleepFallAsleepDuration();
                    this.animationHandler.triggerFallAsleepAnimation();
                    return;
                }
                this.sleepTransitionTicks = this.getSleepSitDownDuration();
                this.animationHandler.triggerSitDownAnimation();
                this.m_21839_(true);
                return;
            }
            if (this.sleepTransitionTicks > 0) {
                --this.sleepTransitionTicks;
                if (this.sleepTransitionTicks > 0) {
                    return;
                }
            }
            this.sleeping = true;
            this.sleepingEntering = false;
            this.sleepTransitioning = false;
            this.sleepFallAsleepTriggered = false;
            this.f_19804_.m_135381_(DATA_SLEEPING_ENTERING, (Object)false);
            this.f_19804_.m_135381_(DATA_SLEEPING, (Object)true);
            this.animationHandler.triggerSleepAnimation();
            this.m_21839_(true);
            this.setGroundMoveStateFromAI(0);
            return;
        }
        if (this.sleepingExiting) {
            if (this.sleepTransitionTicks > 0) {
                --this.sleepTransitionTicks;
                if (this.sleepTransitionTicks > 0) {
                    return;
                }
            }
            this.sleepingExiting = false;
            this.sleepTransitioning = false;
            this.sleepSitUpTriggered = false;
            this.f_19804_.m_135381_(DATA_SLEEPING_EXITING, (Object)false);
            this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
            this.sleepLocked = false;
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            boolean ownerWantsSit = desired == 1;
            this.m_21839_(ownerWantsSit);
            this.setGroundMoveStateFromAI(0);
        }
    }

    private void freezeDuringSleepChain() {
        this.m_21573_().m_26573_();
        this.m_20334_(0.0, 0.0, 0.0);
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
        this.setFlying(false);
        this.setHovering(false);
        this.setTakeoff(false);
        this.setLanding(false);
        this.m_21839_(true);
    }

    public void useRidingAbility(String abilityName) {
        Player player;
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        LivingEntity controller = this.m_6688_();
        if (!(controller instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = controller;
        if (this.m_21824_() && controller instanceof Player && !this.m_21830_((LivingEntity)(player = (Player)controller))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        }
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
        this.clearFireBreathPath();
        this.setBreathingFire(false);
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        this.combatManager.forceEndAbility(abilityType);
        if (abilityType == IgnivorusAbilities.IGNIVORUS_FIRE_BREATH) {
            this.clearFireBreathPath();
            this.setBreathingFire(false);
        }
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("ignivorus_roar", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("ignivorus_ultimate", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("ignivorus_fire_breath", RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        String abilityId = this.getMeleeMode() == 1 ? "ignivorus_body_slam" : "ignivorus_bite";
        return new RideableDragonBase.RiderAbilityBinding(abilityId, RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        return this.interactionHandler.handleInteraction(player, hand);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42526_) || stack.m_150930_(ModItems.HEARTY_DRAGON_MEAL.get());
    }

    public void setCommandManual(int command) {
        this.setCommand(command);
    }

    @Override
    protected void onRiderToggleMelee(Player player) {
        if ((this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering()) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.m_9236_().f_46443_) {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.ignivorus_secondary_ground_only"), true);
                this.syncMeleeMode((Player)serverPlayer);
                return;
            }
        }
        super.onRiderToggleMelee(player);
        if (!this.m_9236_().f_46443_) {
            this.syncMeleeMode(player);
        }
    }

    @Override
    protected void onRiderBulldoze(Player player) {
        if (this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering()) {
            return;
        }
        if (this.bulldozeCooldownTicks > 0) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.bulldozing) {
            this.bulldozing = false;
            this.f_19804_.m_135381_(DATA_BULLDOZING, (Object)false);
            this.setAccelerating(false);
            this.bulldozeCooldownTicks = 40;
            this.lockRiderControls(20);
            this.animationHandler.triggerBulldozeExitAnimation();
        } else {
            this.bulldozing = true;
            this.f_19804_.m_135381_(DATA_BULLDOZING, (Object)true);
            this.setAccelerating(true);
            this.lockRiderControls(20);
            this.animationHandler.triggerBulldozeEnterAnimation();
        }
    }

    @Override
    protected void onRiderTakeoffRequest(Player player) {
        if (!this.m_29443_() && this.m_20096_()) {
            this.enforcePrimaryMeleeForFlight(player);
            this.riderController.requestRiderTakeoff();
        }
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    public double m_6048_() {
        return this.riderController.getPassengersRidingOffset();
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.riderController.getControllingPassenger();
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.f_21344_ = this.airNav;
            this.f_21342_ = new DragonFlightMoveHelper(this);
            this.usingAirNav = true;
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.f_21344_ = this.groundNav;
            this.f_21342_ = new MoveControl((Mob)this);
            this.usingAirNav = false;
        }
    }

    @Override
    public void markLandedNow() {
        this.setFlying(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setHovering(false);
        this.timeFlying = 0;
    }

    @Override
    public float getFlightSpeed() {
        return (float)this.m_21133_(Attributes.f_22280_);
    }

    @Override
    public double getPreferredFlightAltitude() {
        return 20.0;
    }

    public boolean canBeBound() {
        return !this.m_29443_() && !this.isDying() && !this.isBreathingFire() && !this.areRiderControlsLocked() && this.getActiveAbility() == null;
    }

    private void applyConfiguredAttributes() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        DragonAttributeConfig config = DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID);
        double attackDamage = config.abilityDamage("bite", 15.0);
        this.setAttributeBase(Attributes.f_22276_, config.maxHealth());
        this.setAttributeBase(Attributes.f_22280_, config.flyingSpeed());
        this.setAttributeBase(Attributes.f_22284_, config.armor());
        this.setAttributeBase(Attributes.f_22281_, attackDamage);
        double maxHealth = config.maxHealth();
        if ((double)this.m_21223_() > maxHealth) {
            this.m_21153_((float)maxHealth);
        }
    }

    private void setAttributeBase(Attribute attribute, double value) {
        AttributeInstance instance = this.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    @Override
    public boolean canTakeoff() {
        return !this.m_29443_() && this.m_20096_();
    }

    @Override
    public void setFlying(boolean flying) {
        boolean wasFlying = this.m_29443_();
        this.f_19804_.m_135381_(DATA_FLYING, (Object)flying);
        if (wasFlying != flying) {
            this.setAccelerating(false);
            if (flying) {
                Player p;
                LivingEntity livingEntity = this.m_6688_();
                this.enforcePrimaryMeleeForFlight(livingEntity instanceof Player ? (p = (Player)livingEntity) : null);
                this.switchToAirNavigation();
                this.setRunning(false);
            } else {
                this.switchToGroundNavigation();
            }
        }
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        boolean wasTakeoff = this.isTakeoff();
        this.f_19804_.m_135381_(DATA_TAKEOFF, (Object)takeoff);
        if (takeoff && !wasTakeoff && !this.m_9236_().f_46443_) {
            float pitch = 0.9f + this.m_217043_().m_188501_() * 0.15f;
            this.m_5496_(ModSounds.IGNIVORUS_TAKEOFF.get(), 1.4f, pitch);
        }
    }

    @Override
    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(DATA_HOVERING, (Object)hovering);
    }

    @Override
    public void setLanding(boolean landing) {
        this.f_19804_.m_135381_(DATA_LANDING, (Object)landing);
    }

    @Override
    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(DATA_RUNNING, (Object)running);
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RUNNING);
    }

    @Override
    protected boolean isDragonFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLYING);
    }

    @Override
    public boolean isTakeoff() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAKEOFF);
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOVERING);
    }

    @Override
    public boolean isLanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LANDING);
    }

    @Override
    public int getFlightMode() {
        return (Integer)this.f_19804_.m_135370_(DATA_FLIGHT_MODE);
    }

    public void setFlightMode(int mode) {
        this.f_19804_.m_135381_(DATA_FLIGHT_MODE, (Object)mode);
    }

    private int computeFlightModeForSync() {
        Player player;
        LivingEntity livingEntity;
        boolean riderAscending;
        Player player2;
        LivingEntity rider;
        if (!this.m_29443_()) {
            this.riderHighAltitudeGlide = false;
            return -1;
        }
        if (this.timeFlying < 5 || this.timeFlying < 30 && (!this.m_20096_() || this.m_20184_().f_82480_ > 0.05)) {
            this.riderHighAltitudeGlide = false;
            return 3;
        }
        if (this.isHovering() || this.isLanding()) {
            this.riderHighAltitudeGlide = false;
            return 2;
        }
        if (this.m_21824_() && this.m_20160_() && (rider = this.m_6688_()) instanceof Player && this.m_21830_((LivingEntity)(player2 = (Player)rider))) {
            double deltaX = this.m_20185_() - this.lastCheckedX;
            double deltaY = this.m_20186_() - this.lastCheckedY;
            double deltaZ = this.m_20189_() - this.lastCheckedZ;
            double positionChangeSqr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            boolean goingUp = this.isGoingUp();
            boolean goingDown = this.isGoingDown();
            boolean accelerating = this.isAccelerating();
            if (positionChangeSqr > 1.0E-4 || goingUp || goingDown || accelerating) {
                this.ticksSinceLastMovement = 0;
                this.lastCheckedX = this.m_20185_();
                this.lastCheckedY = this.m_20186_();
                this.lastCheckedZ = this.m_20189_();
            } else {
                ++this.ticksSinceLastMovement;
            }
            if (this.ticksSinceLastMovement > 3) {
                return 5;
            }
            if (accelerating) {
                return 4;
            }
        }
        double altitude = this.m_20186_() - (double)this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)this.m_20185_(), (int)this.m_20189_());
        Vec3 velocity = this.m_20184_();
        boolean ascending = velocity.f_82480_ > 0.02;
        boolean bl = riderAscending = this.m_20160_() && this.isGoingUp();
        if (this.m_21824_() && this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player && this.m_21830_((LivingEntity)(player = (Player)livingEntity))) {
            if (altitude <= 6.0 || this.isNearWaterSurface()) {
                this.riderHighAltitudeGlide = false;
                return 0;
            }
            if (ascending || riderAscending) {
                return 1;
            }
            if (this.riderHighAltitudeGlide) {
                if (altitude > 30.0) {
                    return 0;
                }
                this.riderHighAltitudeGlide = false;
            } else if (altitude > 40.0) {
                this.riderHighAltitudeGlide = true;
                return 0;
            }
            return 1;
        }
        this.riderHighAltitudeGlide = false;
        if (ascending || riderAscending) {
            return 1;
        }
        return altitude > 35.0 ? 0 : 1;
    }

    private boolean isNearWaterSurface() {
        if (this.m_9236_() == null) {
            return false;
        }
        double dragonY = this.m_20186_();
        if (dragonY > 64.0) {
            return false;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int baseX = Mth.m_14107_((double)this.m_20185_());
        int baseY = Mth.m_14107_((double)dragonY);
        int baseZ = Mth.m_14107_((double)this.m_20189_());
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy <= 8; ++dy) {
                    double surfaceY;
                    cursor.m_122178_(baseX + dx, baseY - dy, baseZ + dz);
                    if (!this.m_9236_().m_46805_((BlockPos)cursor) || this.m_9236_().m_8055_((BlockPos)cursor).m_60819_().m_76178_() || !(Math.abs(dragonY - (surfaceY = (double)cursor.m_123342_() + 1.0)) <= 2.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FIRE_BREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        boolean wasBreathing = (Boolean)this.f_19804_.m_135370_(DATA_FIRE_BREATHING);
        this.f_19804_.m_135381_(DATA_FIRE_BREATHING, (Object)breathing);
        if (!breathing) {
            this.resetFireAimDirection();
            this.setFireBreathProgress(0);
            this.fireTime = 0;
            this.fireServerTarget = null;
        }
        if (breathing && !wasBreathing) {
            this.fireTime = 0;
            this.fireServerTarget = this.createInitialFireTarget();
        }
    }

    public int getFireBreathProgress() {
        return (Integer)this.f_19804_.m_135370_(DATA_FIRE_BREATH_PROGRESS);
    }

    public void setFireBreathProgress(int progress) {
        this.f_19804_.m_135381_(DATA_FIRE_BREATH_PROGRESS, (Object)Mth.m_14045_((int)progress, (int)0, (int)40));
    }

    public void syncFireBreathPath(@Nullable Vec3 start, @Nullable Vec3 end) {
        this.setFireBreathStart(start);
        this.setFireBreathTarget(end);
    }

    public void clearFireBreathPath() {
        this.setFireBreathStart(null);
        this.setFireBreathTarget(null);
    }

    @Nullable
    public Vec3 getFireBreathStart() {
        if (!((Boolean)this.f_19804_.m_135370_(DATA_FIRE_START_SET)).booleanValue()) {
            return null;
        }
        return new Vec3((double)((Float)this.f_19804_.m_135370_(DATA_FIRE_START_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_FIRE_START_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_FIRE_START_Z)).floatValue());
    }

    @Nullable
    public Vec3 getFireBreathTarget() {
        if (!((Boolean)this.f_19804_.m_135370_(DATA_FIRE_END_SET)).booleanValue()) {
            return null;
        }
        return new Vec3((double)((Float)this.f_19804_.m_135370_(DATA_FIRE_END_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_FIRE_END_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_FIRE_END_Z)).floatValue());
    }

    public Vec3 getFireBreathStartAnchor(float partialTicks) {
        Vec3 clientBone = this.getClientLocatorPosition("fireBoneOrigin");
        if (clientBone != null) {
            return clientBone;
        }
        return this.computeFireBoneFallback(partialTicks);
    }

    private Vec3 computeFireBoneFallback(float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)this.f_19854_, (double)this.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)this.f_19855_, (double)this.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)this.f_19856_, (double)this.m_20189_());
        float yawDeg = Mth.m_14179_((float)partialTicks, (float)this.f_20886_, (float)this.f_20885_);
        float pitchDeg = Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double localRight = -0.004126875;
        double localUp = 3.715625;
        double localForward = 15.315625;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double pitchedUp = localUp * cp - localForward * sp;
        double pitchedForward = localUp * sp + localForward * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = localRight * cy - pitchedForward * sy;
        double offZ = localRight * sy + pitchedForward * cy;
        return new Vec3(x + offX, y + pitchedUp, z + offZ);
    }

    public Vec3 refreshFireAimDirection(Vec3 start, boolean smooth) {
        Vec3 desired = this.computeRawFireAimDirection(start);
        if (desired == null) {
            this.resetFireAimDirection();
            return null;
        }
        Vec3 clamped = this.clampFireDirection(desired);
        if (clamped == null) {
            this.resetFireAimDirection();
            return null;
        }
        if (this.fireAimDir == null) {
            this.fireAimDir = clamped;
        } else if (smooth) {
            double blend = 0.35;
            this.fireAimDir = this.fireAimDir.m_82549_(clamped.m_82546_(this.fireAimDir).m_82490_(blend));
            double len = this.fireAimDir.m_82553_();
            this.fireAimDir = len > 1.0E-6 ? this.fireAimDir.m_82490_(1.0 / len) : clamped;
        } else {
            this.fireAimDir = clamped;
        }
        return this.fireAimDir;
    }

    private Vec3 computeRawFireAimDirection(Vec3 start) {
        Vec3 towardTarget;
        LivingEntity rider;
        Vec3 look;
        LivingEntity controller = this.m_6688_();
        if (controller instanceof LivingEntity && (look = (rider = controller).m_20154_()).m_82556_() > 1.0E-6) {
            return look.m_82541_();
        }
        if (!this.m_9236_().f_46443_) {
            this.tickFireTargeting(start);
        }
        if (this.fireServerTarget != null && (towardTarget = this.fireServerTarget.m_82546_(start)).m_82556_() > 1.0E-6) {
            return towardTarget.m_82541_();
        }
        Vec3 fallback = Vec3.m_82498_((float)this.m_146909_(), (float)this.f_20885_);
        return fallback.m_82556_() > 1.0E-6 ? fallback.m_82541_() : null;
    }

    private Vec3 clampFireDirection(Vec3 desiredDir) {
        if (desiredDir == null || desiredDir.m_82556_() < 1.0E-6) {
            return null;
        }
        Vec3 dir = desiredDir.m_82541_();
        float desiredYaw = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        float desiredPitch = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.29577951308232);
        float headYaw = this.f_20885_;
        float headPitch = this.m_146909_();
        float yawErr = Mth.m_14118_((float)headYaw, (float)desiredYaw);
        float pitchErr = desiredPitch - headPitch;
        float finalYaw = headYaw + Mth.m_14036_((float)yawErr, (float)-70.0f, (float)70.0f);
        float finalPitch = headPitch + Mth.m_14036_((float)pitchErr, (float)-45.0f, (float)45.0f);
        Vec3 finalDir = Vec3.m_82498_((float)finalPitch, (float)finalYaw);
        return finalDir.m_82556_() > 1.0E-6 ? finalDir.m_82541_() : null;
    }

    private void applyFireLook(Vec3 aimDir) {
        if (aimDir == null) {
            return;
        }
        float desiredYaw = (float)(Math.atan2(-aimDir.f_82479_, aimDir.f_82481_) * 57.29577951308232);
        float desiredPitch = (float)(-Math.atan2(aimDir.f_82480_, Math.sqrt(aimDir.f_82479_ * aimDir.f_82479_ + aimDir.f_82481_ * aimDir.f_82481_)) * 57.29577951308232);
        float headYawSpeed = 12.0f;
        float headPitchSpeed = 9.0f;
        this.f_20885_ = Mth.m_14148_((float)this.f_20885_, (float)desiredYaw, (float)headYawSpeed);
        float currentPitch = this.m_146909_();
        float pitchDelta = desiredPitch - currentPitch;
        float pitchChange = Mth.m_14036_((float)pitchDelta, (float)(-headPitchSpeed), (float)headPitchSpeed);
        this.m_146926_(currentPitch + pitchChange);
        float yawDiff = Mth.m_14145_((float)desiredYaw, (float)Mth.m_14177_((float)this.f_20883_));
        if (yawDiff > 45.5f) {
            float bodySpeed = 6.0f;
            this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)desiredYaw, (float)bodySpeed));
            this.f_20883_ = Mth.m_14148_((float)this.f_20883_, (float)desiredYaw, (float)bodySpeed);
        }
    }

    private void resetFireAimDirection() {
        this.fireAimDir = null;
    }

    private Vec3 createInitialFireTarget() {
        LivingEntity target = this.m_5448_();
        Vec3 shootFrom = this.getFireBreathStartAnchor(1.0f);
        if (shootFrom == null) {
            shootFrom = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
        }
        if (target != null && target.m_6084_()) {
            Vec3 randomOffset = new Vec3((double)(-50.0f + this.f_19796_.m_188501_() * 100.0f), (double)(-20.0f + this.f_19796_.m_188501_() * 40.0f), (double)(-50.0f + this.f_19796_.m_188501_() * 100.0f));
            return target.m_20182_().m_82549_(randomOffset);
        }
        Vec3 forward = new Vec3(0.0, this.f_19796_.m_188499_() ? 50.0 : 10.0, 30.0).m_82524_((float)Math.toRadians(-this.f_20883_));
        return shootFrom.m_82549_(forward);
    }

    private void tickFireTargeting(Vec3 shootFrom) {
        Vec3 currentTarget;
        ++this.fireTime;
        LivingEntity target = this.m_5448_();
        Vec3 vec3 = currentTarget = this.fireServerTarget != null ? this.fireServerTarget : shootFrom;
        if (target != null && target.m_6084_()) {
            Vec3 approach;
            float maxFireTime = 60.0f;
            float time = (float)this.fireTime / maxFireTime;
            float accuracy = 1.0f - Math.min(0.75f, time) / 0.75f;
            Vec3 wobbleOffset = new Vec3(Math.sin((float)this.f_19797_ * 0.2f) * 4.0, Math.sin((float)this.f_19797_ * 0.15f) * 2.0, Math.cos((float)this.f_19797_ * 0.2f) * -4.0).m_82524_((float)Math.toRadians(-this.f_20883_)).m_82490_((double)accuracy);
            Vec3 targetPoint = target.m_146892_().m_82520_(0.0, -0.2, 0.0).m_82549_(wobbleOffset);
            this.fireServerTarget = approach = targetPoint.m_82546_(currentTarget).m_82490_((double)0.1f).m_82549_(currentTarget);
        } else {
            Vec3 approach;
            Vec3 sweepOffset = new Vec3(Math.sin((float)this.f_19797_ * 0.1f) * 10.0, 0.0, 6.0).m_82524_((float)Math.toRadians(-this.f_20883_));
            Vec3 sweepTarget = shootFrom.m_82549_(sweepOffset);
            this.fireServerTarget = approach = sweepTarget.m_82546_(currentTarget).m_82490_((double)0.1f).m_82549_(currentTarget);
        }
    }

    private void setFireBreathStart(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(DATA_FIRE_START_SET, (Object)false);
            return;
        }
        this.f_19804_.m_135381_(DATA_FIRE_START_SET, (Object)true);
        this.f_19804_.m_135381_(DATA_FIRE_START_X, (Object)Float.valueOf((float)pos.f_82479_));
        this.f_19804_.m_135381_(DATA_FIRE_START_Y, (Object)Float.valueOf((float)pos.f_82480_));
        this.f_19804_.m_135381_(DATA_FIRE_START_Z, (Object)Float.valueOf((float)pos.f_82481_));
    }

    private void setFireBreathTarget(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(DATA_FIRE_END_SET, (Object)false);
            return;
        }
        this.f_19804_.m_135381_(DATA_FIRE_END_SET, (Object)true);
        this.f_19804_.m_135381_(DATA_FIRE_END_X, (Object)Float.valueOf((float)pos.f_82479_));
        this.f_19804_.m_135381_(DATA_FIRE_END_Y, (Object)Float.valueOf((float)pos.f_82480_));
        this.f_19804_.m_135381_(DATA_FIRE_END_Z, (Object)Float.valueOf((float)pos.f_82481_));
    }

    @Override
    public Vec3 getMouthPosition() {
        Vec3 mouthLocator = this.getClientLocatorPosition("mouth_origin");
        if (mouthLocator != null) {
            return mouthLocator;
        }
        return this.computeMouthPositionFallback();
    }

    private Vec3 computeMouthPositionFallback() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        float yawDeg = this.f_20885_;
        float pitchDeg = this.m_146909_();
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double localRight = -0.004126875;
        double localUp = 3.715625;
        double localForward = 15.315625;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double pitchedUp = localUp * cp - localForward * sp;
        double pitchedForward = localUp * sp + localForward * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = localRight * cy - pitchedForward * sy;
        double offZ = localRight * sy + pitchedForward * cy;
        return new Vec3(x + offX, y + pitchedUp, z + offZ);
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return this.getMeleeMode() == 1 ? IgnivorusAbilities.IGNIVORUS_BODY_SLAM : IgnivorusAbilities.IGNIVORUS_BITE;
    }

    private void enforcePrimaryMeleeForFlight(@Nullable Player rider) {
        if (this.m_9236_().f_46443_ || this.getMeleeMode() == 0) {
            return;
        }
        this.setMeleeMode(0);
        this.syncMeleeMode(rider);
    }

    private void syncMeleeMode(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayer(serverPlayer, new MessageDragonMeleeMode(this.getMeleeMode()));
        }
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return IgnivorusAbilities.IGNIVORUS_ROAR;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return IgnivorusAbilities.IGNIVORUS_FIRE_BREATH;
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return IgnivorusAbilities.IGNIVORUS_HURT;
    }

    @Override
    protected DragonAbilityType<?, ?> getDeathAbilityType() {
        return IgnivorusAbilities.IGNIVORUS_DIE;
    }

    @Override
    public int getDeathAnimationDurationTicks() {
        return 80;
    }

    @Override
    public void onDeathAbilityStarted() {
        this.setBreathingFire(false);
        this.clearFireBreathPath();
        super.onDeathAbilityStarted();
    }

    @Override
    protected EntityDataAccessor<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected EntityDataAccessor<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected EntityDataAccessor<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected EntityDataAccessor<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected EntityDataAccessor<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    private void tickBankingLogic() {
        this.prevBankAngle = this.bankAngle;
        if (!this.m_29443_()) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.7f + yawChange * 0.3f;
        float targetAngle = Mth.m_14036_((float)(this.bankSmoothedYaw * 4.5f), (float)-45.0f, (float)45.0f);
        this.bankAngle = Mth.m_14179_((float)0.28f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 12.0f;
        float exit = 5.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickPitchingLogic() {
        this.tickRiderLandingBlendTimer();
        if (!this.m_29443_()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) != Double.POSITIVE_INFINITY && altitude >= -0.25 && altitude <= 8.0) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.m_146909_() - this.f_19860_;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.85f + pitchChange * 0.15f;
            float enter = 3.0f;
            float exit = 3.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 20);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.m_20160_() || !this.m_29443_() || this.m_20096_()) {
            boolean wasLanding = this.riderLandingBlendTicks > 0 && this.isRiderLandingBlendActive();
            this.riderLandingBlendTicks = 0;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
                if (wasLanding && this.m_20096_() && this.m_20160_()) {
                    this.setFlying(false);
                    this.setTakeoff(false);
                    this.timeFlying = 0;
                    this.triggerAnim("action", "landed");
                    this.lockRiderControls(33);
                }
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 5;
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_46805_(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        int dragonY = Mth.m_14107_((double)this.m_20186_());
        int scanBottom = Math.min(groundY, dragonY - 12);
        for (int y = dragonY; y >= scanBottom; --y) {
            BlockPos check = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (this.m_9236_().m_6425_(check).m_76178_()) continue;
            return Double.POSITIVE_INFINITY;
        }
        return this.m_20186_() - (double)groundY;
    }

    private void tickWaterDisturbance() {
        if (this.m_9236_().f_46443_ || !this.m_29443_()) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB box = this.m_20191_();
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        int checkDown = 0;
        while ((double)checkDown < 8.0) {
            BlockPos checkPos = new BlockPos(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)pos.f_82480_) - checkDown, Mth.m_14107_((double)pos.f_82481_));
            BlockState state = this.m_9236_().m_8055_(checkPos);
            if (!state.m_60819_().m_76178_()) {
                double waterY = (double)checkPos.m_123342_() + 1.0;
                double boxWidth = box.m_82362_();
                double boxLength = box.m_82385_();
                int particleCount = (int)Math.ceil((boxWidth + boxLength) / 2.0 * 0.6 * 8.0);
                particleCount = Math.min(particleCount, 40);
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * boxWidth;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * boxLength;
                    double particleX = pos.f_82479_ + offsetX;
                    double particleZ = pos.f_82481_ + offsetZ;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, particleX, waterY, particleZ, 1, offsetX * 0.2, 0.1, offsetZ * 0.2, 0.1);
                    if (!(this.f_19796_.m_188501_() < 0.25f)) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, particleX, waterY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            ++checkDown;
        }
    }

    private void tickTerrainClearing() {
        Vec3 planarVelocity;
        int tickInterval;
        if (this.m_9236_().f_46443_ || this.m_6162_() || !this.m_6084_()) {
            return;
        }
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        boolean isBeingRidden = this.m_20160_();
        Vec3 velocity = this.m_20184_();
        double speed = velocity.m_165925_();
        if (!isBeingRidden && speed < 0.01) {
            return;
        }
        int n = tickInterval = isBeingRidden ? 1 : 3;
        if (this.f_19797_ % tickInterval != 0) {
            return;
        }
        AABB rawBounds = this.m_20191_();
        AABB bounds = rawBounds.m_82400_(0.1);
        if (isBeingRidden && (planarVelocity = new Vec3(velocity.f_82479_, 0.0, velocity.f_82481_)).m_82556_() > 4.0E-4) {
            double reach = isBeingRidden ? 1.1 : 0.6;
            Vec3 forwardProbe = planarVelocity.m_82541_().m_82490_(reach);
            bounds = bounds.m_82363_(forwardProbe.f_82479_, 0.0, forwardProbe.f_82481_);
        }
        int minX = Mth.m_14107_((double)bounds.f_82288_);
        int maxX = Mth.m_14107_((double)bounds.f_82291_);
        int minZ = Mth.m_14107_((double)bounds.f_82290_);
        int maxZ = Mth.m_14107_((double)bounds.f_82293_);
        int baseY = Mth.m_14107_((double)rawBounds.f_82289_);
        int minBreakY = baseY + 1;
        int maxY = Mth.m_14107_((double)bounds.f_82292_);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int brokenThisTick = 0;
        int maxBreakPerTick = isBeingRidden ? 24 : 8;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minBreakY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    float hardness;
                    BlockState state;
                    if (brokenThisTick >= maxBreakPerTick) {
                        return;
                    }
                    cursor.m_122178_(x, y, z);
                    if (!this.m_9236_().m_46805_((BlockPos)cursor) || (state = this.m_9236_().m_8055_((BlockPos)cursor)).m_60795_() || !state.m_60819_().m_76178_() || (hardness = state.m_60800_((BlockGetter)this.m_9236_(), (BlockPos)cursor)) < 0.0f || hardness > 5.0f || state.m_155947_()) continue;
                    this.m_9236_().m_46953_((BlockPos)cursor, true, (Entity)this);
                    ++brokenThisTick;
                }
            }
        }
    }

    private void updateSittingProgress() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.m_21827_()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = this.getSitDownAnimationTicks();
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else if (this.m_20160_()) {
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
                this.prevSitProgress = 0.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
                this.isSittingDown = false;
                this.isStandingUp = false;
                this.sitTransitionTicks = 0;
            }
        } else if (this.sitProgress > 0.0f) {
            if ((this.sitProgress == this.maxSitTicks() || this.isSittingDown) && !this.isStandingUp) {
                this.animationHandler.triggerSitUpAnimation();
                this.isStandingUp = true;
                this.isSittingDown = false;
                this.sitTransitionTicks = this.getSitUpAnimationTicks();
            }
            this.sitProgress -= 1.0f;
            if (this.sitProgress < 0.0f) {
                this.sitProgress = 0.0f;
            }
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
    }

    public int getSitDownAnimationTicks() {
        return 38;
    }

    public int getSitUpAnimationTicks() {
        return 38;
    }

    public float getBankAngleDegrees(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public double getPitchDirection() {
        return this.pitchDir;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::handleMovementAnimation);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        AnimationController bankingController = new AnimationController((GeoAnimatable)this, "banking", 8, this.animationHandler::bankingPredicate);
        AnimationController pitchingController = new AnimationController((GeoAnimatable)this, "pitching", 6, this.animationHandler::pitchingPredicate);
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 5, state -> {
            if (this.isTamingStunned()) {
                return PlayState.STOP;
            }
            return PlayState.STOP;
        });
        AnimationController hurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        hurtController.triggerableAnim("ignivorus_hurt", RawAnimation.begin().thenPlay("animation.ignivorus.hurt"));
        hurtController.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Ignivorus>)actionController);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{movementController, bankingController, pitchingController, hurtController, actionController});
    }

    private void onAnimationSound(SoundKeyframeEvent<Ignivorus> event) {
        String controllerName;
        if (!this.m_9236_().f_46443_) {
            return;
        }
        SoundKeyframeData data = event.getKeyframeData();
        String key = this.extractSoundKey(data);
        String string = controllerName = event.getController() != null ? event.getController().getName() : "unknown";
        if (key != null && (key.contains("ignivorus_walk") || key.contains("ignivorus_run")) && !"movement".equals(controllerName)) {
            return;
        }
        this.soundHandler.handleAnimationSound(this, data, event.getController());
    }

    private String extractSoundKey(Object data) {
        if (data == null) {
            return null;
        }
        try {
            Object value = data.getClass().getMethod("getSound", new Class[0]).invoke(data, new Object[0]);
            return value instanceof String ? ((String)value).toLowerCase(Locale.ROOT) : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private String extractLocator(Object data) {
        if (data == null) {
            return null;
        }
        try {
            Object value = data.getClass().getMethod("getLocator", new Class[0]).invoke(data, new Object[0]);
            return value instanceof String ? (String)value : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.dragonCache;
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return IgnivorusSoundProfile.INSTANCE;
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    @Override
    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return null;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.saveRideableData(tag);
        tag.m_128405_("TimeFlying", this.timeFlying);
        this.combatManager.saveToNBT(tag);
        tag.m_128405_("FeedingCooldownTicks", Math.max(0, (Integer)this.f_19804_.m_135370_(DATA_FEEDING_COOLDOWN)));
        tag.m_128405_("TextureVariant", ((Integer)this.f_19804_.m_135370_(DATA_TEXTURE_VARIANT)).intValue());
        this.tamingController.save(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.loadRideableData(tag);
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.combatManager.loadFromNBT(tag);
        if (tag.m_128441_("FeedingCooldownTicks")) {
            this.f_19804_.m_135381_(DATA_FEEDING_COOLDOWN, (Object)Math.max(0, tag.m_128451_("FeedingCooldownTicks")));
        }
        if (tag.m_128441_("TextureVariant")) {
            this.f_19804_.m_135381_(DATA_TEXTURE_VARIANT, (Object)tag.m_128451_("TextureVariant"));
        }
        this.tamingController.load(tag);
        this.applyConfiguredAttributes();
    }

    protected boolean m_6093_() {
        return !this.m_29443_() && !this.isHovering();
    }

    @Override
    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
        this.setFlying(flying);
        this.setTakeoff(takeoff);
        this.setHovering(hovering);
        this.setLanding(landing);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if ((this.isTamingStunned() || this.tamingAbortCalmTicks > 0) && target != null) {
            return;
        }
        super.m_6710_(target);
    }

    public boolean m_142535_(float fallDistance, float fallMultiplier, @NotNull DamageSource source) {
        return false;
    }

    public static boolean canSpawnHere(EntityType<Ignivorus> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos below = pos.m_7495_();
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (!level.m_6425_(below).m_76178_()) {
            return false;
        }
        boolean solidGround = level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
        boolean feetFree = level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
        boolean headFree = level.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)level, pos.m_7494_()).m_83281_();
        return solidGround && feetFree && headFree;
    }

    private void tickScreenShake() {
        if (this.m_9236_().f_46443_) {
            this.prevScreenShakeAmount = this.screenShakeAmount;
            this.screenShakeAmount = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
            return;
        }
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            float newAmount;
            this.screenShakeAmount = newAmount = Math.max(0.0f, this.screenShakeAmount - 0.025f);
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(newAmount));
        } else if (((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue() != 0.0f) {
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        }
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 30.0;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        float clamped = Math.max(0.0f, intensity);
        if (clamped <= 0.0f) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.screenShakeAmount = Math.max(this.screenShakeAmount, clamped);
        this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }
}

