/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane.handlers;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public final class CindervaneSoundProfile
implements DragonSoundProfile {
    public static final CindervaneSoundProfile INSTANCE = new CindervaneSoundProfile();
    private static final Map<String, Integer> VOCAL_WINDOWS = Map.ofEntries(Map.entry("grumble1", 90), Map.entry("grumble2", 150), Map.entry("grumble3", 75), Map.entry("roar", 45), Map.entry("roar_ground", 45), Map.entry("roar_air", 45), Map.entry("cindervane_hurt", 20), Map.entry("cindervane_die", 95));
    private static final Map<String, String> EFFECT_TO_VOCAL_KEY = Map.ofEntries(Map.entry("cindervane_grumble1", "grumble1"), Map.entry("cindervane_grumble2", "grumble2"), Map.entry("cindervane_grumble3", "grumble3"), Map.entry("cindervane_roar", "roar"), Map.entry("roar_ground", "roar_ground"), Map.entry("roar_air", "roar_air"), Map.entry("cindervane_hurt", "cindervane_hurt"), Map.entry("cindervane_die", "cindervane_die"));
    private static final Map<String, DragonEntity.VocalEntry> FALLBACK_VOCALS = new DragonEntity.VocalEntryBuilder().add("cindervane_bite", "actions", "animation.cindervane.bite", ModSounds.CINDERVANE_BITE, 1.0f, 0.95f, 0.1f, false, false, false).build();

    private CindervaneSoundProfile() {
    }

    @Override
    public boolean handleAnimationSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator) {
        String vocalKey = EFFECT_TO_VOCAL_KEY.get(key);
        if (vocalKey != null) {
            if ("cindervane_hurt".equals(key)) {
                return true;
            }
            this.playVocalEntry(handler, dragon, vocalKey, locator);
            return true;
        }
        return switch (key) {
            case "cindervane_walk" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.CINDERVANE_WALK.get(), 1.0f, 1.0f, 0.0f);
                yield true;
            }
            case "cindervane_run" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.CINDERVANE_RUN.get(), 1.0f, 1.0f, 0.0f);
                yield true;
            }
            case "cindervane_bite" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.CINDERVANE_BITE.get(), 1.0f, 0.95f, 0.1f);
                yield true;
            }
            case "cindervane_landed" -> {
                this.playSimpleSound(handler, dragon, locator, ModSounds.CINDERVANE_LANDED.get(), 1.0f, 1.0f, 0.0f);
                yield true;
            }
            case "cindervane_eat" -> {
                this.playSimpleSound(handler, dragon, "mouth_origin", ModSounds.CINDERVANE_EAT.get(), 1.0f, 1.0f, 0.0f);
                yield true;
            }
            default -> false;
        };
    }

    @Override
    public DragonEntity.VocalEntry getFallbackVocalEntry(String key) {
        return FALLBACK_VOCALS.get(key);
    }

    @Override
    public int getVocalAnimationWindowTicks(String key) {
        return VOCAL_WINDOWS.getOrDefault(key, -1);
    }

    @Override
    public boolean handleWingFlapSound(DragonSoundHandler handler, DragonEntity dragon, String key) {
        float volume = dragon.m_6162_() ? 0.6f : 1.1f;
        float pitch = 0.98f + (dragon.m_217043_().m_188501_() - 0.5f) * 0.1f;
        dragon.m_9236_().m_7785_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), ModSounds.CINDERVANE_FLAP.get(), SoundSource.NEUTRAL, volume, pitch, false);
        return true;
    }

    private void playVocalEntry(DragonSoundHandler handler, DragonEntity dragon, String vocalKey, String locator) {
        DragonEntity.VocalEntry entry = dragon.getVocalEntries().get(vocalKey);
        if (entry == null) {
            entry = FALLBACK_VOCALS.get(vocalKey);
        }
        if (entry == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (dragon.m_5803_() || dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && dragon.isStayOrSitMuted()) {
            return;
        }
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = entry.basePitch();
        if (entry.pitchVariance() != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * entry.pitchVariance();
        }
        this.playClientSound(dragon, at, entry.soundSupplier().get(), entry.volume(), pitch);
    }

    private void playSimpleSound(DragonSoundHandler handler, DragonEntity dragon, String locator, SoundEvent sound, float volume, float basePitch, float variance) {
        Vec3 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = basePitch;
        if (variance != 0.0f) {
            pitch += dragon.m_217043_().m_188501_() * variance;
        }
        this.playClientSound(dragon, at, sound, volume, pitch);
    }

    private void playClientSound(DragonEntity dragon, Vec3 position, SoundEvent sound, float volume, float pitch) {
        double x = position != null ? position.f_82479_ : dragon.m_20185_();
        double y = position != null ? position.f_82480_ : dragon.m_20186_();
        double z = position != null ? position.f_82481_ : dragon.m_20189_();
        dragon.m_9236_().m_7785_(x, y, z, sound, SoundSource.NEUTRAL, volume, pitch, false);
    }
}

