/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane.handlers;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CindervaneAnimationHandler {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.cindervane.idle");
    private static final RawAnimation GLIDE = RawAnimation.begin().thenLoop("animation.cindervane.glide");
    private static final RawAnimation GLIDE_DOWN = RawAnimation.begin().thenLoop("animation.cindervane.glide_down");
    private static final RawAnimation FLAP = RawAnimation.begin().thenLoop("animation.cindervane.flap");
    private static final RawAnimation SPRINT_FLAP = RawAnimation.begin().thenLoop("animation.cindervane.sprint_flap");
    private static final RawAnimation FLY_IDLE = RawAnimation.begin().thenLoop("animation.cindervane.fly_idle");
    private static final RawAnimation TAKEOFF = RawAnimation.begin().thenPlay("animation.cindervane.takeoff");
    private static final RawAnimation LANDING = RawAnimation.begin().thenPlay("animation.cindervane.landing");
    private static final RawAnimation LANDED = RawAnimation.begin().thenPlay("animation.cindervane.landed");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.cindervane.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.cindervane.run");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.cindervane.sit");
    private static final RawAnimation SIT_DOWN = RawAnimation.begin().thenPlay("animation.cindervane.down");
    private static final RawAnimation SIT_UP = RawAnimation.begin().thenPlay("animation.cindervane.up");
    private static final RawAnimation FALL_ASLEEP = RawAnimation.begin().thenPlay("animation.cindervane.fall_asleep");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.cindervane.sleep");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("animation.cindervane.wake_up");
    private static final RawAnimation BANK_LEFT = RawAnimation.begin().thenLoop("animation.cindervane.banking_left");
    private static final RawAnimation BANK_RIGHT = RawAnimation.begin().thenLoop("animation.cindervane.banking_right");
    private static final RawAnimation BANK_OFF = RawAnimation.begin().thenLoop("animation.cindervane.banking_off");
    private static final RawAnimation PITCH_UP = RawAnimation.begin().thenLoop("animation.cindervane.pitching_up");
    private static final RawAnimation PITCH_DOWN = RawAnimation.begin().thenLoop("animation.cindervane.pitching_down");
    private static final RawAnimation PITCH_OFF = RawAnimation.begin().thenLoop("animation.cindervane.pitching_off");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.cindervane.swim");
    private final Cindervane dragon;

    public CindervaneAnimationHandler(Cindervane dragon) {
        this.dragon = dragon;
    }

    public PlayState handleMovementAnimation(AnimationState<Cindervane> state) {
        float maxSit;
        boolean inWater;
        state.getController().transitionLength(12);
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(IDLE);
            return PlayState.CONTINUE;
        }
        if (this.dragon.isDying()) {
            return PlayState.STOP;
        }
        if (this.dragon.m_5803_() && !this.dragon.isSleepTransitioning()) {
            state.getController().transitionLength(6);
            state.setAndContinue(SLEEP);
            return PlayState.CONTINUE;
        }
        if (this.dragon.isSleepTransitioning()) {
            return PlayState.STOP;
        }
        boolean bl = inWater = this.dragon.m_20069_() || this.dragon.m_20072_();
        if (inWater) {
            state.getController().transitionLength(6);
            state.setAndContinue(SWIM);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.dragon.m_20160_()) {
            state.getController().transitionLength(4);
            if (this.dragon.m_29443_()) {
                int syncedMode = this.dragon.getSyncedFlightMode();
                if (syncedMode == 3) {
                    state.setAndContinue(TAKEOFF);
                    return PlayState.CONTINUE;
                }
                if (this.dragon.isRiderLandingBlendActive()) {
                    state.getController().transitionLength(4);
                    state.setAndContinue(LANDING);
                    return PlayState.CONTINUE;
                }
                if (this.dragon.isGoingDown() && !this.dragon.isRiderLandingBlendActive()) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(GLIDE_DOWN);
                    return PlayState.CONTINUE;
                }
                if (syncedMode == 5) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(FLY_IDLE);
                    return PlayState.CONTINUE;
                }
                if (syncedMode == 4) {
                    state.getController().transitionLength(3);
                    state.setAndContinue(SPRINT_FLAP);
                    return PlayState.CONTINUE;
                }
                if (syncedMode == 2) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(FLAP);
                    return PlayState.CONTINUE;
                }
                int flightMode = this.dragon.getSyncedFlightMode();
                if (flightMode == 0) {
                    state.getController().transitionLength(12);
                    state.setAndContinue(GLIDE);
                } else if (flightMode == 1) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(FLAP);
                } else {
                    state.getController().transitionLength(12);
                    state.setAndContinue(GLIDE);
                }
            } else {
                int groundState = this.dragon.getEffectiveGroundState();
                if (groundState == 2) {
                    state.setAndContinue(RUN);
                } else if (groundState == 1) {
                    state.setAndContinue(WALK);
                } else {
                    state.setAndContinue(IDLE);
                }
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        float sitProgress = this.dragon.getSitProgress();
        if (sitProgress >= (maxSit = this.dragon.maxSitTicks())) {
            state.setAndContinue(SIT);
            return PlayState.CONTINUE;
        }
        if (sitProgress > 0.0f) {
            return PlayState.STOP;
        }
        state.getController().setAnimationSpeed(1.0);
        if (this.dragon.m_29443_()) {
            boolean riderDescending;
            if (this.dragon.getSyncedFlightMode() == 3) {
                state.getController().transitionLength(4);
                state.setAndContinue(TAKEOFF);
                return PlayState.CONTINUE;
            }
            boolean bl2 = riderDescending = this.dragon.m_20160_() && this.dragon.m_6688_() != null && this.dragon.isGoingDown();
            if (riderDescending) {
                state.getController().transitionLength(6);
                state.setAndContinue(GLIDE_DOWN);
            } else {
                boolean sprinting = this.dragon.isAccelerating();
                boolean isMovingHorizontally = this.dragon.m_20184_().m_165925_() > 0.01 || sprinting;
                double verticalVelocity = this.dragon.m_20184_().f_82480_;
                if (sprinting && isMovingHorizontally) {
                    state.getController().transitionLength(3);
                    state.setAndContinue(SPRINT_FLAP);
                } else if (verticalVelocity > 0.02 || this.dragon.m_20184_().m_165925_() < 0.1) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(FLAP);
                } else {
                    state.getController().transitionLength(8);
                    state.setAndContinue(GLIDE);
                }
            }
            return PlayState.CONTINUE;
        }
        if (!(this.dragon.isTakeoff() || this.dragon.isLanding() || this.dragon.isHovering())) {
            int groundState = this.dragon.getEffectiveGroundState();
            if (groundState == 2) {
                state.setAndContinue(RUN);
            } else if (groundState == 1) {
                state.setAndContinue(WALK);
            } else if (this.dragon.isRunning()) {
                state.setAndContinue(RUN);
            } else if (this.dragon.isWalking()) {
                state.setAndContinue(WALK);
            } else {
                state.setAndContinue(IDLE);
            }
        } else {
            state.setAndContinue(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public PlayState bankingPredicate(AnimationState<Cindervane> state) {
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(BANK_OFF);
            return PlayState.CONTINUE;
        }
        if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return PlayState.STOP;
        }
        if (this.dragon.m_20069_() || this.dragon.m_20072_()) {
            return PlayState.STOP;
        }
        state.getController().transitionLength(8);
        float smoothDir = this.dragon.getSmoothBankDirection();
        if (smoothDir > 0.2f) {
            state.setAndContinue(BANK_RIGHT);
        } else if (smoothDir < -0.2f) {
            state.setAndContinue(BANK_LEFT);
        } else {
            state.setAndContinue(BANK_OFF);
        }
        return PlayState.CONTINUE;
    }

    public PlayState pitchingPredicate(AnimationState<Cindervane> state) {
        if (this.dragon.m_9236_().f_46443_ && !this.dragon.isClientAnimationReady()) {
            state.setAndContinue(PITCH_OFF);
            return PlayState.CONTINUE;
        }
        if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return PlayState.STOP;
        }
        if (this.dragon.m_20069_() || this.dragon.m_20072_()) {
            return PlayState.STOP;
        }
        state.getController().transitionLength(4);
        int dir = this.dragon.getPitchDirection();
        if (dir > 0) {
            state.setAndContinue(PITCH_DOWN);
        } else if (dir < 0) {
            state.setAndContinue(PITCH_UP);
        } else {
            state.setAndContinue(PITCH_OFF);
        }
        return PlayState.CONTINUE;
    }

    public void setupActionController(AnimationController<Cindervane> controller) {
        controller.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation.cindervane.bite"));
        controller.triggerableAnim("magma_blast", RawAnimation.begin().thenPlay("animation.cindervane.magma_blast"));
        controller.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.cindervane.eat"));
        controller.triggerableAnim("landed", LANDED);
        controller.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.cindervane.die"));
        controller.triggerableAnim("down", SIT_DOWN);
        controller.triggerableAnim("up", SIT_UP);
        controller.triggerableAnim("fall_asleep", FALL_ASLEEP);
        controller.triggerableAnim("sleep", SLEEP);
        controller.triggerableAnim("wake_up", WAKE_UP);
        this.dragon.getVocalEntries().forEach((key, entry) -> controller.triggerableAnim(key, RawAnimation.begin().thenPlay(entry.animationId())));
    }

    public void triggerSitDownAnimation() {
        this.dragon.triggerAnim("actions", "down");
    }

    public void triggerSitUpAnimation() {
        this.dragon.triggerAnim("actions", "up");
    }

    public void triggerFallAsleepAnimation() {
        this.dragon.triggerAnim("actions", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.dragon.triggerAnim("actions", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.dragon.triggerAnim("actions", "wake_up");
    }

    public PlayState actionPredicate(AnimationState<Cindervane> state) {
        state.getController().transitionLength(5);
        return PlayState.STOP;
    }
}

