/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record NulljawRiderController(Nulljaw drake) {
    private static final double SEAT_BASE_FACTOR = 0.45;
    private static final double SEAT_LIFT = 0.75;
    private static final double SEAT_FORWARD = 3.0;
    private static final double SEAT_SIDE = 0.0;
    private static final double WATER_SPEED_MULT = 1.2;

    @Nullable
    public Player getRidingPlayer() {
        Entity entity = this.drake.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        float f;
        float f2 = f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        if (this.drake.m_20069_()) {
            return new Vec3((double)(player.f_20900_ * 0.6f), 0.0, (double)(player.f_20902_ * 1.0f * f));
        }
        return new Vec3((double)(player.f_20900_ * 0.5f), 0.0, (double)(player.f_20902_ * 0.9f * f));
    }

    public void tickRidden(Player player, Vec3 travelVector) {
        player.f_19789_ = 0.0f;
        this.drake.f_19789_ = 0.0f;
        this.drake.m_6710_(null);
        float currentYaw = this.drake.m_146908_();
        float targetYaw = player.m_146908_();
        float rawDiff = Mth.m_14177_((float)(targetYaw - currentYaw));
        float blend = 0.28f;
        float newYaw = currentYaw + rawDiff * blend;
        this.drake.m_146922_(newYaw);
        this.drake.f_20883_ = newYaw;
        this.drake.f_20885_ = newYaw;
        this.drake.m_146926_(0.0f);
    }

    public void handleRiderMovement(Player player, Vec3 motion) {
        throw new UnsupportedOperationException("handleRiderMovement should not be called for ground-based dragons");
    }

    public float getRiddenSpeed(Player player) {
        if (this.drake.m_20069_()) {
            double swimSpeed = this.drake.getConfiguredSwimSpeed();
            double speed = this.drake.isAccelerating() ? swimSpeed * 1.2 : swimSpeed;
            return (float)speed;
        }
        double speed = this.drake.isAccelerating() ? 0.42 : 0.22;
        return (float)speed;
    }

    public double getPassengersRidingOffset() {
        return (double)this.drake.m_20206_() * 0.45 + 0.75;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (passenger == null) {
            return;
        }
        Vec3 passengerLoc = this.drake.getClientLocatorPosition("passengerLocator");
        if (passengerLoc != null) {
            Vec3 drakeOldPos = new Vec3(this.drake.f_19854_, this.drake.f_19855_, this.drake.f_19856_);
            float oldYaw = this.drake.f_19859_;
            Vec3 worldOffset = passengerLoc.m_82546_(drakeOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.f_82479_ * cosOld - worldOffset.f_82481_ * sinOld;
            double localY = worldOffset.f_82480_;
            double localZ = worldOffset.f_82479_ * sinOld + worldOffset.f_82481_ * cosOld;
            float currentYaw = this.drake.m_146908_();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            Vec3 drakeCurrentPos = this.drake.m_20182_();
            Vec3 passengerCurrentPos = drakeCurrentPos.m_82520_(currentWorldX, localY, currentWorldZ);
            moveFunction.m_20372_(passenger, passengerCurrentPos.f_82479_, passengerCurrentPos.f_82480_, passengerCurrentPos.f_82481_);
        } else {
            double seatY = this.getPassengersRidingOffset();
            Vec3 forward = Vec3.m_82498_((float)0.0f, (float)this.drake.m_146908_());
            Vec3 right = new Vec3(forward.f_82481_, 0.0, -forward.f_82479_);
            Vec3 offset = forward.m_82490_(3.0).m_82549_(right.m_82490_(0.0)).m_82520_(0.0, seatY, 0.0);
            moveFunction.m_20372_(passenger, this.drake.m_20185_() + offset.f_82479_, this.drake.m_20186_() + offset.f_82480_, this.drake.m_20189_() + offset.f_82481_);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 vec3 = NulljawRiderController.getCollisionHorizontalEscapeVector(this.drake.m_20205_(), passenger.m_20205_(), this.drake.m_146908_() + (passenger.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f));
        Vec3 rightSide = this.getDismountLocationInDirection(vec3, passenger);
        if (rightSide != null) {
            return rightSide;
        }
        Vec3 vec32 = NulljawRiderController.getCollisionHorizontalEscapeVector(this.drake.m_20205_(), passenger.m_20205_(), this.drake.m_146908_() + (passenger.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f));
        Vec3 leftSide = this.getDismountLocationInDirection(vec32, passenger);
        return leftSide != null ? leftSide : this.drake.m_20182_();
    }

    private static Vec3 getCollisionHorizontalEscapeVector(double entityWidth, double passengerWidth, float yaw) {
        double d0 = (entityWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
        float f2 = Math.max(Math.abs(f), Math.abs(f1));
        return new Vec3((double)f * d0 / (double)f2, 0.0, (double)f1 * d0 / (double)f2);
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 offset, LivingEntity passenger) {
        double targetX = this.drake.m_20185_() + offset.f_82479_;
        double minY = this.drake.m_20191_().f_82289_;
        double targetZ = this.drake.m_20189_() + offset.f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.m_7431_()) {
            pos.m_122169_(targetX, minY, targetZ);
            double maxY = this.drake.m_20191_().f_82292_ + 0.75;
            do {
                double floorHeight = this.drake.m_9236_().m_45573_((BlockPos)pos);
                if ((double)pos.m_123342_() + floorHeight > maxY) continue block0;
                if (DismountHelper.m_38439_((double)floorHeight)) {
                    AABB aabb = passenger.m_21270_(pose);
                    Vec3 dismountPos = new Vec3(targetX, (double)pos.m_123342_() + floorHeight, targetZ);
                    if (DismountHelper.m_38456_((CollisionGetter)this.drake.m_9236_(), (LivingEntity)passenger, (AABB)aabb.m_82383_(dismountPos))) {
                        passenger.m_20124_(pose);
                        return dismountPos;
                    }
                }
                pos.m_122173_(Direction.UP);
            } while ((double)pos.m_123342_() < maxY);
        }
        return null;
    }

    @Nullable
    public Player getControllingPassenger() {
        Player rider = this.getRidingPlayer();
        if (rider == null) {
            return null;
        }
        if (!this.drake.m_21824_()) {
            return null;
        }
        if (!this.drake.m_21830_((LivingEntity)rider)) {
            return null;
        }
        return rider;
    }
}

