/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.ignivorus;

import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record IgnivorusRiderController(Ignivorus dragon) {
    private static final double SEAT_BASE_FACTOR = 0.5;
    private static final double LANDING_HEIGHT_TRIGGER = 4.0;
    private static final int MAX_GROUND_CHECK_DISTANCE = 10;
    private static final double CRUISE_SPEED_MULT = 8.5;
    private static final double SPRINT_SPEED_MULT = 12.5;
    private static final double ACCELERATION = 0.15;
    private static final double DRAG_WITH_INPUT = 0.08;
    private static final double DRAG_NO_INPUT = 0.5;
    private static final double STRAFE_POWER = 0.5;
    private static final double ASCEND_THRUST = 0.08;
    private static final double DESCEND_THRUST = 1.0;
    private static final double TERMINAL_VELOCITY = 1.5;
    private static final double VERTICAL_DRAG = 0.92;

    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.dragon.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        float f;
        float f2 = f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        if (this.dragon.m_29443_()) {
            return new Vec3((double)(player.f_20900_ * 0.4f), 0.0, (double)(player.f_20902_ * 1.0f * f));
        }
        return new Vec3((double)(player.f_20900_ * 0.5f), 0.0, (double)(player.f_20902_ * 0.9f * f));
    }

    public void tickRidden(Player player, Vec3 travelVector) {
        player.f_19789_ = 0.0f;
        this.dragon.f_19789_ = 0.0f;
        this.dragon.m_6710_(null);
        boolean flying = this.dragon.m_29443_();
        float currentYaw = this.dragon.m_146908_();
        float targetYaw = player.m_146908_();
        float rawDiff = Mth.m_14177_((float)(targetYaw - currentYaw));
        float blend = flying ? 0.35f : 0.28f;
        float newYaw = currentYaw + rawDiff * blend;
        this.dragon.m_146922_(newYaw);
        this.dragon.f_20883_ = newYaw;
        this.dragon.f_20885_ = newYaw;
        if (flying) {
            float targetPitch = 0.0f;
            if (this.dragon.isGoingUp()) {
                targetPitch = -25.0f;
            } else if (this.dragon.isGoingDown()) {
                targetPitch = 20.0f;
            }
            this.dragon.m_146926_(targetPitch);
        } else {
            this.dragon.m_146926_(0.0f);
        }
        if (flying && !this.dragon.isTakeoff()) {
            double distanceToGround = this.getDistanceToGround();
            boolean nearGround = distanceToGround >= 0.0 && distanceToGround <= 4.0;
            boolean atWaterSurface = this.isNearWaterSurface();
            if (nearGround && this.dragon.isGoingDown() && !atWaterSurface && !this.dragon.isLanding()) {
                this.dragon.setLanding(true);
            }
            if (this.dragon.m_20096_()) {
                this.dragon.setFlying(false);
                this.dragon.setLanding(false);
                this.dragon.setTakeoff(false);
            }
        }
        if (this.dragon.m_20096_()) {
            player.f_19789_ = 0.0f;
            this.dragon.f_19789_ = 0.0f;
        }
    }

    private double getDistanceToGround() {
        int startY;
        Level level = this.dragon.m_9236_();
        if (level == null) {
            return -1.0;
        }
        BlockPos dragonPos = this.dragon.m_20183_();
        for (int checkY = startY = dragonPos.m_123342_(); checkY > startY - 10 && checkY >= level.m_141937_(); --checkY) {
            BlockPos checkPos = new BlockPos(dragonPos.m_123341_(), checkY, dragonPos.m_123343_());
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60795_() || !state.m_60819_().m_76178_() || !state.m_60804_((BlockGetter)level, checkPos)) continue;
            return this.dragon.m_20186_() - (double)(checkY + 1);
        }
        return -1.0;
    }

    private boolean isNearWaterSurface() {
        double dragonY = this.dragon.m_20186_();
        return Math.abs(dragonY - 62.0) <= 2.0;
    }

    public float getRiddenSpeed(Player rider) {
        boolean isMoving;
        if (this.dragon.m_29443_()) {
            return (float)this.dragon.m_21133_(Attributes.f_22280_);
        }
        boolean bl = isMoving = this.dragon.m_20184_().m_165925_() > 1.0E-4;
        if (this.dragon.isAccelerating() && isMoving) {
            this.dragon.setRunning(true);
            return 0.6f;
        }
        this.dragon.setRunning(false);
        return 0.225f;
    }

    public void handleRiderMovement(Player player, Vec3 motion) {
        if (this.dragon.m_21573_().m_26570_() != null) {
            this.dragon.m_21573_().m_26573_();
        }
        if (this.dragon.m_29443_()) {
            Vec3 newHorizontalVel;
            double baseSpeed = this.dragon.m_21133_(Attributes.f_22280_);
            boolean sprinting = this.dragon.isAccelerating();
            double targetSpeed = (sprinting ? 12.5 : 8.5) * baseSpeed;
            Vec3 currentVelocity = this.dragon.m_20184_();
            Vec3 horizontalVel = new Vec3(currentVelocity.f_82479_, 0.0, currentVelocity.f_82481_);
            double forwardInput = motion.f_82481_;
            double strafeInput = motion.f_82479_;
            boolean hasInput = Math.abs(forwardInput) > 0.01 || Math.abs(strafeInput) > 0.01;
            float yawRad = (float)Math.toRadians(this.dragon.m_146908_());
            double forwardX = -Math.sin(yawRad);
            double forwardZ = Math.cos(yawRad);
            double rightX = Math.cos(yawRad);
            double rightZ = Math.sin(yawRad);
            double targetDirX = forwardX * forwardInput + rightX * (strafeInput * 0.5);
            double targetDirZ = forwardZ * forwardInput + rightZ * (strafeInput * 0.5);
            double dirLength = Math.hypot(targetDirX, targetDirZ);
            if (hasInput && dirLength > 0.01) {
                Vec3 targetVelocity = new Vec3((targetDirX /= dirLength) * targetSpeed, 0.0, (targetDirZ /= dirLength) * targetSpeed);
                newHorizontalVel = new Vec3(Mth.m_14139_((double)0.15, (double)horizontalVel.f_82479_, (double)targetVelocity.f_82479_), 0.0, Mth.m_14139_((double)0.15, (double)horizontalVel.f_82481_, (double)targetVelocity.f_82481_));
                newHorizontalVel = newHorizontalVel.m_82490_(0.92);
            } else {
                newHorizontalVel = horizontalVel.m_82490_(0.5);
                if (newHorizontalVel.m_82553_() < 0.01) {
                    newHorizontalVel = Vec3.f_82478_;
                }
            }
            double verticalVel = currentVelocity.f_82480_;
            if (this.dragon.isTakeoff()) {
                if (this.dragon.isGoingUp()) {
                    double boost = 0.052000000000000005;
                    verticalVel = Math.max(verticalVel + boost, 0.2);
                } else {
                    verticalVel *= 0.92;
                }
            } else {
                verticalVel = this.dragon.isGoingUp() ? (verticalVel += 0.08) : (this.dragon.isGoingDown() ? (verticalVel -= 1.0) : (verticalVel *= 0.92));
            }
            verticalVel = Mth.m_14008_((double)verticalVel, (double)-1.5, (double)1.5);
            Vec3 finalVelocity = new Vec3(newHorizontalVel.f_82479_, verticalVel, newHorizontalVel.f_82481_);
            this.dragon.m_6478_(MoverType.SELF, finalVelocity);
            this.dragon.m_20256_(finalVelocity);
            this.dragon.m_267651_(true);
            player.f_19789_ = 0.0f;
            this.dragon.f_19789_ = 0.0f;
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.dragon.m_20206_() * 0.5;
    }

    public void positionRider(@NotNull Entity passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction moveFunction) {
        if (!this.dragon.m_20363_(passenger)) {
            return;
        }
        Vec3 passengerLoc = this.dragon.getClientLocatorPosition("passengerLocator");
        if (passengerLoc != null) {
            Vec3 dragonOldPos = new Vec3(this.dragon.f_19854_, this.dragon.f_19855_, this.dragon.f_19856_);
            float oldYaw = this.dragon.f_19859_;
            Vec3 worldOffset = passengerLoc.m_82546_(dragonOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.f_82479_ * cosOld - worldOffset.f_82481_ * sinOld;
            double localY = worldOffset.f_82480_;
            double localZ = worldOffset.f_82479_ * sinOld + worldOffset.f_82481_ * cosOld;
            float currentYaw = this.dragon.m_146908_();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            Vec3 dragonCurrentPos = this.dragon.m_20182_();
            Vec3 passengerCurrentPos = dragonCurrentPos.m_82520_(currentWorldX, localY, currentWorldZ);
            moveFunction.m_20372_(passenger, passengerCurrentPos.f_82479_, passengerCurrentPos.f_82480_, passengerCurrentPos.f_82481_);
        } else {
            double x = this.dragon.m_20185_();
            double y = this.dragon.m_20186_() + this.getPassengersRidingOffset() + passenger.m_6049_();
            double z = this.dragon.m_20189_();
            moveFunction.m_20372_(passenger, x, y, z);
        }
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        passenger.f_19789_ = 0.0f;
        Vec3 base = this.dragon.m_20182_();
        Vec3 direction = this.dragon.m_20252_(1.0f);
        return base.m_82549_(direction.m_82490_(2.0));
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.dragon.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.dragon.m_21824_() && this.dragon.m_21830_((LivingEntity)player)) {
                return player;
            }
        }
        return null;
    }

    public void requestRiderTakeoff() {
        if (!this.dragon.m_21824_() || this.getRidingPlayer() == null || this.dragon.m_29443_()) {
            return;
        }
        this.dragon.m_21573_().m_26573_();
        this.dragon.setGoingDown(false);
        this.dragon.setGoingUp(true);
        this.dragon.timeFlying = 0;
        this.dragon.setFlying(true);
        this.dragon.setTakeoff(true);
        this.dragon.setHovering(false);
        this.dragon.setLanding(false);
        Vec3 current = this.dragon.m_20184_();
        double upward = Math.max(current.f_82480_, 0.25);
        this.dragon.m_20334_(current.f_82479_, upward, current.f_82481_);
        this.dragon.f_19812_ = true;
    }
}

