/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class DragonBodyControl
extends BodyRotationControl {
    private static final int HISTORY_SIZE = 10;
    private final Mob entity;
    private float targetYawHead;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];
    private final float turnSpeed;
    private final float maxHeadBodyDiff;
    private final float headLagSpeed;
    private final float bodyLagStillSpeed;
    private final float bodyMaxDelta;

    public DragonBodyControl(Mob entity, float turnSpeed) {
        this(entity, turnSpeed, 50.0f, 0.3f, 0.1f, 45.0f);
    }

    public DragonBodyControl(Mob entity, float turnSpeed, float maxHeadBodyDiff, float headLagSpeed, float bodyLagStillSpeed, float bodyMaxDelta) {
        super(entity);
        this.entity = entity;
        this.turnSpeed = turnSpeed;
        this.maxHeadBodyDiff = maxHeadBodyDiff;
        this.headLagSpeed = headLagSpeed;
        this.bodyLagStillSpeed = bodyLagStillSpeed;
        this.bodyMaxDelta = bodyMaxDelta;
    }

    public void m_8121_() {
        double dz;
        if (this.entity.m_20160_()) {
            return;
        }
        for (int i = this.histPosX.length - 1; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.delta(this.histPosX);
        double distSq = dx * dx + (dz = this.delta(this.histPosZ)) * dz;
        if (distSq > 2.5E-7) {
            double moveAngle = Math.toDegrees(Mth.m_14136_((double)dz, (double)dx)) - 90.0;
            this.entity.f_20883_ = DragonBodyControl.approach((float)moveAngle, this.entity.f_20883_, this.bodyMaxDelta, this.turnSpeed);
            this.targetYawHead = this.entity.f_20885_;
        } else {
            this.targetYawHead = DragonBodyControl.smooth(this.targetYawHead, this.entity.f_20885_, this.headLagSpeed);
            this.entity.f_20883_ = DragonBodyControl.approach(this.targetYawHead, this.entity.f_20883_, this.bodyMaxDelta, this.bodyLagStillSpeed);
        }
        this.clampHeadBodyDifference();
    }

    public void serverTick() {
        double dz;
        if (this.entity.m_20160_()) {
            return;
        }
        for (int i = this.histPosX.length - 1; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.delta(this.histPosX);
        double distSq = dx * dx + (dz = this.delta(this.histPosZ)) * dz;
        if (distSq > 2.5E-7) {
            double moveAngle = Math.toDegrees(Mth.m_14136_((double)dz, (double)dx)) - 90.0;
            this.entity.f_20883_ = DragonBodyControl.approach((float)moveAngle, this.entity.f_20883_, this.bodyMaxDelta, this.turnSpeed);
            this.targetYawHead = this.entity.f_20885_;
        } else {
            this.targetYawHead = DragonBodyControl.smooth(this.targetYawHead, this.entity.f_20885_, this.headLagSpeed);
            this.entity.f_20883_ = DragonBodyControl.approach(this.targetYawHead, this.entity.f_20883_, this.bodyMaxDelta, this.bodyLagStillSpeed);
        }
        this.clampHeadBodyDifference();
    }

    private void clampHeadBodyDifference() {
        float diff = Mth.m_14177_((float)(this.entity.f_20885_ - this.entity.f_20883_));
        float clamped = Mth.m_14036_((float)diff, (float)(-this.maxHeadBodyDiff), (float)this.maxHeadBodyDiff);
        this.entity.f_20885_ = this.entity.f_20883_ + clamped;
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double sum = 0.0;
        int count = arr.length / 2;
        for (int i = 0; i < count; ++i) {
            sum += arr[i + start];
        }
        return sum / (double)count;
    }

    private static float smooth(float current, float target, float speed) {
        return current + (target - current) * speed;
    }

    private static float approach(float target, float current, float maxDelta, float speed) {
        float delta = Mth.m_14177_((float)(target - current));
        delta = Mth.m_14036_((float)delta, (float)(-maxDelta), (float)maxDelta);
        return current + delta * speed;
    }
}

