/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.behavior;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DragonSleepBehavior {
    private final DragonEntity dragon;
    private int sleepActionCooldown = 0;
    private SleepPhase currentPhase = SleepPhase.IDLE;

    public DragonSleepBehavior(DragonEntity dragon) {
        this.dragon = dragon;
    }

    public void tick() {
        boolean shouldWake;
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.sleepActionCooldown > 0) {
            --this.sleepActionCooldown;
        }
        if (!this.dragon.m_21824_() && this.dragon.m_21827_() && !this.dragon.m_5803_() && !this.dragon.isSleepTransitioning()) {
            this.dragon.m_21839_(false);
            if (this.dragon.getCommand() == 1) {
                this.dragon.setCommand(0);
            }
            if (this.dragon.sitProgress > 0.0f) {
                this.dragon.sitProgress = 0.0f;
                this.dragon.prevSitProgress = 0.0f;
                this.dragon.m_20088_().m_135381_(DragonEntity.DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
        }
        SleepPhase oldPhase = this.currentPhase;
        this.updatePhase();
        if (this.dragon.m_21824_()) {
            this.handleTamedDragonSleep();
        }
        if (this.currentPhase == SleepPhase.IDLE && this.shouldAttemptSleep()) {
            if (this.tryStartSleeping()) {
                this.currentPhase = SleepPhase.ENTERING;
            }
        } else if (this.currentPhase == SleepPhase.SLEEPING && (shouldWake = this.shouldWakeUp()) && this.tryWakeUp()) {
            this.currentPhase = SleepPhase.EXITING;
        }
    }

    private void updatePhase() {
        if (this.dragon.isSleepTransitioning()) {
            if (this.dragon.m_5803_()) {
                if (this.currentPhase != SleepPhase.EXITING) {
                    this.currentPhase = SleepPhase.EXITING;
                }
            } else if (this.currentPhase != SleepPhase.ENTERING) {
                this.currentPhase = SleepPhase.ENTERING;
            }
        } else if (this.dragon.m_5803_()) {
            this.currentPhase = SleepPhase.SLEEPING;
        } else if (this.currentPhase != SleepPhase.IDLE) {
            this.currentPhase = SleepPhase.IDLE;
            this.delaySleep(40, 60);
        }
    }

    private void handleTamedDragonSleep() {
        if (this.dragon.m_21827_()) {
            if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
                this.tryWakeUp();
            }
            return;
        }
        if ((this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) && !this.isOwnerSleepingNearby()) {
            this.sleepActionCooldown = 0;
            this.tryWakeUp();
        }
    }

    private boolean shouldAttemptSleep() {
        if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return false;
        }
        if (this.sleepActionCooldown > 0) {
            return false;
        }
        if (this.dragon.m_21827_()) {
            return false;
        }
        if (!this.canSleepInCurrentEnvironment()) {
            return false;
        }
        DragonSleepPreferences prefs = this.dragon.getSleepPreferences();
        if (!prefs.canSleepDuringConditions(this.dragon.m_9236_())) {
            return false;
        }
        if (this.dragon.m_21824_()) {
            return this.isOwnerSleepingNearby();
        }
        return true;
    }

    private boolean shouldWakeUp() {
        if (!this.dragon.m_5803_()) {
            return false;
        }
        if (!this.canSleepInCurrentEnvironment()) {
            return true;
        }
        DragonSleepPreferences prefs = this.dragon.getSleepPreferences();
        if (!prefs.canSleepDuringConditions(this.dragon.m_9236_())) {
            return true;
        }
        return this.dragon.m_21824_() && !this.dragon.m_21827_() && !this.isOwnerSleepingNearby();
    }

    private String getWakeReason() {
        if (!this.dragon.m_5803_()) {
            return "not sleeping";
        }
        if (!this.canSleepInCurrentEnvironment()) {
            return "environment unsafe: " + this.getEnvironmentFailure();
        }
        DragonSleepPreferences prefs = this.dragon.getSleepPreferences();
        if (!prefs.canSleepDuringConditions(this.dragon.m_9236_())) {
            boolean isDay = this.dragon.m_9236_().m_46461_();
            if (this.dragon.m_9236_().m_46470_()) {
                return "thunderstorm";
            }
            if (isDay && !prefs.canSleepDuringDay()) {
                return "daytime (nocturnal)";
            }
            if (!isDay && !prefs.canSleepAtNight()) {
                return "nighttime (diurnal)";
            }
            return "time/weather conditions";
        }
        if (this.dragon.m_21824_() && !this.dragon.m_21827_() && !this.isOwnerSleepingNearby()) {
            return "owner not sleeping";
        }
        return "unknown";
    }

    private String getEnvironmentFailure() {
        if (this.dragon.isDying() || !this.dragon.m_6084_() || this.dragon.m_21224_()) {
            return "dying/dead";
        }
        if (this.dragon.m_20160_()) {
            return "being ridden";
        }
        if (this.dragon.m_5448_() != null) {
            return "has target";
        }
        if (this.dragon.m_20072_() || this.dragon.m_20077_()) {
            return "in water/lava";
        }
        if (!this.dragon.m_20096_()) {
            return "not on ground";
        }
        DragonEntity dragonEntity = this.dragon;
        if (dragonEntity instanceof DragonFlightCapable) {
            DragonFlightCapable flyer = (DragonFlightCapable)((Object)dragonEntity);
            if (flyer.isFlying()) {
                return "flying";
            }
            if (flyer.isHovering()) {
                return "hovering";
            }
            if (flyer.isTakeoff()) {
                return "taking off";
            }
            if (flyer.isLanding()) {
                return "landing";
            }
        }
        if (this.dragon.isSleepSuppressed()) {
            return "sleep suppressed";
        }
        return "unknown";
    }

    private boolean canSleepInCurrentEnvironment() {
        boolean alreadySleepingOrTransitioning;
        if (this.dragon.isDying() || !this.dragon.m_6084_() || this.dragon.m_21224_()) {
            return false;
        }
        if (this.dragon.m_20160_()) {
            return false;
        }
        if (this.dragon.m_5448_() != null) {
            return false;
        }
        if (this.dragon.m_20072_() || this.dragon.m_20077_()) {
            return false;
        }
        boolean bl = alreadySleepingOrTransitioning = this.dragon.m_5803_() || this.dragon.isSleepTransitioning();
        if (!alreadySleepingOrTransitioning) {
            DragonFlightCapable flyer;
            if (!this.dragon.m_20096_()) {
                return false;
            }
            DragonEntity dragonEntity = this.dragon;
            if (dragonEntity instanceof DragonFlightCapable && ((flyer = (DragonFlightCapable)((Object)dragonEntity)).isFlying() || flyer.isHovering() || flyer.isTakeoff() || flyer.isLanding())) {
                return false;
            }
        }
        return !this.dragon.isSleepSuppressed();
    }

    public boolean tryStartSleeping() {
        if (this.sleepActionCooldown > 0) {
            return false;
        }
        if (!this.canSleepInCurrentEnvironment()) {
            return false;
        }
        if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return false;
        }
        this.dragon.startSleepEnter();
        this.delaySleep(20, 40);
        return true;
    }

    public boolean tryWakeUp() {
        if (this.sleepActionCooldown > 0) {
            return false;
        }
        if (!this.dragon.m_5803_() && !this.dragon.isSleepTransitioning()) {
            return false;
        }
        this.dragon.startSleepExit();
        this.delaySleep(20, 40);
        return true;
    }

    public void forceWakeUp() {
        this.sleepActionCooldown = 0;
        if (this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            this.dragon.wakeUpImmediately();
        }
        this.delaySleep(90, 120);
    }

    public void delaySleep(int min, int max) {
        this.sleepActionCooldown = min + this.dragon.m_217043_().m_188503_(max - min + 1);
    }

    private boolean isOwnerSleepingNearby() {
        LivingEntity owner = this.dragon.m_269323_();
        if (!(owner instanceof Player)) {
            return false;
        }
        Player player = (Player)owner;
        if (!player.m_5803_() || !player.m_6084_()) {
            return false;
        }
        return player.m_9236_() == this.dragon.m_9236_() && this.dragon.m_20280_((Entity)player) <= 144.0;
    }

    public int getSleepCooldown() {
        return this.sleepActionCooldown;
    }

    private static enum SleepPhase {
        IDLE,
        ENTERING,
        SLEEPING,
        EXITING;

    }

    public record DragonSleepPreferences(boolean canSleepAtNight, boolean canSleepDuringDay, boolean avoidsThunderstorms) {
        public boolean canSleepDuringConditions(Level level) {
            if (this.avoidsThunderstorms && level.m_46470_()) {
                return false;
            }
            boolean isDay = level.m_46461_();
            if (isDay && !this.canSleepDuringDay) {
                return false;
            }
            return isDay || this.canSleepAtNight;
        }

        public static DragonSleepPreferences DIURNAL() {
            return new DragonSleepPreferences(false, true, true);
        }

        public static DragonSleepPreferences NOCTURNAL() {
            return new DragonSleepPreferences(true, false, true);
        }

        public static DragonSleepPreferences FLEXIBLE() {
            return new DragonSleepPreferences(true, true, true);
        }
    }
}

