/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import com.leon.saintsdragons.common.network.DragonAnimTickets;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonRideInput;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.RideableDragon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RideableDragonBase
extends DragonEntity
implements RideableDragon,
FlyingAnimal {
    private static final EntityDataAccessor<Integer> DATA_MELEE_MODE = SynchedEntityData.m_135353_(RideableDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_RIDER_LOCKED = SynchedEntityData.m_135353_(RideableDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int riderControlLockTicks = 0;

    protected RideableDragonBase(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MELEE_MODE, (Object)0);
        this.f_19804_.m_135372_(DATA_RIDER_LOCKED, (Object)false);
        this.defineRideableDragonData();
    }

    protected abstract void defineRideableDragonData();

    public boolean canBeControlledBy(Player player) {
        if (player == null) {
            return false;
        }
        if (this.m_21824_()) {
            return this.m_21830_((LivingEntity)player);
        }
        return player.m_7500_() || player.m_5833_();
    }

    public void handleRiderNetworkInput(ServerPlayer player, MessageDragonRideInput msg) {
        boolean locked = this.isRiderInputLocked((Player)player);
        this.applyRiderVerticalInput((Player)player, msg.goingUp(), msg.goingDown(), locked);
        this.handleRiderAction(player, msg.action(), msg.abilityName(), locked);
        this.applyRiderMovementInput((Player)player, msg.forward(), msg.strafe(), msg.yaw(), locked);
    }

    protected boolean isRiderInputLocked(Player player) {
        return false;
    }

    protected void applyRiderVerticalInput(Player player, boolean goingUp, boolean goingDown, boolean locked) {
        if (locked) {
            this.setGoingUp(false);
            this.setGoingDown(false);
            return;
        }
        this.setGoingUp(goingUp);
        this.setGoingDown(goingDown);
    }

    protected float applyInputDeadzone(float value) {
        return Math.abs(value) > 0.02f ? value : 0.0f;
    }

    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float clampedForward = locked ? 0.0f : this.applyInputDeadzone(forward);
        float clampedStrafe = locked ? 0.0f : this.applyInputDeadzone(strafe);
        this.setLastRiderForward(clampedForward);
        this.setLastRiderStrafe(clampedStrafe);
    }

    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.onRiderTakeoffRequest((Player)player);
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.onRiderAccelerationStart((Player)player);
                break;
            }
            case STOP_ACCELERATE: {
                this.onRiderAccelerationStop((Player)player);
                break;
            }
            case ABILITY_USE: {
                if (locked) break;
                this.onRiderAbilityUse((Player)player, abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (locked) break;
                this.onRiderAbilityStop((Player)player, abilityName);
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.onRiderToggleMelee((Player)player);
                break;
            }
            case DOUBLE_TAP_A: {
                if (locked) break;
                this.onRiderDodge((Player)player, true);
                break;
            }
            case DOUBLE_TAP_D: {
                if (locked) break;
                this.onRiderDodge((Player)player, false);
                break;
            }
        }
    }

    protected void onRiderDodge(Player player, boolean isLeft) {
    }

    protected void onRiderBulldoze(Player player) {
    }

    protected void onRiderToggleMelee(Player player) {
        if (!this.hasSecondaryMelee()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.no_secondary_melee"), true);
            }
            return;
        }
        this.toggleMeleeMode();
    }

    public boolean hasSecondaryMelee() {
        return true;
    }

    public boolean canTakeoff() {
        return true;
    }

    protected void onRiderTakeoffRequest(Player player) {
    }

    protected void onRiderAccelerationStart(Player player) {
        this.setAccelerating(true);
    }

    protected void onRiderAccelerationStop(Player player) {
        this.setAccelerating(false);
    }

    protected void onRiderAbilityUse(Player player, String abilityName) {
    }

    protected void onRiderAbilityStop(Player player, String abilityName) {
    }

    protected float getRiderLockYawBlend() {
        return 0.18f;
    }

    protected float getRiderLockPitchBlend() {
        return 0.18f;
    }

    protected float getRiderLockPitchMin() {
        return -45.0f;
    }

    protected float getRiderLockPitchMax() {
        return 45.0f;
    }

    @Nullable
    public RiderAbilityBinding getPrimaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getSecondaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getTertiaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getAttackRiderAbility() {
        return null;
    }

    public int getMeleeMode() {
        return (Integer)this.f_19804_.m_135370_(DATA_MELEE_MODE);
    }

    public void setMeleeMode(int mode) {
        this.f_19804_.m_135381_(DATA_MELEE_MODE, (Object)Mth.m_14045_((int)mode, (int)0, (int)1));
    }

    public void toggleMeleeMode() {
        this.setMeleeMode(this.getMeleeMode() == 0 ? 1 : 0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("MeleeMode", this.getMeleeMode());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("MeleeMode")) {
            this.setMeleeMode(tag.m_128451_("MeleeMode"));
        }
    }

    public byte buildClientControlState(boolean ascendDown, boolean descendDown, boolean attackDown, boolean primaryDown, boolean secondaryDown, boolean sneakDown) {
        return -1;
    }

    protected abstract EntityDataAccessor<Float> getRiderForwardAccessor();

    protected abstract EntityDataAccessor<Float> getRiderStrafeAccessor();

    protected abstract EntityDataAccessor<Integer> getGroundMoveStateAccessor();

    protected abstract EntityDataAccessor<Integer> getFlightModeAccessor();

    protected abstract EntityDataAccessor<Boolean> getGoingUpAccessor();

    protected abstract EntityDataAccessor<Boolean> getGoingDownAccessor();

    protected abstract EntityDataAccessor<Boolean> getAcceleratingAccessor();

    @Override
    public void setLastRiderForward(float forward) {
        this.f_19804_.m_135381_(this.getRiderForwardAccessor(), (Object)Float.valueOf(forward));
    }

    @Override
    public void setLastRiderStrafe(float strafe) {
        this.f_19804_.m_135381_(this.getRiderStrafeAccessor(), (Object)Float.valueOf(strafe));
    }

    @Override
    public int getGroundMoveState() {
        return (Integer)this.f_19804_.m_135370_(this.getGroundMoveStateAccessor());
    }

    @Override
    public int getSyncedFlightMode() {
        return (Integer)this.f_19804_.m_135370_(this.getFlightModeAccessor());
    }

    @Override
    public int getEffectiveGroundState() {
        Integer state = (Integer)this.getAnimData(DragonAnimTickets.GROUND_STATE);
        if (state != null) {
            return state;
        }
        return (Integer)this.f_19804_.m_135370_(this.getGroundMoveStateAccessor());
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.f_19804_.m_135370_(this.getGoingUpAccessor());
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.f_19804_.m_135381_(this.getGoingUpAccessor(), (Object)goingUp);
    }

    @Override
    public boolean isGoingDown() {
        return (Boolean)this.f_19804_.m_135370_(this.getGoingDownAccessor());
    }

    @Override
    public void setGoingDown(boolean goingDown) {
        this.f_19804_.m_135381_(this.getGoingDownAccessor(), (Object)goingDown);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.f_19804_.m_135370_(this.getAcceleratingAccessor());
    }

    @Override
    public void setAccelerating(boolean accelerating) {
        this.f_19804_.m_135381_(this.getAcceleratingAccessor(), (Object)accelerating);
    }

    protected void copyRiderLook(Player player) {
        if (player == null) {
            return;
        }
        float currentYaw = this.m_146908_();
        float targetYaw = player.m_146908_();
        float yawDelta = Mth.m_14177_((float)(targetYaw - currentYaw));
        float yawBlend = this.getRiderLockYawBlend();
        float blendedYaw = currentYaw + yawDelta * yawBlend;
        this.m_146922_(blendedYaw);
        this.f_20884_ = this.f_20883_;
        this.f_20883_ = blendedYaw;
        this.f_20886_ = this.f_20885_;
        this.m_5616_(blendedYaw);
        float targetPitch = Mth.m_14036_((float)player.m_146909_(), (float)this.getRiderLockPitchMin(), (float)this.getRiderLockPitchMax());
        float blendedPitch = Mth.m_14179_((float)this.getRiderLockPitchBlend(), (float)this.m_146909_(), (float)targetPitch);
        this.f_19860_ = this.m_146909_();
        this.m_146926_(blendedPitch);
    }

    @Override
    public void syncAnimState(int groundState, int flightMode) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.setAnimData(DragonAnimTickets.GROUND_STATE, groundState);
        this.setAnimData(DragonAnimTickets.FLIGHT_MODE, flightMode);
    }

    @Override
    public void initializeAnimationState() {
        if (!this.m_9236_().f_46443_) {
            int initialGroundState = 0;
            int initialFlightMode = -1;
            if (!(this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
                double velSqr = this.m_20184_().m_165925_();
                if (velSqr > 0.02) {
                    initialGroundState = 2;
                } else if (velSqr > 8.0E-4) {
                    initialGroundState = 1;
                }
            } else if (this.m_29443_()) {
                initialFlightMode = this.getFlightMode();
            }
            this.f_19804_.m_135381_(this.getGroundMoveStateAccessor(), (Object)initialGroundState);
            this.f_19804_.m_135381_(this.getFlightModeAccessor(), (Object)initialFlightMode);
        }
    }

    @Override
    public void resetAnimationState() {
        if (!this.m_9236_().f_46443_) {
            int currentGroundState = 0;
            if (!(this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
                double velSqr = this.m_20184_().m_165925_();
                if (velSqr > 0.02) {
                    currentGroundState = 2;
                } else if (velSqr > 8.0E-4) {
                    currentGroundState = 1;
                }
            }
            int currentFlightMode = this.getFlightMode();
            this.f_19804_.m_135381_(this.getGroundMoveStateAccessor(), (Object)currentGroundState);
            this.f_19804_.m_135381_(this.getFlightModeAccessor(), (Object)currentFlightMode);
            this.syncAnimState(currentGroundState, currentFlightMode);
        }
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@NotNull Player player, @NotNull Vec3 deltaIn) {
        Vec3 input = super.m_274312_(player, deltaIn);
        if (!this.m_9236_().f_46443_ && !this.m_29443_()) {
            float fwd = (float)Mth.m_14008_((double)input.f_82481_, (double)-1.0, (double)1.0);
            float str = (float)Mth.m_14008_((double)input.f_82479_, (double)-1.0, (double)1.0);
            this.setLastRiderForward(Math.abs(fwd) > 0.02f ? fwd : 0.0f);
            this.setLastRiderStrafe(Math.abs(str) > 0.02f ? str : 0.0f);
        }
        return input;
    }

    @Override
    public void m_20351_(@NotNull Entity passenger) {
        if (passenger == this.m_6688_()) {
            this.clearRiderControlLock();
        }
        super.m_20351_(passenger);
        if (!this.m_9236_().f_46443_) {
            this.setAccelerating(false);
            this.setRunning(false);
            this.setLastRiderForward(0.0f);
            this.setLastRiderStrafe(0.0f);
            this.f_19804_.m_135381_(this.getGroundMoveStateAccessor(), (Object)0);
            this.syncAnimState(0, this.getSyncedFlightMode());
        }
    }

    @Override
    public void tickAnimationStates() {
        boolean flightModeChanged;
        int moveState = 0;
        if (!(this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
            if (this.m_6688_() != null) {
                float fwd = ((Float)this.f_19804_.m_135370_(this.getRiderForwardAccessor())).floatValue();
                float str = ((Float)this.f_19804_.m_135370_(this.getRiderStrafeAccessor())).floatValue();
                if (Math.abs(fwd) + Math.abs(str) > 0.05f) {
                    moveState = this.isAccelerating() ? 2 : 1;
                } else {
                    double speedSqr = this.m_20184_().m_165925_();
                    if (speedSqr > 0.08) {
                        moveState = 2;
                    } else if (speedSqr > 0.005) {
                        moveState = 1;
                    }
                }
            } else {
                double velSqr = this.m_20184_().m_165925_();
                if (velSqr > 0.02) {
                    moveState = 2;
                } else if (velSqr > 8.0E-4) {
                    moveState = 1;
                }
            }
        }
        int flightMode = this.getFlightMode();
        boolean groundStateChanged = (Integer)this.f_19804_.m_135370_(this.getGroundMoveStateAccessor()) != moveState;
        boolean bl = flightModeChanged = (Integer)this.f_19804_.m_135370_(this.getFlightModeAccessor()) != flightMode;
        if (groundStateChanged) {
            this.f_19804_.m_135381_(this.getGroundMoveStateAccessor(), (Object)moveState);
        }
        if (flightModeChanged) {
            this.f_19804_.m_135381_(this.getFlightModeAccessor(), (Object)flightMode);
        }
        if (groundStateChanged || flightModeChanged) {
            this.syncAnimState(moveState, flightMode);
        }
        if (this.isRunning() && this.m_20184_().m_165925_() < 0.01) {
            this.setRunning(false);
        }
    }

    protected abstract int getFlightMode();

    @Override
    public final boolean m_29443_() {
        return this.isDragonFlying();
    }

    protected abstract boolean isDragonFlying();

    public abstract boolean isTakeoff();

    public abstract boolean isLanding();

    public abstract boolean isHovering();

    @Override
    public abstract boolean isRunning();

    public abstract void setRunning(boolean var1);

    public void forceSitProgress(float value) {
        float clamped;
        this.sitProgress = clamped = Mth.m_14036_((float)value, (float)0.0f, (float)this.maxSitTicks());
        this.prevSitProgress = clamped;
        this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(clamped));
    }

    protected void saveRideableData(CompoundTag tag) {
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128379_("Takeoff", this.isTakeoff());
        tag.m_128379_("Hovering", this.isHovering());
        tag.m_128379_("Landing", this.isLanding());
        tag.m_128379_("Running", this.isRunning());
        tag.m_128379_("Accelerating", ((Boolean)this.f_19804_.m_135370_(this.getAcceleratingAccessor())).booleanValue());
        tag.m_128379_("GoingUp", this.isGoingUp());
        tag.m_128379_("GoingDown", this.isGoingDown());
        tag.m_128405_("GroundMoveState", ((Integer)this.f_19804_.m_135370_(this.getGroundMoveStateAccessor())).intValue());
        tag.m_128405_("FlightMode", ((Integer)this.f_19804_.m_135370_(this.getFlightModeAccessor())).intValue());
        tag.m_128350_("RiderForward", ((Float)this.f_19804_.m_135370_(this.getRiderForwardAccessor())).floatValue());
        tag.m_128350_("RiderStrafe", ((Float)this.f_19804_.m_135370_(this.getRiderStrafeAccessor())).floatValue());
        tag.m_128379_("IsSitting", this.m_21827_());
        tag.m_128350_("SitProgress", this.sitProgress);
    }

    protected void loadRideableData(CompoundTag tag) {
        boolean savedFlying = tag.m_128471_("Flying");
        boolean savedTakeoff = tag.m_128471_("Takeoff");
        boolean savedHovering = tag.m_128471_("Hovering");
        boolean savedLanding = tag.m_128471_("Landing");
        this.applyLoadedFlightState(savedFlying, savedTakeoff, savedHovering, savedLanding);
        this.setRunning(tag.m_128471_("Running"));
        this.setAccelerating(tag.m_128471_("Accelerating"));
        this.setGoingUp(savedFlying && tag.m_128471_("GoingUp"));
        this.setGoingDown(savedFlying && tag.m_128471_("GoingDown"));
        int groundState = tag.m_128441_("GroundMoveState") ? tag.m_128451_("GroundMoveState") : 0;
        this.f_19804_.m_135381_(this.getGroundMoveStateAccessor(), (Object)Mth.m_14045_((int)groundState, (int)0, (int)2));
        int flightMode = tag.m_128441_("FlightMode") ? tag.m_128451_("FlightMode") : -1;
        this.f_19804_.m_135381_(this.getFlightModeAccessor(), (Object)(savedFlying ? Mth.m_14045_((int)flightMode, (int)-1, (int)3) : -1));
        float riderForward = tag.m_128441_("RiderForward") ? tag.m_128457_("RiderForward") : 0.0f;
        float riderStrafe = tag.m_128441_("RiderStrafe") ? tag.m_128457_("RiderStrafe") : 0.0f;
        this.f_19804_.m_135381_(this.getRiderForwardAccessor(), (Object)Float.valueOf(riderForward));
        this.f_19804_.m_135381_(this.getRiderStrafeAccessor(), (Object)Float.valueOf(riderStrafe));
        boolean savedSitting = tag.m_128471_("IsSitting");
        this.m_21839_(savedSitting);
        float savedSitProgress = tag.m_128441_("SitProgress") ? tag.m_128457_("SitProgress") : (savedSitting ? this.maxSitTicks() : 0.0f);
        this.prevSitProgress = this.sitProgress = Mth.m_14036_((float)savedSitProgress, (float)0.0f, (float)this.maxSitTicks());
        this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        if (!this.m_9236_().f_46443_) {
            this.syncAnimState((Integer)this.f_19804_.m_135370_(this.getGroundMoveStateAccessor()), (Integer)this.f_19804_.m_135370_(this.getFlightModeAccessor()));
        }
    }

    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
    }

    public void lockRiderControls(int ticks) {
        this.riderControlLockTicks = Math.max(this.riderControlLockTicks, Math.max(0, ticks));
        this.f_19804_.m_135381_(DATA_RIDER_LOCKED, (Object)true);
    }

    @Override
    public boolean areRiderControlsLocked() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_RIDER_LOCKED) : this.riderControlLockTicks > 0;
    }

    public void clearRiderControlLock() {
        if (this.riderControlLockTicks > 0 || ((Boolean)this.f_19804_.m_135370_(DATA_RIDER_LOCKED)).booleanValue()) {
            this.riderControlLockTicks = 0;
            this.f_19804_.m_135381_(DATA_RIDER_LOCKED, (Object)false);
        }
    }

    protected void tickRiderControlLock() {
        if (!this.m_9236_().f_46443_ && this.riderControlLockTicks > 0) {
            --this.riderControlLockTicks;
            if (this.riderControlLockTicks == 0) {
                this.f_19804_.m_135381_(DATA_RIDER_LOCKED, (Object)false);
            }
        }
    }

    public record RiderAbilityBinding(String abilityId, Activation activation) {

        public static enum Activation {
            PRESS,
            HOLD;

        }
    }
}

