/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class RaevyxSummonStormAbility
extends DragonAbility<Raevyx> {
    private static final int SUPERCHARGE_TICKS = 1200;
    private static final int COOLDOWN_TICKS = 4800;
    private static final int GROUND_START_TICKS = 38;
    private static final int GROUND_LOOP_TICKS = 114;
    private static final int GROUND_END_TICKS = 38;
    private static final int GROUND_TOTAL_SEQUENCE_TICKS = 190;
    private static final int AIR_START_TICKS = 38;
    private static final int AIR_LOOP_TICKS = 114;
    private static final int AIR_END_TICKS = 38;
    private static final int AIR_TOTAL_SEQUENCE_TICKS = 190;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 190), new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 20)};
    private boolean isGroundCast;
    private boolean loopAnimPlayed;
    private boolean endAnimPlayed;
    private boolean screenShakeActive;
    private int activeStartupDuration = 190;

    public RaevyxSummonStormAbility(DragonAbilityType<Raevyx, RaevyxSummonStormAbility> type, Raevyx user) {
        super(type, user, TRACK, 4800);
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section;
        if (this.screenShakeActive && !((Raevyx)this.getUser()).m_9236_().f_46443_) {
            ((Raevyx)this.getUser()).triggerScreenShake(1.5f);
        }
        if ((section = this.getCurrentSection()) == null || section.sectionType != DragonAbilitySection.AbilitySectionType.STARTUP) {
            return;
        }
        int ticks = this.getTicksInSection();
        int startTicks = this.getCurrentStartTicks();
        int loopEndTicks = startTicks + this.getCurrentLoopTicks();
        if (!this.loopAnimPlayed && ticks >= startTicks) {
            String loopTrigger = this.isGroundCast ? "summon_storm_ground" : "summon_storm_air";
            ((Raevyx)this.getUser()).triggerAnim("action", loopTrigger);
            this.loopAnimPlayed = true;
            this.screenShakeActive = true;
        }
        if (!this.endAnimPlayed && ticks >= loopEndTicks) {
            String endTrigger = this.isGroundCast ? "summon_storm_ground_end" : "summon_storm_air_end";
            ((Raevyx)this.getUser()).triggerAnim("action", endTrigger);
            this.endAnimPlayed = true;
            this.screenShakeActive = false;
        }
        if (ticks >= this.activeStartupDuration) {
            this.nextSection();
        }
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.isGroundCast = !((Raevyx)this.getUser()).m_29443_();
            this.activeStartupDuration = this.getCurrentTotalTicks();
            ((Raevyx)this.getUser()).startTemporaryInvuln(this.activeStartupDuration);
            ((Raevyx)this.getUser()).lockRiderControls(this.activeStartupDuration);
            ((Raevyx)this.getUser()).lockTakeoff(this.activeStartupDuration);
            String startTrigger = this.isGroundCast ? "summon_storm_ground_start" : "summon_storm_air_start";
            ((Raevyx)this.getUser()).triggerAnim("action", startTrigger);
            this.loopAnimPlayed = false;
            this.endAnimPlayed = false;
            this.screenShakeActive = false;
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.getLevel().f_46443_) {
            ((Raevyx)this.getUser()).startSupercharge(1200);
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                LevelData ld = server.m_6106_();
                if (ld instanceof ServerLevelData) {
                    ServerLevelData data = (ServerLevelData)ld;
                    if (!data.m_6533_()) {
                        data.m_5565_(true);
                    }
                    data.m_6399_(Math.max(data.m_6531_(), 1200));
                    if (!data.m_6534_()) {
                        data.m_5557_(true);
                    }
                    data.m_6398_(Math.max(data.m_6558_(), 1200));
                    server.m_8606_(0, 1200, true, true);
                }
                server.m_5594_(null, ((Raevyx)this.getUser()).m_20183_(), SoundEvents.f_12090_, SoundSource.WEATHER, 6.0f, 0.9f);
            }
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.releaseLocks();
        }
    }

    @Override
    public void end() {
        this.releaseLocks();
        ((Raevyx)this.getUser()).clearTemporaryInvuln();
        super.end();
    }

    private void releaseLocks() {
        ((Raevyx)this.getUser()).clearTakeoffLock();
        ((Raevyx)this.getUser()).clearRiderControlLock();
        this.screenShakeActive = false;
    }

    private int getCurrentStartTicks() {
        return this.isGroundCast ? 38 : 38;
    }

    private int getCurrentLoopTicks() {
        return this.isGroundCast ? 114 : 114;
    }

    private int getCurrentEndTicks() {
        return this.isGroundCast ? 38 : 38;
    }

    private int getCurrentTotalTicks() {
        return this.getCurrentStartTicks() + this.getCurrentLoopTicks() + this.getCurrentEndTicks();
    }
}

