/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RaevyxRoarAbility
extends DragonAbility<Raevyx> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 28), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 12)};
    private boolean roarQueued = false;
    private static final int ROAR_DELAY_TICKS = 3;
    private static final int ROAR_TOTAL_TICKS = 69;
    private int strikesLeft = 0;
    private int strikeCooldown = 0;
    private List<Integer> targetIds = Collections.emptyList();
    private int targetCursor = 0;

    public RaevyxRoarAbility(DragonAbilityType<Raevyx, RaevyxRoarAbility> type, Raevyx user) {
        super(type, user, TRACK, 40);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Raevyx)this.getUser()).triggerAnim("action", "roar");
            this.roarQueued = true;
            this.selectLightningTargets();
            int count = this.targetIds.size();
            boolean isSupercharged = ((Raevyx)this.getUser()).isSupercharged();
            this.strikesLeft = count > 1 ? Math.min(6, Math.max(3, count * 2)) : 2 + ((Raevyx)this.getUser()).m_217043_().m_188503_(2);
            if (isSupercharged) {
                this.strikesLeft *= 2;
            }
            this.strikeCooldown = 0;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.roarQueued && this.getTicksInSection() >= 3 && !((Raevyx)this.getUser()).m_9236_().f_46443_) {
            Raevyx dragon = (Raevyx)this.getUser();
            float pitch = 0.9f + dragon.m_217043_().m_188501_() * 0.15f;
            dragon.m_5496_(ModSounds.RAEVYX_ROAR.get(), 1.4f, pitch);
            this.roarQueued = false;
        }
        if (!((Raevyx)this.getUser()).m_9236_().f_46443_) {
            ((Raevyx)this.getUser()).triggerScreenShake(1.0f);
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && this.strikesLeft > 0 && !((Raevyx)this.getUser()).m_9236_().f_46443_) {
            if (this.strikeCooldown > 0) {
                --this.strikeCooldown;
            } else {
                this.spawnLightningStrike();
                --this.strikesLeft;
                this.strikeCooldown = 6 + ((Raevyx)this.getUser()).m_217043_().m_188503_(6);
            }
        }
    }

    private void selectLightningTargets() {
        Raevyx dragon = (Raevyx)this.getUser();
        LivingEntity rider = dragon.m_6688_();
        LinkedHashSet<Integer> ids = new LinkedHashSet<Integer>();
        Level level = dragon.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            AABB box = dragon.m_20191_().m_82400_(24.0);
            List chasers = server.m_6443_(Mob.class, box, m -> {
                LivingEntity t = m.m_5448_();
                return m.m_6084_() && (t == dragon || rider != null && t == rider);
            });
            chasers.sort(Comparator.comparingDouble(m -> m.m_20280_((Entity)dragon)));
            for (Mob m2 : chasers) {
                ids.add(m2.m_19879_());
            }
        }
        if (dragon.m_9236_() instanceof ServerLevel) {
            List<LivingEntity> recent = dragon.getRecentAggro();
            recent.sort(Comparator.comparingDouble(e -> e.m_20280_((Entity)dragon)));
            for (LivingEntity le : recent) {
                if (le == null || !le.m_6084_()) continue;
                ids.add(le.m_19879_());
            }
            LivingEntity ct = dragon.m_5448_();
            if (ct != null && ct.m_6084_()) {
                ids.add(ct.m_19879_());
            }
        }
        this.targetIds = new ArrayList<Integer>();
        int added = 0;
        for (Integer id : ids) {
            this.targetIds.add(id);
            if (++added < 6) continue;
            break;
        }
        this.targetCursor = 0;
    }

    private void spawnLightningStrike() {
        Raevyx dragon = (Raevyx)this.getUser();
        Level level = dragon.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        LivingEntity target = this.nextValidTarget(server);
        if (target == null) {
            return;
        }
        double ox = (dragon.m_217043_().m_188500_() - 0.5) * 2.0;
        double oz = (dragon.m_217043_().m_188500_() - 0.5) * 2.0;
        double x = target.m_20185_() + ox;
        double z = target.m_20189_() + oz;
        double y = target.m_20186_();
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)server);
        if (bolt != null) {
            bolt.m_6027_(x, y, z);
            LivingEntity owner = dragon.m_269323_();
            if (owner instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)owner;
                bolt.m_20879_(sp);
            }
            server.m_7967_((Entity)bolt);
        }
        this.spawnElectrocuteArcs(server, target);
        RaevyxRoarAbility.applyStun(target);
    }

    private void spawnElectrocuteArcs(ServerLevel server, LivingEntity target) {
        Raevyx dragon = (Raevyx)this.getUser();
        Random rnd = new Random(dragon.m_217043_().m_188505_());
        boolean female = dragon.isFemale();
        Vec3 center = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        double radius = Math.max(target.m_20191_().m_82362_(), target.m_20191_().m_82385_()) * 0.6;
        int count = 6 + dragon.m_217043_().m_188503_(5);
        for (int i = 0; i < count; ++i) {
            Vec3 a = RaevyxRoarAbility.randomUnit(rnd).m_82490_(radius * (0.4 + rnd.nextDouble() * 0.6));
            Vec3 b = RaevyxRoarAbility.randomUnit(rnd).m_82490_(radius * (0.4 + rnd.nextDouble() * 0.6));
            Vec3 from = center.m_82549_(a);
            Vec3 to = center.m_82549_(b);
            this.spawnRoarArc(server, from, to, female);
        }
    }

    private void spawnRoarArc(ServerLevel server, Vec3 from, Vec3 to, boolean female) {
        Vec3 delta = to.m_82546_(from);
        int steps = Math.max(2, (int)(delta.m_82553_() * 4.0));
        Vec3 step = delta.m_82490_(1.0 / (double)steps);
        Vec3 pos = from;
        Vec3 dir = step.m_82541_();
        float size = 0.8f;
        for (int i = 0; i <= steps; ++i) {
            server.m_8767_((ParticleOptions)new RaevyxLightningStormData(size, female), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, dir.f_82479_, dir.f_82480_, dir.f_82481_, 0.0);
            pos = pos.m_82549_(step);
        }
    }

    private static Vec3 randomUnit(Random rnd) {
        double u = rnd.nextDouble();
        double v = rnd.nextDouble();
        double theta = Math.PI * 2 * u;
        double z = 2.0 * v - 1.0;
        double r = Math.sqrt(1.0 - z * z);
        return new Vec3(r * Math.cos(theta), z, r * Math.sin(theta));
    }

    private static void applyStun(LivingEntity target) {
        int durationTicks = 30;
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 5, false, true));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 30, 0, false, true));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, Math.min(30, 20), 0, false, true));
    }

    private LivingEntity nextValidTarget(ServerLevel server) {
        int n = this.targetIds != null ? this.targetIds.size() : 0;
        for (int i = 0; i < n; ++i) {
            LivingEntity le;
            int idx = (this.targetCursor + i) % n;
            Entity e = server.m_6815_(this.targetIds.get(idx).intValue());
            if (!(e instanceof LivingEntity) || !(le = (LivingEntity)e).m_6084_()) continue;
            this.targetCursor = (idx + 1) % n;
            return le;
        }
        return null;
    }
}

