/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.effect.raevyx.RaevyxLightningChainEntity;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class RaevyxBiteAbility
extends DragonAbility<Raevyx> {
    private static final float DEFAULT_BITE_DAMAGE = 15.0f;
    private static final double BITE_RANGE = 4.6;
    private static final double BITE_RANGE_RIDDEN = 8.0;
    private static final double BITE_ANGLE_DEG = 85.0;
    private static final double BITE_SWIPE_HORIZONTAL = 2.5;
    private static final double BITE_SWIPE_HORIZONTAL_RIDDEN = 2.5;
    private static final double BITE_SWIPE_VERTICAL = 2.5;
    private static final float CHAIN_DAMAGE_BASE = 10.0f;
    private static final double CHAIN_RADIUS = 7.0;
    private static final int CHAIN_JUMPS = 5;
    private static final float CHAIN_FALLOFF = 0.75f;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 3)};
    private boolean didHitThisActive = false;

    public RaevyxBiteAbility(DragonAbilityType<Raevyx, RaevyxBiteAbility> type, Raevyx user) {
        super(type, user, TRACK, 3);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Raevyx)this.getUser()).triggerAnim("action", "lightning_bite");
            this.didHitThisActive = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.didHitThisActive) {
            double d;
            LivingEntity t;
            LivingEntity primary = this.findPrimaryTarget();
            if (primary == null && (t = ((Raevyx)this.getUser()).m_5448_()) != null && t.m_6084_() && (d = (double)t.m_20270_(this.getUser())) <= 5.2) {
                primary = t;
            }
            if (primary == null) {
                boolean ridden = ((Raevyx)this.getUser()).m_6688_() != null;
                primary = this.raycastTargetAlongMouth(ridden ? 7.5 : 5.5, ridden ? 2.0 : 1.0);
            }
            if (primary != null) {
                this.bitePrimary(primary);
                this.chainFrom(primary);
            }
            this.didHitThisActive = true;
        }
    }

    private LivingEntity findPrimaryTarget() {
        Raevyx wyvern = (Raevyx)this.getUser();
        Vec3 mouth = wyvern.getMouthPosition();
        Vec3 look = wyvern.m_20154_().m_82541_();
        boolean ridden = wyvern.m_6688_() != null;
        double effectiveRange = ridden ? 8.0 : 4.6;
        double horizontalInflate = ridden ? 2.5 : 2.5;
        AABB forwardSweep = new AABB(mouth, mouth.m_82549_(look.m_82490_(effectiveRange))).m_82377_(horizontalInflate, 2.5, horizontalInflate);
        List candidates = wyvern.m_9236_().m_6443_(LivingEntity.class, forwardSweep, e -> e != wyvern && e.m_6084_() && e.m_5789_() && !this.isAllied(wyvern, (Entity)e));
        double cosLimit = Math.cos(Math.toRadians(85.0));
        LivingEntity best = null;
        double bestDist = Double.MAX_VALUE;
        for (LivingEntity e2 : candidates) {
            boolean goodAngle;
            Vec3 dir;
            double dot;
            Vec3 toward;
            double len;
            double distToAabb = RaevyxBiteAbility.distancePointToAABB(mouth, e2.m_20191_());
            if (distToAabb > effectiveRange + 0.4 || (len = (toward = RaevyxBiteAbility.closestPointOnAABB(mouth, e2.m_20191_()).m_82546_(mouth)).m_82553_()) <= 1.0E-4 || (dot = (dir = toward.m_82490_(1.0 / len)).m_82526_(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.35;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.75;
            }
            if (!veryClose && !goodAngle || !(distToAabb < bestDist)) continue;
            bestDist = distToAabb;
            best = e2;
        }
        return best;
    }

    private void bitePrimary(LivingEntity primary) {
        Raevyx wyvern = (Raevyx)this.getUser();
        DamageSource src = wyvern.m_9236_().m_269111_().m_269333_((LivingEntity)wyvern);
        float mult = wyvern.getDamageMultiplier();
        primary.m_6469_(src, this.resolveBiteDamage() * mult);
        wyvern.noteAggroFrom(primary);
    }

    private float resolveBiteDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.RAEVYX_ID).abilityDamage("bite", 15.0);
    }

    private void chainFrom(LivingEntity start) {
        LivingEntity next;
        Raevyx wyvern = (Raevyx)this.getUser();
        ElectricalConductivityState conductivity = wyvern.getConductivityState();
        HashSet<LivingEntity> hit = new HashSet<LivingEntity>();
        hit.add(start);
        LivingEntity current = start;
        float damage = 10.0f;
        for (int i = 0; i < 5 && (next = this.findNearestChainTarget(current, hit, conductivity)) != null; ++i) {
            float mult = wyvern.getDamageMultiplier();
            next.m_6469_(wyvern.m_9236_().m_269111_().m_269548_(), damage * mult * conductivity.damageMultiplier());
            wyvern.noteAggroFrom(next);
            this.spawnArc(current.m_20182_().m_82520_(0.0, (double)current.m_20206_() * 0.5, 0.0), next.m_20182_().m_82520_(0.0, (double)next.m_20206_() * 0.5, 0.0), conductivity);
            hit.add(next);
            current = next;
            damage *= 0.75f;
        }
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static Vec3 closestPointOnAABB(Vec3 p, AABB box) {
        double cx = Mth.m_14008_((double)p.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double cy = Mth.m_14008_((double)p.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double cz = Mth.m_14008_((double)p.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(cx, cy, cz);
    }

    private LivingEntity raycastTargetAlongMouth(double maxDistance, double inflateRadius) {
        Entity entity;
        Raevyx wyvern = (Raevyx)this.getUser();
        Vec3 start = wyvern.getMouthPosition();
        Vec3 look = wyvern.m_20154_().m_82541_();
        Vec3 end = start.m_82549_(look.m_82490_(maxDistance));
        AABB sweep = new AABB(start, end).m_82400_(inflateRadius);
        EntityHitResult hit = ProjectileUtil.m_150175_((Level)wyvern.m_9236_(), (Entity)wyvern, (Vec3)start, (Vec3)end, (AABB)sweep, e -> {
            if (!(e instanceof LivingEntity)) return false;
            LivingEntity le = (LivingEntity)e;
            if (e == wyvern) return false;
            if (!e.m_6084_()) return false;
            if (!le.m_5789_()) return false;
            if (this.isAllied(wyvern, (Entity)e)) return false;
            return true;
        }, (float)((float)(maxDistance * maxDistance)));
        if (hit != null && (entity = hit.m_82443_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return le;
        }
        return null;
    }

    private LivingEntity findNearestChainTarget(LivingEntity origin, Set<LivingEntity> exclude, ElectricalConductivityState conductivity) {
        Raevyx wyvern = (Raevyx)this.getUser();
        double rangeMult = conductivity.rangeMultiplier();
        List<LivingEntity> nearby = DragonMathUtil.getEntitiesNearby((Entity)origin, LivingEntity.class, 7.0 * rangeMult);
        LivingEntity best = null;
        double bestDist = Double.MAX_VALUE;
        for (LivingEntity e : nearby) {
            double d;
            if (e == wyvern || exclude.contains(e) || !e.m_6084_() || !e.m_5789_() || this.isAllied(wyvern, (Entity)e) || !((d = e.m_20280_((Entity)origin)) < bestDist) || !wyvern.m_21574_().m_148306_((Entity)e)) continue;
            bestDist = d;
            best = e;
        }
        return best;
    }

    private boolean isAllied(Raevyx wyvern, Entity other) {
        return wyvern.isAlly(other);
    }

    private void spawnArc(Vec3 from, Vec3 to, ElectricalConductivityState conductivity) {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Raevyx wyvern = (Raevyx)this.getUser();
        float damage = 10.0f * wyvern.getDamageMultiplier() * conductivity.damageMultiplier();
        RaevyxLightningChainEntity lightningEntity = new RaevyxLightningChainEntity((Level)server, from, to, damage, 1.2f, (LivingEntity)wyvern, false);
        server.m_7967_((Entity)lightningEntity);
    }
}

