/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaevyxBeamAbility
extends DragonAbility<Raevyx> {
    private static final DragonAbilitySection[] RIDER_TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 20), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 400)};
    private static final DragonAbilitySection[] AI_TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 20), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 80)};
    private static final double MAX_BEAM_RANGE = 128.0;
    private static final float DEFAULT_BEAM_DAMAGE = 35.0f;
    private boolean hasBeamFired = false;
    private boolean beamStartPlayed = false;
    private boolean beamLoopActive = false;

    public RaevyxBeamAbility(DragonAbilityType<Raevyx, RaevyxBeamAbility> type, Raevyx user) {
        super(type, user, user.m_6688_() != null ? RIDER_TRACK : AI_TRACK, 0);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.hasBeamFired = false;
            this.beamLoopActive = false;
            this.beamStartPlayed = true;
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeamGlowActive(true);
            wyvern.setBeaming(false);
            wyvern.triggerAnim("action", "lightning_beam_start");
            if (!wyvern.m_9236_().f_46443_) {
                float pitch = 0.9f + wyvern.m_217043_().m_188501_() * 0.2f;
                wyvern.m_5496_(ModSounds.RAEVYX_LIGHTNING_BEAM_START.get(), 1.8f, pitch);
            }
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeaming(true);
            wyvern.triggerAnim("action", "lightning_beaming");
            this.beamLoopActive = true;
            if (!this.hasBeamFired) {
                this.fireBeamOnce();
                this.hasBeamFired = true;
            }
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeaming(false);
            wyvern.setBeamGlowActive(false);
            wyvern.clearBeamPath();
            this.triggerBeamStop(wyvern);
            this.hasBeamFired = false;
        }
    }

    @Override
    public void interrupt() {
        Raevyx wyvern = (Raevyx)this.getUser();
        wyvern.setBeaming(false);
        wyvern.setBeamGlowActive(false);
        wyvern.clearBeamPath();
        this.triggerBeamStop(wyvern);
        this.hasBeamFired = false;
        super.interrupt();
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        Raevyx wyvern = (Raevyx)this.getUser();
        if (wyvern.m_9236_().f_46443_) {
            return;
        }
        LivingEntity tgt = wyvern.m_5448_();
        if (!wyvern.m_21824_() && wyvern.m_6688_() == null && !this.isValidTarget(wyvern.m_5448_())) {
            this.interrupt();
            return;
        }
        BeamPath path = this.computeBeamPath(wyvern);
        if (path == null) {
            return;
        }
        if (tgt != null && tgt.m_6084_()) {
            double dx = tgt.m_20185_() - wyvern.m_20185_();
            double dz = tgt.m_20189_() - wyvern.m_20189_();
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float currentYaw = wyvern.m_146908_();
            float yawErr = Mth.m_14118_((float)currentYaw, (float)targetYaw);
            if (Math.abs(yawErr) > 3.5f) {
                float base = 2.5f;
                float scale = 0.1f;
                float max = wyvern.m_29443_() ? 7.0f : 6.0f;
                float step = Mth.m_14036_((float)(base + Math.abs(yawErr) * scale), (float)base, (float)max);
                float newYaw = Mth.m_14148_((float)currentYaw, (float)targetYaw, (float)step);
                wyvern.m_146922_(newYaw);
                wyvern.f_20883_ = wyvern.m_146908_();
            }
        }
        this.damageAlongBeam(wyvern, path.origin(), path.impact());
    }

    private void triggerBeamStop(Raevyx wyvern) {
        if (this.beamLoopActive || this.beamStartPlayed) {
            wyvern.triggerAnim("action", "lightning_beam_stop");
            if (!wyvern.m_9236_().f_46443_) {
                float pitch = 0.95f + wyvern.m_217043_().m_188501_() * 0.15f;
                wyvern.m_5496_(ModSounds.RAEVYX_LIGHTNING_BEAM_STOP.get(), 1.6f, pitch);
            }
        }
        this.beamLoopActive = false;
        this.beamStartPlayed = false;
    }

    private void fireBeamOnce() {
        Raevyx wyvern = (Raevyx)this.getUser();
        BeamPath path = this.computeBeamPath(wyvern);
        if (path != null) {
            this.damageAlongBeam(wyvern, path.origin(), path.impact());
        }
    }

    private BeamPath computeBeamPath(Raevyx wyvern) {
        Vec3 origin = wyvern.getBeamStartAnchor(1.0f);
        if (origin == null) {
            wyvern.clearBeamPath();
            return null;
        }
        Vec3 aimDir = wyvern.refreshBeamAimDirection(origin, false);
        if (aimDir == null || aimDir.m_82556_() < 1.0E-6) {
            wyvern.clearBeamPath();
            return null;
        }
        Vec3 impact = this.traceBeamImpact(wyvern, origin, aimDir);
        wyvern.syncBeamPath(origin, impact);
        return new BeamPath(origin, impact);
    }

    private Vec3 traceBeamImpact(Raevyx wyvern, Vec3 origin, Vec3 aimDir) {
        Vec3 reach = origin.m_82549_(aimDir.m_82490_(128.0));
        ClipContext context = new ClipContext(origin, reach, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)wyvern);
        BlockHitResult hit = wyvern.m_9236_().m_45547_(context);
        if (hit == null || hit.m_6662_() == HitResult.Type.MISS) {
            return reach;
        }
        return hit.m_82450_();
    }

    private void damageAlongBeam(Raevyx wyvern, Vec3 start, Vec3 end) {
        Level level = wyvern.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double STEP = 1.0;
        double BASE_RADIUS = 1.2;
        float configuredBaseDamage = (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.RAEVYX_ID).abilityDamage("lightning_beam", 35.0);
        ElectricalConductivityState conductivity = wyvern.getConductivityState();
        double RADIUS = 1.2 * conductivity.rangeMultiplier();
        float DAMAGE = configuredBaseDamage * conductivity.damageMultiplier() * wyvern.getDamageMultiplier();
        Vec3 delta = end.m_82546_(start);
        double len = delta.m_82553_();
        if (len < 1.0E-4) {
            return;
        }
        Vec3 dir = delta.m_82490_(1.0 / len);
        HashSet<LivingEntity> hitThisBeam = new HashSet<LivingEntity>();
        for (double d = 0.0; d <= len; d += 1.0) {
            Vec3 p = start.m_82549_(dir.m_82490_(d));
            AABB aabb = new AABB(p, p).m_82400_(RADIUS);
            List list = server.m_6443_(LivingEntity.class, aabb, e -> e != wyvern && e.m_6084_() && e.m_5789_() && !this.isAllied(wyvern, (Entity)e));
            for (LivingEntity le : list) {
                if (!hitThisBeam.add(le)) continue;
                le.m_6469_(wyvern.m_9236_().m_269111_().m_269548_(), DAMAGE);
                Vec3 away = le.m_20182_().m_82546_(p).m_82541_();
                le.m_5997_(away.f_82479_ * 0.15, 0.08, away.f_82481_ * 0.15);
            }
        }
    }

    private boolean isAllied(Raevyx wyvern, Entity other) {
        return wyvern.isAlly(other);
    }

    private boolean isValidTarget(LivingEntity target) {
        Player player;
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_213877_()) {
            return false;
        }
        return !(target instanceof Player) || !(player = (Player)target).m_7500_() && !player.m_5833_();
    }

    private record BeamPath(Vec3 origin, Vec3 impact) {
    }
}

