/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;

public class NulljawPhaseShiftAbility
extends DragonAbility<Nulljaw> {
    private static final int GROUND_START_TICKS = 38;
    private static final int GROUND_MAIN_TICKS = 67;
    private static final int GROUND_END_TICKS = 17;
    private static final int GROUND_TOTAL_SEQUENCE_TICKS = 122;
    private static final int UNDERWATER_START_TICKS = 38;
    private static final int UNDERWATER_MAIN_TICKS = 67;
    private static final int UNDERWATER_STOP_TICKS = 17;
    private static final int UNDERWATER_TOTAL_SEQUENCE_TICKS = 122;
    private static final int LOCK_DURATION = 120;
    private final boolean enteringPhaseTwo;
    private final boolean isGroundTransition;
    private boolean phaseToggleApplied;
    private boolean mainAnimPlayed;
    private boolean endAnimPlayed;
    private boolean screenShakeActive;
    private static final DragonAbilitySection[] TRACK_ENTER_PHASE2_GROUND = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 122), new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private static final DragonAbilitySection[] TRACK_ENTER_PHASE2_UNDERWATER = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 122), new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private static final DragonAbilitySection[] TRACK_EXIT_PHASE2 = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE)};

    public NulljawPhaseShiftAbility(DragonAbilityType<Nulljaw, NulljawPhaseShiftAbility> type, Nulljaw user) {
        super(type, user, NulljawPhaseShiftAbility.determineTrack(user), 0);
        this.enteringPhaseTwo = !user.isPhaseTwoActive();
        this.isGroundTransition = !user.m_20072_();
        this.phaseToggleApplied = false;
        this.mainAnimPlayed = false;
        this.endAnimPlayed = false;
        this.screenShakeActive = false;
    }

    private static DragonAbilitySection[] determineTrack(Nulljaw user) {
        if (user.isPhaseTwoActive()) {
            return TRACK_EXIT_PHASE2;
        }
        if (user.m_20072_()) {
            return TRACK_ENTER_PHASE2_UNDERWATER;
        }
        return TRACK_ENTER_PHASE2_GROUND;
    }

    @Override
    public boolean canUse() {
        Nulljaw user = (Nulljaw)this.getUser();
        boolean underwater = user.m_20072_();
        if (!underwater && !user.m_20096_()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            if (this.enteringPhaseTwo) {
                ((Nulljaw)this.getUser()).lockRiderControls(120);
                ((Nulljaw)this.getUser()).lockAbilities(120);
                ((Nulljaw)this.getUser()).m_21573_().m_26573_();
                ((Nulljaw)this.getUser()).m_21566_().m_6849_(((Nulljaw)this.getUser()).m_20185_(), ((Nulljaw)this.getUser()).m_20186_(), ((Nulljaw)this.getUser()).m_20189_(), 0.0);
                ((Nulljaw)this.getUser()).setPhaseTwoActive(true, true);
                this.phaseToggleApplied = true;
            }
            this.mainAnimPlayed = false;
            this.endAnimPlayed = false;
            this.screenShakeActive = false;
            String startTrigger = this.resolvePhaseAnimation();
            ((Nulljaw)this.getUser()).triggerAnim("action", startTrigger);
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            if (this.enteringPhaseTwo) {
                if (!this.phaseToggleApplied) {
                    ((Nulljaw)this.getUser()).setPhaseTwoActive(true, true);
                    this.phaseToggleApplied = true;
                }
            } else {
                boolean newPhase = !((Nulljaw)this.getUser()).isPhaseTwoActive();
                ((Nulljaw)this.getUser()).setPhaseTwoActive(newPhase, true);
                if (!newPhase) {
                    ((Nulljaw)this.getUser()).lockRiderControls(45);
                    ((Nulljaw)this.getUser()).lockAbilities(45);
                    boolean underwater = ((Nulljaw)this.getUser()).m_20072_();
                    String revertAnim = underwater ? "phase1_underwater" : "phase1";
                    ((Nulljaw)this.getUser()).triggerAnim("action", revertAnim);
                }
            }
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section;
        if (this.screenShakeActive && !((Nulljaw)this.getUser()).m_9236_().f_46443_) {
            ((Nulljaw)this.getUser()).triggerScreenShake(1.5f);
        }
        if ((section = this.getCurrentSection()) == null || section.sectionType != DragonAbilitySection.AbilitySectionType.STARTUP) {
            return;
        }
        if (!this.enteringPhaseTwo) {
            return;
        }
        int ticks = this.getTicksInSection();
        if (this.isGroundTransition) {
            if (!this.mainAnimPlayed && ticks >= 38) {
                ((Nulljaw)this.getUser()).triggerAnim("action", "phase2");
                this.mainAnimPlayed = true;
                this.screenShakeActive = true;
            }
            if (!this.endAnimPlayed && ticks >= 105) {
                ((Nulljaw)this.getUser()).triggerAnim("action", "phase2_end");
                this.endAnimPlayed = true;
                this.screenShakeActive = false;
            }
        } else {
            if (!this.mainAnimPlayed && ticks >= 38) {
                ((Nulljaw)this.getUser()).triggerAnim("action", "phase2_underwater");
                this.mainAnimPlayed = true;
                this.screenShakeActive = true;
            }
            if (!this.endAnimPlayed && ticks >= 105) {
                ((Nulljaw)this.getUser()).triggerAnim("action", "phase2_underwater_end");
                this.endAnimPlayed = true;
                this.screenShakeActive = false;
            }
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.screenShakeActive = false;
        }
    }

    @Override
    public void end() {
        this.screenShakeActive = false;
        super.end();
    }

    private String resolvePhaseAnimation() {
        boolean underwater = ((Nulljaw)this.getUser()).m_20072_();
        if (underwater) {
            return "phase2_underwater_start";
        }
        return "phase2_start";
    }
}

