/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NulljawHornGoreAbility
extends DragonAbility<Nulljaw> {
    private static final float DEFAULT_PHASE1_DAMAGE = 16.0f;
    private static final float DEFAULT_PHASE2_DAMAGE = 20.8f;
    private static final float DEFAULT_ATTACK_DAMAGE = 10.0f;
    private static final double GORE_RANGE = 7.0;
    private static final double GORE_RANGE_RIDDEN = 8.5;
    private static final double GORE_ANGLE_DEG = 90.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 6)};
    private final Set<Integer> hitIdsThisUse = new HashSet<Integer>();

    public NulljawHornGoreAbility(DragonAbilityType<Nulljaw, NulljawHornGoreAbility> type, Nulljaw user) {
        super(type, user, TRACK, 3);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Nulljaw)this.getUser()).triggerAnim("action", "horn_gore");
            this.hitIdsThisUse.clear();
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            // empty if block
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        List<LivingEntity> candidates = this.findTargets();
        ArrayList<LivingEntity> newHits = new ArrayList<LivingEntity>();
        for (LivingEntity le : candidates) {
            if (!this.hitIdsThisUse.add(le.m_19879_())) continue;
            newHits.add(le);
        }
        if (!newHits.isEmpty()) {
            for (LivingEntity le : newHits) {
                this.applyGore(le);
            }
        }
    }

    private List<LivingEntity> findTargets() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        Vec3 head = dragon.getHeadPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        boolean ridden = dragon.m_6688_() != null;
        double range = ridden ? 8.5 : 7.0;
        AABB broad = dragon.m_20191_().m_82377_(range, range, range);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, broad, e -> e != dragon && e.m_6084_() && e.m_5789_() && !this.isAllied(dragon, (Entity)e));
        double cosLimit = Math.cos(Math.toRadians(90.0));
        ArrayList<LivingEntity> hits = new ArrayList<LivingEntity>();
        for (LivingEntity e2 : candidates) {
            boolean angleOk;
            Vec3 toward;
            double len;
            double dist = NulljawHornGoreAbility.distancePointToAABB(head, e2.m_20191_());
            if (dist > range + 0.4 || (len = (toward = e2.m_20191_().m_82399_().m_82546_(head)).m_82553_()) < 1.0E-4) continue;
            double dot = toward.m_82541_().m_82526_(look);
            boolean close = dist < range * 0.6;
            boolean bl = angleOk = dot >= cosLimit;
            if (ridden) {
                double bodyDist = NulljawHornGoreAbility.distancePointToAABB(e2.m_20182_(), dragon.m_20191_());
                boolean bl2 = angleOk = angleOk || dot >= cosLimit * 0.7 || bodyDist <= range;
            }
            if (!close && !angleOk) continue;
            hits.add(e2);
        }
        return hits;
    }

    private void applyGore(LivingEntity target) {
        double value;
        Nulljaw dragon = (Nulljaw)this.getUser();
        DamageSource src = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        boolean phaseTwo = dragon.isPhaseTwoActive();
        float configuredDamage = this.resolveBaseDamage(phaseTwo);
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            configuredDamage = (float)((double)configuredDamage * (value / 10.0));
        }
        float armorPenetration = phaseTwo ? 5.0f : 3.0f;
        float armor = (float)target.m_21133_(Attributes.f_22284_);
        float toughness = (float)target.m_21133_(Attributes.f_22285_);
        float desiredPostArmor = NulljawHornGoreAbility.damageAfterArmor(configuredDamage, Math.max(0.0f, armor - armorPenetration), toughness);
        float rawToDeal = NulljawHornGoreAbility.solveRawDamageForPostArmor(desiredPostArmor, armor, toughness);
        target.m_6469_(src, rawToDeal);
        Vec3 look = dragon.m_20154_().m_82541_();
        double strength = phaseTwo ? 3.5 : 2.0;
        target.m_147240_((double)((float)strength), -look.f_82479_, -look.f_82481_);
        Vec3 dv = target.m_20184_();
        float verticalLift = phaseTwo ? 0.9f : 0.5f;
        target.m_20334_(dv.f_82479_, Math.max(dv.f_82480_, (double)verticalLift), dv.f_82481_);
    }

    private static float damageAfterArmor(float damage, float armor, float toughness) {
        float f = 2.0f + toughness / 4.0f;
        float reduction = Mth.m_14036_((float)(armor - damage / f), (float)(armor * 0.2f), (float)20.0f);
        return damage * (1.0f - reduction / 25.0f);
    }

    private static float solveRawDamageForPostArmor(float desiredPostArmor, float armor, float toughness) {
        float lo = 0.0f;
        float hi = Math.max(desiredPostArmor + 16.0f, 16.0f);
        for (int i = 0; i < 8 && NulljawHornGoreAbility.damageAfterArmor(hi, armor, toughness) < desiredPostArmor; ++i) {
            hi *= 2.0f;
        }
        for (int it = 0; it < 20; ++it) {
            float mid = (lo + hi) * 0.5f;
            float val = NulljawHornGoreAbility.damageAfterArmor(mid, armor, toughness);
            if (val < desiredPostArmor) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        return (lo + hi) * 0.5f;
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private boolean isAllied(Nulljaw dragon, Entity other) {
        return dragon.isAlly(other);
    }

    private float resolveBaseDamage(boolean phaseTwo) {
        String key = phaseTwo ? "horn_gore_phase2" : "horn_gore_phase1";
        float fallback = phaseTwo ? 20.8f : 16.0f;
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.NULLJAW_ID).abilityDamage(key, fallback);
    }
}

