/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NulljawBiteAbility
extends DragonAbility<Nulljaw> {
    private static final float DEFAULT_DAMAGE = 40.0f;
    private static final float DEFAULT_ATTACK_DAMAGE = 10.0f;
    private static final double BASE_RANGE = 5.5;
    private static final double RIDDEN_RANGE_BONUS = 0.5;
    private static final double SWIM_RANGE_BONUS = 2.0;
    private static final double BITE_ANGLE_DEG = 90.0;
    private static final double BITE_SWIPE_HORIZONTAL = 4.0;
    private static final double BITE_SWIPE_HORIZONTAL_RIDDEN = 1.5;
    private static final double BITE_SWIPE_VERTICAL = 4.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 6)};
    private boolean appliedHit;

    public NulljawBiteAbility(DragonAbilityType<Nulljaw, NulljawBiteAbility> type, Nulljaw user) {
        super(type, user, TRACK, 15);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            dragon.triggerAnim("action", "bite");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            List<LivingEntity> targets = this.findAllTargetsInCone();
            for (LivingEntity target : targets) {
                this.applyHit(dragon, target);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Nulljaw dragon, LivingEntity target) {
        double value;
        float damage = this.resolveBaseDamage();
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            damage = (float)((double)damage * (value / 10.0));
        }
        DamageSource source = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        target.m_6469_(source, damage);
        Vec3 push = dragon.m_20154_().m_82490_(0.3);
        target.m_5997_(push.f_82479_, dragon.m_6069_() ? 0.15 : 0.05, push.f_82481_);
    }

    private double getEffectiveRange() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        double range = 5.5;
        if (dragon.m_6688_() != null) {
            range += 0.5;
        }
        if (dragon.m_6069_()) {
            range += 2.0;
        }
        return range;
    }

    private List<LivingEntity> findAllTargetsInCone() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        Vec3 mouth = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        boolean ridden = dragon.m_6688_() != null;
        double effectiveRange = this.getEffectiveRange();
        double horizontalInflate = ridden ? 1.5 : 4.0;
        AABB forwardSweep = new AABB(mouth, mouth.m_82549_(look.m_82490_(effectiveRange))).m_82377_(horizontalInflate, 4.0, horizontalInflate);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, forwardSweep, e -> e != dragon && e.m_6084_() && e.m_5789_() && !dragon.isAlly((Entity)e));
        double cosLimit = Math.cos(Math.toRadians(90.0));
        ArrayList<LivingEntity> validTargets = new ArrayList<LivingEntity>();
        for (LivingEntity e2 : candidates) {
            boolean goodAngle;
            Vec3 dir;
            double dot;
            Vec3 toward;
            double len;
            double distToAabb = NulljawBiteAbility.distancePointToAABB(mouth, e2.m_20191_());
            if (distToAabb > effectiveRange + 0.4 || (len = (toward = NulljawBiteAbility.closestPointOnAABB(mouth, e2.m_20191_()).m_82546_(mouth)).m_82553_()) <= 1.0E-4 || (dot = (dir = toward.m_82490_(1.0 / len)).m_82526_(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.35;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.75;
            }
            if (!veryClose && !goodAngle) continue;
            validTargets.add(e2);
        }
        return validTargets;
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static Vec3 closestPointOnAABB(Vec3 p, AABB box) {
        double cx = Mth.m_14008_((double)p.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double cy = Mth.m_14008_((double)p.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double cz = Mth.m_14008_((double)p.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(cx, cy, cz);
    }

    private float resolveBaseDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.NULLJAW_ID).abilityDamage("bite_phase1", 40.0);
    }
}

