/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.ignivorus;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class IgnivorusUltimateAbility
extends DragonAbility<Ignivorus> {
    private static final int ULTIMATE_START_TICKS = 28;
    private static final int ULTIMATE_LOOP_TICKS = 108;
    private static final int ULTIMATE_END_TICKS = 28;
    private static final int TOTAL_SEQUENCE_TICKS = 164;
    private static final int COOLDOWN_TICKS_RIDER = 0;
    private static final int COOLDOWN_TICKS_AI = 6000;
    private static final int START_END_TICK = 28;
    private static final int LOOP_END_TICK = 136;
    private static final double EXPLOSION_RADIUS = 32.0;
    private static final float EXPLOSION_DAMAGE = 200.0f;
    private static final int EXPLOSION_FIRE_SECONDS = 8;
    private static final int EXPLOSION_PARTICLE_POINTS = 64;
    private static final int LOOP_DAMAGE_INTERVAL = 5;
    private static final int LOOP_DAMAGE_WARMUP = 20;
    private static final float PENALTY_HEALTH = 50.0f;
    private static final Component PENALTY_MESSAGE = Component.m_237115_((String)"saintsdragons.message.ignivorus.ultimate_penalty");
    private static final Component REQUIREMENT_MESSAGE = Component.m_237115_((String)"saintsdragons.message.ignivorus.ultimate_requires_full_health");
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 164), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 1), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private boolean lockedControls;
    private boolean startAnimPlayed;
    private boolean loopAnimPlayed;
    private boolean endAnimPlayed;
    private int lastLoopDamageTick;
    private boolean penaltyApplied;

    public IgnivorusUltimateAbility(DragonAbilityType<Ignivorus, IgnivorusUltimateAbility> type, Ignivorus user) {
        super(type, user, TRACK, user.m_6688_() != null ? 0 : 6000);
    }

    @Override
    public boolean tryAbility() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (dragon.m_20160_() && dragon.m_21223_() < dragon.m_21233_()) {
            this.sendRequirementMessage();
            return false;
        }
        return super.tryAbility();
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            boolean isAirborne;
            dragon.lockRiderControls(164);
            this.lockedControls = true;
            boolean bl = isAirborne = dragon.m_29443_() || !dragon.m_20096_();
            if (!isAirborne) {
                dragon.markLandedNow();
                dragon.setHovering(false);
                dragon.setLanding(false);
                dragon.setTakeoff(false);
                dragon.m_20256_(Vec3.f_82478_);
            }
            dragon.setUltimateCameraZoomActive(true);
            this.startAnimPlayed = false;
            this.loopAnimPlayed = false;
            this.endAnimPlayed = false;
            this.lastLoopDamageTick = -5;
            this.penaltyApplied = false;
            if (isAirborne) {
                dragon.triggerAnim("action", "ultimate_start_air");
            } else {
                dragon.triggerAnim("action", "ultimate_start");
            }
            this.startAnimPlayed = true;
            this.applyPenaltyHealth(dragon);
        }
    }

    @Override
    public void tickUsing() {
        int loopTick;
        boolean isAirborne;
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.STARTUP) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        int ticks = this.getTicksInSection();
        boolean bl = isAirborne = dragon.m_29443_() || !dragon.m_20096_();
        if (!this.loopAnimPlayed && ticks >= 28) {
            if (isAirborne) {
                dragon.triggerAnim("action", "ultimate_air");
            } else {
                dragon.triggerAnim("action", "ultimate");
            }
            this.loopAnimPlayed = true;
        }
        if (this.loopAnimPlayed && ticks >= 28 && ticks < 136 && (loopTick = ticks - 28) >= 20 && loopTick - this.lastLoopDamageTick >= 5) {
            this.triggerRingExplosion(loopTick == 20);
            this.lastLoopDamageTick = loopTick;
        }
        if (!this.endAnimPlayed && ticks >= 136) {
            if (isAirborne) {
                dragon.triggerAnim("action", "ultimate_end_air");
            } else {
                dragon.triggerAnim("action", "ultimate_end");
            }
            this.endAnimPlayed = true;
        }
    }

    private void applyPenaltyHealth(Ignivorus dragon) {
        float penaltyHealth;
        float current;
        if (this.penaltyApplied) {
            return;
        }
        if (dragon.m_21824_() && dragon.m_20160_() && (current = dragon.m_21223_()) > (penaltyHealth = this.resolvePenaltyHealth())) {
            dragon.m_21153_(penaltyHealth);
            this.sendPenaltyMessage();
        }
        this.penaltyApplied = true;
    }

    private void sendRequirementMessage() {
        Player rider = ((Ignivorus)this.getUser()).getRidingPlayer();
        if (rider != null) {
            rider.m_5661_(REQUIREMENT_MESSAGE, true);
        }
    }

    private void sendPenaltyMessage() {
        Player rider = ((Ignivorus)this.getUser()).getRidingPlayer();
        if (rider != null) {
            rider.m_5661_(PENALTY_MESSAGE, true);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.releaseLocks();
        }
    }

    @Override
    public void interrupt() {
        this.releaseLocks();
        super.interrupt();
    }

    @Override
    public void end() {
        this.releaseLocks();
        super.end();
    }

    private void releaseLocks() {
        if (this.lockedControls) {
            ((Ignivorus)this.getUser()).clearRiderControlLock();
            this.lockedControls = false;
        }
        ((Ignivorus)this.getUser()).setUltimateCameraZoomActive(false);
    }

    private void triggerRingExplosion(boolean openingPulse) {
        Ignivorus dragon = (Ignivorus)this.getUser();
        Vec3 center = dragon.m_20182_();
        dragon.triggerScreenShake(openingPulse ? 2.3f : 1.2f);
        if (dragon.m_9236_().f_46443_) {
            return;
        }
        ServerLevel server = (ServerLevel)dragon.m_9236_();
        if (openingPulse) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, 3, 1.0, 0.5, 1.0, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, 100, 2.0, 1.0, 2.0, 0.2);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, 50, 1.5, 0.5, 1.5, 0.1);
        }
        this.spawnRingParticles(server, center);
        this.applyRingDamage(server, center);
    }

    private void spawnRingParticles(ServerLevel level, Vec3 center) {
        for (int i = 0; i < 64; ++i) {
            double angle = Math.PI * 2 * (double)i / 64.0;
            double x = center.f_82479_ + Math.cos(angle) * 32.0;
            double z = center.f_82481_ + Math.sin(angle) * 32.0;
            double y = center.f_82480_ + 0.1;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 20, 0.8, 0.6, 0.8, 0.05);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y + 0.5, z, 8, 0.6, 0.4, 0.6, 0.02);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 10, 0.3, 1.0, 0.3, 0.1);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 3, 0.5, 0.2, 0.5, 0.0);
        }
    }

    private void applyRingDamage(ServerLevel level, Vec3 center) {
        double radiusSqr = 1024.0;
        DamageSource source = level.m_269111_().m_269333_(this.getUser());
        float explosionDamage = this.resolveExplosionDamage();
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, ((Ignivorus)this.getUser()).m_20191_().m_82400_(32.0), target -> target != this.getUser() && target.m_6084_() && target.m_5789_() && !((Ignivorus)this.getUser()).isAlly((Entity)target))) {
            if (entity.m_20182_().m_82557_(center) > radiusSqr) continue;
            entity.m_6469_(source, explosionDamage);
            entity.m_20254_(8);
            Vec3 knock = entity.m_20182_().m_82546_(center).m_82541_().m_82490_(1.4);
            entity.m_5997_(knock.f_82479_, 0.6, knock.f_82481_);
        }
    }

    private float resolveExplosionDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID).abilityDamage("ultimate", 200.0);
    }

    private float resolvePenaltyHealth() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID).extraDouble("ultimate_penalty_health", 50.0);
    }
}

