/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.ignivorus;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.leon.saintsdragons.server.entity.effect.ignivorus.IgnivorusMagmaPillarEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class IgnivorusRoarAbility
extends DragonAbility<Ignivorus> {
    private static final int STARTUP_TICKS = 8;
    private static final int ACTIVE_TICKS = 36;
    private static final int RECOVERY_TICKS = 16;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 8), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 36), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 16)};
    private static final int SOUND_DELAY_TICKS = 4;
    private static final int WAVES = 3;
    private static final int FIRST_WAVE_TICK = 10;
    private static final int WAVE_INTERVAL_TICKS = 6;
    private static final double LANE_SPACING = 5.0;
    private static final double BASE_FORWARD_OFFSET = 20.0;
    private static final double FORWARD_STEP = 10.0;
    private static final float BASE_DAMAGE = 18.0f;
    private static final float DAMAGE_PER_WAVE = 4.0f;
    private static final double BASE_KNOCKBACK = 0.9;
    private static final double KNOCKBACK_PER_WAVE = 0.2;
    private static final int PILLAR_WARMUP_TICKS = 5;
    private static final int PILLAR_LIFETIME_TICKS = 34;
    private boolean soundQueued;
    private int wavesSpawned;
    private boolean cosmeticMode;

    public IgnivorusRoarAbility(DragonAbilityType<Ignivorus, IgnivorusRoarAbility> type, Ignivorus user) {
        super(type, user, TRACK, 80);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Ignivorus dragon = (Ignivorus)this.getUser();
            dragon.triggerAnim("action", "roar");
            dragon.lockAbilities(60);
            dragon.triggerScreenShake(1.8f);
            this.soundQueued = true;
            this.wavesSpawned = 0;
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.soundQueued = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.soundQueued && this.getTicksInSection() >= 4) {
            if (!dragon.m_9236_().f_46443_) {
                float pitch = 0.85f + dragon.m_217043_().m_188501_() * 0.2f;
                dragon.m_5496_(ModSounds.IGNIVORUS_ROAR.get(), 2.0f, pitch);
            }
            this.soundQueued = false;
        }
        if (section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE || dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.cosmeticMode) {
            return;
        }
        int totalTicks = this.getTicksInUse();
        while (this.wavesSpawned < 3 && totalTicks >= 10 + this.wavesSpawned * 6) {
            this.spawnWave(dragon, this.wavesSpawned);
            ++this.wavesSpawned;
        }
    }

    private void spawnWave(Ignivorus dragon, int waveIndex) {
        Level level = dragon.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 forward = dragon.m_20154_();
        Vec3 horizontalForward = new Vec3(forward.f_82479_, 0.0, forward.f_82481_);
        if (horizontalForward.m_82556_() < 1.0E-4) {
            horizontalForward = new Vec3(dragon.m_20156_().f_82479_, 0.0, dragon.m_20156_().f_82481_);
        }
        if (horizontalForward.m_82556_() < 1.0E-4) {
            horizontalForward = new Vec3(0.0, 0.0, 1.0);
        }
        horizontalForward = horizontalForward.m_82541_();
        Vec3 right = new Vec3(-horizontalForward.f_82481_, 0.0, horizontalForward.f_82479_).m_82541_();
        double forwardOffset = 20.0 + (double)waveIndex * 10.0;
        for (int lane = -1; lane <= 1; ++lane) {
            double lateral = (double)lane * 5.0;
            Vec3 laneOffset = horizontalForward.m_82490_(forwardOffset).m_82549_(right.m_82490_(lateral));
            Vec3 base = new Vec3(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_()).m_82549_(laneOffset);
            BlockPos column = BlockPos.m_274561_((double)base.f_82479_, (double)base.f_82480_, (double)base.f_82481_);
            BlockPos ground = server.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, column);
            Vec3 spawnPos = new Vec3(base.f_82479_, (double)ground.m_123342_(), base.f_82481_);
            IgnivorusMagmaPillarEntity pillar = new IgnivorusMagmaPillarEntity((Level)server, spawnPos, dragon, waveIndex, 18.0f + (float)waveIndex * 4.0f, 0.9 + (double)waveIndex * 0.2, 5, 34);
            server.m_7967_((Entity)pillar);
            server.m_6263_(null, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, ModSounds.IGNIVORUS_MAGMA_PILLAR.get(), SoundSource.HOSTILE, 1.2f, 0.9f + server.f_46441_.m_188501_() * 0.2f);
        }
    }

    @Override
    public boolean tryAbility() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (dragon == null || dragon.m_6162_()) {
            return false;
        }
        boolean allowCosmetic = dragon.m_29443_();
        boolean grounded = dragon.m_20096_();
        if (!allowCosmetic && !grounded) {
            return false;
        }
        this.cosmeticMode = allowCosmetic;
        boolean success = super.tryAbility();
        if (!success) {
            this.cosmeticMode = false;
        }
        return success;
    }
}

